/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.image.ToolkitImage;
import com.trollworks.ttk.utility.Path;
import com.trollworks.ttk.widgets.AppWindow;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class FileType {
    private static final String DOT = ".";
    private static final ArrayList<FileType> TYPES = new ArrayList();
    private static HashMap<String, BufferedImage> ICON_MAP = new HashMap();
    private String mExtension;
    private BufferedImage mIcon;
    private Class<? extends AppWindow> mWindowClass;
    private boolean mAllowOpen;

    public static final void register(String string, BufferedImage bufferedImage, Class<? extends AppWindow> clazz, boolean bl) {
        if (!string.startsWith(DOT)) {
            string = DOT + string;
        }
        for (FileType fileType : TYPES) {
            if (!fileType.mExtension.equals(string)) continue;
            TYPES.remove(fileType);
            break;
        }
        TYPES.add(new FileType(string, bufferedImage, clazz, bl));
        ICON_MAP.put(string, bufferedImage);
    }

    public static final FileType[] getAll() {
        return TYPES.toArray(new FileType[TYPES.size()]);
    }

    public static final FileType[] getOpenable() {
        ArrayList<FileType> arrayList = new ArrayList<FileType>();
        for (FileType fileType : TYPES) {
            if (!fileType.allowOpen()) continue;
            arrayList.add(fileType);
        }
        return arrayList.toArray(new FileType[arrayList.size()]);
    }

    public static final String[] getOpenableExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FileType fileType : TYPES) {
            if (!fileType.mAllowOpen) continue;
            arrayList.add(fileType.getExtension());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static BufferedImage getIconForFile(String string) {
        return FileType.getIconForFileExtension(Path.getExtension(string));
    }

    public static BufferedImage getIconForFile(File file) {
        return FileType.getIconForFile(file != null && file.isFile() ? file.getName() : null);
    }

    public static BufferedImage getIconForFileExtension(String string) {
        if (string != null) {
            BufferedImage bufferedImage;
            if (!string.startsWith(DOT)) {
                string = DOT + string;
            }
            if ((bufferedImage = ICON_MAP.get(string)) != null) {
                return bufferedImage;
            }
            return ToolkitImage.getFileIcon();
        }
        return ToolkitImage.getFolderIcon();
    }

    private FileType(String string, BufferedImage bufferedImage, Class<? extends AppWindow> clazz, boolean bl) {
        this.mExtension = string;
        this.mIcon = bufferedImage;
        this.mWindowClass = clazz;
        this.mAllowOpen = bl;
    }

    public String getExtension() {
        return this.mExtension;
    }

    public BufferedImage getIcon() {
        return this.mIcon;
    }

    public Class<? extends AppWindow> getWindowClass() {
        return this.mWindowClass;
    }

    public boolean allowOpen() {
        return this.mAllowOpen;
    }
}

