/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.file.FileType;
import com.trollworks.ttk.menu.file.OpenCommand;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class OpenDataFileCommand
extends Command
implements Runnable {
    private static final String CMD_PREFIX = "OpenDataFile[";
    private static final String CMD_POSTFIX = "]";
    private static boolean PASS_THROUGH = false;
    private static ArrayList<File> PENDING_FILES = null;
    private File mFile;
    private boolean mVerify;

    public static synchronized void open(File file) {
        if (PASS_THROUGH) {
            OpenDataFileCommand openDataFileCommand = new OpenDataFileCommand(file);
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueue.invokeLater(openDataFileCommand);
            } else {
                openDataFileCommand.run();
            }
        } else {
            if (PENDING_FILES == null) {
                PENDING_FILES = new ArrayList();
            }
            PENDING_FILES.add(file);
        }
    }

    public static synchronized void enablePassThrough() {
        PASS_THROUGH = true;
        if (PENDING_FILES != null) {
            for (File file : PENDING_FILES) {
                OpenDataFileCommand.open(file);
            }
            PENDING_FILES = null;
        }
    }

    public OpenDataFileCommand(String string, File file) {
        super(string, CMD_PREFIX + file.getName() + CMD_POSTFIX, new ImageIcon(FileType.getIconForFile(file)));
        this.mFile = file;
    }

    public OpenDataFileCommand(File file) {
        super(file.getName(), CMD_PREFIX + file.getName() + CMD_POSTFIX);
        this.mFile = file;
        this.mVerify = true;
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.run();
    }

    @Override
    public void run() {
        if (this.mVerify) {
            OpenCommand.INSTANCE.adjustForMenu(null);
            if (!OpenCommand.INSTANCE.isEnabled()) {
                return;
            }
        }
        OpenCommand.INSTANCE.open(this.mFile);
    }
}

