/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.file.ClearRecentFilesMenuCommand;
import com.trollworks.ttk.menu.file.FileType;
import com.trollworks.ttk.menu.file.OpenDataFileCommand;
import com.trollworks.ttk.preferences.Preferences;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.Path;
import com.trollworks.ttk.utility.Platform;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class RecentFilesMenu
extends JMenu
implements MenuListener {
    private static final String PREFS_MODULE = "RecentFiles";
    private static final int PREFS_VERSION = 1;
    private static String MSG_TITLE;
    private static final int MAX_RECENTS = 20;
    private static final ArrayList<File> RECENTS;

    public static ArrayList<File> getRecents() {
        return new ArrayList<File>(RECENTS);
    }

    public static int getRecentCount() {
        return RECENTS.size();
    }

    public static void clearRecents() {
        RECENTS.clear();
    }

    public static void addRecent(File file) {
        String string = Path.getExtension(file.getName());
        if (Platform.isMacintosh() || Platform.isWindows()) {
            string = string.toLowerCase();
        }
        for (String string2 : FileType.getOpenableExtensions()) {
            if (!string2.equals(string)) continue;
            if (!file.canRead()) break;
            file = Path.getFile(Path.getFullPath(file));
            RECENTS.remove(file);
            RECENTS.add(0, file);
            if (RECENTS.size() <= 20) break;
            RECENTS.remove(20);
            break;
        }
    }

    public static void loadFromPreferences() {
        String string;
        RecentFilesMenu.clearRecents();
        Preferences preferences = Preferences.getInstance();
        preferences.resetIfVersionMisMatch(PREFS_MODULE, 1);
        for (int i = 0; i < 20 && (string = preferences.getStringValue(PREFS_MODULE, Integer.toString(i))) != null; ++i) {
            RecentFilesMenu.addRecent(Path.getFile(Path.normalizeFullPath(string)));
        }
    }

    public static void saveToPreferences() {
        Preferences preferences = Preferences.getInstance();
        preferences.startBatch();
        preferences.removePreferences(PREFS_MODULE);
        int n = RECENTS.size();
        for (int i = 0; i < n; ++i) {
            preferences.setValue(PREFS_MODULE, Integer.toString(n - (i + 1)), RECENTS.get(i).getAbsolutePath());
        }
        preferences.endBatch();
    }

    public RecentFilesMenu() {
        super(MSG_TITLE);
        this.addMenuListener(this);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.removeAll();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : RECENTS) {
            if (!file.canRead()) continue;
            arrayList.add(file);
            this.add(new JMenuItem(new OpenDataFileCommand(Path.getLeafName(file.getName(), false), file)));
            if (arrayList.size() != 20) continue;
            break;
        }
        RECENTS.clear();
        RECENTS.addAll(arrayList);
        if (RecentFilesMenu.getRecentCount() > 0) {
            this.addSeparator();
        }
        JMenuItem jMenuItem = new JMenuItem(ClearRecentFilesMenuCommand.INSTANCE);
        ClearRecentFilesMenuCommand.INSTANCE.adjustForMenu(jMenuItem);
        this.add(jMenuItem);
    }

    static {
        RECENTS = new ArrayList();
        LocalizedMessages.initialize(RecentFilesMenu.class);
        RecentFilesMenu.loadFromPreferences();
    }
}

