/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.file.RecentFilesMenu;
import com.trollworks.ttk.menu.file.Saveable;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.Path;
import com.trollworks.ttk.widgets.StdFileDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JMenuItem;

public class SaveAsCommand
extends Command {
    public static final String CMD_SAVE_AS = "SaveAs";
    private static String MSG_SAVE_AS;
    public static final SaveAsCommand INSTANCE;

    private SaveAsCommand() {
        super(MSG_SAVE_AS, CMD_SAVE_AS, 83, SHIFTED_COMMAND_MODIFIER);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        this.setEnabled(SaveAsCommand.getActiveWindow() instanceof Saveable);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.saveAs((Saveable)((Object)SaveAsCommand.getActiveWindow()));
    }

    public File[] saveAs(Saveable saveable) {
        File[] fileArray;
        String string = saveable.getPreferredSavePath();
        File file = StdFileDialog.choose(saveable instanceof Component ? (Component)((Object)saveable) : null, false, MSG_SAVE_AS, Path.getParent(string), Path.getLeafName(string), saveable.getAllowedExtensions());
        for (File file2 : fileArray = file != null ? saveable.saveTo(file) : new File[]{}) {
            RecentFilesMenu.addRecent(file2);
        }
        return fileArray;
    }

    static {
        LocalizedMessages.initialize(SaveAsCommand.class);
        INSTANCE = new SaveAsCommand();
    }
}

