/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.model;

import com.trollworks.ttk.model.ModelContext;
import com.trollworks.ttk.text.XMLGenerator;
import com.trollworks.ttk.text.XMLParser;
import com.trollworks.ttk.utility.LocalizedMessages;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;

public abstract class Model
implements Cloneable {
    private static String MSG_INVALID_ROOT_TAG;
    private static String MSG_TOO_OLD;
    private static String MSG_TOO_NEW;
    private static final String ATTR_VERSION = "version";

    public abstract String getRootTag();

    public abstract int getCurrentVersion();

    public abstract int getMinimumVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(InputStream inputStream, ModelContext modelContext) throws XMLStreamException {
        block13: {
            XMLStreamException xMLStreamException = null;
            XMLParser xMLParser = new XMLParser(inputStream);
            try {
                String string;
                while ((string = xMLParser.nextTag()) != null) {
                    if (this.getRootTag().equals(string)) {
                        this.load(xMLParser, modelContext);
                        break;
                    }
                    xMLParser.skip();
                }
            }
            catch (XMLStreamException xMLStreamException2) {
                xMLStreamException = xMLStreamException2;
            }
            finally {
                block14: {
                    try {
                        xMLParser.close();
                    }
                    catch (XMLStreamException xMLStreamException3) {
                        if (xMLStreamException != null) break block14;
                        xMLStreamException = xMLStreamException3;
                    }
                }
                if (xMLStreamException == null) break block13;
                throw xMLStreamException;
            }
        }
    }

    public final void load(XMLParser xMLParser, ModelContext modelContext) throws XMLStreamException {
        String string = xMLParser.getCurrentTag();
        if (this.getRootTag().equals(string)) {
            this.modelWillLoad(modelContext);
            String string2 = xMLParser.getMarker();
            int n = xMLParser.getIntegerAttribute(ATTR_VERSION);
            if (n < this.getMinimumVersion()) {
                throw new XMLStreamException(MessageFormat.format(MSG_TOO_OLD, xMLParser.getCurrentTag()), xMLParser.getLocation());
            }
            if (n > this.getCurrentVersion()) {
                throw new XMLStreamException(MessageFormat.format(MSG_TOO_NEW, xMLParser.getCurrentTag()), xMLParser.getLocation());
            }
            modelContext.mVersionStack.push(n);
            this.loadAttributes(xMLParser, modelContext);
            if (!this.loadContents(xMLParser, modelContext)) {
                while ((string = xMLParser.nextTag(string2)) != null) {
                    this.loadChildTag(string, xMLParser, modelContext);
                }
            }
        } else {
            throw new XMLStreamException(MessageFormat.format(MSG_INVALID_ROOT_TAG, this.getRootTag(), string), xMLParser.getLocation());
        }
        this.modelDidLoad(modelContext);
        modelContext.mVersionStack.pop();
    }

    protected boolean loadContents(XMLParser xMLParser, ModelContext modelContext) throws XMLStreamException {
        return false;
    }

    protected void modelWillLoad(ModelContext modelContext) throws XMLStreamException {
    }

    protected void modelDidLoad(ModelContext modelContext) throws XMLStreamException {
    }

    protected void loadAttributes(XMLParser xMLParser, ModelContext modelContext) throws XMLStreamException {
    }

    protected void loadChildTag(String string, XMLParser xMLParser, ModelContext modelContext) throws XMLStreamException {
        xMLParser.skip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(OutputStream outputStream, ModelContext modelContext) throws XMLStreamException {
        block11: {
            XMLStreamException xMLStreamException = null;
            XMLGenerator xMLGenerator = new XMLGenerator(outputStream);
            try {
                xMLGenerator.startDocument();
                this.save(xMLGenerator, modelContext);
                xMLGenerator.endDocument();
            }
            catch (XMLStreamException xMLStreamException2) {
                xMLStreamException = xMLStreamException2;
            }
            finally {
                block12: {
                    try {
                        xMLGenerator.close();
                    }
                    catch (XMLStreamException xMLStreamException3) {
                        if (xMLStreamException != null) break block12;
                        xMLStreamException = xMLStreamException3;
                    }
                }
                if (xMLStreamException == null) break block11;
                throw xMLStreamException;
            }
        }
    }

    public final void save(XMLGenerator xMLGenerator, ModelContext modelContext) throws XMLStreamException {
        this.modelWillSave(modelContext);
        String string = this.getRootTag();
        if (this.isEmptyTag()) {
            xMLGenerator.startEmptyTag(string);
            xMLGenerator.addAttribute(ATTR_VERSION, this.getCurrentVersion());
            this.saveAttributes(xMLGenerator, modelContext);
        } else {
            xMLGenerator.startTag(string);
            xMLGenerator.addAttribute(ATTR_VERSION, this.getCurrentVersion());
            this.saveAttributes(xMLGenerator, modelContext);
            this.saveChildTags(xMLGenerator, modelContext);
            xMLGenerator.endTag();
        }
        this.modelDidSave(modelContext);
    }

    protected abstract boolean isEmptyTag();

    protected void modelWillSave(ModelContext modelContext) throws XMLStreamException {
    }

    protected void modelDidSave(ModelContext modelContext) throws XMLStreamException {
    }

    protected void saveAttributes(XMLGenerator xMLGenerator, ModelContext modelContext) throws XMLStreamException {
    }

    protected void saveChildTags(XMLGenerator xMLGenerator, ModelContext modelContext) throws XMLStreamException {
    }

    public Model clone() {
        try {
            return (Model)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static {
        LocalizedMessages.initialize(Model.class);
    }
}

