/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.notification;

import com.trollworks.ttk.notification.BatchNotifierTarget;
import com.trollworks.ttk.notification.NotifierTarget;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;

public class Notifier
implements Comparator<NotifierTarget> {
    public static final String SEPARATOR = ".";
    private HashSet<BatchNotifierTarget> mBatchTargets = new HashSet();
    private HashMap<String, HashSet<NotifierTarget>> mProductionMap = new HashMap();
    private HashMap<NotifierTarget, HashSet<String>> mNameMap = new HashMap();
    private BatchNotifierTarget[] mCurrentBatch;
    private int mBatchLevel;
    private boolean mEnabled = true;

    public synchronized void add(Notifier notifier) {
        HashMap<NotifierTarget, HashSet<String>> hashMap = new HashMap<NotifierTarget, HashSet<String>>(notifier.mNameMap);
        for (Map.Entry<NotifierTarget, HashSet<String>> entry : hashMap.entrySet()) {
            HashSet<String> hashSet = entry.getValue();
            this.add(entry.getKey(), hashSet.toArray(new String[hashSet.size()]));
        }
    }

    public synchronized void add(NotifierTarget notifierTarget, String ... stringArray) {
        HashSet<String> hashSet = this.mNameMap.get(notifierTarget);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.mNameMap.put(notifierTarget, hashSet);
        }
        if (notifierTarget instanceof BatchNotifierTarget) {
            this.mBatchTargets.add((BatchNotifierTarget)notifierTarget);
        }
        for (String string : stringArray) {
            if ((string = this.normalizeName(string)).length() <= 0) continue;
            HashSet<NotifierTarget> hashSet2 = this.mProductionMap.get(string);
            if (hashSet2 == null) {
                hashSet2 = new HashSet();
                this.mProductionMap.put(string, hashSet2);
            }
            hashSet2.add(notifierTarget);
            hashSet.add(string);
        }
        if (hashSet.isEmpty()) {
            this.mNameMap.remove(notifierTarget);
        }
    }

    private String normalizeName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(stringTokenizer.nextToken());
        }
        return stringBuilder.toString();
    }

    public synchronized void remove(NotifierTarget notifierTarget) {
        if (this.mNameMap.containsKey(notifierTarget)) {
            if (notifierTarget instanceof BatchNotifierTarget) {
                this.mBatchTargets.remove(notifierTarget);
            }
            for (String string : this.mNameMap.get(notifierTarget)) {
                HashSet<NotifierTarget> hashSet;
                if (string.length() <= 0 || (hashSet = this.mProductionMap.get(string)) == null) continue;
                hashSet.remove(notifierTarget);
                if (!hashSet.isEmpty()) continue;
                this.mProductionMap.remove(string);
            }
            this.mNameMap.remove(notifierTarget);
        }
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean bl) {
        this.mEnabled = bl;
    }

    public void notify(Object object, String string, Object object2) {
        if (this.isEnabled()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
            StringBuilder stringBuilder = new StringBuilder();
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                stringBuilder.append(stringTokenizer.nextToken());
                String string2 = stringBuilder.toString();
                stringBuilder.append(SEPARATOR);
                HashSet<NotifierTarget> hashSet = this.mProductionMap.get(string2);
                if (hashSet == null || (n = hashSet.size()) <= 0) continue;
                NotifierTarget[] notifierTargetArray = hashSet.toArray(new NotifierTarget[n]);
                Arrays.sort(notifierTargetArray, this);
                for (NotifierTarget notifierTarget : notifierTargetArray) {
                    notifierTarget.handleNotification(object, string, object2);
                }
            }
        }
    }

    public synchronized void startBatch() {
        if (this.isEnabled() && ++this.mBatchLevel == 1 && !this.mBatchTargets.isEmpty()) {
            for (BatchNotifierTarget batchNotifierTarget : this.mCurrentBatch = this.mBatchTargets.toArray(new BatchNotifierTarget[this.mBatchTargets.size()])) {
                batchNotifierTarget.enterBatchMode();
            }
        }
    }

    public synchronized int getBatchLevel() {
        return this.mBatchLevel;
    }

    public synchronized void endBatch() {
        if (this.isEnabled() && --this.mBatchLevel < 1 && this.mCurrentBatch != null) {
            for (BatchNotifierTarget batchNotifierTarget : this.mCurrentBatch) {
                batchNotifierTarget.leaveBatchMode();
            }
            this.mCurrentBatch = null;
        }
    }

    public void reset() {
        this.mBatchTargets.clear();
        this.mProductionMap.clear();
        this.mNameMap.clear();
    }

    public void reset(NotifierTarget ... notifierTargetArray) {
        HashMap<NotifierTarget, HashSet<String>> hashMap = new HashMap<NotifierTarget, HashSet<String>>();
        for (NotifierTarget notifierTarget : notifierTargetArray) {
            HashSet<String> hashSet;
            if (notifierTarget == null || (hashSet = this.mNameMap.get(notifierTarget)) == null || hashSet.isEmpty()) continue;
            hashMap.put(notifierTarget, hashSet);
        }
        this.reset();
        for (NotifierTarget notifierTarget : hashMap.keySet()) {
            HashSet hashSet = (HashSet)hashMap.get(notifierTarget);
            this.add(notifierTarget, hashSet.toArray(new String[hashSet.size()]));
        }
    }

    @Override
    public int compare(NotifierTarget notifierTarget, NotifierTarget notifierTarget2) {
        int n;
        int n2 = notifierTarget.getNotificationPriority();
        if (n2 > (n = notifierTarget2.getNotificationPriority())) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        return 0;
    }
}

