/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.preferences;

import com.trollworks.ttk.layout.FlexGrid;
import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.StdMenuBar;
import com.trollworks.ttk.preferences.PreferencePanel;
import com.trollworks.ttk.preferences.Preferences;
import com.trollworks.ttk.preferences.PreferencesWindow;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.BandedPanel;
import com.trollworks.ttk.widgets.KeyStrokeDisplay;
import com.trollworks.ttk.widgets.WindowUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class MenuKeyPreferences
extends PreferencePanel
implements ActionListener {
    private static final String NONE = "NONE";
    private static final String MODULE = "MenuKeys";
    private static String MSG_MENU_KEYS;
    private static String MSG_CLEAR;
    private static String MSG_ACCEPT;
    private static String MSG_RESET;
    private static String MSG_TYPE_KEYSTROKE;
    private static boolean LOADED;
    private HashMap<JButton, Command> mMap = new HashMap();
    private BandedPanel mPanel;

    public MenuKeyPreferences(PreferencesWindow preferencesWindow) {
        super(MSG_MENU_KEYS, preferencesWindow);
        this.setLayout(new BorderLayout());
        this.mPanel = new BandedPanel(MSG_MENU_KEYS);
        this.mPanel.setBorder(new EmptyBorder(2, 5, 2, 5));
        this.mPanel.setOpaque(true);
        this.mPanel.setBackground(Color.WHITE);
        FlexGrid flexGrid = new FlexGrid();
        int n = 0;
        for (Command command : StdMenuBar.getCommands()) {
            JButton jButton = new JButton(this.getAcceleratorText(command));
            this.mMap.put(jButton, command);
            jButton.addActionListener(this);
            this.mPanel.add(jButton);
            flexGrid.add(jButton, n, 0);
            JLabel jLabel = new JLabel(command.getTitle());
            this.mPanel.add(jLabel);
            flexGrid.add(jLabel, n++, 1);
        }
        flexGrid.apply(this.mPanel);
        this.mPanel.setSize(this.mPanel.getPreferredSize());
        JScrollPane jScrollPane = new JScrollPane(this.mPanel);
        Dimension dimension = jScrollPane.getPreferredSize();
        if (dimension.height > 200) {
            dimension.height = 200;
        }
        jScrollPane.setPreferredSize(dimension);
        this.add(jScrollPane);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        Command command = this.mMap.get(jButton);
        KeyStrokeDisplay keyStrokeDisplay = new KeyStrokeDisplay(command.getAccelerator());
        switch (WindowUtils.showOptionDialog(this, keyStrokeDisplay, MSG_TYPE_KEYSTROKE, false, 1, -1, null, new Object[]{MSG_ACCEPT, MSG_CLEAR, MSG_RESET}, null)) {
            case -1: {
                break;
            }
            case 0: {
                this.setAccelerator(jButton, keyStrokeDisplay.getKeyStroke());
                break;
            }
            case 1: {
                this.setAccelerator(jButton, null);
                break;
            }
            case 2: {
                this.setAccelerator(jButton, command.getOriginalAccelerator());
            }
        }
        this.mPanel.setSize(this.mPanel.getPreferredSize());
        this.adjustResetButton();
    }

    @Override
    public void reset() {
        for (JButton jButton : this.mMap.keySet()) {
            this.setAccelerator(jButton, this.mMap.get(jButton).getOriginalAccelerator());
            jButton.invalidate();
        }
        this.mPanel.setSize(this.mPanel.getPreferredSize());
    }

    @Override
    public boolean isSetToDefaults() {
        for (Command command : this.mMap.values()) {
            if (command.hasOriginalAccelerator()) continue;
            return false;
        }
        return true;
    }

    private String getAcceleratorText(Command command) {
        return KeyStrokeDisplay.getKeyStrokeDisplay(command.getAccelerator());
    }

    private void setAccelerator(JButton jButton, KeyStroke keyStroke) {
        Command command = this.mMap.get(jButton);
        command.setAccelerator(keyStroke);
        jButton.setText(this.getAcceleratorText(command));
        jButton.invalidate();
        Preferences preferences = Preferences.getInstance();
        String string = command.getCommand();
        if (command.hasOriginalAccelerator()) {
            preferences.removePreference(MODULE, string);
        } else {
            preferences.setValue(MODULE, string, keyStroke != null ? keyStroke.toString() : NONE);
        }
    }

    public static synchronized void loadFromPreferences() {
        if (!LOADED) {
            Preferences preferences = Preferences.getInstance();
            for (Command command : StdMenuBar.getCommands()) {
                String string = preferences.getStringValue(MODULE, command.getCommand());
                if (string == null) continue;
                if (NONE.equals(string)) {
                    command.setAccelerator(null);
                    continue;
                }
                command.setAccelerator(KeyStroke.getKeyStroke(string));
            }
            LOADED = true;
        }
    }

    static {
        LOADED = false;
        LocalizedMessages.initialize(MenuKeyPreferences.class);
    }
}

