/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.print;

import com.trollworks.ttk.collections.Enums;
import com.trollworks.ttk.preferences.Preferences;
import com.trollworks.ttk.print.InkChromaticity;
import com.trollworks.ttk.print.PageOrientation;
import com.trollworks.ttk.print.PageSetupPanel;
import com.trollworks.ttk.print.PageSides;
import com.trollworks.ttk.print.PrintPanel;
import com.trollworks.ttk.print.PrintUtilities;
import com.trollworks.ttk.print.Quality;
import com.trollworks.ttk.text.Numbers;
import com.trollworks.ttk.units.LengthUnits;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.AppWindow;
import com.trollworks.ttk.widgets.WindowUtils;
import com.trollworks.ttk.xml.XMLNodeType;
import com.trollworks.ttk.xml.XMLReader;
import com.trollworks.ttk.xml.XMLWriter;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;

public class PrintManager {
    private static String MSG_PRINTING_FAILED;
    private static String MSG_NO_PRINTER_AVAILABLE;
    private static String MSG_UNABLE_TO_SWITCH_PRINTERS;
    private static String MSG_PAGE_SETUP_TITLE;
    private static String MSG_PRINT_TITLE;
    private static final String MODULE = "PrintManager";
    private static final int MODULE_VERSION = 1;
    private static final String NATIVE_DIALOGS_ENABLED_KEY = "UseNativeDialogs";
    public static final String TAG_ROOT = "print_settings";
    private static final String ATTRIBUTE_UNITS = "units";
    private static final String ATTRIBUTE_PRINTER = "printer";
    private static final String TAG_ORIENTATION = "orientation";
    private static final String TAG_WIDTH = "width";
    private static final String TAG_HEIGHT = "height";
    private static final String TAG_TOP_MARGIN = "top_margin";
    private static final String TAG_BOTTOM_MARGIN = "bottom_margin";
    private static final String TAG_LEFT_MARGIN = "left_margin";
    private static final String TAG_RIGHT_MARGIN = "right_margin";
    private static final String TAG_CHROMATICITY = "ink_chromaticity";
    private static final String TAG_SIDES = "sides";
    private static final String TAG_NUMBER_UP = "number_up";
    private static final String TAG_QUALITY = "quality";
    private static final String TAG_RESOLUTION = "resolution";
    private PrinterJob mJob;
    private HashPrintRequestAttributeSet mSet;

    public PrintManager() {
        this.mJob = PrinterJob.getPrinterJob();
        this.mSet = new HashPrintRequestAttributeSet();
    }

    public PrintManager(double d, LengthUnits lengthUnits) {
        this();
        this.setPageMargins(new double[]{d, d, d, d}, lengthUnits);
    }

    public PrintManager(double[] dArray, LengthUnits lengthUnits) {
        this();
        this.setPageMargins(dArray, lengthUnits);
    }

    public PrintManager(PageOrientation pageOrientation, double d, LengthUnits lengthUnits) {
        this();
        this.setPageOrientation(pageOrientation);
        this.setPageMargins(new double[]{d, d, d, d}, lengthUnits);
    }

    public PrintManager(PageOrientation pageOrientation, double[] dArray, LengthUnits lengthUnits) {
        this();
        this.setPageOrientation(pageOrientation);
        this.setPageMargins(dArray, lengthUnits);
    }

    public PrintManager(XMLReader xMLReader) throws IOException {
        this.load(xMLReader);
    }

    public void load(XMLReader xMLReader) throws IOException {
        String string = xMLReader.getMarker();
        LengthUnits lengthUnits = (LengthUnits)Enums.extract((String)xMLReader.getAttribute(ATTRIBUTE_UNITS), (Enum[])LengthUnits.values(), (Enum)LengthUnits.INCHES);
        String string2 = xMLReader.getAttribute(ATTRIBUTE_PRINTER);
        double[] dArray = new double[]{8.5, 11.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        if (string2 != null && string2.length() > 0) {
            try {
                for (PrintService printService : PrinterJob.lookupPrintServices()) {
                    if (!printService.getName().equalsIgnoreCase(string2)) continue;
                    this.mJob.setPrintService(printService);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        do {
            if (xMLReader.next() != XMLNodeType.START_TAG) continue;
            String string3 = xMLReader.getName();
            try {
                if (TAG_ORIENTATION.equals(string3)) {
                    this.setPageOrientation((PageOrientation)Enums.extract((String)xMLReader.readText(), (Enum[])PageOrientation.values(), (Enum)PageOrientation.PORTRAIT));
                    continue;
                }
                if (TAG_WIDTH.equals(string3)) {
                    dArray[0] = this.getNumber(xMLReader, lengthUnits, 8.5);
                    continue;
                }
                if (TAG_HEIGHT.equals(string3)) {
                    dArray[1] = this.getNumber(xMLReader, lengthUnits, 11.0);
                    continue;
                }
                if (TAG_TOP_MARGIN.equals(string3)) {
                    dArray2[0] = this.getNumber(xMLReader, lengthUnits, 0.0);
                    continue;
                }
                if (TAG_LEFT_MARGIN.equals(string3)) {
                    dArray2[1] = this.getNumber(xMLReader, lengthUnits, 0.0);
                    continue;
                }
                if (TAG_BOTTOM_MARGIN.equals(string3)) {
                    dArray2[2] = this.getNumber(xMLReader, lengthUnits, 0.0);
                    continue;
                }
                if (TAG_RIGHT_MARGIN.equals(string3)) {
                    dArray2[3] = this.getNumber(xMLReader, lengthUnits, 0.0);
                    continue;
                }
                if (TAG_CHROMATICITY.equals(string3)) {
                    this.setChromaticity((InkChromaticity)Enums.extract((String)xMLReader.readText(), (Enum[])InkChromaticity.values(), (Enum)InkChromaticity.COLOR));
                    continue;
                }
                if (TAG_SIDES.equals(string3)) {
                    this.setSides((PageSides)Enums.extract((String)xMLReader.readText(), (Enum[])PageSides.values(), (Enum)PageSides.SINGLE));
                    continue;
                }
                if (TAG_NUMBER_UP.equals(string3)) {
                    this.setNumberUp(xMLReader.readInteger(1));
                    continue;
                }
                if (TAG_QUALITY.equals(string3)) {
                    this.setPrintQuality((Quality)Enums.extract((String)xMLReader.readText(), (Enum[])Quality.values(), (Enum)Quality.NORMAL));
                    continue;
                }
                if (TAG_RESOLUTION.equals(string3)) {
                    this.setResolution(this.extractFromResolutionString(xMLReader.readText()));
                    continue;
                }
                xMLReader.skipTag(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (xMLReader.withinMarker(string));
        this.setPaperSize(dArray, lengthUnits);
        this.setPaperMargins(dArray2, lengthUnits);
    }

    private double getNumber(XMLReader xMLReader, LengthUnits lengthUnits, double d) throws IOException {
        return xMLReader.readDouble(lengthUnits.convert(LengthUnits.INCHES, d));
    }

    public boolean pageSetup(AppWindow appWindow) {
        if (PrintManager.useNativeDialogs()) {
            PageFormat pageFormat = this.mJob.pageDialog(this.createPageFormat());
            if (pageFormat != null) {
                this.adjustSettingsToPageFormat(pageFormat);
                appWindow.adjustToPageSetupChanges();
                return true;
            }
        } else {
            PageSetupPanel pageSetupPanel = new PageSetupPanel(this.getPrintService(), this.mSet);
            if (WindowUtils.showOptionDialog(appWindow, pageSetupPanel, MSG_PAGE_SETUP_TITLE, false, 2, -1, null, null, null) == 0) {
                try {
                    PrintService printService = pageSetupPanel.accept(this.mSet);
                    if (printService != null) {
                        this.mJob.setPrintService(printService);
                    }
                    appWindow.adjustToPageSetupChanges();
                    return true;
                }
                catch (PrinterException printerException) {
                    WindowUtils.showError(appWindow, MSG_UNABLE_TO_SWITCH_PRINTERS);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(AppWindow appWindow, String string, Printable printable) {
        PrintService printService = this.getPrintService();
        if (printService != null) {
            if (PrintManager.useNativeDialogs()) {
                this.mJob.setJobName(string);
                if (this.mJob.printDialog()) {
                    try {
                        appWindow.adjustToPageSetupChanges();
                        appWindow.setPrinting(true);
                        this.mJob.setPrintable(printable, this.createPageFormat());
                        this.mJob.print();
                    }
                    catch (PrinterException printerException) {
                        WindowUtils.showError(appWindow, MSG_PRINTING_FAILED);
                    }
                    finally {
                        appWindow.setPrinting(false);
                    }
                }
            } else {
                this.mSet.add(new JobName(string, null));
                PrintPanel printPanel = new PrintPanel(this.getPrintService(), this.mSet);
                if (WindowUtils.showOptionDialog(appWindow, printPanel, MSG_PRINT_TITLE, false, 2, -1, null, null, null) == 0) {
                    try {
                        this.mJob.setPrintService(printPanel.accept(this.mSet));
                        try {
                            appWindow.adjustToPageSetupChanges();
                            appWindow.setPrinting(true);
                            this.mJob.setPrintable(printable, this.createPageFormat());
                            this.mJob.print(this.mSet);
                        }
                        catch (PrinterException printerException) {
                            WindowUtils.showError(appWindow, MSG_PRINTING_FAILED);
                        }
                        finally {
                            appWindow.setPrinting(false);
                        }
                    }
                    catch (PrinterException printerException) {
                        WindowUtils.showError(appWindow, MSG_UNABLE_TO_SWITCH_PRINTERS);
                    }
                }
            }
        } else {
            WindowUtils.showError(appWindow, MSG_NO_PRINTER_AVAILABLE);
        }
    }

    public PageFormat createPageFormat() {
        PageFormat pageFormat = new PageFormat();
        PageOrientation pageOrientation = this.getPageOrientation();
        double[] dArray = this.getPaperSize(LengthUnits.POINTS);
        double[] dArray2 = this.getPaperMargins(LengthUnits.POINTS);
        Paper paper = new Paper();
        if (pageOrientation == PageOrientation.PORTRAIT) {
            pageFormat.setOrientation(1);
        } else if (pageOrientation == PageOrientation.LANDSCAPE) {
            pageFormat.setOrientation(0);
        } else if (pageOrientation == PageOrientation.REVERSE_PORTRAIT) {
            pageFormat.setOrientation(1);
        } else if (pageOrientation == PageOrientation.REVERSE_LANDSCAPE) {
            pageFormat.setOrientation(2);
        }
        paper.setSize(dArray[0], dArray[1]);
        paper.setImageableArea(dArray2[1], dArray2[0], dArray[0] - (dArray2[1] + dArray2[3]), dArray[1] - (dArray2[0] + dArray2[2]));
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public void adjustSettingsToPageFormat(PageFormat pageFormat) {
        Paper paper = pageFormat.getPaper();
        this.setPageOrientation(PageOrientation.get(pageFormat));
        this.setPaperSize(new double[]{paper.getWidth(), paper.getHeight()}, LengthUnits.POINTS);
        this.setPaperMargins(new double[]{paper.getImageableY(), paper.getImageableX(), paper.getHeight() - (paper.getImageableY() + paper.getImageableHeight()), paper.getWidth() - (paper.getImageableX() + paper.getImageableWidth())}, LengthUnits.POINTS);
    }

    public void save(XMLWriter xMLWriter, LengthUnits lengthUnits) {
        double[] dArray = this.getPaperSize(lengthUnits);
        double[] dArray2 = this.getPaperMargins(lengthUnits);
        PrintService printService = this.getPrintService();
        xMLWriter.startTag(TAG_ROOT);
        if (printService != null) {
            xMLWriter.writeAttribute(ATTRIBUTE_PRINTER, printService.getName());
        }
        xMLWriter.writeAttribute(ATTRIBUTE_UNITS, lengthUnits.toString());
        xMLWriter.finishTagEOL();
        xMLWriter.simpleTag(TAG_ORIENTATION, (Object)this.getPageOrientation());
        xMLWriter.simpleTag(TAG_WIDTH, dArray[0]);
        xMLWriter.simpleTag(TAG_HEIGHT, dArray[1]);
        xMLWriter.simpleTag(TAG_TOP_MARGIN, dArray2[0]);
        xMLWriter.simpleTag(TAG_LEFT_MARGIN, dArray2[1]);
        xMLWriter.simpleTag(TAG_BOTTOM_MARGIN, dArray2[2]);
        xMLWriter.simpleTag(TAG_RIGHT_MARGIN, dArray2[3]);
        xMLWriter.simpleTag(TAG_CHROMATICITY, (Object)this.getChromaticity(false));
        xMLWriter.simpleTag(TAG_SIDES, (Object)this.getSides());
        xMLWriter.simpleTag(TAG_NUMBER_UP, this.getNumberUp());
        xMLWriter.simpleTag(TAG_QUALITY, (Object)this.getPrintQuality(false));
        xMLWriter.simpleTagNotEmpty(TAG_RESOLUTION, this.createResolutionString(this.getResolution(false)));
        xMLWriter.endTagEOL(TAG_ROOT, true);
    }

    private PrintService getPrintService() {
        try {
            return this.mJob.getPrintService();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private PrinterResolution extractFromResolutionString(String string) {
        if (string != null && string.length() > 0) {
            int n;
            int n2;
            int n3 = string.indexOf(120);
            if (n3 != -1 && n3 < string.length() - 1) {
                n2 = Numbers.getInteger(string.substring(0, n3), 0);
                n = Numbers.getInteger(string.substring(n3 + 1), 0);
            } else {
                n = n2 = Numbers.getInteger(string, 0);
            }
            if (n2 < 1 || n < 1) {
                return null;
            }
            return new PrinterResolution(n2, n, 1);
        }
        return null;
    }

    private String createResolutionString(PrinterResolution printerResolution) {
        if (printerResolution != null) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = printerResolution.getCrossFeedResolution(1);
            int n2 = printerResolution.getFeedResolution(1);
            stringBuilder.append(Integer.toString(n));
            if (n != n2) {
                stringBuilder.append("x");
                stringBuilder.append(Integer.toString(n2));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public PageOrientation getPageOrientation() {
        return PrintUtilities.getPageOrientation(this.getPrintService(), this.mSet);
    }

    public void setPageOrientation(PageOrientation pageOrientation) {
        PrintUtilities.setPageOrientation(this.mSet, pageOrientation);
    }

    public double[] getPaperMargins(LengthUnits lengthUnits) {
        return PrintUtilities.getPaperMargins(this.getPrintService(), this.mSet, lengthUnits);
    }

    public void setPaperMargins(double[] dArray, LengthUnits lengthUnits) {
        PrintUtilities.setPaperMargins(this.getPrintService(), this.mSet, dArray, lengthUnits);
    }

    public double[] getPageMargins(LengthUnits lengthUnits) {
        return PrintUtilities.getPageMargins(this.getPrintService(), this.mSet, lengthUnits);
    }

    public void setPageMargins(double[] dArray, LengthUnits lengthUnits) {
        PrintUtilities.setPageMargins(this.getPrintService(), this.mSet, dArray, lengthUnits);
    }

    public double[] getPaperSize(LengthUnits lengthUnits) {
        return PrintUtilities.getPaperSize(this.getPrintService(), this.mSet, lengthUnits);
    }

    public void setPaperSize(double[] dArray, LengthUnits lengthUnits) {
        PrintUtilities.setPaperSize(this.getPrintService(), this.mSet, dArray, lengthUnits);
    }

    public double[] getPageSize(LengthUnits lengthUnits) {
        return PrintUtilities.getPageSize(this.getPrintService(), this.mSet, lengthUnits);
    }

    public void setPageSize(double[] dArray, LengthUnits lengthUnits) {
        PrintUtilities.setPageSize(this.getPrintService(), this.mSet, dArray, lengthUnits);
    }

    public PrinterJob getJob() {
        return this.mJob;
    }

    public void setAttribute(Attribute attribute) {
        this.mSet.add(attribute);
    }

    public InkChromaticity getChromaticity(boolean bl) {
        return PrintUtilities.getChromaticity(this.getPrintService(), this.mSet, bl);
    }

    public void setChromaticity(InkChromaticity inkChromaticity) {
        PrintUtilities.setChromaticity(this.mSet, inkChromaticity);
    }

    public PageSides getSides() {
        return PrintUtilities.getSides(this.getPrintService(), this.mSet);
    }

    public void setSides(PageSides pageSides) {
        PrintUtilities.setSides(this.mSet, pageSides);
    }

    public NumberUp getNumberUp() {
        return PrintUtilities.getNumberUp(this.getPrintService(), this.mSet);
    }

    public void setNumberUp(NumberUp numberUp) {
        PrintUtilities.setNumberUp(this.mSet, numberUp);
    }

    public void setNumberUp(int n) {
        PrintService printService = this.getPrintService();
        if (printService != null) {
            for (NumberUp numberUp : (NumberUp[])printService.getSupportedAttributeValues(NumberUp.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null)) {
                if (numberUp.getValue() != n) continue;
                this.setNumberUp(numberUp);
                return;
            }
        }
    }

    public Quality getPrintQuality(boolean bl) {
        return PrintUtilities.getPrintQuality(this.getPrintService(), this.mSet, bl);
    }

    public void setPrintQuality(Quality quality) {
        PrintUtilities.setPrintQuality(this.mSet, quality);
    }

    public int getCopies() {
        return PrintUtilities.getCopies(this.getPrintService(), this.mSet);
    }

    public void setCopies(int n) {
        PrintUtilities.setCopies(this.mSet, n);
    }

    public PageRanges getPageRanges() {
        return PrintUtilities.getPageRanges(this.getPrintService(), this.mSet);
    }

    public void setPageRanges(PageRanges pageRanges) {
        PrintUtilities.setPageRanges(this.mSet, pageRanges);
    }

    public PrinterResolution getResolution(boolean bl) {
        return PrintUtilities.getResolution(this.getPrintService(), this.mSet, bl);
    }

    public void setResolution(PrinterResolution printerResolution) {
        PrintUtilities.setResolution(this.mSet, printerResolution);
    }

    public static boolean useNativeDialogs() {
        return Preferences.getInstance().getBooleanValue(MODULE, NATIVE_DIALOGS_ENABLED_KEY, false);
    }

    public static void useNativeDialogs(boolean bl) {
        Preferences.getInstance().setValue(MODULE, NATIVE_DIALOGS_ENABLED_KEY, bl);
    }

    static {
        LocalizedMessages.initialize(PrintManager.class);
        Preferences.getInstance().resetIfVersionMisMatch(MODULE, 1);
    }
}

