/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.print;

import com.trollworks.ttk.layout.Alignment;
import com.trollworks.ttk.layout.FlexComponent;
import com.trollworks.ttk.layout.FlexGrid;
import com.trollworks.ttk.layout.FlexRow;
import com.trollworks.ttk.print.PageSetupPanel;
import com.trollworks.ttk.print.PrintUtilities;
import com.trollworks.ttk.text.IntegerFormatter;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.UIUtilities;
import com.trollworks.ttk.widgets.EditorField;
import com.trollworks.ttk.widgets.LinkedLabel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.PageRanges;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.text.DefaultFormatterFactory;

public class PrintPanel
extends PageSetupPanel {
    private static String MSG_COPIES;
    private static String MSG_PAGE_RANGE;
    private static String MSG_ALL;
    private static String MSG_PAGES;
    private static String MSG_TO;
    private EditorField mCopies;
    private JRadioButton mPageRangeAll;
    private JRadioButton mPageRangeSome;
    private EditorField mPageRangeStart;
    private EditorField mPageRangeEnd;

    public PrintPanel(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        super(printService, printRequestAttributeSet);
    }

    @Override
    protected void rebuildSelf(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        n = this.createCopiesField(printRequestAttributeSet, flexGrid, n);
        n = this.createPageRangeFields(printRequestAttributeSet, flexGrid, n);
        super.rebuildSelf(printRequestAttributeSet, flexGrid, n);
    }

    private int createCopiesField(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        PrintService printService = this.getService();
        if (printService.isAttributeCategorySupported(Copies.class)) {
            this.mCopies = new EditorField(new DefaultFormatterFactory(new IntegerFormatter(1, 999, false)), null, 4, new Integer(PrintUtilities.getCopies(printService, printRequestAttributeSet)), new Integer(999), null);
            UIUtilities.setOnlySize(this.mCopies, this.mCopies.getPreferredSize());
            this.add(this.mCopies);
            LinkedLabel linkedLabel = new LinkedLabel(MSG_COPIES, (JComponent)this.mCopies);
            this.add(linkedLabel);
            flexGrid.add(new FlexComponent(linkedLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            flexGrid.add(this.mCopies, n, 1);
            return n + 1;
        }
        this.mCopies = null;
        return n;
    }

    private int createPageRangeFields(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        PrintService printService = this.getService();
        if (printService.isAttributeCategorySupported(PageRanges.class)) {
            Object object;
            ButtonGroup buttonGroup = new ButtonGroup();
            int n2 = 1;
            int n3 = 9999;
            PageRanges pageRanges = (PageRanges)printRequestAttributeSet.get(PageRanges.class);
            if (pageRanges != null) {
                object = pageRanges.getMembers();
                if (((int[][])object).length > 0 && object[0].length > 1) {
                    n2 = object[0][0];
                    n3 = object[0][1];
                } else {
                    pageRanges = null;
                }
            }
            object = new JLabel(MSG_PAGE_RANGE, 0);
            this.add((Component)object);
            flexGrid.add(new FlexComponent((Component)object, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            this.mPageRangeAll = new JRadioButton(MSG_ALL, pageRanges == null);
            this.add(this.mPageRangeAll);
            this.mPageRangeSome = new JRadioButton(MSG_PAGES, pageRanges != null);
            this.add(this.mPageRangeSome);
            this.mPageRangeStart = this.createPageRangeField(n2);
            this.mPageRangeEnd = this.createPageRangeField(n3);
            buttonGroup.add(this.mPageRangeAll);
            buttonGroup.add(this.mPageRangeSome);
            this.adjustPageRanges();
            this.mPageRangeAll.addActionListener(this);
            this.mPageRangeSome.addActionListener(this);
            object = new JLabel(MSG_TO, 0);
            this.add((Component)object);
            FlexRow flexRow = new FlexRow();
            flexRow.add(this.mPageRangeAll);
            flexRow.add(this.mPageRangeSome);
            flexRow.add(this.mPageRangeStart);
            flexRow.add((Component)object);
            flexRow.add(this.mPageRangeEnd);
            flexGrid.add(flexRow, n, 1);
            return n + 1;
        }
        this.mPageRangeAll = null;
        this.mPageRangeSome = null;
        this.mPageRangeStart = null;
        this.mPageRangeEnd = null;
        return n;
    }

    private EditorField createPageRangeField(int n) {
        EditorField editorField = new EditorField(new DefaultFormatterFactory(new IntegerFormatter(1, 9999, false)), null, 4, new Integer(n), new Integer(9999), null);
        UIUtilities.setOnlySize(editorField, editorField.getPreferredSize());
        this.add(editorField);
        return editorField;
    }

    private void adjustPageRanges() {
        boolean bl = !this.mPageRangeAll.isSelected();
        this.mPageRangeStart.setEnabled(bl);
        this.mPageRangeEnd.setEnabled(bl);
    }

    @Override
    public PrintService accept(PrintRequestAttributeSet printRequestAttributeSet) {
        PrintService printService = super.accept(printRequestAttributeSet);
        if (this.mCopies != null) {
            PrintUtilities.setCopies(printRequestAttributeSet, (Integer)this.mCopies.getValue());
        }
        if (this.mPageRangeAll != null) {
            if (this.mPageRangeAll.isSelected()) {
                PrintUtilities.setPageRanges(printRequestAttributeSet, null);
            } else {
                int n;
                int n2 = (Integer)this.mPageRangeStart.getValue();
                if (n2 > (n = ((Integer)this.mPageRangeEnd.getValue()).intValue())) {
                    int n3 = n2;
                    n2 = n;
                    n = n3;
                }
                PrintUtilities.setPageRanges(printRequestAttributeSet, new PageRanges(n2, n));
            }
        }
        return printService;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mPageRangeAll || object == this.mPageRangeSome) {
            this.adjustPageRanges();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    static {
        LocalizedMessages.initialize(PrintPanel.class);
    }
}

