/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final String PREFERRED_ENCODING = "UTF-8";
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte WHITESPACE_ENCODING = -5;
    private static final byte EQUALS_ENCODING = -1;
    private static final byte[] ALPHABET;
    private static final byte[] NATIVE_ALPHABET;
    private static final byte[] DECODE_ALPHABET;

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, 0, byArray.length, true);
    }

    public static String encode(byte[] byArray, boolean bl) {
        return Base64.encode(byArray, 0, byArray.length, bl);
    }

    public static String encode(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = n2 * 4 / 3;
        byte[] byArray2 = new byte[n3 + (n2 % 3 > 0 ? 4 : 0) + (bl ? n3 / 76 : 0)];
        int n4 = n2 - 2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            Base64.encode3to4(byArray, n7 + n, 3, byArray2, n6);
            if (bl && (n5 += 4) == 76) {
                byArray2[n6++ + 4] = 10;
                n5 = 0;
            }
            n7 += 3;
            n6 += 4;
        }
        if (n7 < n2) {
            Base64.encode3to4(byArray, n7 + n, n2 - n7, byArray2, n6);
            n6 += 4;
        }
        try {
            return new String(byArray2, 0, n6, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray2, 0, n6);
        }
    }

    private static void encode3to4(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = (n2 > 0 ? byArray[n] << 24 >>> 8 : 0) | (n2 > 1 ? byArray[n + 1] << 24 >>> 16 : 0) | (n2 > 2 ? byArray[n + 2] << 24 >>> 24 : 0);
        switch (n2) {
            case 3: {
                byArray2[n3++] = ALPHABET[n4 >>> 18];
                byArray2[n3++] = ALPHABET[n4 >>> 12 & 0x3F];
                byArray2[n3++] = ALPHABET[n4 >>> 6 & 0x3F];
                byArray2[n3] = ALPHABET[n4 & 0x3F];
                break;
            }
            case 2: {
                byArray2[n3++] = ALPHABET[n4 >>> 18];
                byArray2[n3++] = ALPHABET[n4 >>> 12 & 0x3F];
                byArray2[n3++] = ALPHABET[n4 >>> 6 & 0x3F];
                byArray2[n3] = 61;
                break;
            }
            case 1: {
                byArray2[n3++] = ALPHABET[n4 >>> 18];
                byArray2[n3++] = ALPHABET[n4 >>> 12 & 0x3F];
                byArray2[n3++] = 61;
                byArray2[n3] = 61;
            }
        }
    }

    public static byte[] decode(String string) {
        byte[] byArray;
        int n = 0;
        byte[] byArray2 = new byte[4];
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        byte by2 = 0;
        try {
            byArray = string.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        int n4 = byArray.length;
        byte[] byArray3 = new byte[n4 * 3 / 4];
        for (n3 = 0; n3 < n4; ++n3) {
            by = (byte)(byArray[n3] & 0x7F);
            by2 = DECODE_ALPHABET[by];
            if (by2 >= -5) {
                int n5;
                if (by2 < -1) continue;
                byArray2[n2++] = by;
                if (n2 <= 3) continue;
                if (byArray2[2] == 61) {
                    n5 = (DECODE_ALPHABET[byArray2[0]] & 0xFF) << 18 | (DECODE_ALPHABET[byArray2[1]] & 0xFF) << 12;
                    byArray3[n++] = (byte)(n5 >>> 16);
                } else if (byArray2[3] == 61) {
                    n5 = (DECODE_ALPHABET[byArray2[0]] & 0xFF) << 18 | (DECODE_ALPHABET[byArray2[1]] & 0xFF) << 12 | (DECODE_ALPHABET[byArray2[2]] & 0xFF) << 6;
                    byArray3[n++] = (byte)(n5 >>> 16);
                    byArray3[n++] = (byte)(n5 >>> 8);
                } else {
                    n5 = (DECODE_ALPHABET[byArray2[0]] & 0xFF) << 18 | (DECODE_ALPHABET[byArray2[1]] & 0xFF) << 12 | (DECODE_ALPHABET[byArray2[2]] & 0xFF) << 6 | DECODE_ALPHABET[byArray2[3]] & 0xFF;
                    byArray3[n++] = (byte)(n5 >> 16);
                    byArray3[n++] = (byte)(n5 >> 8);
                    byArray3[n++] = (byte)n5;
                }
                n2 = 0;
                if (by != 61) continue;
                break;
            }
            return null;
        }
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray3, 0, byArray4, 0, n);
        return byArray4;
    }

    static {
        byte[] byArray;
        NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        DECODE_ALPHABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
        try {
            byArray = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = NATIVE_ALPHABET;
        }
        ALPHABET = byArray;
    }
}

