/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;

public class Numbers {
    private static final String HEX_PREFIX = "0x";
    private static final DecimalFormat NUMBER_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance();
    private static final DecimalFormat NUMBER_PLUS_FORMAT;

    public static boolean getBoolean(String string) {
        return "true".equalsIgnoreCase(string = Numbers.normalize(string)) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string) || "1".equals(string);
    }

    public static short getShort(String string) {
        return Numbers.getShort(string, (short)0);
    }

    public static short getShort(String string, short s) {
        return Numbers.getShort(string, s, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    public static short getShort(String string, short s, short s2, short s3) {
        int n = 10;
        if ((string = Numbers.normalize(string)) != null && string.startsWith(HEX_PREFIX)) {
            string = string.substring(HEX_PREFIX.length());
            n = 16;
        }
        return Numbers.getShort(string, n, s, s2, s3);
    }

    public static short getShort(String string, int n, short s, short s2, short s3) {
        try {
            string = Numbers.normalize(string);
            if (n == 16 && string.length() == 4) {
                short s4 = (short)Character.digit(string.charAt(0), n);
                s4 = (short)(s4 << 14);
                s4 = (short)(s4 | Short.parseShort(string.substring(1), n));
            } else {
                s = Short.parseShort(Numbers.normalize(string), n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s2 > s) {
            s = s2;
        } else if (s3 < s) {
            s = s3;
        }
        return s;
    }

    public static short getLocalizedShort(String string) {
        return Numbers.getLocalizedShort(string, (short)0);
    }

    public static short getLocalizedShort(String string, short s) {
        return Numbers.getLocalizedShort(string, s, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    public static short getLocalizedShort(String string, short s, short s2, short s3) {
        try {
            s = NUMBER_FORMAT.parse(Numbers.normalize(string)).shortValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s2 > s) {
            s = s2;
        } else if (s3 < s) {
            s = s3;
        }
        return s;
    }

    public static int getInteger(String string) {
        return Numbers.getInteger(string, 0);
    }

    public static int getInteger(String string, int n) {
        return Numbers.getInteger(string, n, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int getInteger(String string, int n, int n2, int n3) {
        int n4 = 10;
        if ((string = Numbers.normalize(string)) != null && string.startsWith(HEX_PREFIX)) {
            string = string.substring(HEX_PREFIX.length());
            n4 = 16;
        }
        return Numbers.getInteger(string, n4, n, n2, n3);
    }

    public static int getInteger(String string, int n, int n2, int n3, int n4) {
        try {
            string = Numbers.normalize(string);
            if (n == 16 && string.length() == 8) {
                int n5 = Character.digit(string.charAt(0), n);
                n2 = n5 << 28 | Integer.parseInt(string.substring(1), n);
            } else {
                n2 = Integer.parseInt(Numbers.normalize(string), n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n3 > n2) {
            n2 = n3;
        } else if (n4 < n2) {
            n2 = n4;
        }
        return n2;
    }

    public static int getLocalizedInteger(String string) {
        return Numbers.getLocalizedInteger(string, 0);
    }

    public static int getLocalizedInteger(String string, int n) {
        return Numbers.getLocalizedInteger(string, n, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int getLocalizedInteger(String string, int n, int n2, int n3) {
        try {
            n = NUMBER_FORMAT.parse(Numbers.normalize(string)).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > n) {
            n = n2;
        } else if (n3 < n) {
            n = n3;
        }
        return n;
    }

    public static long getLong(String string) {
        return Numbers.getLong(string, 0L);
    }

    public static long getLong(String string, long l) {
        return Numbers.getLong(string, l, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static long getLong(String string, long l, long l2, long l3) {
        int n = 10;
        if ((string = Numbers.normalize(string)) != null && string.startsWith(HEX_PREFIX)) {
            string = string.substring(HEX_PREFIX.length());
            n = 16;
        }
        return Numbers.getLong(string, n, l, l2, l3);
    }

    public static long getLong(String string, int n, long l, long l2, long l3) {
        try {
            string = Numbers.normalize(string);
            if (n == 16 && string.length() == 16) {
                long l4 = Character.digit(string.charAt(0), n);
                l = l4 << 60 | Long.parseLong(string.substring(1), n);
            } else {
                l = Long.parseLong(string, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l2 > l) {
            l = l2;
        } else if (l3 < l) {
            l = l3;
        }
        return l;
    }

    public static long getLocalizedLong(String string) {
        return Numbers.getLocalizedLong(string, 0L);
    }

    public static long getLocalizedLong(String string, long l) {
        return Numbers.getLocalizedLong(string, l, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static long getLocalizedLong(String string, long l, long l2, long l3) {
        try {
            l = NUMBER_FORMAT.parse(Numbers.normalize(string)).longValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l2 > l) {
            l = l2;
        } else if (l3 < l) {
            l = l3;
        }
        return l;
    }

    public static float getFloat(String string) {
        return Numbers.getFloat(string, 0.0f);
    }

    public static float getFloat(String string, float f) {
        return Numbers.getFloat(string, f, -3.4028235E38f, Float.MAX_VALUE);
    }

    public static float getFloat(String string, float f, float f2, float f3) {
        try {
            f = Float.parseFloat(Numbers.normalize(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f2 > f) {
            f = f2;
        } else if (f3 < f) {
            f = f3;
        }
        return f;
    }

    public static float getLocalizedFloat(String string) {
        return Numbers.getLocalizedFloat(string, 0.0f);
    }

    public static float getLocalizedFloat(String string, float f) {
        return Numbers.getLocalizedFloat(string, f, -3.4028235E38f, Float.MAX_VALUE);
    }

    public static float getLocalizedFloat(String string, float f, float f2, float f3) {
        try {
            f = NUMBER_FORMAT.parse(Numbers.normalize(string)).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f2 > f) {
            f = f2;
        } else if (f3 < f) {
            f = f3;
        }
        return f;
    }

    public static double getDouble(String string) {
        return Numbers.getDouble(string, 0.0);
    }

    public static double getDouble(String string, double d) {
        return Numbers.getDouble(string, d, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static double getDouble(String string, double d, double d2, double d3) {
        try {
            d = Double.parseDouble(Numbers.normalize(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d2 > d) {
            d = d2;
        } else if (d3 < d) {
            d = d3;
        }
        return d;
    }

    public static double getLocalizedDouble(String string) {
        return Numbers.getLocalizedDouble(string, 0.0);
    }

    public static double getLocalizedDouble(String string, double d) {
        return Numbers.getLocalizedDouble(string, d, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static double getLocalizedDouble(String string, double d, double d2, double d3) {
        try {
            d = NUMBER_FORMAT.parse(Numbers.normalize(string)).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d2 > d) {
            d = d2;
        } else if (d3 < d) {
            d = d3;
        }
        return d;
    }

    public static String normalize(String string) {
        if (string != null && (string = string.trim()).length() > 0 && string.charAt(0) == '+') {
            string = string.substring(1);
        }
        return string;
    }

    public static String trimTrailingZerosAfterDecimal(String string) {
        int n;
        if (string != null && (n = (string = string.trim()).indexOf(46)) != -1) {
            int n2 = string.length() - 1;
            while (string.charAt(n2) == '0') {
                --n2;
            }
            if (n != n2) {
                ++n2;
            }
            string = string.substring(0, n2);
        }
        return string;
    }

    public static String hex(int n) {
        return HEX_PREFIX + Integer.toHexString(n);
    }

    public static String hex(long l) {
        return HEX_PREFIX + Long.toHexString(l);
    }

    public static String format(long l) {
        return NUMBER_FORMAT.format(l);
    }

    public static String formatWithForcedSign(long l) {
        return NUMBER_PLUS_FORMAT.format(l);
    }

    public static String format(double d) {
        return NUMBER_FORMAT.format(d);
    }

    public static String formatWithForcedSign(double d) {
        return NUMBER_PLUS_FORMAT.format(d);
    }

    public static long getDate(String string) {
        if (string != null) {
            string = string.trim();
            for (int i = 0; i <= 3; ++i) {
                try {
                    return DateFormat.getDateInstance(i).parse(string).getTime();
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        return System.currentTimeMillis();
    }

    public static long getDateTime(String string) {
        if (string != null) {
            string = string.trim();
            for (int i = 0; i <= 3; ++i) {
                for (int j = 0; j <= 3; ++j) {
                    try {
                        return DateFormat.getDateTimeInstance(i, j).parse(string).getTime();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
            }
        }
        return System.currentTimeMillis();
    }

    public static String formatDateTime(long l, String string) {
        Date date = new Date(l);
        return MessageFormat.format(string, DateFormat.getTimeInstance(3).format(date), DateFormat.getDateInstance(2).format(date));
    }

    public static String formatHeight(int n) {
        int n2 = n / 12;
        n %= 12;
        if (n2 > 0) {
            String string = Numbers.format(n2) + '\'';
            if (n > 0) {
                return string + ' ' + Numbers.format(n) + '\"';
            }
            return string;
        }
        return Numbers.format(n) + '\"';
    }

    public static int getHeight(String string) {
        if (string != null) {
            int n = string.indexOf(39);
            int n2 = string.indexOf(34);
            if (n == -1) {
                if (n2 == -1) {
                    return Numbers.getLocalizedInteger(string, 0, 0, Integer.MAX_VALUE);
                }
                return Numbers.getLocalizedInteger(string.substring(0, n2), 0, 0, Integer.MAX_VALUE);
            }
            int n3 = Numbers.getLocalizedInteger(string.substring(n2 != -1 && n > n2 ? n2 + 1 : 0, n), 0, 0, Integer.MAX_VALUE) * 12;
            if (n2 != -1) {
                n3 += Numbers.getLocalizedInteger(string.substring(n < n2 ? n + 1 : 0, n2), 0, 0, Integer.MAX_VALUE);
            }
            return n3;
        }
        return 0;
    }

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(5);
        NUMBER_PLUS_FORMAT = (DecimalFormat)NUMBER_FORMAT.clone();
        NUMBER_PLUS_FORMAT.setPositivePrefix("+");
    }
}

