/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import com.trollworks.ttk.utility.Fonts;
import gnu.trove.TIntIntHashMap;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class TextDrawing {
    private static HashMap<Font, TIntIntHashMap> WIDTH_MAP = new HashMap();
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final char ELLIPSIS = '\u2026';

    public static final int getWidth(Font font, char c) {
        return TextDrawing.getCharWidth(font, c, TextDrawing.getWidthMap(font));
    }

    private static int getCharWidth(Font font, char c, TIntIntHashMap tIntIntHashMap) {
        int n = tIntIntHashMap.get((int)c);
        if (n == 0) {
            n = Fonts.getFontMetrics(font).charWidth(c);
            if (n == 0) {
                n = 1;
            }
            tIntIntHashMap.put((int)c, n);
        }
        return n;
    }

    public static final int getSimpleWidth(Font font, String string) {
        TIntIntHashMap tIntIntHashMap = TextDrawing.getWidthMap(font);
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n += TextDrawing.getCharWidth(font, string.charAt(i), tIntIntHashMap);
        }
        return n;
    }

    private static TIntIntHashMap getWidthMap(Font font) {
        TIntIntHashMap tIntIntHashMap = WIDTH_MAP.get(font);
        if (tIntIntHashMap == null) {
            tIntIntHashMap = new TIntIntHashMap();
            WIDTH_MAP.put(font, tIntIntHashMap);
            FontMetrics fontMetrics = Fonts.getFontMetrics(font);
            for (int i = 32; i < 127; ++i) {
                tIntIntHashMap.put(i, fontMetrics.charWidth((char)i));
            }
        }
        return tIntIntHashMap;
    }

    public static final int draw(Graphics graphics, Rectangle rectangle, String string, int n, int n2) {
        int n3 = rectangle.y;
        if (string.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Font font = graphics.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.getAscent();
            int n5 = fontMetrics.getDescent();
            int n6 = n4 + n5;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n", true);
            StringBuilder stringBuilder = new StringBuilder(string.length());
            int n7 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(NEWLINE)) {
                    string = stringBuilder.toString();
                    n7 += n6;
                    arrayList.add(string);
                    stringBuilder.setLength(0);
                    continue;
                }
                int n8 = TextDrawing.getSimpleWidth(font, stringBuilder.toString() + (String)string2);
                if (n8 > rectangle.width && stringBuilder.length() > 0) {
                    string = stringBuilder.toString();
                    n7 += n6;
                    arrayList.add(string);
                    stringBuilder.setLength(0);
                }
                stringBuilder.append(string2);
            }
            if (stringBuilder.length() > 0) {
                string = stringBuilder.toString();
                n7 += n6;
                arrayList.add(string);
            }
            if (n2 == 0) {
                n3 = rectangle.y + (rectangle.height - (n7 - n5 / 2)) / 2;
            } else if (n2 == 3) {
                n3 = rectangle.y + rectangle.height - n7;
            }
            for (String string3 : arrayList) {
                int n9 = rectangle.x;
                if (n == 0) {
                    n9 += (rectangle.width - TextDrawing.getSimpleWidth(font, string3)) / 2;
                } else if (n == 4) {
                    n9 = n9 + rectangle.width - (1 + TextDrawing.getSimpleWidth(font, string3));
                }
                graphics.drawString(string3, n9, n3 + n4);
                n3 += n6;
            }
        }
        return n3;
    }

    public static final Dimension getPreferredSize(Font font, String string) {
        FontMetrics fontMetrics = Fonts.getFontMetrics(font);
        int n = fontMetrics.getAscent() + fontMetrics.getDescent();
        StringTokenizer stringTokenizer = new StringTokenizer(string, NEWLINE, true);
        boolean bl = true;
        boolean bl2 = true;
        int n2 = 0;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(NEWLINE)) {
                if (bl2 && !bl) {
                    bl2 = false;
                    continue;
                }
                string2 = SPACE;
            } else {
                bl2 = true;
            }
            bl = false;
            n3 += n;
            int n4 = TextDrawing.getSimpleWidth(font, string2);
            if (n2 >= n4) continue;
            n2 = n4;
        }
        return new Dimension(n2, n3);
    }

    public static final int getWidth(Font font, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, NEWLINE, true);
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(NEWLINE)) {
                if (bl2 && !bl) {
                    bl2 = false;
                    continue;
                }
                string2 = SPACE;
            } else {
                bl2 = true;
            }
            bl = false;
            int n2 = TextDrawing.getSimpleWidth(font, string2);
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public static final String truncateIfNecessary(Font font, String string, int n, int n2) {
        if (TextDrawing.getSimpleWidth(font, string) > n) {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n3 = stringBuilder.length();
            if (n2 == 2) {
                stringBuilder.insert(0, '\u2026');
                while (n3-- > 0 && TextDrawing.getSimpleWidth(font, stringBuilder.toString()) > n) {
                    stringBuilder.deleteCharAt(1);
                }
            } else if (n2 == 0) {
                int n4 = n3 / 2;
                int n5 = n4 + 1;
                boolean bl = false;
                stringBuilder.insert(n4--, '\u2026');
                while (n3-- > 0 && TextDrawing.getSimpleWidth(font, stringBuilder.toString()) > n) {
                    if (bl) {
                        stringBuilder.deleteCharAt(n4--);
                        if (--n5 >= n3 + 1) continue;
                        bl = false;
                        continue;
                    }
                    stringBuilder.deleteCharAt(n5);
                    if (n4 < 0) continue;
                    bl = true;
                }
            } else if (n2 == 4) {
                stringBuilder.append('\u2026');
                while (n3-- > 0 && TextDrawing.getSimpleWidth(font, stringBuilder.toString()) > n) {
                    stringBuilder.deleteCharAt(n3);
                }
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static String wrapToPixelWidth(Font font, String string, int n) {
        int[] nArray = new int[]{0};
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        StringBuilder stringBuilder2 = new StringBuilder(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string + NEWLINE, " \t/\\\n", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(NEWLINE)) {
                if (nArray[0] > 0) {
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
                stringBuilder.append(string2);
                bl = false;
                stringBuilder2.setLength(0);
                nArray[0] = 0;
                continue;
            }
            if (bl && nArray[0] == 0 && string2.equals(SPACE)) continue;
            bl = TextDrawing.processOneTokenForWrapToPixelWidth(string2, font, stringBuilder, stringBuilder2, n, nArray, bl);
        }
        if (nArray[0] > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static boolean processOneTokenForWrapToPixelWidth(String string, Font font, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n, int[] nArray, boolean bl) {
        int n2 = TextDrawing.getSimpleWidth(font, string);
        if (nArray[0] + n2 <= n) {
            stringBuilder2.append(string);
            nArray[0] = nArray[0] + n2;
        } else if (nArray[0] == 0) {
            int n3 = string.length();
            stringBuilder2.append(string.charAt(0));
            for (int i = 1; i < n3; ++i) {
                stringBuilder2.append(string.charAt(i));
                if (TextDrawing.getSimpleWidth(font, stringBuilder2.toString()) <= n) continue;
                stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append(NEWLINE);
                bl = true;
                stringBuilder2.setLength(0);
                stringBuilder2.append(string.charAt(i));
            }
            nArray[0] = TextDrawing.getSimpleWidth(font, stringBuilder2.toString());
        } else {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append(NEWLINE);
            bl = true;
            stringBuilder2.setLength(0);
            nArray[0] = 0;
            if (!string.equals(SPACE)) {
                return TextDrawing.processOneTokenForWrapToPixelWidth(string, font, stringBuilder, stringBuilder2, n, nArray, bl);
            }
        }
        return bl;
    }
}

