/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.units;

import com.trollworks.ttk.text.Numbers;
import com.trollworks.ttk.units.Units;
import com.trollworks.ttk.utility.LocalizedMessages;
import java.text.MessageFormat;

public enum WeightUnits implements Units
{
    OUNCES(0.0625){

        public String toString() {
            return MSG_OUNCES_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_OUNCES;
        }
    }
    ,
    POUNDS(1.0){

        public String toString() {
            return MSG_POUNDS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_POUNDS;
        }
    }
    ,
    SHORT_TONS(2000.0){

        public String toString() {
            return MSG_SHORT_TONS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_SHORT_TONS;
        }
    }
    ,
    LONG_TONS(2240.0){

        public String toString() {
            return MSG_LONG_TONS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_LONG_TONS;
        }
    }
    ,
    METRIC_TONS(2205.0){

        public String toString() {
            return MSG_METRIC_TONS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_METRIC_TONS;
        }
    }
    ,
    KILOGRAMS(2.205){

        public String toString() {
            return MSG_KILOGRAMS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_KILOGRAMS;
        }
    }
    ,
    GRAMS(0.002205){

        public String toString() {
            return MSG_GRAMS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_GRAMS;
        }
    };

    static String MSG_OUNCES;
    static String MSG_OUNCES_ABBREVIATION;
    static String MSG_POUNDS;
    static String MSG_POUNDS_ABBREVIATION;
    static String MSG_SHORT_TONS;
    static String MSG_SHORT_TONS_ABBREVIATION;
    static String MSG_LONG_TONS;
    static String MSG_LONG_TONS_ABBREVIATION;
    static String MSG_METRIC_TONS;
    static String MSG_METRIC_TONS_ABBREVIATION;
    static String MSG_KILOGRAMS;
    static String MSG_KILOGRAMS_ABBREVIATION;
    static String MSG_GRAMS;
    static String MSG_GRAMS_ABBREVIATION;
    static String MSG_FORMAT;
    private double mFactor;

    private WeightUnits(double d) {
        this.mFactor = d;
    }

    @Override
    public double convert(Units units, double d) {
        return d * units.getFactor() / this.mFactor;
    }

    @Override
    public double normalize(double d) {
        return d / this.mFactor;
    }

    @Override
    public double getFactor() {
        return this.mFactor;
    }

    @Override
    public String format(double d, boolean bl) {
        String string = bl ? Numbers.format(d) : Double.toString(d);
        return MessageFormat.format(MSG_FORMAT, Numbers.trimTrailingZerosAfterDecimal(string), this.toString());
    }

    @Override
    public Units[] getCompatibleUnits() {
        return WeightUnits.values();
    }

    static {
        LocalizedMessages.initialize(WeightUnits.class);
    }
}

