/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import java.awt.Color;

public class Colors {
    public static Color getBanding(boolean bl) {
        return bl ? Color.WHITE : new Color(232, 255, 232);
    }

    public static boolean threshold(Color color, int n) {
        if (n < 0 || n > 100) {
            return false;
        }
        return (int)((double)(color.getRed() + color.getGreen() + color.getBlue()) / 7.65) > n;
    }

    public static final Color blend(Color color, Color color2, int n) {
        int n2 = 100 - n;
        return new Color((color.getRed() * n2 + color2.getRed() * n) / 100, (color.getGreen() * n2 + color2.getGreen() * n) / 100, (color.getBlue() * n2 + color2.getBlue() * n) / 100);
    }

    public static final Color brighten(Color color) {
        if (Colors.threshold(color, 50)) {
            return Colors.darker(color, 65).brighter();
        }
        return color;
    }

    public static final Color darker(Color color, int n) {
        return Colors.blend(color, Color.black, n);
    }

    public static final Color lighter(Color color, int n) {
        return Colors.blend(color, Color.white, n);
    }
}

