/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import com.trollworks.ttk.preferences.Preferences;
import com.trollworks.ttk.utility.GraphicsUtilities;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.UIManager;

public class Fonts {
    public static final String FONT_NOTIFICATION_KEY = "FontsChanged";
    private static final String COMMA = ",";
    private static final String MODULE = "Font";
    public static final String KEY_STD_TEXT_FIELD = "TextField.font";
    private static final TreeMap<String, Fonts> DEFAULTS = new TreeMap();
    private String mDescription;
    private Font mDefaultFont;

    public static void register(String string, String string2, Font font) {
        UIManager.put(string, font);
        DEFAULTS.put(string, new Fonts(string2, font));
    }

    public static String[] getKeys() {
        return DEFAULTS.keySet().toArray(new String[DEFAULTS.size()]);
    }

    public static String getDescription(String string) {
        Fonts fonts = DEFAULTS.get(string);
        return fonts != null ? fonts.mDescription : null;
    }

    public static Font getDefaultFont() {
        return UIManager.getFont(KEY_STD_TEXT_FIELD);
    }

    public static String getDefaultFontName() {
        return Fonts.getDefaultFont().getName();
    }

    public static void restoreDefaults() {
        for (Map.Entry<String, Fonts> entry : DEFAULTS.entrySet()) {
            UIManager.put(entry.getKey(), entry.getValue().mDefaultFont);
        }
    }

    public static boolean isSetToDefaults() {
        for (Map.Entry<String, Fonts> entry : DEFAULTS.entrySet()) {
            if (entry.getValue().mDefaultFont.equals(UIManager.getFont(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static String getStringValue(Font font) {
        return font.getName() + COMMA + font.getStyle() + COMMA + font.getSize();
    }

    public static FontMetrics getFontMetrics(Font font) {
        Graphics2D graphics2D = GraphicsUtilities.getGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        graphics2D.dispose();
        return fontMetrics;
    }

    public static Font create(String string) {
        return Fonts.create(string, null);
    }

    public static Font create(String string, Font font) {
        StringTokenizer stringTokenizer;
        if (font == null) {
            font = Fonts.getDefaultFont();
        }
        String string2 = font.getName();
        int n = font.getStyle();
        int n2 = font.getSize();
        if (string != null && string.length() > 0 && (stringTokenizer = new StringTokenizer(string, COMMA)).hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!Fonts.isValidFontName(string2)) {
                string2 = font.getName();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n < 0 || n > 3) {
                    n = font.getStyle();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n2 < 1) {
                        n2 = 1;
                    } else if (n2 > 200) {
                        n2 = 200;
                    }
                }
            }
        }
        return new Font(string2, n, n2);
    }

    public static boolean isValidFontName(String string) {
        for (String string2 : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static void loadFromPreferences() {
        Preferences preferences = Preferences.getInstance();
        for (String string : DEFAULTS.keySet()) {
            Font font = preferences.getFontValue(MODULE, string);
            if (font == null) continue;
            UIManager.put(string, font);
        }
    }

    public static void saveToPreferences() {
        Preferences preferences = Preferences.getInstance();
        preferences.removePreferences(MODULE);
        for (String string : DEFAULTS.keySet()) {
            Font font = UIManager.getFont(string);
            if (font == null) continue;
            preferences.setValue(MODULE, string, font);
        }
    }

    public static void notifyOfFontChanges() {
        Preferences.getInstance().getNotifier().notify(null, FONT_NOTIFICATION_KEY, null);
    }

    private Fonts(String string, Font font) {
        this.mDescription = string;
        this.mDefaultFont = font;
    }
}

