/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import com.trollworks.ttk.conduit.Conduit;
import com.trollworks.ttk.conduit.ConduitMessage;
import com.trollworks.ttk.conduit.ConduitReceiver;
import com.trollworks.ttk.menu.file.OpenCommand;
import com.trollworks.ttk.menu.file.OpenDataFileCommand;
import com.trollworks.ttk.utility.App;
import com.trollworks.ttk.utility.Debug;
import com.trollworks.ttk.utility.GraphicsUtilities;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LaunchProxy
implements ConduitReceiver {
    private static final String AT = "@";
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private static final String AT_MARKER = "@!";
    private static final String SPACE_MARKER = "@%";
    private static final String COMMA_MARKER = "@#";
    private static final String LAUNCH_ID = "Launched";
    private static final String TOOK_OVER_FOR_ID = "TookOverFor";
    private static LaunchProxy INSTANCE = null;
    private Conduit mConduit;
    private long mTimeStamp;
    private boolean mReady;
    private ArrayList<File> mFiles;

    public static synchronized LaunchProxy getInstance() {
        assert (INSTANCE != null);
        return INSTANCE;
    }

    public static synchronized void configure(File ... fileArray) {
        if (INSTANCE == null) {
            INSTANCE = new LaunchProxy(fileArray);
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
                assert (false) : Debug.throwableToString(exception);
            }
        } else assert (false) : "Can only call configure once.";
    }

    private LaunchProxy(File ... fileArray) {
        StringBuilder stringBuilder = new StringBuilder();
        this.mFiles = new ArrayList();
        this.mTimeStamp = System.currentTimeMillis();
        stringBuilder.append(LAUNCH_ID);
        stringBuilder.append(' ');
        stringBuilder.append(this.mTimeStamp);
        stringBuilder.append(' ');
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(fileArray[i].getAbsolutePath().replaceAll(AT, AT_MARKER).replaceAll(SPACE, SPACE_MARKER).replaceAll(COMMA, COMMA_MARKER));
            }
        }
        this.mConduit = new Conduit(this, false);
        this.mConduit.send(new ConduitMessage(App.getName(), stringBuilder.toString()));
    }

    public void setReady(boolean bl) {
        this.mReady = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conduitMessageReceived(ConduitMessage conduitMessage) {
        StringTokenizer stringTokenizer = new StringTokenizer(conduitMessage.getMessage(), SPACE);
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (this.mReady && LAUNCH_ID.equals(string)) {
                long l;
                if (stringTokenizer.hasMoreTokens() && (l = this.getLong(stringTokenizer)) != this.mTimeStamp) {
                    this.mConduit.send(new ConduitMessage(App.getName(), "TookOverFor " + l));
                    GraphicsUtilities.forceAppToFront();
                    if (stringTokenizer.hasMoreTokens()) {
                        ArrayList<File> arrayList;
                        stringTokenizer = new StringTokenizer(stringTokenizer.nextToken(), COMMA);
                        while (stringTokenizer.hasMoreTokens()) {
                            arrayList = this.mFiles;
                            synchronized (arrayList) {
                                this.mFiles.add(new File(stringTokenizer.nextToken().replaceAll(COMMA_MARKER, COMMA).replaceAll(SPACE_MARKER, SPACE).replaceAll(AT_MARKER, AT)));
                            }
                        }
                        arrayList = this.mFiles;
                        synchronized (arrayList) {
                            if (!this.mFiles.isEmpty()) {
                                for (File file : this.mFiles) {
                                    OpenDataFileCommand.open(file);
                                }
                                this.mFiles.clear();
                            }
                        }
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OpenCommand.INSTANCE.open();
                            }
                        });
                    }
                }
            } else if (TOOK_OVER_FOR_ID.equals(string) && stringTokenizer.hasMoreTokens() && this.getLong(stringTokenizer) == this.mTimeStamp) {
                System.exit(0);
            }
        }
    }

    private long getLong(StringTokenizer stringTokenizer) {
        try {
            return Long.parseLong(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Override
    public String getConduitMessageIDFilter() {
        return App.getName();
    }

    @Override
    public String getConduitMessageUserFilter() {
        return System.getProperty("user.name");
    }
}

