/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import com.trollworks.ttk.utility.LocalizedMessages;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SafeFileUpdater {
    private static String MSG_NO_TRANSACTION_IN_PROGRESS;
    private static String MSG_FILE_SWAP_FAILED;
    private static String MSG_MAY_NOT_BE_NULL;
    private static String MSG_MAY_NOT_BE_DIRECTORY;
    private HashMap<File, File> mFiles = new HashMap();
    private int mStarted = 0;

    public void abort() {
        this.mStarted = 0;
        for (File file : this.mFiles.values()) {
            file.delete();
        }
        this.mFiles.clear();
    }

    public void begin() {
        ++this.mStarted;
    }

    public void commit() throws IOException {
        if (this.mStarted == 0) {
            throw new IllegalStateException(MSG_NO_TRANSACTION_IN_PROGRESS);
        }
        if (--this.mStarted == 0) {
            HashMap<File, File> hashMap = new HashMap<File, File>();
            try {
                for (Map.Entry<File, File> object : this.mFiles.entrySet()) {
                    File file = object.getKey();
                    File file2 = object.getValue();
                    if (file.exists()) {
                        File file3 = File.createTempFile("ren", null, file.getParentFile());
                        if (file3.delete() && file.renameTo(file3)) {
                            hashMap.put(file, file3);
                        } else {
                            throw new IOException(MSG_FILE_SWAP_FAILED);
                        }
                    }
                    if (!file2.exists() || file2.renameTo(file)) continue;
                    throw new IOException(MSG_FILE_SWAP_FAILED);
                }
            }
            catch (IOException iOException) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    File file = (File)entry.getKey();
                    File file4 = (File)entry.getValue();
                    file.delete();
                    file4.renameTo(file);
                }
                this.abort();
                throw iOException;
            }
            for (File file : hashMap.values()) {
                file.delete();
            }
            for (File file : this.mFiles.values()) {
                file.delete();
            }
            this.mFiles.clear();
        }
    }

    public File getTransactionFile(File file) throws IOException {
        if (this.mStarted == 0) {
            throw new IllegalStateException(MSG_NO_TRANSACTION_IN_PROGRESS);
        }
        if (file == null) {
            throw new IllegalArgumentException(MSG_MAY_NOT_BE_NULL);
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(MSG_MAY_NOT_BE_DIRECTORY);
        }
        File file2 = this.mFiles.get(file);
        if (file2 == null) {
            file2 = File.createTempFile(".trn", null, file.getParentFile());
            this.mFiles.put(file, file2);
        }
        return file2;
    }

    static {
        LocalizedMessages.initialize(SafeFileUpdater.class);
    }
}

