/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.RepaintManager;

public class UIUtilities {
    public static void selectTab(JTabbedPane jTabbedPane, String string) {
        int n = jTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!jTabbedPane.getTitleAt(i).equals(string)) continue;
            jTabbedPane.setSelectedIndex(i);
            break;
        }
    }

    public static void disableControls(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                UIUtilities.disableControls(container.getComponent(i));
            }
        }
        if (component instanceof AbstractButton || component instanceof JComboBox || component instanceof JTextField) {
            component.setEnabled(false);
        }
    }

    public static void setOnlySize(Component component, Dimension dimension) {
        component.setMinimumSize(dimension);
        component.setMaximumSize(dimension);
        component.setPreferredSize(dimension);
    }

    public static void adjustToSameSize(Component ... componentArray) {
        Dimension dimension = new Dimension();
        for (Component component : componentArray) {
            Dimension dimension2 = component.getPreferredSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height <= dimension.height) continue;
            dimension.height = dimension2.height;
        }
        for (Component component : componentArray) {
            UIUtilities.setOnlySize(component, dimension);
        }
    }

    public static void convertPoint(Point point, Component component, Component component2) {
        UIUtilities.convertPointToScreen(point, component);
        UIUtilities.convertPointFromScreen(point, component2);
    }

    public static void convertPointFromScreen(Point point, Component component) {
        do {
            point.x -= component.getX();
            point.y -= component.getY();
        } while (!(component instanceof Window) && (component = component.getParent()) != null);
    }

    public static void convertPointToScreen(Point point, Component component) {
        do {
            point.x += component.getX();
            point.y += component.getY();
        } while (!(component instanceof Window) && (component = component.getParent()) != null);
    }

    public static void convertRectangle(Rectangle rectangle, Component component, Component component2) {
        UIUtilities.convertRectangleToScreen(rectangle, component);
        UIUtilities.convertRectangleFromScreen(rectangle, component2);
    }

    public static void convertRectangleFromScreen(Rectangle rectangle, Component component) {
        do {
            rectangle.x -= component.getX();
            rectangle.y -= component.getY();
        } while (!(component instanceof Window) && (component = component.getParent()) != null);
    }

    public static void convertRectangleToScreen(Rectangle rectangle, Component component) {
        do {
            rectangle.x += component.getX();
            rectangle.y += component.getY();
        } while (!(component instanceof Window) && (component = component.getParent()) != null);
    }

    public static int getIndexOf(Container container, Component component) {
        if (container != null) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (component != container.getComponent(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static final MouseEvent cloneMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
            return new MouseWheelEvent((Component)mouseWheelEvent.getSource(), mouseWheelEvent.getID(), System.currentTimeMillis(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        }
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), System.currentTimeMillis(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    public static final MouseEvent cloneMouseEvent(MouseEvent mouseEvent, boolean bl) {
        if (mouseEvent instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
            return new MouseWheelEvent((Component)mouseWheelEvent.getSource(), mouseWheelEvent.getID(), bl ? System.currentTimeMillis() : mouseEvent.getWhen(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        }
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), bl ? System.currentTimeMillis() : mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    public static final MouseEvent cloneMouseEvent(MouseEvent mouseEvent, Component component, Point point, boolean bl) {
        if (mouseEvent instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
            return new MouseWheelEvent(component, mouseWheelEvent.getID(), bl ? System.currentTimeMillis() : mouseEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        }
        return new MouseEvent(component, mouseEvent.getID(), bl ? System.currentTimeMillis() : mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    public static void forwardMouseEvent(MouseEvent mouseEvent, Component component, Component component2) {
        UIUtilities.translateMouseEvent(mouseEvent, component, component2);
        component2.dispatchEvent(mouseEvent);
    }

    public static void translateMouseEvent(MouseEvent mouseEvent, Component component, Component component2) {
        Point point = mouseEvent.getPoint();
        Point point2 = new Point(point);
        UIUtilities.convertPoint(point2, component, component2);
        mouseEvent.setSource(component2);
        mouseEvent.translatePoint(point2.x - point.x, point2.y - point.y);
    }

    public static boolean shouldTrackViewportWidth(Component component) {
        Container container = component.getParent();
        if (container instanceof JViewport) {
            Dimension dimension = container.getSize();
            Dimension dimension2 = component.getPreferredSize();
            return dimension2.width < dimension.width;
        }
        return false;
    }

    public static boolean shouldTrackViewportHeight(Component component) {
        Container container = component.getParent();
        if (container instanceof JViewport) {
            Dimension dimension = container.getSize();
            Dimension dimension2 = component.getPreferredSize();
            return dimension2.height < dimension.height;
        }
        return false;
    }

    public static void revalidateImmediately(Component component) {
        if (component != null) {
            RepaintManager repaintManager = RepaintManager.currentManager(component);
            repaintManager.validateInvalidComponents();
            repaintManager.paintDirtyRegions();
        }
    }

    public static Container getAncestorOfType(Component component, Class<? extends Container> clazz) {
        Container container;
        for (container = component.getParent(); container != null && !clazz.isAssignableFrom(container.getClass()); container = container.getParent()) {
        }
        return container;
    }
}

