/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import com.trollworks.ttk.preferences.Preferences;
import com.trollworks.ttk.text.Version;
import com.trollworks.ttk.utility.App;
import com.trollworks.ttk.utility.DelayedTask;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.WindowUtils;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.StringTokenizer;

public class UpdateChecker
implements Runnable {
    private static String MSG_CHECKING;
    private static String MSG_UP_TO_DATE;
    private static String MSG_OUT_OF_DATE;
    private static String MSG_UPDATE_TITLE;
    private static String MSG_IGNORE_TITLE;
    private static final String MODULE = "Updates";
    private static final String LAST_VERSION_KEY = "LastVersionSeen";
    private static boolean NEW_VERSION_AVAILABLE;
    private static String RESULT;
    private static String UPDATE_URL;
    private String mProductKey;
    private String mCheckURL;
    private int mMode;

    public static void check(String string, String string2, String string3) {
        Thread thread = new Thread((Runnable)new UpdateChecker(string, string2), UpdateChecker.class.getSimpleName());
        UPDATE_URL = string3;
        thread.setPriority(5);
        thread.setDaemon(true);
        thread.start();
    }

    public static boolean isNewVersionAvailable() {
        return NEW_VERSION_AVAILABLE;
    }

    public static String getResult() {
        return RESULT;
    }

    public static void goToUpdate() {
        if (NEW_VERSION_AVAILABLE && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(UPDATE_URL));
            }
            catch (Exception exception) {
                WindowUtils.showError(null, exception.getMessage());
            }
        }
    }

    private UpdateChecker(String string, String string2) {
        this.mProductKey = string;
        this.mCheckURL = string2;
    }

    @Override
    public void run() {
        if (this.mMode == 0) {
            Object object;
            Object object2;
            long l = Version.extractVersion(App.getVersion());
            if (l == 0L) {
                this.mMode = 2;
                RESULT = MSG_UP_TO_DATE;
                return;
            }
            long l2 = l;
            this.mMode = 2;
            try {
                Object object3;
                object2 = new StringBuilder(this.mCheckURL);
                try {
                    object = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
                    if (!((NetworkInterface)object).isLoopback() && ((NetworkInterface)object).isUp() && !((NetworkInterface)object).isVirtual()) {
                        ((StringBuilder)object2).append('?');
                        for (Object object4 : object3 = (Object)((NetworkInterface)object).getHardwareAddress()) {
                            ((StringBuilder)object2).append(Integer.toHexString(object4 >>> 4 & 0xF));
                            ((StringBuilder)object2).append(Integer.toHexString(object4 & 0xF));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = new URL(((StringBuilder)object2).toString());
                object3 = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
                Object object5 = ((BufferedReader)object3).readLine();
                while (object5 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object5, "\t");
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            String string;
                            long l3;
                            if (stringTokenizer.nextToken().equalsIgnoreCase(this.mProductKey) && (l3 = Version.extractVersion(string = stringTokenizer.nextToken())) > l2) {
                                l2 = l3;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    object5 = ((BufferedReader)object3).readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (l2 > l) {
                object2 = Preferences.getInstance();
                object = Version.getHumanReadableVersion(l2);
                NEW_VERSION_AVAILABLE = true;
                RESULT = MessageFormat.format(MSG_OUT_OF_DATE, object);
                if (l2 > Version.extractVersion(((Preferences)object2).getStringValue(MODULE, LAST_VERSION_KEY, App.getVersion()))) {
                    ((Preferences)object2).setValue(MODULE, LAST_VERSION_KEY, (String)object);
                    ((Preferences)object2).save();
                    this.mMode = 1;
                    EventQueue.invokeLater(this);
                    return;
                }
            } else {
                RESULT = MSG_UP_TO_DATE;
            }
        } else if (this.mMode == 1) {
            if (App.isNotificationAllowed()) {
                String string = UpdateChecker.getResult();
                this.mMode = 2;
                if (WindowUtils.showConfirmDialog(null, string, MSG_UPDATE_TITLE, 2, new String[]{MSG_UPDATE_TITLE, MSG_IGNORE_TITLE}, MSG_UPDATE_TITLE) == 0) {
                    UpdateChecker.goToUpdate();
                }
            } else {
                DelayedTask.schedule(this, 250L);
            }
        }
    }

    static {
        NEW_VERSION_AVAILABLE = false;
        LocalizedMessages.initialize(UpdateChecker.class);
        RESULT = MSG_CHECKING;
    }
}

