/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import com.trollworks.ttk.utility.Platform;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

public class WindowsRegistry
implements Runnable {
    private static final String DOT = ".";
    private static final String UNDERSCORE = "_";
    private static final String START_BRACKET = "[";
    private static final String END_BRACKET = "]";
    private String mPrefix;
    private HashMap<String, String> mMap;
    private File mAppFile;
    private File mIconDir;

    public static final void register(String string, HashMap<String, String> hashMap, File file, File file2) {
        if (Platform.isWindows()) {
            Thread thread = new Thread((Runnable)new WindowsRegistry(string, hashMap, file, file2), WindowsRegistry.class.getSimpleName());
            thread.setPriority(5);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private WindowsRegistry(String string, HashMap<String, String> hashMap, File file, File file2) {
        this.mPrefix = string;
        this.mMap = hashMap;
        this.mAppFile = file;
        this.mIconDir = file2;
    }

    @Override
    public void run() {
        try {
            String string = this.mAppFile.getCanonicalPath().replaceAll("\\\\", "\\\\\\\\");
            File file = File.createTempFile("reg", ".reg");
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.println("REGEDIT4");
            printWriter.println();
            for (String string2 : this.mMap.keySet()) {
                this.writeRegistryEntry(printWriter, string, string2);
            }
            printWriter.close();
            new ProcessBuilder("regedit", "/S", file.getCanonicalPath()).start().waitFor();
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeRegistryEntry(PrintWriter printWriter, String string, String string2) throws IOException {
        String string3 = string2.toUpperCase();
        StringBuilder stringBuilder = new StringBuilder("HKEY_CLASSES_ROOT\\");
        printWriter.println("[-" + stringBuilder.toString() + DOT + string2 + END_BRACKET);
        printWriter.println();
        printWriter.println(START_BRACKET + stringBuilder.toString() + DOT + string2 + END_BRACKET);
        printWriter.println("@=\"" + this.mPrefix + UNDERSCORE + string3 + "\"");
        printWriter.println();
        stringBuilder.append(this.mPrefix + UNDERSCORE + string3);
        printWriter.println("[-" + stringBuilder.toString() + END_BRACKET);
        printWriter.println();
        printWriter.println(START_BRACKET + stringBuilder.toString() + END_BRACKET);
        printWriter.println("@=\"" + this.mMap.get(string2) + "\"");
        printWriter.println();
        printWriter.println(START_BRACKET + stringBuilder.toString() + "\\DefaultIcon]");
        printWriter.println("@=\"\\\"" + new File(this.mIconDir, string2 + ".ico").getCanonicalPath().replaceAll("\\\\", "\\\\\\\\") + "\\\"\"");
        printWriter.println();
        stringBuilder.append("\\shell");
        printWriter.println(START_BRACKET + stringBuilder.toString() + END_BRACKET);
        printWriter.println("@=\"open\"");
        printWriter.println();
        stringBuilder.append("\\open");
        printWriter.println(START_BRACKET + stringBuilder.toString() + END_BRACKET);
        printWriter.println("@=\"&Open\"");
        printWriter.println();
        stringBuilder.append("\\command");
        printWriter.println(START_BRACKET + stringBuilder.toString() + END_BRACKET);
        printWriter.println("@=\"\\\"" + string + "\\\" \\\"%1\\\"\"");
        printWriter.println();
    }
}

