/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class CommitEnforcer
implements PrivilegedAction<Object> {
    private Component mTarget;

    public static void forceFocusToAccept() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getPermanentFocusOwner();
        if (component == null) {
            component = keyboardFocusManager.getFocusOwner();
        }
        if (component != null) {
            CommitEnforcer commitEnforcer = new CommitEnforcer(component);
            if (System.getSecurityManager() == null) {
                commitEnforcer.run();
            } else {
                AccessController.doPrivileged(commitEnforcer);
            }
        }
    }

    private CommitEnforcer(Component component) {
        this.mTarget = component;
    }

    @Override
    public Object run() {
        try {
            Class<?> clazz = this.mTarget.getClass();
            Method method = null;
            while (method == null && clazz != null) {
                try {
                    method = clazz.getDeclaredMethod("processFocusEvent", FocusEvent.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    clazz = clazz.getSuperclass();
                }
            }
            if (method != null && clazz != null) {
                method.setAccessible(true);
                method.invoke((Object)this.mTarget, new FocusEvent(this.mTarget, 1005, false, null));
                method.invoke((Object)this.mTarget, new FocusEvent(this.mTarget, 1004, false, null));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }
}

