/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.utility.Debug;
import com.trollworks.ttk.utility.Geometry;
import com.trollworks.ttk.widgets.DirectScrollPanelArea;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DirectScrollPanel
extends JPanel
implements Autoscroll,
LayoutManager,
ChangeListener,
MouseWheelListener {
    public static final int AUTO_SCROLL_MARGIN = 10;
    private JScrollBar mHSB = new JScrollBar(0);
    private JScrollBar mVSB = new JScrollBar(1);
    private int mHSBHeight;
    private int mVSBWidth;
    private Dimension mHeaderSize;
    private Dimension mContentSize;
    private Rectangle mHeaderBounds;
    private Rectangle mContentBounds;
    private DirectScrollPanelArea mLastAreaClicked;
    private Rectangle mDragClip;
    private Component mHSBLeftCorner;
    private Component mHSBRightCorner;
    private Component mVSBTopCorner;
    private Component mVSBBottomCorner;
    private boolean mDrawingDragImage;
    private boolean mInAutoscroll;

    public DirectScrollPanel() {
        this.mHSBHeight = this.mHSB.getPreferredSize().height;
        this.mVSBWidth = this.mVSB.getPreferredSize().width;
        this.mHeaderSize = new Dimension();
        this.mContentSize = new Dimension();
        this.mHeaderBounds = new Rectangle();
        this.mContentBounds = new Rectangle();
        this.setBackground(Color.WHITE);
        this.setLayout(this);
        this.mHSB.setVisible(false);
        this.mVSB.setVisible(false);
        this.mHSB.getModel().addChangeListener(this);
        this.mVSB.getModel().addChangeListener(this);
        this.addMouseWheelListener(this);
        this.add(this.mHSB);
        this.add(this.mVSB);
        this.setAutoscrolls(true);
    }

    public void setVerticalUnitIncrement(int n) {
        this.mVSB.setUnitIncrement(n);
    }

    public void setHorizontalUnitIncrement(int n) {
        this.mHSB.setUnitIncrement(n);
    }

    public void setUnitIncrement(int n) {
        this.mVSB.setUnitIncrement(n);
        this.mHSB.setUnitIncrement(n);
    }

    public void repaintHeaderView() {
        this.repaint(this.mHeaderBounds);
    }

    public void paintHeaderViewImmediately() {
        this.paintImmediately(this.mHeaderBounds);
    }

    public void repaintHeaderView(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n - (this.mHSB.getValue() - this.mHeaderBounds.x), n2 + this.mHeaderBounds.y, n3, n4);
        this.repaint(rectangle.intersection(this.mHeaderBounds));
    }

    public void paintHeaderViewImmediately(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n - (this.mHSB.getValue() - this.mHeaderBounds.x), n2 + this.mHeaderBounds.y, n3, n4);
        this.paintImmediately(rectangle.intersection(this.mHeaderBounds));
    }

    public void repaintHeaderView(Rectangle rectangle) {
        this.repaintHeaderView(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintHeaderViewImmediately(Rectangle rectangle) {
        this.paintHeaderViewImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void repaintContentView() {
        this.repaint(this.mContentBounds);
    }

    public void paintContentViewImmediately() {
        this.paintImmediately(this.mContentBounds);
    }

    public void repaintContentView(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n - (this.mHSB.getValue() - this.mContentBounds.x), n2 - (this.mVSB.getValue() - this.mContentBounds.y), n3, n4);
        this.repaint(rectangle.intersection(this.mContentBounds));
    }

    public void paintContentViewImmediately(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n - (this.mHSB.getValue() - this.mContentBounds.x), n2 - (this.mVSB.getValue() - this.mContentBounds.y), n3, n4);
        this.paintImmediately(rectangle.intersection(this.mContentBounds));
    }

    public void repaintContentView(Rectangle rectangle) {
        this.repaintContentView(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintContentViewImmediately(Rectangle rectangle) {
        this.paintContentViewImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle getHeaderViewBounds() {
        return new Rectangle(this.mHSB.getValue(), 0, this.mHeaderBounds.width, this.mHeaderBounds.height);
    }

    public Rectangle getContentViewBounds() {
        return new Rectangle(this.mHSB.getValue(), this.mVSB.getValue(), this.mContentBounds.width, this.mContentBounds.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D;
        super.paintComponent(graphics);
        int n = this.mHSB.getValue();
        if (this.mHeaderBounds.height > 0) {
            graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.clipRect(this.mHeaderBounds.x, this.mHeaderBounds.y, this.mHeaderBounds.width, this.mHeaderBounds.height);
                graphics2D.translate(this.mHeaderBounds.x - n, this.mHeaderBounds.y);
                this.drawHeader(graphics2D);
            }
            finally {
                graphics2D.dispose();
            }
        }
        graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.clipRect(this.mContentBounds.x, this.mContentBounds.y, this.mContentBounds.width, this.mContentBounds.height);
            graphics2D.translate(this.mContentBounds.x - n, this.mContentBounds.y - this.mVSB.getValue());
            this.drawContents(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public void drawHeader(Graphics2D graphics2D) {
    }

    public void drawContents(Graphics2D graphics2D) {
    }

    public void pack() {
        this.mHeaderSize.setSize(this.getPreferredHeaderSize());
        this.mContentSize.setSize(this.getPreferredContentSize());
        this.layoutContainer(this);
        this.repaint();
    }

    public abstract Dimension getPreferredHeaderSize();

    public abstract Dimension getPreferredContentSize();

    public Dimension getHeaderSize() {
        return this.mHeaderSize;
    }

    public void setHeaderSize(Dimension dimension) {
        this.mHeaderSize.setSize(dimension);
        this.layoutContainer(this);
    }

    public Dimension getContentSize() {
        return this.mContentSize;
    }

    public void setContentSize(Dimension dimension) {
        this.mContentSize.setSize(dimension);
        this.layoutContainer(this);
    }

    public Dimension getMinimumViewableContentSize() {
        return new Dimension(20, 20);
    }

    public void syncScrollBars() {
        this.syncScrollBar(this.mHSB, this.mContentBounds.width, this.mContentSize.width);
        this.syncScrollBar(this.mVSB, this.mContentBounds.height, this.mContentSize.height);
    }

    private void syncScrollBar(JScrollBar jScrollBar, int n, int n2) {
        jScrollBar.setValues(n < n2 ? Math.min(jScrollBar.getValue(), n2 - n) : 0, n, 0, n2);
    }

    public void scrollContentIntoView(Point point) {
        this.scrollContentIntoView(point.x, point.y);
    }

    public void scrollContentIntoView(int n, int n2) {
        this.scrollContentIntoView(n, n2, 1, 1);
    }

    public void scrollContentIntoView(Rectangle rectangle) {
        this.scrollContentIntoView(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void scrollContentIntoView(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        Point point = this.fromContentView(new Point(n, n2));
        int n7 = this.mContentBounds.x + this.mContentBounds.width;
        int n8 = point.x + n3;
        if (point.x >= this.mContentBounds.x || n8 <= n7) {
            if (point.x < this.mContentBounds.x) {
                n5 = point.x - this.mContentBounds.x;
            } else if (n8 > n7) {
                n5 = n8 - n7;
                point.x -= n5;
                if (point.x < this.mContentBounds.x) {
                    n5 += point.x - this.mContentBounds.x;
                }
            }
        }
        int n9 = this.mContentBounds.y + this.mContentBounds.height;
        int n10 = point.y + n4;
        if (point.y >= this.mContentBounds.y || n10 <= n9) {
            if (point.y < this.mContentBounds.y) {
                n6 = point.y - this.mContentBounds.y;
            } else if (n10 > n9) {
                n6 = n10 - n9;
                point.y -= n6;
                if (point.y < this.mContentBounds.y) {
                    n6 += point.y - this.mContentBounds.y;
                }
            }
        }
        if (n5 != 0) {
            this.mHSB.setValue(this.mHSB.getValue() + n5);
        }
        if (n6 != 0) {
            this.mVSB.setValue(this.mVSB.getValue() + n6);
        }
    }

    public void scrollContentTo(int n, int n2) {
        this.scrollContentToX(n);
        this.scrollContentToY(n2);
    }

    public void scrollContentToX(int n) {
        if (n != this.mHSB.getValue()) {
            this.mHSB.setValue(n);
        }
    }

    public void scrollContentToY(int n) {
        if (n != this.mVSB.getValue()) {
            this.mVSB.setValue(n);
        }
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        boolean bl2;
        Insets insets = this.getInsets();
        Dimension dimension = this.getHeaderSize();
        Dimension dimension2 = this.getContentSize();
        int n7 = this.getWidth();
        int n8 = n7 - (insets.left + insets.right);
        int n9 = this.getHeight();
        int n10 = n9 - (insets.top + dimension.height + insets.bottom);
        boolean bl3 = bl2 = this.mHSBLeftCorner != null || this.mHSBRightCorner != null || Math.max(dimension.width, dimension2.width) > n8;
        if (bl2) {
            n10 -= this.mHSBHeight;
        }
        boolean bl4 = bl = this.mVSBTopCorner != null || this.mVSBBottomCorner != null || dimension2.height > n10;
        if (bl) {
            n8 -= this.mVSBWidth;
            if (!bl2) {
                boolean bl5 = bl2 = Math.max(dimension.width, dimension2.width) > n8;
                if (bl2) {
                    n10 -= this.mHSBHeight;
                }
            }
        }
        this.mHeaderBounds.x = insets.left;
        this.mHeaderBounds.y = insets.top;
        this.mHeaderBounds.width = Math.max(n8, 0);
        this.mHeaderBounds.height = dimension.height;
        this.mContentBounds.x = insets.left;
        this.mContentBounds.y = this.mHeaderBounds.y + this.mHeaderBounds.height;
        this.mContentBounds.width = this.mHeaderBounds.width;
        this.mContentBounds.height = Math.max(n10, 0);
        this.mHSB.setVisible(bl2);
        if (bl2) {
            n6 = insets.left;
            n5 = n9 - (insets.bottom + this.mHSBHeight);
            n4 = n7 - (n6 + insets.right);
            n3 = this.mHSBHeight * 3;
            if (bl) {
                n4 -= this.mVSBWidth;
            }
            if (this.mHSBLeftCorner != null) {
                n2 = this.mHSBLeftCorner.getPreferredSize().width;
                n = n4 - n2;
                if (n < n3) {
                    n2 = Math.max(n2 - (n3 - n), 0);
                }
                this.mHSBLeftCorner.setBounds(n6, n5, n2, this.mHSBHeight);
                n6 += n2;
                n4 -= n2;
            }
            if (this.mHSBRightCorner != null) {
                n2 = this.mHSBRightCorner.getPreferredSize().width;
                if (bl) {
                    n4 += this.mVSBWidth;
                }
                if ((n = n4 - n2) < n3) {
                    n2 = Math.max(n2 - (n3 - n), 0);
                }
                this.mHSBRightCorner.setBounds(n6 + (n4 -= n2), n5, n2, this.mHSBHeight);
            }
            this.mHSB.setBounds(n6, n5, n4, this.mHSBHeight);
        }
        this.mVSB.setVisible(bl);
        if (bl) {
            n6 = n7 - (insets.right + this.mVSBWidth);
            n5 = insets.top;
            n4 = n9 - (n5 + insets.bottom);
            n3 = this.mVSBWidth * 3;
            if (bl2) {
                n4 -= this.mHSBHeight;
            }
            if (this.mVSBTopCorner != null) {
                n2 = this.mVSBTopCorner.getPreferredSize().height;
                n = n4 - n2;
                if (n < n3) {
                    n2 = Math.max(n2 - (n3 - n), 0);
                }
                this.mVSBTopCorner.setBounds(n6, n5, this.mVSBWidth, n2);
                n5 += n2;
                n4 -= n2;
            }
            if (this.mVSBBottomCorner != null) {
                n2 = this.mVSBBottomCorner.getPreferredSize().height;
                if (bl2 && this.mHSBRightCorner == null) {
                    n4 += this.mHSBHeight;
                }
                if ((n = n4 - n2) < n3) {
                    n2 = Math.max(n2 - (n3 - n), 0);
                }
                this.mVSBBottomCorner.setBounds(n6, n5 + (n4 -= n2), this.mVSBWidth, n2);
            }
            this.mVSB.setBounds(n6, n5, this.mVSBWidth, n4);
        }
        this.syncScrollBars();
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(this.getMinimumViewableContentSize());
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(this.getContentSize());
    }

    private Dimension getLayoutSize(Dimension dimension) {
        Insets insets = this.getInsets();
        Dimension dimension2 = this.getHeaderSize();
        int n = insets.left + insets.right + Math.max(Math.max(dimension2.width, dimension.width), this.mVSBWidth);
        int n2 = insets.top + insets.bottom + dimension2.height + Math.max(dimension.height, this.mHSBHeight);
        return new Dimension(n, n2);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.mHSB.getModel() || object == this.mVSB.getModel()) {
            this.repaint(this.mHeaderBounds);
            this.repaint(this.mContentBounds);
        }
    }

    public Point toHeaderView(Point point) {
        point.x += this.mHSB.getValue() - this.mHeaderBounds.x;
        point.y -= this.mHeaderBounds.y;
        return point;
    }

    public Point fromHeaderView(Point point) {
        point.x -= this.mHSB.getValue() - this.mHeaderBounds.x;
        point.y += this.mHeaderBounds.y;
        return point;
    }

    public Point toContentView(Point point) {
        point.x += this.mHSB.getValue() - this.mContentBounds.x;
        point.y += this.mVSB.getValue() - this.mContentBounds.y;
        return point;
    }

    public Point fromContentView(Point point) {
        point.x -= this.mHSB.getValue() - this.mContentBounds.x;
        point.y -= this.mVSB.getValue() - this.mContentBounds.y;
        return point;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            int n = mouseWheelEvent.getUnitsToScroll();
            JScrollBar jScrollBar = mouseWheelEvent.isShiftDown() ? this.mHSB : this.mVSB;
            jScrollBar.setValue(jScrollBar.getValue() + n * jScrollBar.getUnitIncrement());
        }
    }

    public DirectScrollPanelArea checkAndConvertToArea(Point point) {
        DirectScrollPanelArea directScrollPanelArea = this.mContentBounds.contains(point) ? DirectScrollPanelArea.CONTENT : (this.mHeaderBounds.contains(point) ? DirectScrollPanelArea.HEADER : DirectScrollPanelArea.NONE);
        directScrollPanelArea.convertPoint(this, point);
        return directScrollPanelArea;
    }

    @Override
    public void autoscroll(Point point) {
        if (this.mLastAreaClicked == DirectScrollPanelArea.CONTENT) {
            if (point.x < 10 + this.mContentBounds.x) {
                point.x -= 10;
            } else if (point.x > this.mContentBounds.x + this.mContentBounds.width - 10) {
                point.x += 10;
            }
            if (point.y < 10 + this.mContentBounds.y) {
                point.y -= 10;
            } else if (point.y > this.mContentBounds.y + this.mContentBounds.height - 10) {
                point.y += 10;
            }
            this.scrollContentIntoView(this.toContentView(point));
        } else if (this.mLastAreaClicked == DirectScrollPanelArea.HEADER) {
            if (point.x < 10 + this.mContentBounds.x) {
                point.x -= 10;
            } else if (point.x > this.mContentBounds.x + this.mContentBounds.width - 10) {
                point.x += 10;
            }
            point.y = this.mContentBounds.y;
            this.scrollContentIntoView(this.toContentView(point));
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        Dimension dimension = this.getSize();
        return new Insets(10 + this.mContentBounds.y, 10 + this.mContentBounds.x, 10 + dimension.height - (this.mContentBounds.y + this.mContentBounds.height), 10 + dimension.width - (this.mContentBounds.x + this.mContentBounds.width));
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.mInAutoscroll = this.getAutoscrolls() && mouseEvent.getID() == 506;
        super.processMouseMotionEvent(mouseEvent);
        this.mInAutoscroll = false;
    }

    @Override
    public Rectangle getVisibleRect() {
        Rectangle rectangle = super.getVisibleRect();
        if (this.mInAutoscroll) {
            rectangle = Geometry.intersection(rectangle, new Rectangle(this.mContentBounds.x + 10, this.mHeaderBounds.y, this.mContentBounds.width - 20, this.mHeaderBounds.height + this.mContentBounds.height - 10));
        }
        return rectangle;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.mLastAreaClicked = this.checkAndConvertToArea(mouseEvent.getPoint());
        }
        super.processMouseEvent(mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage createImage() {
        BufferedImage bufferedImage = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            Graphics graphics = null;
            try {
                int n = this.mHeaderBounds.width;
                int n2 = this.mHeaderBounds.height + this.mContentBounds.height;
                bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(n, n2, 3);
                graphics = (Graphics2D)bufferedImage.getGraphics();
                Color color = ((Graphics2D)graphics).getBackground();
                ((Graphics2D)graphics).setBackground(new Color(0, true));
                graphics.clearRect(0, 0, n, n2);
                ((Graphics2D)graphics).setBackground(color);
                Insets insets = this.getInsets();
                ((Graphics2D)graphics).translate(-insets.left, -insets.top);
                Rectangle rectangle = new Rectangle(0, 0, n, n2);
                graphics.setClip(rectangle);
                this.paint(graphics);
            }
            catch (Exception exception) {
                assert (false) : Debug.throwableToString(exception);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
            }
        }
        return bufferedImage;
    }

    protected boolean isDrawingDragImage() {
        return this.mDrawingDragImage;
    }

    protected Rectangle getDragClip() {
        return this.mDragClip;
    }

    protected void setDragClip(Rectangle rectangle) {
        this.mDragClip = rectangle != null ? new Rectangle(rectangle) : null;
    }

    @Override
    public boolean isOpaque() {
        return super.isOpaque() && !this.mDrawingDragImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage createDragImage(Point point) {
        Graphics graphics = null;
        BufferedImage bufferedImage = null;
        this.mDrawingDragImage = true;
        this.mDragClip = null;
        BufferedImage bufferedImage2 = this.createImage();
        this.mDrawingDragImage = false;
        if (this.mDragClip == null) {
            this.mDragClip = new Rectangle(point.x, point.y, 1, 1);
        }
        try {
            bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(this.mDragClip.width, this.mDragClip.height, 3);
            graphics = (Graphics2D)bufferedImage.getGraphics();
            graphics.setClip(new Rectangle(0, 0, this.mDragClip.width, this.mDragClip.height));
            ((Graphics2D)graphics).setBackground(new Color(0, true));
            graphics.clearRect(0, 0, this.mDragClip.width, this.mDragClip.height);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.5f));
            Point point2 = this.toContentView(new Point(this.mHeaderBounds.x, this.mHeaderBounds.y));
            graphics.drawImage(bufferedImage2, -(this.mDragClip.x - point2.x), -(this.mDragClip.y - point2.y), this);
        }
        catch (Exception exception) {
            assert (false) : Debug.throwableToString(exception);
            bufferedImage = null;
            this.mDragClip = new Rectangle(point.x, point.y, 1, 1);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return bufferedImage != null ? bufferedImage : bufferedImage2;
    }

    public Component getHSBLeftCorner() {
        return this.mHSBLeftCorner;
    }

    public void setHSBLeftCorner(Component component) {
        if (this.mHSBLeftCorner != component) {
            if (this.mHSBLeftCorner != null) {
                this.remove(this.mHSBLeftCorner);
            }
            this.mHSBLeftCorner = component;
            if (this.mHSBLeftCorner != null) {
                this.add(this.mHSBLeftCorner);
            }
        }
    }

    public Component getHSBRightCorner() {
        return this.mHSBRightCorner;
    }

    public void setHSBRightCorner(Component component) {
        if (this.mHSBRightCorner != component) {
            if (this.mHSBRightCorner != null) {
                this.remove(this.mHSBRightCorner);
            }
            this.mHSBRightCorner = component;
            if (this.mHSBRightCorner != null) {
                this.add(this.mHSBRightCorner);
            }
        }
    }

    public Component getVSBTopCorner() {
        return this.mVSBTopCorner;
    }

    public void setVSBTopCorner(Component component) {
        if (this.mVSBTopCorner != component) {
            if (this.mVSBTopCorner != null) {
                this.remove(this.mVSBTopCorner);
            }
            this.mVSBTopCorner = component;
            if (this.mVSBTopCorner != null) {
                this.add(this.mVSBTopCorner);
            }
        }
    }

    public Component getVSBBottomCorner() {
        return this.mVSBBottomCorner;
    }

    public void setVSBBottomCorner(Component component) {
        if (this.mVSBBottomCorner != component) {
            if (this.mVSBBottomCorner != null) {
                this.remove(this.mVSBBottomCorner);
            }
            this.mVSBBottomCorner = component;
            if (this.mVSBBottomCorner != null) {
                this.add(this.mVSBBottomCorner);
            }
        }
    }
}

