/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.UIUtilities;
import com.trollworks.ttk.widgets.ActionPanel;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;

public class FontPanel
extends ActionPanel
implements ActionListener {
    private static String MSG_PLAIN;
    private static String MSG_BOLD;
    private static String MSG_ITALIC;
    private static String MSG_BOLD_ITALIC;
    private static String MSG_NAME_TOOLTIP;
    private static String MSG_SIZE_TOOLTIP;
    private static String MSG_STYLE_TOOLTIP;
    private static final String[] STD_STYLES;
    private JComboBox mFontSizeMenu;
    private JComboBox mFontNameMenu;
    private JComboBox mFontStyleMenu;
    private boolean mNoNotify;

    public FontPanel(Font font) {
        super(new FlowLayout(0, 5, 0));
        this.setOpaque(false);
        this.mFontNameMenu = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.mFontNameMenu.setOpaque(false);
        this.mFontNameMenu.setToolTipText(MSG_NAME_TOOLTIP);
        this.mFontNameMenu.setMaximumRowCount(25);
        this.mFontNameMenu.addActionListener(this);
        UIUtilities.setOnlySize(this.mFontNameMenu, this.mFontNameMenu.getPreferredSize());
        this.add(this.mFontNameMenu);
        Integer[] integerArray = new Integer[10];
        for (int i = 0; i < 7; ++i) {
            integerArray[i] = new Integer(6 + i);
        }
        integerArray[7] = new Integer(14);
        integerArray[8] = new Integer(16);
        integerArray[9] = new Integer(18);
        this.mFontSizeMenu = new JComboBox<Integer>(integerArray);
        this.mFontSizeMenu.setOpaque(false);
        this.mFontSizeMenu.setToolTipText(MSG_SIZE_TOOLTIP);
        this.mFontSizeMenu.setMaximumRowCount(integerArray.length);
        this.mFontSizeMenu.addActionListener(this);
        UIUtilities.setOnlySize(this.mFontSizeMenu, this.mFontSizeMenu.getPreferredSize());
        this.add(this.mFontSizeMenu);
        this.mFontStyleMenu = new JComboBox<String>(STD_STYLES);
        this.mFontStyleMenu.setOpaque(false);
        this.mFontStyleMenu.setToolTipText(MSG_STYLE_TOOLTIP);
        this.mFontStyleMenu.addActionListener(this);
        UIUtilities.setOnlySize(this.mFontStyleMenu, this.mFontStyleMenu.getPreferredSize());
        this.add(this.mFontStyleMenu);
        this.setCurrentFont(font);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyActionListeners();
    }

    @Override
    public void notifyActionListeners(ActionEvent actionEvent) {
        if (!this.mNoNotify) {
            super.notifyActionListeners(actionEvent);
        }
    }

    public Font getCurrentFont() {
        return new Font((String)this.mFontNameMenu.getSelectedItem(), this.mFontStyleMenu.getSelectedIndex(), (Integer)this.mFontSizeMenu.getSelectedItem());
    }

    public void setCurrentFont(Font font) {
        this.mNoNotify = true;
        this.mFontNameMenu.setSelectedItem(font.getName());
        if (this.mFontNameMenu.getSelectedItem() == null) {
            this.mFontNameMenu.setSelectedIndex(0);
        }
        this.mFontSizeMenu.setSelectedItem(new Integer(font.getSize()));
        if (this.mFontSizeMenu.getSelectedItem() == null) {
            this.mFontSizeMenu.setSelectedIndex(3);
        }
        this.mFontStyleMenu.setSelectedIndex(font.getStyle());
        if (this.mFontStyleMenu.getSelectedItem() == null) {
            this.mFontStyleMenu.setSelectedIndex(0);
        }
        this.mNoNotify = false;
        this.notifyActionListeners();
    }

    static {
        LocalizedMessages.initialize(FontPanel.class);
        STD_STYLES = new String[]{MSG_PLAIN, MSG_BOLD, MSG_ITALIC, MSG_BOLD_ITALIC};
    }
}

