/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.utility.Platform;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class KeyStrokeDisplay
extends JLabel
implements KeyListener {
    private static final String EMPTY = "";
    private KeyStroke mKeyStroke;

    public KeyStrokeDisplay(KeyStroke keyStroke) {
        super("Command-Alt-Option-Control-Shift-Meta-Z", 0);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setBorder(new CompoundBorder(LineBorder.createBlackLineBorder(), new EmptyBorder(2, 5, 2, 5)));
        this.addKeyListener(this);
        this.mKeyStroke = keyStroke;
        this.setPreferredSize(this.getPreferredSize());
        this.setText(KeyStrokeDisplay.getKeyStrokeDisplay(this.mKeyStroke));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        int n = keyStroke.getKeyCode();
        if (n != 16 && n != 17 && n != 157 && n != 18 && n != 20 && n != 27) {
            this.mKeyStroke = keyStroke;
            this.setText(KeyStrokeDisplay.getKeyStrokeDisplay(this.mKeyStroke));
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public KeyStroke getKeyStroke() {
        return this.mKeyStroke;
    }

    public static String getKeyStrokeDisplay(KeyStroke keyStroke) {
        String string = EMPTY;
        if (keyStroke != null) {
            int n;
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string = KeyEvent.getKeyModifiersText(n2);
                if (Platform.isMacintosh()) {
                    string = string.replaceAll("\\+", EMPTY);
                } else {
                    String string2 = UIManager.getString("MenuItem.acceleratorDelimiter");
                    if (string2 == null) {
                        string2 = "+";
                    }
                    string = string + string2;
                }
            }
            string = (n = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n) : string + keyStroke.getKeyChar();
        }
        return string;
    }
}

