/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.image.ToolkitImage;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.DataModifiedListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JRootPane;

public class ModifiedMarker
extends JLabel
implements DataModifiedListener {
    private static String MSG_NOT_MODIFIED;
    private static String MSG_MODIFIED;
    private static ImageIcon ICON_NOT_MODIFIED;
    private static ImageIcon ICON_MODIFIED;

    public ModifiedMarker() {
        super(ICON_NOT_MODIFIED);
        this.setToolTipText(MSG_NOT_MODIFIED);
    }

    @Override
    public void dataModificationStateChanged(Object object, boolean bl) {
        if (bl) {
            this.setIcon(ICON_MODIFIED);
            this.setToolTipText(MSG_MODIFIED);
        } else {
            this.setIcon(ICON_NOT_MODIFIED);
            this.setToolTipText(MSG_NOT_MODIFIED);
        }
        this.repaint();
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.putClientProperty("Window.documentModified", bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    static {
        ICON_NOT_MODIFIED = new ImageIcon(ToolkitImage.getNotModifiedMarker());
        ICON_MODIFIED = new ImageIcon(ToolkitImage.getModifiedMarker());
        LocalizedMessages.initialize(ModifiedMarker.class);
    }
}

