/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.text.NumericStringComparator;
import com.trollworks.ttk.widgets.outline.Cell;
import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.Outline;
import com.trollworks.ttk.widgets.outline.Row;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class ImageCell
implements Cell {
    private int mHAlignment;
    private int mVAlignment;

    public ImageCell() {
        this(0, 0);
    }

    public ImageCell(int n, int n2) {
        this.mHAlignment = n;
        this.mVAlignment = n2;
    }

    @Override
    public int compare(Column column, Row row, Row row2) {
        String string = row.getDataAsText(column);
        String string2 = row2.getDataAsText(column);
        return NumericStringComparator.caselessCompareStrings(string != null ? string : "", string2 != null ? string2 : "");
    }

    protected BufferedImage getIcon(Row row, Column column, boolean bl, boolean bl2) {
        Object object = row.getData(column);
        return object instanceof BufferedImage ? (BufferedImage)object : null;
    }

    @Override
    public void drawCell(Outline outline, Graphics graphics, Rectangle rectangle, Row row, Column column, boolean bl, boolean bl2) {
        BufferedImage bufferedImage;
        if (row != null && (bufferedImage = this.getIcon(row, column, bl, bl2)) != null) {
            int n;
            int n2 = rectangle.x;
            int n3 = rectangle.y;
            if (this.mHAlignment != 2) {
                n = rectangle.width - bufferedImage.getWidth();
                if (this.mHAlignment == 0) {
                    n /= 2;
                }
                n2 += n;
            }
            if (this.mVAlignment != 1) {
                n = rectangle.height - bufferedImage.getHeight();
                if (this.mVAlignment == 0) {
                    n /= 2;
                }
                n3 += n;
            }
            graphics.drawImage(bufferedImage, n2, n3, null);
        }
    }

    @Override
    public int getPreferredWidth(Row row, Column column) {
        Object object = row != null ? row.getData(column) : null;
        return object instanceof BufferedImage ? ((BufferedImage)object).getWidth() : 0;
    }

    @Override
    public int getPreferredHeight(Row row, Column column) {
        Object object = row != null ? row.getData(column) : null;
        return object instanceof BufferedImage ? ((BufferedImage)object).getHeight() : 0;
    }

    @Override
    public Cursor getCursor(MouseEvent mouseEvent, Rectangle rectangle, Row row, Column column) {
        return Cursor.getDefaultCursor();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent, Rectangle rectangle, Row row, Column column) {
        return null;
    }

    @Override
    public boolean participatesInDynamicRowLayout() {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent, Rectangle rectangle, Row row, Column column) {
    }
}

