/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.image.ToolkitImage;
import com.trollworks.ttk.menu.edit.Deletable;
import com.trollworks.ttk.menu.edit.SelectAllCapable;
import com.trollworks.ttk.text.Numbers;
import com.trollworks.ttk.undo.StdUndoManager;
import com.trollworks.ttk.utility.Colors;
import com.trollworks.ttk.utility.Debug;
import com.trollworks.ttk.utility.Geometry;
import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.Selection;
import com.trollworks.ttk.utility.UIUtilities;
import com.trollworks.ttk.widgets.ActionPanel;
import com.trollworks.ttk.widgets.AppWindow;
import com.trollworks.ttk.widgets.outline.Cell;
import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.ColumnConfig;
import com.trollworks.ttk.widgets.outline.OutlineHeader;
import com.trollworks.ttk.widgets.outline.OutlineModel;
import com.trollworks.ttk.widgets.outline.OutlineModelListener;
import com.trollworks.ttk.widgets.outline.OutlineProxy;
import com.trollworks.ttk.widgets.outline.Row;
import com.trollworks.ttk.widgets.outline.RowSelection;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.undo.StateEdit;
import javax.swing.undo.UndoableEdit;

public class Outline
extends ActionPanel
implements OutlineModelListener,
ComponentListener,
FocusListener,
Autoscroll,
Scrollable,
Deletable,
SelectAllCapable,
DragGestureListener,
DropTargetListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private static String MSG_SORT_UNDO_TITLE;
    private static String MSG_ROW_DROP_UNDO_TITLE;
    public static final String CMD_OPEN_SELECTION = "Outline.OpenSelection";
    public static final String CMD_SELECTION_CHANGED = "Outline.SelectionChanged";
    public static final String CMD_POTENTIAL_CONTENT_SIZE_CHANGE = "Outline.ContentSizeMayHaveChanged";
    public static final String CMD_TOGGLE_COLUMN_VISIBILITY = "Outline.ToggleColumnVisibility";
    private static final int DIVIDER_HIT_SLOP = 2;
    private static final int AUTO_SCROLL_MARGIN = 10;
    private OutlineModel mModel;
    protected OutlineHeader mHeaderPanel;
    private boolean mDrawRowDividers;
    private boolean mDrawColumnDividers;
    private Color mDividerColor;
    private boolean mDrawingDragImage;
    private Rectangle mDragClip;
    private Column mDividerDrag;
    private int mColumnStart;
    private String mSelectionChangedCommand;
    private String mPotentialContentSizeChangeCommand;
    private boolean mAllowColumnContextMenu;
    private boolean mAllowColumnResize;
    private boolean mAllowColumnDrag;
    private boolean mAllowRowDrag;
    private String mDefaultConfig;
    private boolean mUseBanding;
    private ArrayList<Column> mSavedColumns;
    private BufferedImage mDownTriangle;
    private BufferedImage mDownTriangleRoll;
    private BufferedImage mRightTriangle;
    private BufferedImage mRightTriangleRoll;
    private Row mRollRow;
    private Row mDragParentRow;
    private int mDragChildInsertIndex;
    private boolean mDragWasAcceptable;
    private boolean mDragFocus;
    private Column mSourceDragColumn;
    private boolean mDynamicRowHeight;
    private HashSet<OutlineProxy> mProxies;
    protected int mFirstRow;
    protected int mLastRow;
    private int mSelectOnMouseUp;
    private boolean mUserSortable;
    private Deletable mDeletableProxy;

    public Outline() {
        this(true);
    }

    public Outline(OutlineModel outlineModel) {
        this(outlineModel, true);
    }

    public Outline(boolean bl) {
        this(new OutlineModel(), bl);
    }

    public Outline(OutlineModel outlineModel, boolean bl) {
        this.mModel = outlineModel;
        this.mProxies = new HashSet();
        this.mUserSortable = true;
        this.mAllowColumnContextMenu = true;
        this.mAllowColumnResize = true;
        this.mAllowColumnDrag = true;
        this.mAllowRowDrag = true;
        this.mDrawRowDividers = true;
        this.mDrawColumnDividers = true;
        this.mUseBanding = true;
        this.mDividerColor = Color.LIGHT_GRAY;
        this.mSelectionChangedCommand = CMD_SELECTION_CHANGED;
        this.mPotentialContentSizeChangeCommand = CMD_POTENTIAL_CONTENT_SIZE_CHANGE;
        this.mDownTriangle = ToolkitImage.getDownTriangleIcon();
        this.mDownTriangleRoll = ToolkitImage.getDownTriangleRollIcon();
        this.mRightTriangle = ToolkitImage.getRightTriangleIcon();
        this.mRightTriangleRoll = ToolkitImage.getRightTriangleRollIcon();
        this.mDragChildInsertIndex = -1;
        this.mLastRow = -1;
        this.mModel.setShowIndent(bl);
        this.mModel.setIndentWidth(this.mDownTriangle.getWidth());
        this.setActionCommand(CMD_OPEN_SELECTION);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addComponentListener(this);
        this.setAutoscrolls(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        if (!GraphicsUtilities.inHeadlessPrintMode()) {
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, this);
            this.setDropTarget(new DropTarget(this, this));
        }
        if (!(this instanceof OutlineProxy)) {
            this.mModel.addListener(this);
        }
    }

    public void reapplyRowFilter() {
        this.mModel.reapplyRowFilter();
        this.revalidateView();
    }

    public OutlineModel getModel() {
        return this.mModel;
    }

    public Outline getRealOutline() {
        return this;
    }

    protected void addProxy(OutlineProxy outlineProxy) {
        this.mProxies.add(outlineProxy);
        this.mModel.addListener(outlineProxy);
    }

    public void clearProxies() {
        for (OutlineProxy outlineProxy : this.mProxies) {
            this.mModel.removeListener(outlineProxy);
        }
        this.mProxies.clear();
    }

    public boolean dynamicRowHeight() {
        return this.mDynamicRowHeight;
    }

    public void setDynamicRowHeight(boolean bl) {
        this.mDynamicRowHeight = bl;
    }

    public boolean showIndent() {
        return this.mModel.showIndent();
    }

    public Color getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColor(Color color) {
        this.mDividerColor = color;
    }

    public boolean shouldDrawRowDividers() {
        return this.mDrawRowDividers;
    }

    public void setDrawRowDividers(boolean bl) {
        this.mDrawRowDividers = bl;
    }

    public boolean shouldDrawColumnDividers() {
        return this.mDrawColumnDividers;
    }

    public void setDrawColumnDividers(boolean bl) {
        this.mDrawColumnDividers = bl;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        List<Column> list = this.mModel.getColumns();
        boolean bl = false;
        for (Column column : list) {
            int n = column.getWidth();
            if (n == -1) {
                n = column.getPreferredWidth(this);
                column.setWidth(n);
                bl = true;
            }
            if (!column.isVisible()) continue;
            dimension.width = dimension.width + (n + (this.mDrawColumnDividers ? 1 : 0));
        }
        if (this.mDrawColumnDividers && !this.mModel.getColumns().isEmpty()) {
            --dimension.width;
        }
        if (bl) {
            this.revalidateView();
        }
        boolean bl2 = false;
        for (int i = this.getFirstRowToDisplay(); i <= this.getLastRowToDisplay(); ++i) {
            Row row = this.mModel.getRowAtIndex(i);
            if (this.mModel.isRowFiltered(row)) continue;
            int n = row.getHeight();
            if (n == -1) {
                n = row.getPreferredHeight(list);
                row.setHeight(n);
            }
            dimension.height = dimension.height + (n + (this.mDrawRowDividers ? 1 : 0));
            bl2 = true;
        }
        if (this.mDrawRowDividers && bl2) {
            --dimension.height;
        }
        if (this.isMinimumSizeSet()) {
            Dimension dimension2 = this.getMinimumSize();
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
        }
        return dimension;
    }

    private void drawDragRowInsertionMarker(Graphics graphics, Row row, int n) {
        Rectangle rectangle = this.getDragRowInsertionMarkerBounds(row, n);
        graphics.setColor(Color.red);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        for (int i = 0; i < rectangle.height / 2; ++i) {
            graphics.drawLine(rectangle.x + i, rectangle.y + i, rectangle.x + i, rectangle.y + rectangle.height - (1 + i));
        }
    }

    private Rectangle getDragRowInsertionMarkerBounds(Row row, int n) {
        Rectangle rectangle;
        int n2 = this.mModel.getRowCount();
        if (n < 0 || n2 == 0) {
            rectangle = new Rectangle();
        } else {
            int n3;
            int n4 = this.getAbsoluteInsertionIndex(row, n);
            int n5 = n3 = row != null ? this.mModel.getIndentWidth(row, this.mModel.getColumns().get(0)) + this.mModel.getIndentWidth() : 0;
            if (n4 < n2) {
                rectangle = this.getRowBounds(this.mModel.getRowAtIndex(n4));
                if (this.mDrawRowDividers && n4 != 0) {
                    --rectangle.y;
                }
            } else {
                rectangle = this.getRowBounds(this.mModel.getRowAtIndex(n2 - 1));
                rectangle.y += rectangle.height;
            }
            rectangle.x += n3;
            rectangle.width -= n3;
        }
        rectangle.y -= 3;
        rectangle.height = 7;
        return rectangle;
    }

    public int getFirstRowToDisplay() {
        return this.mFirstRow < 0 ? 0 : this.mFirstRow;
    }

    public void setFirstRowToDisplay(int n) {
        this.mFirstRow = n;
    }

    public int getLastRowToDisplay() {
        int n = this.mModel.getRowCount() - 1;
        return this.mLastRow < 0 || this.mLastRow > n ? n : this.mLastRow;
    }

    public void setLastRowToDisplay(int n) {
        this.mLastRow = n;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(GraphicsUtilities.prepare(graphics));
        this.drawBackground(graphics);
        Shape shape = graphics.getClip();
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.getInsets();
        Rectangle rectangle2 = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
        boolean bl = this.isFocusOwner();
        int n = this.getFirstRowToDisplay();
        int n2 = this.getLastRowToDisplay();
        Container container = this.getTopLevelAncestor();
        boolean bl2 = container instanceof AppWindow && ((AppWindow)container).isPrinting();
        boolean bl3 = this.showIndent();
        for (int i = n; i <= n2; ++i) {
            Row row = this.mModel.getRowAtIndex(i);
            if (this.mModel.isRowFiltered(row)) continue;
            rectangle2.height = row.getHeight();
            if (rectangle2.y >= rectangle.y || rectangle2.y + rectangle2.height + (this.mDrawRowDividers ? 1 : 0) >= rectangle.y) {
                boolean bl4;
                if (rectangle2.y > rectangle.y + rectangle.height) break;
                boolean bl5 = bl4 = !bl2 && this.mModel.isRowSelected(row);
                if (!this.mDrawingDragImage || this.mDrawingDragImage && bl4) {
                    Rectangle rectangle3 = new Rectangle(rectangle2);
                    Composite composite = null;
                    boolean bl6 = true;
                    int n3 = 0;
                    for (Column column : this.mModel.getColumns()) {
                        if (!column.isVisible()) continue;
                        rectangle3.width = column.getWidth();
                        if (rectangle.intersects(rectangle3)) {
                            boolean bl7 = this.mSourceDragColumn == column;
                            graphics.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                            if (bl7) {
                                composite = ((Graphics2D)graphics).getComposite();
                                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.5f));
                            }
                            if (bl3 && bl6) {
                                n3 = this.mModel.getIndentWidth(row, column);
                                rectangle3.x += n3;
                                rectangle3.width -= n3;
                                if (row.canHaveChildren()) {
                                    BufferedImage bufferedImage = this.getDisclosureControl(row);
                                    graphics.drawImage(bufferedImage, rectangle3.x - bufferedImage.getWidth(), 1 + rectangle3.y + (rectangle3.height - bufferedImage.getHeight()) / 2, null);
                                }
                            }
                            if (bl2) {
                                ++rectangle3.width;
                            }
                            column.drawRowCell(this, graphics, rectangle3, row, bl4, bl);
                            if (bl2) {
                                --rectangle3.width;
                            }
                            if (bl3 && bl6) {
                                rectangle3.x -= n3;
                                rectangle3.width += n3;
                            }
                            if (bl7) {
                                ((Graphics2D)graphics).setComposite(composite);
                            }
                            graphics.setClip(shape);
                        }
                        rectangle3.x += rectangle3.width + 1;
                        bl6 = false;
                    }
                    if (this.mDrawingDragImage) {
                        if (this.mDragClip == null) {
                            this.mDragClip = new Rectangle(rectangle2);
                        } else {
                            this.mDragClip.add(rectangle2);
                        }
                    }
                }
            }
            rectangle2.y = rectangle2.y + (rectangle2.height + (this.mDrawRowDividers ? 1 : 0));
        }
        if (this.mDragChildInsertIndex != -1) {
            this.drawDragRowInsertionMarker(graphics, this.mDragParentRow, this.mDragChildInsertIndex);
        }
    }

    private void drawBackground(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.getInsets();
        int n2 = insets.top;
        int n3 = this.getHeight() - (n2 + insets.bottom);
        Rectangle rectangle2 = new Rectangle(insets.left, n2, this.getWidth() - (insets.left + insets.right), n3);
        boolean bl = this.isFocusOwner();
        int n4 = this.getFirstRowToDisplay();
        int n5 = this.getLastRowToDisplay();
        Container container = this.getTopLevelAncestor();
        boolean bl2 = container instanceof AppWindow && ((AppWindow)container).isPrinting();
        for (n = n4; n <= n5; ++n) {
            Row row = this.mModel.getRowAtIndex(n);
            if (this.mModel.isRowFiltered(row)) continue;
            rectangle2.height = row.getHeight();
            if (rectangle2.y >= rectangle.y || rectangle2.y + rectangle2.height + (this.mDrawRowDividers ? 1 : 0) >= rectangle.y) {
                boolean bl3;
                if (rectangle2.y > rectangle.y + rectangle.height) break;
                boolean bl4 = bl3 = !bl2 && this.mModel.isRowSelected(row);
                if (!this.mDrawingDragImage || this.mDrawingDragImage && bl3) {
                    graphics.setColor(this.getBackground(n, bl3, bl));
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    if (this.mDrawRowDividers) {
                        graphics.setColor(this.mDividerColor);
                        graphics.drawLine(rectangle2.x, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                    }
                }
            }
            rectangle2.y = rectangle2.y + (rectangle2.height + (this.mDrawRowDividers ? 1 : 0));
        }
        if (this.mDrawColumnDividers) {
            n = insets.left;
            n3 += n2;
            graphics.setColor(this.mDividerColor);
            for (Column column : this.mModel.getColumns()) {
                if (!column.isVisible()) continue;
                graphics.drawLine(n += column.getWidth(), n2, n, n3);
                ++n;
            }
        }
        if (!bl2 && (bl || this.mDragFocus)) {
            graphics.setColor(Outline.getListBackground(true, true));
            rectangle2 = this.getVisibleRect();
            n = rectangle2.x;
            int n6 = rectangle2.y;
            int n7 = rectangle2.width - 1;
            int n8 = rectangle2.height - 1;
            graphics.drawRect(n, n6, n7, n8);
        }
    }

    @Override
    public void repaint(Rectangle rectangle) {
        super.repaint(rectangle);
        if (this.mProxies != null) {
            for (OutlineProxy outlineProxy : this.mProxies) {
                outlineProxy.repaintProxy(rectangle);
            }
        }
    }

    void repaintHeader(Rectangle rectangle) {
        if (this.mHeaderPanel != null) {
            this.getHeaderPanel().repaintInternal(rectangle);
            for (OutlineProxy outlineProxy : this.mProxies) {
                if (outlineProxy.mHeaderPanel == null) continue;
                outlineProxy.getHeaderPanel().repaintInternal(rectangle);
            }
        }
    }

    void repaintHeader() {
        if (this.mHeaderPanel != null) {
            Rectangle rectangle = this.mHeaderPanel.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            this.mHeaderPanel.repaintInternal(rectangle);
        }
    }

    public void repaintColumn(int n) {
        this.repaintColumn(this.mModel.getColumnAtIndex(n));
    }

    public void repaintColumn(Column column) {
        if (column.isVisible()) {
            Rectangle rectangle = new Rectangle(this.getColumnStart(column), 0, column.getWidth(), this.getHeight());
            this.repaint(rectangle);
            if (this.mHeaderPanel != null) {
                rectangle.height = this.mHeaderPanel.getHeight();
                this.mHeaderPanel.repaint(rectangle);
            }
        }
    }

    public void repaintView() {
        this.repaint();
        if (this.mHeaderPanel != null) {
            this.mHeaderPanel.repaint();
        }
    }

    public void repaintSelection() {
        this.repaintSelectionInternal();
        for (OutlineProxy outlineProxy : this.mProxies) {
            outlineProxy.repaintSelectionInternal();
        }
    }

    protected Rectangle repaintSelectionInternal() {
        Rectangle rectangle = new Rectangle();
        Insets insets = this.getInsets();
        Rectangle rectangle2 = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
        int n = this.getLastRowToDisplay();
        List<Column> list = this.mModel.getColumns();
        for (int i = this.getFirstRowToDisplay(); i <= n; ++i) {
            Row row = this.mModel.getRowAtIndex(i);
            if (this.mModel.isRowFiltered(row)) continue;
            int n2 = row.getHeight();
            if (n2 == -1) {
                n2 = row.getPreferredHeight(list);
                row.setHeight(n2);
            }
            if (this.mDrawRowDividers) {
                ++n2;
            }
            if (this.mModel.isRowSelected(row)) {
                rectangle2.height = n2;
                this.repaint(rectangle2);
                rectangle = Geometry.union(rectangle, rectangle2);
            }
            rectangle2.y += n2;
        }
        return rectangle;
    }

    public Color getBackground(int n, boolean bl, boolean bl2) {
        if (bl) {
            return Outline.getListBackground(bl, bl2);
        }
        return this.useBanding() ? Colors.getBanding(n % 2 == 0) : Color.white;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            Insets insets = this.getInsets();
            int n3 = rectangle.y - insets.top;
            if (n2 < 0) {
                int n4 = this.overRowIndex(n3);
                if (n4 > -1) {
                    int n5 = this.getRowIndexStart(n4);
                    if (n5 < n3) {
                        return n3 - n5;
                    }
                    if (--n4 > -1) {
                        return n3 - this.getRowIndexStart(n4);
                    }
                }
            } else {
                int n6 = this.overRowIndex(n3 += rectangle.height);
                if (n6 > -1) {
                    int n7 = this.getRowIndexStart(n6);
                    int n8 = n7 + this.mModel.getRowAtIndex(n6).getHeight() + (this.mDrawRowDividers ? 1 : 0);
                    if (n8 > n3) {
                        return n8 - (n3 - 1);
                    }
                    if (++n6 < this.mModel.getRowCount()) {
                        return this.getRowIndexStart(n6) + this.mModel.getRowAtIndex(n6).getHeight() + (this.mDrawRowDividers ? 1 : 0) - (n3 - 1);
                    }
                }
            }
        }
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return UIUtilities.shouldTrackViewportHeight(this);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return UIUtilities.shouldTrackViewportWidth(this);
    }

    public Column overColumnDivider(int n) {
        int n2 = this.getInsets().left;
        int n3 = this.mModel.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Column column = this.mModel.getColumnAtIndex(i);
            if (!column.isVisible() || n < (n2 += column.getWidth() + (this.mDrawColumnDividers ? 1 : 0)) - 2 || n > n2 + 2) continue;
            return column;
        }
        return null;
    }

    public int overColumnDividerIndex(int n) {
        int n2 = this.getInsets().left;
        int n3 = this.mModel.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Column column = this.mModel.getColumnAtIndex(i);
            if (!column.isVisible() || n < (n2 += column.getWidth() + (this.mDrawColumnDividers ? 1 : 0)) - 2 || n > n2 + 2) continue;
            return i;
        }
        return -1;
    }

    public Column overColumn(int n) {
        int n2 = this.getInsets().left;
        int n3 = this.mModel.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Column column = this.mModel.getColumnAtIndex(i);
            if (!column.isVisible() || n >= (n2 += column.getWidth() + (this.mDrawColumnDividers ? 1 : 0))) continue;
            return column;
        }
        return null;
    }

    public int overColumnIndex(int n) {
        int n2 = this.getInsets().left;
        int n3 = this.mModel.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Column column = this.mModel.getColumnAtIndex(i);
            if (!column.isVisible() || n >= (n2 += column.getWidth() + (this.mDrawColumnDividers ? 1 : 0))) continue;
            return i;
        }
        return -1;
    }

    private BufferedImage getDisclosureControl(Row row) {
        return row.isOpen() ? (row == this.mRollRow ? this.mDownTriangleRoll : this.mDownTriangle) : (row == this.mRollRow ? this.mRightTriangleRoll : this.mRightTriangle);
    }

    public boolean overDisclosureControl(int n, int n2, Column column, Row row) {
        if (this.showIndent() && column != null && row != null && row.canHaveChildren() && this.mModel.isFirstColumn(column)) {
            BufferedImage bufferedImage = this.getDisclosureControl(row);
            int n3 = this.getInsets().left + this.mModel.getIndentWidth(row, column);
            return n <= n3 && n >= n3 - bufferedImage.getWidth();
        }
        return false;
    }

    public int getColumnIndexStart(int n) {
        int n2 = this.getInsets().left;
        for (int i = 0; i < n; ++i) {
            Column column = this.mModel.getColumnAtIndex(i);
            if (!column.isVisible()) continue;
            n2 += column.getWidth() + (this.mDrawColumnDividers ? 1 : 0);
        }
        return n2;
    }

    public int getColumnStart(Column column) {
        Column column2;
        int n = this.getInsets().left;
        int n2 = this.mModel.getColumnCount();
        for (int i = 0; i < n2 && (column2 = this.mModel.getColumnAtIndex(i)) != column; ++i) {
            if (!column2.isVisible()) continue;
            n += column2.getWidth() + (this.mDrawColumnDividers ? 1 : 0);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getColumnDragImage(Column column) {
        BufferedImage bufferedImage = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            Graphics graphics = null;
            try {
                Rectangle rectangle = new Rectangle(0, 0, column.getWidth() + (this.mDrawColumnDividers ? 2 : 0), this.getVisibleRect().height + (this.mHeaderPanel != null ? this.mHeaderPanel.getHeight() + 1 : 0));
                bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(rectangle.width, rectangle.height, 3);
                graphics = GraphicsUtilities.prepare(bufferedImage.getGraphics());
                graphics.setClip(rectangle);
                ((Graphics2D)graphics).setBackground(new Color(0, true));
                graphics.clearRect(0, 0, rectangle.width, rectangle.height);
                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.5f));
                graphics.setColor(this.getBackground());
                ((Graphics2D)graphics).fill(rectangle);
                graphics.setColor(this.getDividerColor());
                if (this.mDrawRowDividers) {
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
                    graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
                    ++rectangle.y;
                    rectangle.height -= 2;
                }
                if (this.mDrawColumnDividers) {
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                    graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
                    ++rectangle.x;
                    rectangle.width -= 2;
                }
                this.drawOneColumn((Graphics2D)graphics, column, rectangle);
            }
            catch (Exception exception) {
                assert (false) : Debug.throwableToString(exception);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
            }
        }
        return bufferedImage;
    }

    private void drawOneColumn(Graphics2D graphics2D, Column column, Rectangle rectangle) {
        Shape shape = graphics2D.getClip();
        Color color = this.getDividerColor();
        int n = this.getLastRowToDisplay();
        int n2 = rectangle.y;
        int n3 = rectangle.y + rectangle.height;
        if (this.mHeaderPanel != null) {
            rectangle.height = this.mHeaderPanel.getHeight();
            graphics2D.setColor(this.mHeaderPanel.getBackground());
            graphics2D.fill(rectangle);
            column.drawHeaderCell(this, graphics2D, rectangle);
            rectangle.y += this.mHeaderPanel.getHeight();
            graphics2D.setColor(color);
            graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
            ++rectangle.y;
        }
        for (int i = this.getFirstRowToDisplay(); i <= n; ++i) {
            Row row = this.mModel.getRowAtIndex(i);
            if (this.mModel.isRowFiltered(row)) continue;
            rectangle.height = row.getHeight();
            if (n3 < rectangle.y) break;
            if (n2 <= rectangle.y) {
                graphics2D.setClip(rectangle);
                graphics2D.setColor(this.getBackground(i, false, true));
                graphics2D.fill(rectangle);
                column.drawRowCell(this, graphics2D, rectangle, row, false, true);
                graphics2D.setClip(shape);
                if (this.mDrawRowDividers) {
                    graphics2D.setColor(color);
                    graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                }
            }
            rectangle.y = rectangle.y + (rectangle.height + (this.mDrawRowDividers ? 1 : 0));
        }
    }

    public Row overRow(int n) {
        List<Row> list = this.mModel.getRows();
        int n2 = this.getInsets().top;
        int n3 = this.getLastRowToDisplay();
        for (int i = this.getFirstRowToDisplay(); i <= n3; ++i) {
            Row row = list.get(i);
            if (this.mModel.isRowFiltered(row) || n >= (n2 += row.getHeight() + (this.mDrawRowDividers ? 1 : 0))) continue;
            return row;
        }
        return null;
    }

    public int overRowIndex(int n) {
        List<Row> list = this.mModel.getRows();
        int n2 = this.getInsets().top;
        int n3 = this.getLastRowToDisplay();
        for (int i = this.getFirstRowToDisplay(); i <= n3; ++i) {
            Row row = list.get(i);
            if (this.mModel.isRowFiltered(row) || n >= (n2 += row.getHeight() + (this.mDrawRowDividers ? 1 : 0))) continue;
            return i;
        }
        return -1;
    }

    public int getRowInsertionIndex(int n) {
        List<Row> list = this.mModel.getRows();
        int n2 = this.getInsets().top;
        int n3 = this.getLastRowToDisplay();
        for (int i = this.getFirstRowToDisplay(); i <= n3; ++i) {
            Row row = list.get(i);
            if (this.mModel.isRowFiltered(row)) continue;
            int n4 = row.getHeight();
            int n5 = n2 + n4 / 2;
            if (n <= n5) {
                return i;
            }
            n2 += n4 + (this.mDrawRowDividers ? 1 : 0);
        }
        return n3;
    }

    public int getRowIndexStart(int n) {
        List<Row> list = this.mModel.getRows();
        int n2 = this.getInsets().top;
        for (int i = this.getFirstRowToDisplay(); i < n; ++i) {
            Row row = list.get(i);
            if (this.mModel.isRowFiltered(row)) continue;
            n2 += row.getHeight() + (this.mDrawRowDividers ? 1 : 0);
        }
        return n2;
    }

    public int getRowStart(Row row) {
        Row row2;
        List<Row> list = this.mModel.getRows();
        int n = this.getInsets().top;
        int n2 = this.getLastRowToDisplay();
        for (int i = this.getFirstRowToDisplay(); i <= n2 && row != (row2 = list.get(i)); ++i) {
            if (this.mModel.isRowFiltered(row2)) continue;
            n += row2.getHeight() + (this.mDrawRowDividers ? 1 : 0);
        }
        return n;
    }

    public Rectangle getRowIndexBounds(int n) {
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
        rectangle.y = this.getRowIndexStart(n);
        rectangle.height = this.mModel.getRowAtIndex(n).getHeight();
        return rectangle;
    }

    public Rectangle getRowBounds(Row row) {
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
        rectangle.y = this.getRowStart(row);
        rectangle.height = row.getHeight();
        return rectangle;
    }

    public Rectangle getCellBounds(Row row, Column column) {
        Rectangle rectangle = this.getRowBounds(row);
        rectangle.x = this.getColumnStart(column);
        rectangle.width = column.getWidth();
        return rectangle;
    }

    public Rectangle getAdjustedCellBounds(Row row, Column column) {
        Rectangle rectangle = this.getCellBounds(row, column);
        if (this.mModel.isFirstColumn(column)) {
            int n = this.mModel.getIndentWidth(row, column);
            rectangle.x += n;
            rectangle.width -= n;
            if (rectangle.width < 1) {
                rectangle.width = 1;
            }
        }
        return rectangle;
    }

    public void sizeColumnsToFit() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : this.mModel.getColumns()) {
            int n;
            if (!column.isVisible() || (n = column.getPreferredWidth(this)) == column.getWidth()) continue;
            column.setWidth(n);
            arrayList.add(column);
        }
        if (!arrayList.isEmpty()) {
            this.processColumnWidthChanges(arrayList);
        }
    }

    protected void repaintProxyRow(Row row) {
        this.repaint(this.getRowBounds(row));
        for (OutlineProxy outlineProxy : this.mProxies) {
            outlineProxy.repaintProxy(outlineProxy.getRowBounds(row));
        }
    }

    protected void notifyOfSelectionChange() {
        this.notifyActionListeners(new ActionEvent(this.getRealOutline(), 1001, this.getSelectionChangedActionCommand()));
    }

    public String getSelectionChangedActionCommand() {
        return this.mSelectionChangedCommand;
    }

    public void setSelectionChangedActionCommand(String string) {
        this.mSelectionChangedCommand = string;
    }

    public String getPotentialContentSizeChangeActionCommand() {
        return this.mPotentialContentSizeChangeCommand;
    }

    public void setPotentialContentSizeChangeActionCommand(String string) {
        this.mPotentialContentSizeChangeCommand = string;
    }

    public Deletable getDeletableProxy() {
        return this.mDeletableProxy;
    }

    public void setDeletableProxy(Deletable deletable) {
        this.mDeletableProxy = deletable;
    }

    @Override
    public boolean canDeleteSelection() {
        return this.mDeletableProxy != null ? this.mDeletableProxy.canDeleteSelection() : false;
    }

    @Override
    public void deleteSelection() {
        if (this.mDeletableProxy != null) {
            this.mDeletableProxy.deleteSelection();
        }
    }

    @Override
    public boolean canSelectAll() {
        return this.mModel.canSelectAll();
    }

    @Override
    public void selectAll() {
        this.mModel.select();
    }

    public void setColumnOrder(List<Column> list) {
        ArrayList<Column> arrayList = new ArrayList<Column>(list);
        List<Column> list2 = this.mModel.getColumns();
        list2.removeAll(list);
        arrayList.addAll(list2);
        list2.clear();
        list2.addAll(arrayList);
        this.repaint();
        this.getHeaderPanel().repaint();
    }

    public OutlineHeader getHeaderPanel() {
        if (this.mHeaderPanel == null) {
            this.mHeaderPanel = new OutlineHeader(this);
        }
        return this.mHeaderPanel;
    }

    public Column getSourceDragColumn() {
        return this.mSourceDragColumn;
    }

    protected void setSourceDragColumn(Column column) {
        if (this.mSourceDragColumn != null) {
            this.repaintColumn(this.mSourceDragColumn);
        }
        this.mSourceDragColumn = column;
        if (this.mSourceDragColumn != null) {
            this.repaintColumn(this.mSourceDragColumn);
        }
    }

    protected void keyScroll(int n) {
        block1: {
            Outline outline = this.getRealOutline();
            if (this.keyScrollInternal(outline, n)) break block1;
            for (OutlineProxy outlineProxy : outline.mProxies) {
                if (this.keyScrollInternal(outlineProxy, n)) break;
            }
        }
    }

    private boolean keyScrollInternal(Outline outline, int n) {
        if (n >= outline.mFirstRow && n <= outline.mLastRow) {
            outline.requestFocus();
            outline.scrollRectToVisible(outline.getRowIndexBounds(n));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Row row = null;
        try {
            boolean bl = mouseEvent.getSource() == this;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            row = this.mRollRow;
            if (n3 == 1) {
                Cell cell;
                Row row2;
                Column column;
                if (bl && (column = this.overColumn(n)) != null && (row2 = this.overRow(n2)) != null && !this.overDisclosureControl(n, n2, column, row2) && (cell = column.getRowCell(row2)) != null) {
                    cell.mouseClicked(mouseEvent, this.getCellBounds(row2, column), row2, column);
                }
            } else if (n3 == 2) {
                int n4;
                Column column = this.overColumnDivider(n);
                if (column == null) {
                    Row row3;
                    if (bl && (row3 = this.overRow(n2)) != null && ((column = this.overColumn(n)) == null || !this.overDisclosureControl(n, n2, column, row3)) && this.mModel.isRowSelected(row3)) {
                        this.notifyActionListeners();
                    }
                } else if (this.allowColumnResize() && (n4 = column.getPreferredWidth(this)) != column.getWidth()) {
                    this.adjustColumnWidth(column, n4);
                }
            }
            this.repaintChangedRollRow(row);
        }
        catch (Throwable throwable) {
            this.repaintChangedRollRow(row);
            throw throwable;
        }
    }

    private void repaintChangedRollRow(Row row) {
        if (row != this.mRollRow) {
            Rectangle rectangle;
            Column column = this.mModel.getColumnAtIndex(0);
            if (this.mRollRow != null) {
                rectangle = this.getCellBounds(this.mRollRow, column);
                rectangle.width = this.mModel.getIndentWidth(this.mRollRow, column);
                this.repaint(rectangle);
            }
            if (row != null) {
                rectangle = this.getCellBounds(row, column);
                rectangle.width = this.mModel.getIndentWidth(row, column);
                this.repaint(rectangle);
            }
            this.mRollRow = row;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        block10: {
            if (this.isEnabled()) {
                int n;
                Row row;
                block11: {
                    row = null;
                    boolean bl = mouseEvent.getSource() == this;
                    int n2 = mouseEvent.getX();
                    n = mouseEvent.getY();
                    this.requestFocus();
                    this.mSelectOnMouseUp = -1;
                    this.mDividerDrag = this.overColumnDivider(n2);
                    if (this.mDividerDrag != null) {
                        if (this.allowColumnResize()) {
                            this.mColumnStart = this.getColumnStart(this.mDividerDrag);
                        }
                        break block10;
                    }
                    if (!bl) break block10;
                    Column column = this.overColumn(n2);
                    Row row2 = this.overRow(n);
                    if (column == null || row2 == null || !this.overDisclosureControl(n2, n, column, row2)) break block11;
                    Rectangle rectangle = this.getCellBounds(row2, column);
                    rectangle.width = this.mModel.getIndentWidth(row2, column);
                    row = this.mRollRow;
                    this.repaint(rectangle);
                    row2.setOpen(!row2.isOpen());
                    this.repaintChangedRollRow(row);
                    return;
                }
                try {
                    int n3 = 0;
                    int n4 = this.overRowIndex(n);
                    if (mouseEvent.isShiftDown()) {
                        n3 |= 1;
                    }
                    if ((mouseEvent.getModifiers() & this.getToolkit().getMenuShortcutKeyMask()) != 0 && !mouseEvent.isPopupTrigger()) {
                        n3 |= 2;
                    }
                    this.mSelectOnMouseUp = this.mModel.getSelection().selectByMouse(n4, n3);
                    this.reapplyRowFilter();
                    if (mouseEvent.isPopupTrigger()) {
                        this.mSelectOnMouseUp = -1;
                        this.showContextMenu(mouseEvent);
                    }
                }
                finally {
                    this.repaintChangedRollRow(row);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            Row row = null;
            try {
                row = this.mRollRow;
                if (this.mDividerDrag != null && this.allowColumnResize()) {
                    this.dragColumnDivider(mouseEvent.getX());
                }
                this.mDividerDrag = null;
                if (this.mSelectOnMouseUp != -1) {
                    this.mModel.select(this.mSelectOnMouseUp, false);
                    this.mSelectOnMouseUp = -1;
                }
            }
            finally {
                this.repaintChangedRollRow(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            Row row = null;
            try {
                int n = mouseEvent.getX();
                this.mSelectOnMouseUp = -1;
                if (this.mDividerDrag != null && this.allowColumnResize()) {
                    this.dragColumnDivider(n);
                    JScrollPane jScrollPane = (JScrollPane)UIUtilities.getAncestorOfType(this, JScrollPane.class);
                    if (jScrollPane != null) {
                        Point point = mouseEvent.getPoint();
                        if (!(mouseEvent.getSource() instanceof Outline)) {
                            point.y = this.getVisibleRect().y + 1;
                        }
                        this.scrollRectToVisible(new Rectangle(point.x, point.y, 1, 1));
                    }
                }
            }
            finally {
                this.repaintChangedRollRow(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            Row row = null;
            try {
                Row row2;
                Column column;
                boolean bl = mouseEvent.getSource() == this;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Cursor cursor = Cursor.getDefaultCursor();
                if (this.overColumnDivider(n) != null) {
                    if (this.allowColumnResize()) {
                        cursor = Cursor.getPredefinedCursor(10);
                    }
                } else if (bl && (column = this.overColumn(n)) != null && (row2 = this.overRow(n2)) != null) {
                    if (this.overDisclosureControl(n, n2, column, row2)) {
                        row = row2;
                    } else {
                        Cell cell = column.getRowCell(row2);
                        cursor = cell.getCursor(mouseEvent, this.getCellBounds(row2, column), row2, column);
                    }
                }
                this.setCursor(cursor);
            }
            finally {
                this.repaintChangedRollRow(row);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Selection selection = this.mModel.getSelection();
        boolean bl = keyEvent.isShiftDown();
        switch (keyEvent.getKeyCode()) {
            case 37: {
                int n = selection.firstSelectedIndex();
                while (n >= 0) {
                    this.mModel.getRowAtIndex(n).setOpen(false);
                    n = selection.nextSelectedIndex(n + 1);
                }
                break;
            }
            case 39: {
                int n = selection.firstSelectedIndex();
                while (n >= 0) {
                    this.mModel.getRowAtIndex(n).setOpen(true);
                    n = selection.nextSelectedIndex(n + 1);
                }
                break;
            }
            case 38: {
                this.keyScroll(selection.selectUp(bl));
                break;
            }
            case 40: {
                this.keyScroll(selection.selectDown(bl));
                break;
            }
            case 36: {
                this.keyScroll(selection.selectToHome(bl));
                break;
            }
            case 35: {
                this.keyScroll(selection.selectToEnd(bl));
                break;
            }
            default: {
                return;
            }
        }
        keyEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n' || c == '\r') {
            if (this.mModel.hasSelection()) {
                this.notifyActionListeners();
            }
            keyEvent.consume();
        } else if (c == '\b' || c == '\u007f') {
            if (this.canDeleteSelection()) {
                this.deleteSelection();
            }
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public Cell getCellAt(Point point) {
        return this.getCellAt(point.x, point.y);
    }

    public Cell getCellAt(int n, int n2) {
        Row row;
        Column column = this.overColumn(n);
        if (column != null && (row = this.overRow(n2)) != null) {
            return column.getRowCell(row);
        }
        return null;
    }

    private void dragColumnDivider(int n) {
        int n2 = this.mDividerDrag.getWidth();
        if (n <= this.mColumnStart + 4) {
            n = this.mColumnStart + 4 + 1;
        }
        if (n2 != (n -= this.mColumnStart)) {
            this.adjustColumnWidth(this.mDividerDrag, n);
        }
    }

    public void adjustColumnWidth(Column column, int n) {
        ArrayList<Column> arrayList = new ArrayList<Column>(1);
        column.setWidth(n);
        arrayList.add(column);
        this.processColumnWidthChanges(arrayList);
    }

    private void processColumnWidthChanges(ArrayList<Column> arrayList) {
        this.updateRowHeightsIfNeeded(arrayList);
        this.revalidateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage getDragImage(int n, int n2) {
        Graphics graphics = null;
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = null;
        this.mDrawingDragImage = true;
        this.mDragClip = null;
        bufferedImage = this.getImage();
        this.mDrawingDragImage = false;
        if (this.mDragClip == null) {
            this.mDragClip = new Rectangle(n, n2, 1, 1);
        }
        try {
            bufferedImage2 = this.getGraphicsConfiguration().createCompatibleImage(this.mDragClip.width, this.mDragClip.height, 3);
            graphics = (Graphics2D)bufferedImage2.getGraphics();
            graphics.setClip(new Rectangle(0, 0, this.mDragClip.width, this.mDragClip.height));
            ((Graphics2D)graphics).setBackground(new Color(0, true));
            graphics.clearRect(0, 0, this.mDragClip.width, this.mDragClip.height);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.5f));
            Rectangle rectangle = this.getVisibleRect();
            ((Graphics2D)graphics).translate(-(this.mDragClip.x - rectangle.x), -(this.mDragClip.y - rectangle.y));
            graphics.drawImage(bufferedImage, 0, 0, this);
        }
        catch (Exception exception) {
            assert (false) : Debug.throwableToString(exception);
            bufferedImage2 = null;
            this.mDragClip = new Rectangle(n, n2, 1, 1);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return bufferedImage2 != null ? bufferedImage2 : bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            Graphics graphics = null;
            try {
                Rectangle rectangle = this.getVisibleRect();
                bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(rectangle.width, rectangle.height, 3);
                graphics = (Graphics2D)bufferedImage.getGraphics();
                Color color = ((Graphics2D)graphics).getBackground();
                ((Graphics2D)graphics).setBackground(new Color(0, true));
                graphics.clearRect(0, 0, rectangle.width, rectangle.height);
                ((Graphics2D)graphics).setBackground(color);
                Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
                graphics.setClip(rectangle2);
                ((Graphics2D)graphics).translate(-rectangle.x, -rectangle.y);
                this.paint(graphics);
            }
            catch (Exception exception) {
                assert (false) : Debug.throwableToString(exception);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
            }
        }
        return bufferedImage;
    }

    @Override
    public boolean isOpaque() {
        return super.isOpaque() && !this.mDrawingDragImage;
    }

    protected void showContextMenu(MouseEvent mouseEvent) {
    }

    public boolean allowColumnResize() {
        return this.mAllowColumnResize;
    }

    public void setAllowColumnResize(boolean bl) {
        this.mAllowColumnResize = bl;
    }

    public boolean allowColumnDrag() {
        return this.mAllowColumnDrag;
    }

    public void setAllowColumnDrag(boolean bl) {
        this.mAllowColumnDrag = bl;
    }

    public boolean allowRowDrag() {
        return this.mAllowRowDrag;
    }

    public void setAllowRowDrag(boolean bl) {
        this.mAllowRowDrag = bl;
    }

    public boolean allowColumnContextMenu() {
        return this.mAllowColumnContextMenu;
    }

    public void setAllowColumnContextMenu(boolean bl) {
        this.mAllowColumnContextMenu = bl;
    }

    public void revalidateView() {
        this.revalidate();
        if (this.mHeaderPanel != null) {
            this.mHeaderPanel.revalidate();
            this.mHeaderPanel.repaint();
        }
        this.repaint();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.mHeaderPanel != null) {
            Dimension dimension = this.mHeaderPanel.getPreferredSize();
            this.mHeaderPanel.setResizeOK(true);
            this.mHeaderPanel.setBounds(this.getX(), this.mHeaderPanel.getY(), this.getWidth(), dimension.height);
            this.mHeaderPanel.setResizeOK(false);
        }
    }

    public void setSort(Column column, boolean bl, boolean bl2) {
        StateEdit stateEdit = new StateEdit(this.mModel, MSG_SORT_UNDO_TITLE);
        int n = this.mModel.getColumnCount();
        if (!bl2) {
            for (int i = 0; i < n; ++i) {
                Column column2 = this.mModel.getColumnAtIndex(i);
                if (column == column2) {
                    column2.setSortCriteria(0, bl);
                    continue;
                }
                column2.setSortCriteria(-1, column2.isSortAscending());
            }
        } else if (column.getSortSequence() == -1) {
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                int n3 = this.mModel.getColumnAtIndex(i).getSortSequence();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            column.setSortCriteria(n2 + 1, bl);
        } else {
            column.setSortCriteria(column.getSortSequence(), bl);
        }
        this.mModel.sort();
        stateEdit.end();
        this.postUndo(stateEdit);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaintSelection();
        this.repaintFocus();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaintSelection();
        this.repaintFocus();
    }

    private void repaintFocus() {
        Rectangle rectangle = this.getVisibleRect();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        this.paintImmediately(n, n2, n3, 1);
        this.paintImmediately(n, n2, 1, n4);
        this.paintImmediately(n + n3 - 1, n2, 1, n4);
        this.paintImmediately(n, n2 + n4 - 1, n3, 1);
    }

    public boolean isSelfOrProxy(Outline outline) {
        Outline outline2 = this.getRealOutline();
        if (outline == outline2) {
            return true;
        }
        for (OutlineProxy outlineProxy : outline2.mProxies) {
            if (outline != outlineProxy) continue;
            return true;
        }
        return false;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Row row;
        int n = mouseEvent.getX();
        Column column = this.overColumn(n);
        if (column != null && (row = this.overRow(mouseEvent.getY())) != null) {
            Rectangle rectangle = this.getCellBounds(row, column);
            return new Point(n, rectangle.y + rectangle.height);
        }
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Row row;
        Column column = this.overColumn(mouseEvent.getX());
        if (column != null && (row = this.overRow(mouseEvent.getY())) != null) {
            return column.getRowCell(row).getToolTipText(mouseEvent, this.getCellBounds(row, column), row, column);
        }
        return super.getToolTipText(mouseEvent);
    }

    public boolean useBanding() {
        return this.mUseBanding;
    }

    public void setUseBanding(boolean bl) {
        this.mUseBanding = bl;
    }

    public static String createConfig(ColumnConfig[] columnConfigArray) {
        return Outline.createConfig(columnConfigArray, 0, 0);
    }

    public static String createConfig(ColumnConfig[] columnConfigArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(4);
        stringBuilder.append('\t');
        stringBuilder.append(columnConfigArray.length);
        for (ColumnConfig columnConfig : columnConfigArray) {
            stringBuilder.append('\t');
            stringBuilder.append(columnConfig.mID);
            stringBuilder.append('\t');
            stringBuilder.append(columnConfig.mVisible);
            stringBuilder.append('\t');
            stringBuilder.append(columnConfig.mWidth);
            stringBuilder.append('\t');
            stringBuilder.append(columnConfig.mSortSequence);
            stringBuilder.append('\t');
            stringBuilder.append(columnConfig.mSortAscending);
        }
        stringBuilder.append('\t');
        stringBuilder.append(n);
        stringBuilder.append('\t');
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    public String getConfig() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.mModel.getColumnCount();
        stringBuilder.append(4);
        stringBuilder.append('\t');
        stringBuilder.append(n);
        for (int i = 0; i < n; ++i) {
            Column column = this.mModel.getColumnAtIndex(i);
            stringBuilder.append('\t');
            stringBuilder.append(column.getID());
            stringBuilder.append('\t');
            stringBuilder.append(column.isVisible());
            stringBuilder.append('\t');
            stringBuilder.append(column.getWidth());
            stringBuilder.append('\t');
            stringBuilder.append(column.getSortSequence());
            stringBuilder.append('\t');
            stringBuilder.append(column.isSortAscending());
        }
        return stringBuilder.toString();
    }

    private int getInteger(StringTokenizer stringTokenizer, int n) {
        try {
            return Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void applyConfig(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            if (this.getInteger(stringTokenizer, 0) == 4) {
                int n = this.getInteger(stringTokenizer, 0);
                List<Column> list = this.mModel.getColumns();
                boolean bl = false;
                this.mModel.clearSort();
                for (int i = 0; i < n; ++i) {
                    Column column = this.mModel.getColumnWithID(this.getInteger(stringTokenizer, 0));
                    if (column == null) {
                        throw new Exception();
                    }
                    list.remove(column);
                    list.add(i, column);
                    column.setVisible(Numbers.getBoolean(stringTokenizer.nextToken()));
                    column.setWidth(this.getInteger(stringTokenizer, column.getWidth()));
                    column.setSortCriteria(this.getInteger(stringTokenizer, -1), Numbers.getBoolean(stringTokenizer.nextToken()));
                    if (column.getSortSequence() == -1) continue;
                    bl = true;
                }
                if (bl) {
                    this.mModel.sort();
                }
                this.updateRowHeightsIfNeeded(list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.revalidateView();
    }

    public String getDefaultConfig() {
        if (this.mDefaultConfig == null) {
            this.mDefaultConfig = this.getConfig();
        }
        return this.mDefaultConfig;
    }

    public void setDefaultConfig(String string) {
        this.mDefaultConfig = string;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.mDividerDrag == null && this.mModel.hasSelection() && this.allowRowDrag()) {
            Point point = dragGestureEvent.getDragOrigin();
            RowSelection rowSelection = new RowSelection(this.mModel, this.mModel.getSelectionAsList(true).toArray(new Row[0]));
            if (DragSource.isDragImageSupported()) {
                BufferedImage bufferedImage = this.getDragImage(point.x, point.y);
                Point point2 = new Point(this.mDragClip.x - point.x, this.mDragClip.y - point.y);
                dragGestureEvent.startDrag(null, bufferedImage, point2, rowSelection, null);
            } else {
                dragGestureEvent.startDrag(null, rowSelection);
            }
        }
    }

    protected boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl;
        block4: {
            bl = false;
            try {
                Row[] rowArray;
                if (dropTargetDragEvent.isDataFlavorSupported(Column.DATA_FLAVOR) && (bl = this.isColumnDragAcceptable(dropTargetDragEvent, (Column)(rowArray = (Row[])dropTargetDragEvent.getTransferable().getTransferData(Column.DATA_FLAVOR))))) {
                    this.mModel.setDragColumn((Column)rowArray);
                }
                if (dropTargetDragEvent.isDataFlavorSupported(RowSelection.DATA_FLAVOR) && (bl = this.isRowDragAcceptable(dropTargetDragEvent, rowArray = (Row[])dropTargetDragEvent.getTransferable().getTransferData(RowSelection.DATA_FLAVOR)))) {
                    this.mModel.setDragRows(rowArray);
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)Debug.throwableToString(exception));
            }
        }
        return bl;
    }

    public boolean isUserSortable() {
        return this.mUserSortable;
    }

    public void setUserSortable(boolean bl) {
        this.mUserSortable = bl;
    }

    protected boolean isColumnDragAcceptable(DropTargetDragEvent dropTargetDragEvent, Column column) {
        return this.mModel.getColumns().contains(column);
    }

    protected boolean isRowDragAcceptable(DropTargetDragEvent dropTargetDragEvent, Row[] rowArray) {
        return rowArray.length > 0 && this.mModel.getRows().contains(rowArray[0]);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.mDragWasAcceptable = this.isDragAcceptable(dropTargetDragEvent);
        if (this.mDragWasAcceptable) {
            if (this.mModel.getDragColumn() != null) {
                dropTargetDragEvent.acceptDrag(this.dragEnterColumn(dropTargetDragEvent));
                return;
            }
            Row[] rowArray = this.mModel.getDragRows();
            if (rowArray != null && rowArray.length > 0) {
                dropTargetDragEvent.acceptDrag(this.dragEnterRow(dropTargetDragEvent));
                return;
            }
        }
        dropTargetDragEvent.rejectDrag();
    }

    protected int dragEnterColumn(DropTargetDragEvent dropTargetDragEvent) {
        this.mSavedColumns = new ArrayList<Column>(this.mModel.getColumns());
        return 2;
    }

    protected int dragEnterRow(DropTargetDragEvent dropTargetDragEvent) {
        this.addDragHighlight(this);
        return 2;
    }

    protected void dragEnterRow(DropTargetDragEvent dropTargetDragEvent, OutlineProxy outlineProxy) {
        this.addDragHighlight(outlineProxy);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mDragWasAcceptable) {
            if (this.mModel.getDragColumn() != null) {
                dropTargetDragEvent.acceptDrag(this.dragOverColumn(dropTargetDragEvent));
                return;
            }
            Row[] rowArray = this.mModel.getDragRows();
            if (rowArray != null && rowArray.length > 0) {
                dropTargetDragEvent.acceptDrag(this.dragOverRow(dropTargetDragEvent));
                return;
            }
        }
        dropTargetDragEvent.rejectDrag();
    }

    protected int dragOverColumn(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        int n2 = dropTargetDragEvent.getLocation().x;
        int n3 = this.overColumnIndex(n2);
        if (n3 != (n = this.mModel.getIndexOfColumn(this.mModel.getDragColumn())) && n3 != -1) {
            int n4 = this.getColumnIndexStart(n3) + this.mModel.getColumnAtIndex(n3).getWidth() / 2;
            if (n3 < n && n2 < n4 || n3 > n && n2 > n4) {
                List<Column> list = this.mModel.getColumns();
                if (n < n3) {
                    for (int i = n; i < n3; ++i) {
                        list.set(i, this.mModel.getColumnAtIndex(i + 1));
                    }
                } else {
                    for (int i = n; i > n3; --i) {
                        list.set(i, this.mModel.getColumnAtIndex(i - 1));
                    }
                }
                list.set(n3, this.mModel.getDragColumn());
                this.repaint();
                if (this.mHeaderPanel != null) {
                    this.mHeaderPanel.repaint();
                }
            }
        }
        return 2;
    }

    protected int dragOverRow(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        Rectangle rectangle;
        Row row;
        Row row2 = this.mDragParentRow;
        int n2 = this.mDragChildInsertIndex;
        Row row3 = null;
        int n3 = -1;
        Point point = dropTargetDragEvent.getLocation();
        int n4 = this.getInsets().top;
        int n5 = this.getLastRowToDisplay();
        Row[] rowArray = this.mModel.getDragRows();
        boolean bl = rowArray != null && rowArray.length > 0 && this.mModel.getRows().contains(rowArray[0]);
        for (int i = this.getFirstRowToDisplay(); i <= n5; ++i) {
            row = this.mModel.getRowAtIndex(i);
            if (this.mModel.isRowFiltered(row)) continue;
            int n6 = row.getHeight();
            if (point.y <= n4 + n6 / 2) {
                if (!bl || !this.mModel.isExtendedRowSelected(i) || i != 0 && !this.mModel.isExtendedRowSelected(i - 1)) {
                    row3 = row.getParent();
                    if (row3 != null) {
                        n3 = row3.getIndexOfChild(row);
                        break;
                    }
                    n3 = i;
                    break;
                }
            } else if (point.y <= n4 + n6) {
                if (row.canHaveChildren()) {
                    rectangle = this.getRowBounds(row);
                    n = this.mModel.getIndentWidth() + this.mModel.getIndentWidth(row, this.mModel.getColumns().get(0));
                    if (!(point.x < rectangle.x + n || bl && this.mModel.isExtendedRowSelected(row))) {
                        row3 = row;
                        n3 = 0;
                        break;
                    }
                }
                if (!bl || !this.mModel.isExtendedRowSelected(i) || i < n5 && !this.mModel.isExtendedRowSelected(i + 1)) {
                    row3 = row.getParent();
                    if (row3 != null) {
                        if (!bl || !this.mModel.isExtendedRowSelected(i)) {
                            n3 = row3.getIndexOfChild(row) + 1;
                            break;
                        }
                    } else {
                        n3 = i + 1;
                        break;
                    }
                }
            }
            n4 += n6 + (this.mDrawRowDividers ? 1 : 0);
        }
        if (n3 == -1) {
            if (n5 > 0) {
                row = this.mModel.getRowAtIndex(n5);
                if (row.canHaveChildren()) {
                    rectangle = this.getRowBounds(row);
                    n = this.mModel.getIndentWidth() + this.mModel.getIndentWidth(row, this.mModel.getColumns().get(0));
                    if (!(point.x < rectangle.x + n || bl && this.mModel.isExtendedRowSelected(row))) {
                        row3 = row;
                        n3 = 0;
                    }
                }
                if (n3 == -1) {
                    row3 = row.getParent();
                    if (!(row3 == null || bl && this.mModel.isExtendedRowSelected(row3))) {
                        n3 = row3.getIndexOfChild(row) + 1;
                    } else {
                        row3 = null;
                        n3 = n5 + 1;
                    }
                }
            } else {
                row3 = null;
                n3 = 0;
            }
        }
        if (!this.isDragToRowAcceptable(row3)) {
            this.mDragParentRow = null;
            this.mDragChildInsertIndex = 0;
            if (this.mDragParentRow != row2 || this.mDragChildInsertIndex != n2) {
                this.repaint(this.getDragRowInsertionMarkerBounds(row2, n2));
            }
            return 0;
        }
        if (this.mDragParentRow != row3 || this.mDragChildInsertIndex != n3) {
            Graphics graphics = this.getGraphics();
            this.mDragParentRow = row3;
            this.mDragChildInsertIndex = n3;
            this.drawDragRowInsertionMarker(graphics, this.mDragParentRow, this.mDragChildInsertIndex);
            graphics.dispose();
        }
        if (this.mDragParentRow != row2 || this.mDragChildInsertIndex != n2) {
            this.repaint(this.getDragRowInsertionMarkerBounds(row2, n2));
        }
        return 2;
    }

    protected boolean isDragToRowAcceptable(Row row) {
        return true;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mDragWasAcceptable) {
            if (this.mModel.getDragColumn() != null) {
                dropTargetDragEvent.acceptDrag(this.dropActionChangedColumn(dropTargetDragEvent));
                return;
            }
            Row[] rowArray = this.mModel.getDragRows();
            if (rowArray != null && rowArray.length > 0) {
                dropTargetDragEvent.acceptDrag(this.dropActionChangedRow(dropTargetDragEvent));
                return;
            }
        }
        dropTargetDragEvent.rejectDrag();
    }

    protected int dropActionChangedColumn(DropTargetDragEvent dropTargetDragEvent) {
        return 2;
    }

    protected int dropActionChangedRow(DropTargetDragEvent dropTargetDragEvent) {
        return 2;
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.mDragWasAcceptable) {
            if (this.mModel.getDragColumn() != null) {
                this.dragExitColumn(dropTargetEvent);
            } else {
                Row[] rowArray = this.mModel.getDragRows();
                if (rowArray != null && rowArray.length > 0) {
                    this.dragExitRow(dropTargetEvent);
                }
            }
        }
    }

    protected void dragExitColumn(DropTargetEvent dropTargetEvent) {
        List<Column> list = this.mModel.getColumns();
        if (((Object)list).equals(this.mSavedColumns)) {
            this.repaintColumn(this.mModel.getDragColumn());
        } else {
            list.clear();
            list.addAll(this.mSavedColumns);
            this.repaint();
            if (this.mHeaderPanel != null) {
                this.mHeaderPanel.repaint();
            }
        }
        this.mSavedColumns = null;
        this.mModel.setDragColumn(null);
    }

    protected void dragExitRow(DropTargetEvent dropTargetEvent) {
        this.repaint(this.getDragRowInsertionMarkerBounds(this.mDragParentRow, this.mDragChildInsertIndex));
        this.removeDragHighlight(this);
        this.mDragParentRow = null;
        this.mDragChildInsertIndex = -1;
        this.mModel.setDragRows(null);
    }

    protected void dragExitRow(DropTargetEvent dropTargetEvent, OutlineProxy outlineProxy) {
        this.removeDragHighlight(outlineProxy);
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        if (this.mModel.getDragColumn() != null) {
            this.dropColumn(dropTargetDropEvent);
        } else {
            Row[] rowArray = this.mModel.getDragRows();
            if (rowArray != null && rowArray.length > 0) {
                this.dropRow(dropTargetDropEvent);
            }
        }
        dropTargetDropEvent.dropComplete(true);
    }

    protected void dropColumn(DropTargetDropEvent dropTargetDropEvent) {
        this.repaintColumn(this.mModel.getDragColumn());
        this.mSavedColumns = null;
        this.mModel.setDragColumn(null);
    }

    public void convertDragRowsToSelf(List<Row> list) {
        Row[] rowArray = this.mModel.getDragRows();
        rowArray[0].getOwner().removeRows(rowArray);
        for (Row row : rowArray) {
            this.mModel.collectRowsAndSetOwner(list, row, false);
        }
    }

    protected void dropRow(DropTargetDropEvent dropTargetDropEvent) {
        this.removeDragHighlight(this);
        if (this.mDragChildInsertIndex != -1) {
            Row row;
            int n;
            StateEdit stateEdit = new StateEdit(this.mModel, MSG_ROW_DROP_UNDO_TITLE);
            Row[] rowArray = this.mModel.getDragRows();
            boolean bl = rowArray != null && rowArray.length > 0 && this.mModel.getRows().contains(rowArray[0]);
            int n2 = this.mModel.getRowCount();
            ArrayList<Row> arrayList = new ArrayList<Row>(n2);
            ArrayList<Row> arrayList2 = new ArrayList<Row>(n2);
            ArrayList<Row> arrayList3 = new ArrayList<Row>(n2);
            if (!bl) {
                this.convertDragRowsToSelf(arrayList2);
            } else {
                for (n = 0; n < n2; ++n) {
                    row = this.mModel.getRowAtIndex(n);
                    if (!this.mModel.isExtendedRowSelected(row)) continue;
                    arrayList2.add(row);
                }
            }
            int n3 = this.mDragParentRow != null && !this.mDragParentRow.isOpen() ? -1 : this.getAbsoluteInsertionIndex(this.mDragParentRow, this.mDragChildInsertIndex);
            for (n = 0; n < n2; ++n) {
                row = this.mModel.getRowAtIndex(n);
                if (n == n3) {
                    arrayList.addAll(arrayList2);
                }
                if (bl && this.mModel.isExtendedRowSelected(row)) continue;
                arrayList.add(row);
            }
            if (n2 == n3) {
                arrayList.addAll(arrayList2);
            }
            arrayList3.addAll(arrayList2);
            for (n = n2 = arrayList2.size() - 1; n >= 0; --n) {
                row = arrayList2.get(n);
                Row row2 = row.getParent();
                if (n3 == -1) {
                    row.setOwner(null);
                }
                if (row2 != null && (!bl && !arrayList2.contains(row2) || bl && !this.mModel.isExtendedRowSelected(row2))) {
                    row.removeFromParent();
                    continue;
                }
                if (row2 == null) continue;
                arrayList2.remove(n);
            }
            if (this.mDragParentRow != null) {
                for (n = n2 = arrayList2.size() - 1; n >= 0; --n) {
                    this.mDragParentRow.insertChild(this.mDragChildInsertIndex, arrayList2.get(n));
                }
            }
            this.mModel.deselect();
            this.mModel.clearSort();
            this.mDragParentRow = null;
            this.mDragChildInsertIndex = -1;
            List<Row> list = this.mModel.getRows();
            list.clear();
            list.addAll(arrayList);
            this.mModel.getSelection().setSize(list.size());
            this.setSize(this.getPreferredSize());
            this.mModel.select(arrayList3, false);
            stateEdit.end();
            this.postUndo(stateEdit);
            this.repaint();
            this.contentSizeMayHaveChanged();
            this.rowsWereDropped();
        }
        this.mModel.setDragRows(null);
    }

    protected void dropRow(DropTargetDropEvent dropTargetDropEvent, OutlineProxy outlineProxy) {
        this.removeDragHighlight(outlineProxy);
    }

    protected void rowsWereDropped() {
    }

    private void addDragHighlight(Outline outline) {
        outline.mDragFocus = true;
        outline.repaintFocus();
    }

    private void removeDragHighlight(Outline outline) {
        outline.mDragFocus = false;
        outline.repaintFocus();
    }

    private int getAbsoluteInsertionIndex(Row row, int n) {
        int n2;
        if (row == null) {
            int n3 = this.mModel.getRowCount();
            for (n2 = n; n2 < n3 && this.mModel.getRowAtIndex(n2).getParent() != null; ++n2) {
            }
        } else {
            int n4 = row.getChildCount();
            if (n4 == 0 || !row.isOpen()) {
                n2 = this.mModel.getIndexOfRow(row) + 1;
            } else if (n < n4) {
                n2 = this.mModel.getIndexOfRow(row.getChild(n));
            } else {
                Row row2 = row.getChild(n4 - 1);
                int n5 = this.mModel.getRowCount();
                for (n2 = this.mModel.getIndexOfRow(row2) + 1; n2 < n5 && this.mModel.getRowAtIndex(n2).isDescendantOf(row2); ++n2) {
                }
            }
        }
        return n2;
    }

    public void updateRowHeightsIfNeeded(Collection<Column> collection) {
        if (this.dynamicRowHeight()) {
            for (Column column : collection) {
                if (!column.getRowCell(null).participatesInDynamicRowLayout()) continue;
                this.updateRowHeights();
                break;
            }
        }
    }

    public void updateRowHeight(Row row) {
        ArrayList<Row> arrayList = new ArrayList<Row>(1);
        arrayList.add(row);
        this.updateRowHeights(arrayList);
    }

    public void updateRowHeights() {
        this.updateRowHeights(this.mModel.getRows());
    }

    public void updateRowHeights(Collection<? extends Row> collection) {
        List<Column> list = this.mModel.getColumns();
        boolean bl = false;
        for (Row row : collection) {
            int n;
            int n2 = row.getHeight();
            if (n2 == (n = row.getPreferredHeight(list))) continue;
            row.setHeight(n);
            bl = true;
        }
        if (bl) {
            this.contentSizeMayHaveChanged();
            this.revalidateView();
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        JScrollPane jScrollPane = (JScrollPane)UIUtilities.getAncestorOfType(this, JScrollPane.class);
        if (jScrollPane != null) {
            Rectangle rectangle = jScrollPane.getViewport().getViewRect();
            return new Insets(rectangle.y + 10, rectangle.x + 10, this.getHeight() - (rectangle.y + rectangle.height) + 10, this.getWidth() - (rectangle.x + rectangle.width) + 10);
        }
        return new Insets(10, 10, 10, 10);
    }

    @Override
    public void autoscroll(Point point) {
        Insets insets = this.getAutoscrollInsets();
        Dimension dimension = this.getSize();
        if (point.x < insets.left) {
            point.x -= 10;
        } else if (point.x > dimension.width - insets.right) {
            point.x += 10;
        }
        if (point.y < insets.top) {
            point.y -= 10;
        } else if (point.y > dimension.height - insets.bottom) {
            point.y += 10;
        }
        this.scrollRectToVisible(new Rectangle(point.x, point.y, 1, 1));
    }

    public void contentSizeMayHaveChanged() {
        this.notifyActionListeners(new ActionEvent(this.getRealOutline(), 1001, this.getPotentialContentSizeChangeActionCommand()));
    }

    @Override
    public void rowsAdded(OutlineModel outlineModel, Row[] rowArray) {
        this.contentSizeMayHaveChanged();
        this.revalidateView();
    }

    @Override
    public void rowsWillBeRemoved(OutlineModel outlineModel, Row[] rowArray) {
    }

    @Override
    public void rowsWereRemoved(OutlineModel outlineModel, Row[] rowArray) {
        for (Row row : rowArray) {
            if (row != this.mRollRow) continue;
            this.mRollRow = null;
            break;
        }
        this.contentSizeMayHaveChanged();
        this.revalidateView();
    }

    @Override
    public void rowWasModified(OutlineModel outlineModel, Row row, Column column) {
        this.repaint();
    }

    @Override
    public void sortCleared(OutlineModel outlineModel) {
        this.repaintHeader();
    }

    @Override
    public void sorted(OutlineModel outlineModel, boolean bl) {
        if (!bl && this.isFocusOwner()) {
            this.scrollSelectionIntoView();
        }
        this.repaintView();
    }

    public void scrollSelectionIntoView() {
        int n = this.mModel.getFirstSelectedRowIndex();
        if (n >= this.getFirstRowToDisplay() && n <= this.getLastRowToDisplay()) {
            this.scrollSelectionIntoViewInternal();
        } else if (this.mProxies != null) {
            for (OutlineProxy outlineProxy : this.mProxies) {
                if (n < outlineProxy.getFirstRowToDisplay() || n > outlineProxy.getLastRowToDisplay()) continue;
                super.scrollSelectionIntoViewInternal();
                break;
            }
        }
    }

    private void scrollSelectionIntoViewInternal() {
        Selection selection = this.mModel.getSelection();
        int n = selection.nextSelectedIndex(this.getFirstRowToDisplay());
        int n2 = this.getLastRowToDisplay();
        if (n != -1 && n <= n2) {
            int n3;
            Rectangle rectangle = this.getRowIndexBounds(n);
            int n4 = n;
            while ((n4 = selection.nextSelectedIndex((n3 = n4) + 1)) != -1 && n4 <= n2) {
            }
            if (n != n3) {
                rectangle = Geometry.union(rectangle, this.getRowIndexBounds(n3));
            }
            this.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void lockedStateWillChange(OutlineModel outlineModel) {
    }

    @Override
    public void lockedStateDidChange(OutlineModel outlineModel) {
    }

    @Override
    public void selectionWillChange(OutlineModel outlineModel) {
        this.repaintSelectionInternal();
    }

    @Override
    public void selectionDidChange(OutlineModel outlineModel) {
        Rectangle rectangle = this.repaintSelectionInternal();
        if (!rectangle.isEmpty() && this.isFocusOwner()) {
            this.scrollRectToVisible(rectangle);
        }
        if (!(this instanceof OutlineProxy)) {
            this.notifyOfSelectionChange();
        }
    }

    @Override
    public void undoWillHappen(OutlineModel outlineModel) {
    }

    @Override
    public void undoDidHappen(OutlineModel outlineModel) {
        this.contentSizeMayHaveChanged();
        this.revalidateView();
    }

    public void postUndo(UndoableEdit undoableEdit) {
        StdUndoManager stdUndoManager;
        Container container = this.getTopLevelAncestor();
        if (container instanceof AppWindow && (stdUndoManager = ((AppWindow)container).getUndoManager()) != null) {
            stdUndoManager.addEdit(undoableEdit);
        }
    }

    public Outline getBestOutlineForRowIndex(int n) {
        Outline outline = this.getRealOutline();
        for (OutlineProxy outlineProxy : outline.mProxies) {
            if (outlineProxy.mFirstRow > n || outlineProxy.mLastRow < n) continue;
            return outlineProxy;
        }
        return outline;
    }

    public static Color getListForeground(boolean bl, boolean bl2) {
        if (bl) {
            Color color = UIManager.getColor("List.selectionForeground");
            if (!bl2) {
                Color color2 = Outline.getListBackground(bl, bl2);
                boolean bl3 = Colors.threshold(color, 50);
                if (bl3 == Colors.threshold(color2, 50)) {
                    return bl3 ? Color.BLACK : Color.WHITE;
                }
            }
            return color;
        }
        return Color.BLACK;
    }

    public static Color getListBackground(boolean bl, boolean bl2) {
        if (bl) {
            Color color = UIManager.getColor("List.selectionBackground");
            if (!bl2) {
                color = Colors.lighter(color, 50);
            }
            return color;
        }
        return Color.WHITE;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this.isFocusOwner()) {
            this.repaint();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    static {
        LocalizedMessages.initialize(Outline.class);
    }
}

