/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.text.Numbers;
import com.trollworks.ttk.utility.Selection;
import com.trollworks.ttk.utility.SelectionOwner;
import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.OutlineModelListener;
import com.trollworks.ttk.widgets.outline.Row;
import com.trollworks.ttk.widgets.outline.RowFilter;
import com.trollworks.ttk.widgets.outline.RowSorter;
import com.trollworks.ttk.widgets.outline.RowUndoSnapshot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.undo.StateEditable;

public class OutlineModel
implements SelectionOwner,
StateEditable {
    private static final String UNDO_KEY_ROWS = "Rows";
    private static final String UNDO_KEY_SELECTION = "Selection";
    private static final String UNDO_KEY_SORT_CONFIG = "SortConfig";
    public static final int CONFIG_VERSION = 4;
    private ArrayList<OutlineModelListener> mListeners = new ArrayList();
    private ArrayList<Column> mColumns = new ArrayList();
    private ArrayList<Row> mRows = new ArrayList();
    private Selection mSelection = new Selection(this);
    private Column mDragColumn;
    private Row[] mDragRows;
    private boolean mLocked;
    private boolean mNotifyOfSelections = true;
    private Row mSavedAnchorRow;
    private List<Row> mSavedSelection;
    private boolean mShowIndent;
    private int mIndentWidth;
    private RowFilter mRowFilter;

    public void addListener(OutlineModelListener outlineModelListener) {
        if (!this.mListeners.contains(outlineModelListener)) {
            this.mListeners.add(outlineModelListener);
        }
    }

    public void removeListener(OutlineModelListener outlineModelListener) {
        this.mListeners.remove(outlineModelListener);
    }

    private OutlineModelListener[] getCurrentListeners() {
        return this.mListeners.toArray(new OutlineModelListener[0]);
    }

    private void notifyOfRowAdditions(Row[] rowArray) {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.rowsAdded(this, rowArray);
        }
    }

    private void notifyOfSortCleared() {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.sortCleared(this);
        }
    }

    private void notifyOfLockedStateWillChange() {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.lockedStateWillChange(this);
        }
    }

    private void notifyOfLockedStateDidChange() {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.lockedStateDidChange(this);
        }
    }

    private void notifyOfSort(boolean bl) {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.sorted(this, bl);
        }
    }

    private void notifyOfRowsWillBeRemoved(Row[] rowArray) {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.rowsWillBeRemoved(this, rowArray);
        }
    }

    private void notifyOfRowsWereRemoved(Row[] rowArray) {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.rowsWereRemoved(this, rowArray);
        }
    }

    public void notifyOfRowModification(Row row, Column column) {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.rowWasModified(this, row, column);
        }
    }

    private void notifyOfUndoWillHappen() {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.undoWillHappen(this);
        }
    }

    private void notifyOfUndoDidHappen() {
        for (OutlineModelListener outlineModelListener : this.getCurrentListeners()) {
            outlineModelListener.undoDidHappen(this);
        }
    }

    public void addColumn(Column column) {
        assert (!this.mColumns.contains(column));
        this.mColumns.add(column);
    }

    public void addColumns(List<Column> list) {
        this.mColumns.addAll(list);
    }

    public void removeColumn(Column column) {
        assert (this.mColumns.contains(column));
        this.mColumns.remove(column);
    }

    public List<Column> getColumns() {
        return this.mColumns;
    }

    public int getColumnCount() {
        return this.mColumns.size();
    }

    public Column getColumnWithID(int n) {
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Column column = this.getColumnAtIndex(i);
            if (column.getID() != n) continue;
            return column;
        }
        return null;
    }

    public Column getColumnAtIndex(int n) {
        return this.mColumns.get(n);
    }

    public int getIndexOfColumn(Column column) {
        return this.mColumns.indexOf(column);
    }

    public int getVisibleColumnCount() {
        int n = 0;
        for (Column column : this.mColumns) {
            if (!column.isVisible()) continue;
            ++n;
        }
        return n;
    }

    public Collection<Column> getHiddenColumns() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : this.mColumns) {
            if (column.isVisible()) continue;
            arrayList.add(column);
        }
        return arrayList;
    }

    public void addRow(Row row) {
        this.addRow(row, false);
    }

    public void addRow(Row row, boolean bl) {
        this.addRow(this.mRows.size(), row, bl);
    }

    public void addRow(int n, Row row) {
        this.addRow(n, row, false);
    }

    public void addRow(int n, Row row, boolean bl) {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        assert (!this.mRows.contains(row));
        if (bl) {
            this.collectRowsAndSetOwner(arrayList, row, false);
        } else {
            arrayList.add(row);
            row.setOwner(this);
        }
        this.preserveSelection();
        this.mRows.addAll(n, arrayList);
        this.mSelection.setSize(this.mRows.size());
        this.restoreSelection();
        this.notifyOfRowAdditions(arrayList.toArray(new Row[0]));
        this.clearSort();
    }

    private void addChildren(Row row) {
        List<Row> list = this.collectRowsAndSetOwner(new ArrayList<Row>(), row, true);
        this.preserveSelection();
        this.mRows.addAll(this.getIndexOfRow(row) + 1, list);
        this.mSelection.setSize(this.mRows.size());
        this.restoreSelection();
        this.notifyOfRowAdditions(list.toArray(new Row[0]));
    }

    public List<Row> collectRowsAndSetOwner(List<Row> list, Row row, boolean bl) {
        if (!bl) {
            list.add(row);
            row.setOwner(this);
        }
        if (row.isOpen() && row.hasChildren()) {
            for (Row row2 : row.getChildren()) {
                this.collectRowsAndSetOwner(list, row2, false);
            }
        }
        return list;
    }

    public void removeRow(Row row) {
        this.removeRows(new Row[]{row});
    }

    public void removeRow(int n) {
        this.removeRows(new int[]{n});
    }

    public void removeRows(Row[] rowArray) {
        int n;
        HashSet<Row> hashSet = new HashSet<Row>();
        for (n = 0; n < rowArray.length; ++n) {
            int n2 = this.getIndexOfRow(rowArray[n]);
            if (n2 <= -1) continue;
            this.collectRows(hashSet, n2);
        }
        int[] nArray = new int[hashSet.size()];
        n = 0;
        for (Row row : hashSet) {
            nArray[n++] = this.getIndexOfRow(row);
        }
        this.removeRowsInternal(nArray);
    }

    public void removeRows(int[] nArray) {
        int n;
        HashSet<Row> hashSet = new HashSet<Row>();
        int n2 = this.mRows.size();
        for (n = 0; n < nArray.length; ++n) {
            int n3 = nArray[n];
            if (n3 <= -1 || n3 >= n2) continue;
            this.collectRows(hashSet, n3);
        }
        int[] nArray2 = new int[hashSet.size()];
        n = 0;
        for (Row row : hashSet) {
            nArray2[n++] = this.getIndexOfRow(row);
        }
        this.removeRowsInternal(nArray2);
    }

    private int collectRows(HashSet<Row> hashSet, int n) {
        Row row;
        Row row2 = this.getRowAtIndex(n);
        int n2 = this.mRows.size();
        hashSet.add(row2);
        ++n;
        while (n < n2 && (row = this.getRowAtIndex(n)).isDescendantOf(row2)) {
            hashSet.add(row);
            ++n;
        }
        return n;
    }

    private void removeRowsInternal(int[] nArray) {
        int n;
        Row[] rowArray = new Row[nArray.length];
        Arrays.sort(nArray);
        for (n = 0; n < nArray.length; ++n) {
            rowArray[n] = this.getRowAtIndex(nArray[n]);
        }
        this.preserveSelection();
        this.notifyOfRowsWillBeRemoved(rowArray);
        for (n = nArray.length - 1; n >= 0; --n) {
            this.mRows.remove(nArray[n]);
            rowArray[n].setOwner(null);
        }
        this.mSelection.setSize(this.mRows.size());
        this.restoreSelection();
        this.notifyOfRowsWereRemoved(rowArray);
    }

    public void removeAllRows() {
        Row[] rowArray = this.mRows.toArray(new Row[0]);
        this.mSelection.deselect();
        this.mSelection.setSize(0);
        this.notifyOfRowsWillBeRemoved(rowArray);
        this.mRows.clear();
        for (Row row : rowArray) {
            row.setOwner(null);
        }
        this.notifyOfRowsWereRemoved(rowArray);
    }

    public void removeSelection() {
        int[] nArray = this.mSelection.getSelectedIndexes();
        this.mSelection.deselect();
        this.removeRows(nArray);
    }

    public List<Row> getRows() {
        return this.mRows;
    }

    public int getRowCount() {
        return this.mRows.size();
    }

    public Row getRowAtIndex(int n) {
        return this.mRows.get(n);
    }

    public int getIndexOfRow(Row row) {
        return this.mRows.indexOf(row);
    }

    public List<Row> getTopLevelRows() {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (Row row : this.mRows) {
            if (row.getParent() != null) continue;
            arrayList.add(row);
        }
        return arrayList;
    }

    public Selection getSelection() {
        return this.mSelection;
    }

    public Column getDragColumn() {
        return this.mDragColumn;
    }

    protected void setDragColumn(Column column) {
        this.mDragColumn = column;
    }

    public Row[] getDragRows() {
        return this.mDragRows;
    }

    public void setDragRows(Row[] rowArray) {
        this.mDragRows = rowArray;
    }

    public void clearSort() {
        if (this.clearSortInternal()) {
            this.notifyOfSortCleared();
        }
    }

    private boolean clearSortInternal() {
        int n = this.getColumnCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Column column = this.getColumnAtIndex(i);
            if (column.getSortSequence() == -1) continue;
            column.setSortCriteria(-1, column.isSortAscending());
            bl = true;
        }
        return bl;
    }

    public void sortIfNeeded() {
        this.sortInternal(false);
    }

    public void sort() {
        this.sortInternal(false);
    }

    private void sortInternal(boolean bl) {
        this.preserveSelection();
        RowSorter.sort(this.mColumns, this.mRows, true);
        this.restoreSelection();
        this.notifyOfSort(bl);
    }

    public String getSortConfig() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.mColumns.size();
        boolean bl = false;
        stringBuilder.append('S');
        stringBuilder.append(4);
        stringBuilder.append('\t');
        stringBuilder.append(n);
        for (int i = 0; i < n; ++i) {
            Column column = this.getColumnAtIndex(i);
            int n2 = column.getSortSequence();
            stringBuilder.append('\t');
            stringBuilder.append(column.getID());
            stringBuilder.append('\t');
            stringBuilder.append(n2);
            stringBuilder.append('\t');
            stringBuilder.append(column.isSortAscending());
            if (n2 <= -1) continue;
            bl = true;
        }
        return bl ? stringBuilder.toString() : null;
    }

    public void applySortConfig(String string) {
        int n = this.applySortConfigInternal(string);
        if (n == 0) {
            this.notifyOfSortCleared();
        } else if (n == 1) {
            this.sort();
        }
    }

    private int applySortConfigInternal(String string) {
        int n = -1;
        if (string != null && string.startsWith("S")) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                if (Numbers.getInteger(stringTokenizer.nextToken().substring(1), 0) == 4) {
                    int n2 = Numbers.getInteger(stringTokenizer.nextToken(), 0);
                    if (this.clearSortInternal()) {
                        n = 0;
                    }
                    for (int i = 0; i < n2; ++i) {
                        Column column = this.getColumnWithID(Numbers.getInteger(stringTokenizer.nextToken(), 0));
                        if (column == null) {
                            throw new Exception();
                        }
                        column.setSortCriteria(Numbers.getInteger(stringTokenizer.nextToken(), -1), Numbers.getBoolean(stringTokenizer.nextToken()));
                        if (column.getSortSequence() == -1) continue;
                        n = 1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void toggleRowOpenState() {
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 0; i < this.mRows.size(); ++i) {
            Row row = this.getRowAtIndex(i);
            if (!row.canHaveChildren()) continue;
            if (bl) {
                bl2 = !row.isOpen();
                bl = false;
            }
            row.setOpen(bl2);
        }
    }

    public void rowOpenStateChanged(Row row, boolean bl) {
        if (row.hasChildren() && this.mRows.contains(row)) {
            if (bl) {
                this.addChildren(row);
            } else {
                this.removeRows(row.getChildren().toArray(new Row[0]));
            }
        }
    }

    public boolean isRowSelected(int n) {
        return this.mSelection.isSelected(n);
    }

    public boolean isRowSelected(Row row) {
        return this.mSelection.isSelected(this.getIndexOfRow(row));
    }

    public boolean isExtendedRowSelected(int n) {
        if (n < 0 || n >= this.mRows.size()) {
            return false;
        }
        return this.isExtendedRowSelected(this.getRowAtIndex(n));
    }

    public boolean isExtendedRowSelected(Row row) {
        while (row != null) {
            if (this.isRowSelected(row)) {
                return true;
            }
            row = row.getParent();
        }
        return false;
    }

    public boolean hasSelection() {
        return !this.mSelection.isEmpty();
    }

    public boolean canSelectAll() {
        return this.mSelection.canSelectAll();
    }

    public int getFirstSelectedRowIndex() {
        return this.mSelection.firstSelectedIndex();
    }

    public Row getFirstSelectedRow() {
        int n = this.getFirstSelectedRowIndex();
        return n == -1 ? null : this.getRowAtIndex(n);
    }

    public int getLastSelectedRowIndex() {
        return this.mSelection.lastSelectedIndex();
    }

    public Row getLastSelectedRow() {
        int n = this.getLastSelectedRowIndex();
        return n == -1 ? null : this.getRowAtIndex(n);
    }

    public List<Row> getSelectionAsList() {
        return this.getSelectionAsList(false);
    }

    public List<Row> getSelectionAsList(boolean bl) {
        ArrayList<Row> arrayList = new ArrayList<Row>(this.mSelection.getCount());
        int n = this.mSelection.firstSelectedIndex();
        while (n != -1) {
            Row row = this.getRowAtIndex(n);
            boolean bl2 = true;
            if (bl) {
                for (Row row2 = row.getParent(); row2 != null; row2 = row2.getParent()) {
                    if (!this.mSelection.isSelected(this.getIndexOfRow(row2))) continue;
                    bl2 = false;
                    break;
                }
            }
            if (bl2) {
                arrayList.add(row);
            }
            n = this.mSelection.nextSelectedIndex(n + 1);
        }
        return arrayList;
    }

    public int getSelectionCount() {
        return this.mSelection.getCount();
    }

    public void select() {
        this.mSelection.select();
        this.reapplyRowFilter();
    }

    public void select(int n, boolean bl) {
        this.mSelection.select(n, bl);
        this.reapplyRowFilter();
    }

    public void select(Row row, boolean bl) {
        this.mSelection.select(this.getIndexOfRow(row), bl);
        this.reapplyRowFilter();
    }

    public void select(Collection<? extends Row> collection, boolean bl) {
        HashSet<? extends Row> hashSet = new HashSet<Row>(collection);
        int[] nArray = new int[hashSet.size()];
        int n = 0;
        for (Row row : hashSet) {
            nArray[n++] = this.getIndexOfRow(row);
        }
        this.mSelection.select(nArray, bl);
        this.reapplyRowFilter();
    }

    public void select(int n, int n2, boolean bl) {
        this.mSelection.select(n, n2, bl);
        this.reapplyRowFilter();
    }

    public void deselect() {
        this.mSelection.deselect();
    }

    public void deselect(int n) {
        this.mSelection.deselect(n);
    }

    public void deselect(Row row) {
        this.mSelection.deselect(this.getIndexOfRow(row));
    }

    public void deselect(List<Row> list) {
        HashSet<Row> hashSet = new HashSet<Row>(list);
        int[] nArray = new int[hashSet.size()];
        int n = 0;
        for (Row row : hashSet) {
            nArray[n++] = this.getIndexOfRow(row);
        }
        this.mSelection.deselect(nArray);
    }

    public void deselect(int n, int n2) {
        this.mSelection.deselect(n, n2);
    }

    private void preserveSelection() {
        int n = this.mSelection.getAnchor();
        this.mSavedAnchorRow = n != -1 ? this.getRowAtIndex(n) : null;
        this.mSavedSelection = this.getSelectionAsList();
        this.mNotifyOfSelections = false;
        this.deselect();
    }

    private void restoreSelection() {
        this.select(this.mSavedSelection, false);
        if (this.mSavedAnchorRow != null) {
            this.mSelection.setAnchor(this.getIndexOfRow(this.mSavedAnchorRow));
        }
        this.mSavedAnchorRow = null;
        this.mSavedSelection = null;
        this.mNotifyOfSelections = true;
    }

    @Override
    public void selectionAboutToChange() {
        if (this.mNotifyOfSelections) {
            OutlineModelListener[] outlineModelListenerArray;
            for (OutlineModelListener outlineModelListener : outlineModelListenerArray = this.getCurrentListeners()) {
                outlineModelListener.selectionWillChange(this);
            }
        }
    }

    @Override
    public void selectionDidChange() {
        if (this.mNotifyOfSelections) {
            OutlineModelListener[] outlineModelListenerArray;
            for (OutlineModelListener outlineModelListener : outlineModelListenerArray = this.getCurrentListeners()) {
                outlineModelListener.selectionDidChange(this);
            }
        }
    }

    public boolean isLocked() {
        return this.mLocked;
    }

    public void setLocked(boolean bl) {
        if (this.mLocked != bl) {
            this.notifyOfLockedStateWillChange();
            this.mLocked = bl;
            this.notifyOfLockedStateDidChange();
        }
    }

    public boolean isFirstColumn(Column column) {
        if (column != null) {
            for (Column column2 : this.mColumns) {
                if (column2 == column) {
                    return true;
                }
                if (!column2.isVisible()) continue;
                return false;
            }
        }
        return false;
    }

    public boolean showIndent() {
        return this.mShowIndent;
    }

    public void setShowIndent(boolean bl) {
        this.mShowIndent = bl;
    }

    public int getIndentWidth() {
        return this.mIndentWidth;
    }

    public void setIndentWidth(int n) {
        this.mIndentWidth = n;
    }

    public int getIndentWidth(Row row, Column column) {
        if (this.mShowIndent && this.isFirstColumn(column)) {
            return this.getIndentWidth() * (1 + row.getDepth());
        }
        return 0;
    }

    @Override
    public void storeState(Hashtable<Object, Object> hashtable) {
        List<Row> list = this.getRows();
        hashtable.put(UNDO_KEY_ROWS, new ArrayList<Row>(list));
        hashtable.put(UNDO_KEY_SELECTION, new Selection(this.getSelection()));
        String string = this.getSortConfig();
        if (string != null) {
            hashtable.put(UNDO_KEY_SORT_CONFIG, string);
        }
        for (Row row : RowSorter.collectContainerRows(list, new HashSet<Row>())) {
            hashtable.put(row, new RowUndoSnapshot(row));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void restoreState(Hashtable<?, ?> hashtable) {
        void var6_11;
        int n;
        String string;
        this.notifyOfUndoWillHappen();
        String string2 = this.getSortConfig();
        boolean bl = this.clearSortInternal();
        ArrayList arrayList = (ArrayList)hashtable.get(UNDO_KEY_ROWS);
        if (arrayList != null) {
            this.mRows = new ArrayList(arrayList);
        }
        for (Row object2 : this.mRows) {
            object2.resetOwner(this);
        }
        for (Row row : hashtable.keySet()) {
            if (!(row instanceof Row)) continue;
            row.applyUndoSnapshot(this, (RowUndoSnapshot)hashtable.get(row));
        }
        Selection selection = (Selection)hashtable.get(UNDO_KEY_SELECTION);
        if (selection != null) {
            this.mSelection = new Selection(selection);
        }
        if ((string = (String)hashtable.get(UNDO_KEY_SORT_CONFIG)) == null) {
            String string3 = string2;
        }
        if ((n = this.applySortConfigInternal((String)var6_11)) == 0) {
            bl = true;
        } else if (n == 1) {
            bl = false;
            this.notifyOfSort(false);
        }
        if (bl) {
            this.notifyOfSortCleared();
        }
        this.notifyOfUndoDidHappen();
    }

    public RowFilter getRowFilter() {
        return this.mRowFilter;
    }

    public void setRowFilter(RowFilter rowFilter) {
        this.mRowFilter = rowFilter;
    }

    public boolean isRowFiltered(Row row) {
        if (this.mRowFilter != null) {
            return this.mRowFilter.isRowFiltered(row);
        }
        return false;
    }

    public void reapplyRowFilter() {
        if (this.mRowFilter != null) {
            ArrayList<Row> arrayList = new ArrayList<Row>(this.mSelection.getCount());
            int n = this.mSelection.firstSelectedIndex();
            while (n != -1) {
                Row row = this.getRowAtIndex(n);
                if (this.mRowFilter.isRowFiltered(row)) {
                    arrayList.add(row);
                }
                n = this.mSelection.nextSelectedIndex(n + 1);
            }
            if (!arrayList.isEmpty()) {
                int n2 = this.mSelection.getAnchor();
                this.deselect(arrayList);
                this.mSelection.setAnchor(n2);
            }
        }
    }
}

