/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.OutlineModel;
import com.trollworks.ttk.widgets.outline.Row;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

public class RowSelection
implements Transferable {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(RowSelection.class, "Outline Rows");
    private OutlineModel mModel;
    private Row[] mRows;
    private String mCache;

    public RowSelection(OutlineModel outlineModel, Row[] rowArray) {
        this.mModel = outlineModel;
        this.mRows = new Row[rowArray.length];
        System.arraycopy(rowArray, 0, this.mRows, 0, rowArray.length);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DATA_FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DATA_FLAVOR.equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (DATA_FLAVOR.equals(dataFlavor)) {
            return this.mRows;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            if (this.mCache == null) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.mRows.length > 0) {
                    int n = this.mModel.getColumnCount();
                    for (Row row : this.mRows) {
                        boolean bl = true;
                        for (int i = 0; i < n; ++i) {
                            Column column = this.mModel.getColumnAtIndex(i);
                            if (!column.isVisible()) continue;
                            if (bl) {
                                bl = false;
                            } else {
                                stringBuilder.append('\t');
                            }
                            stringBuilder.append(row.getDataAsText(column));
                        }
                        stringBuilder.append('\n');
                    }
                }
                this.mCache = stringBuilder.toString();
            }
            return this.mCache;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

