/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.text.NumericStringComparator;
import com.trollworks.ttk.text.TextDrawing;
import com.trollworks.ttk.widgets.outline.Cell;
import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.Outline;
import com.trollworks.ttk.widgets.outline.Row;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.UIManager;

public class TextCell
implements Cell {
    public static final int H_MARGIN = 2;
    public static final int H_MARGIN_WIDTH = 4;
    private int mHAlignment;
    private boolean mWrapped;

    public TextCell() {
        this(2);
    }

    public TextCell(int n) {
        this(n, false);
    }

    public TextCell(int n, boolean bl) {
        this.mHAlignment = n;
        this.mWrapped = bl;
    }

    @Override
    public int compare(Column column, Row row, Row row2) {
        Object object = row.getData(column);
        Object object2 = row2.getData(column);
        if (!(object instanceof String) && object.getClass() == object2.getClass() && object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        return NumericStringComparator.caselessCompareStrings(row.getDataAsText(column), row2.getDataAsText(column));
    }

    public Color getColor(boolean bl, boolean bl2, Row row, Column column) {
        return Outline.getListForeground(bl, bl2);
    }

    @Override
    public int getPreferredWidth(Row row, Column column) {
        BufferedImage bufferedImage;
        int n = TextDrawing.getPreferredSize((Font)this.getFont((Row)row, (Column)column), (String)this.getPresentationText((Row)row, (Column)column)).width;
        BufferedImage bufferedImage2 = bufferedImage = row == null ? column.getIcon() : row.getIcon(column);
        if (bufferedImage != null) {
            n += bufferedImage.getWidth() + 2;
        }
        return 4 + n;
    }

    @Override
    public int getPreferredHeight(Row row, Column column) {
        int n;
        BufferedImage bufferedImage;
        Font font = this.getFont(row, column);
        int n2 = TextDrawing.getPreferredSize((Font)font, (String)"Mg").height;
        int n3 = TextDrawing.getPreferredSize((Font)font, (String)this.getPresentationText((Row)row, (Column)column)).height;
        BufferedImage bufferedImage2 = bufferedImage = row == null ? column.getIcon() : row.getIcon(column);
        if (bufferedImage != null && n3 < (n = bufferedImage.getHeight())) {
            n3 = n;
        }
        return n2 > n3 ? n2 : n3;
    }

    public BufferedImage getIcon(Row row, Column column) {
        return row == null ? column.getIcon() : row.getIcon(column);
    }

    @Override
    public void drawCell(Outline outline, Graphics graphics, Rectangle rectangle, Row row, Column column, boolean bl, boolean bl2) {
        Font font = this.getFont(row, column);
        int n = graphics.getFontMetrics(font).getAscent();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getPresentationText(row, column), "\n", true);
        int n2 = this.getPreferredHeight(row, column);
        int n3 = TextDrawing.getPreferredSize((Font)font, (String)"Mg").height;
        int n4 = 0;
        BufferedImage bufferedImage = this.getIcon(row, column);
        int n5 = bufferedImage == null ? 0 : bufferedImage.getWidth() + 2;
        int n6 = rectangle.width - (n5 + 4);
        int n7 = this.getVAlignment();
        int n8 = this.getHAlignment();
        n5 += rectangle.x + 2;
        if (bufferedImage != null) {
            int n9 = rectangle.y;
            if (n7 != 1) {
                int n10 = rectangle.height - bufferedImage.getHeight();
                if (n7 == 0) {
                    n10 /= 2;
                }
                n9 += n10;
            }
            graphics.drawImage(bufferedImage, rectangle.x + 2, n9, null);
        }
        graphics.setFont(font);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\n")) {
                ++n4;
                continue;
            }
            String string2 = TextDrawing.truncateIfNecessary(font, string, n6, this.getTruncationPolicy());
            int n11 = n5;
            int n12 = rectangle.y + n + n3 * n4;
            if (n8 != 2) {
                int n13 = n6 - TextDrawing.getWidth(font, string2);
                if (n8 == 0) {
                    n13 /= 2;
                }
                n11 += n13;
            }
            if (n7 != 1) {
                float f = rectangle.height - n2;
                if (n7 == 0) {
                    f /= 2.0f;
                }
                n12 = (int)((float)n12 + f);
            }
            graphics.setColor(this.getColor(bl, bl2, row, column));
            graphics.drawString(string2, n11, n12);
        }
    }

    protected String getPresentationText(Row row, Column column) {
        String string = this.getData(row, column, false);
        if (!this.mWrapped || row == null) {
            return string;
        }
        int n = column.getWidth();
        if (n == -1) {
            return string;
        }
        return TextDrawing.wrapToPixelWidth(this.getFont(row, column), string, n - (4 + row.getOwner().getIndentWidth(row, column)));
    }

    @Override
    public Cursor getCursor(MouseEvent mouseEvent, Rectangle rectangle, Row row, Column column) {
        return Cursor.getDefaultCursor();
    }

    public int getTruncationPolicy() {
        return 0;
    }

    protected String getData(Row row, Column column, boolean bl) {
        if (row != null) {
            String string = row.getDataAsText(column);
            return string == null ? (bl ? null : "") : string;
        }
        return column.toString();
    }

    public Font getFont(Row row, Column column) {
        return UIManager.getFont("TextField.font");
    }

    public int getHAlignment() {
        return this.mHAlignment;
    }

    public void setHAlignment(int n) {
        this.mHAlignment = n;
    }

    public int getVAlignment() {
        return 1;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent, Rectangle rectangle, Row row, Column column) {
        if (this.getPreferredWidth(row, column) - 2 > column.getWidth() - row.getOwner().getIndentWidth(row, column)) {
            return this.getData(row, column, true);
        }
        return null;
    }

    @Override
    public boolean participatesInDynamicRowLayout() {
        return this.mWrapped;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent, Rectangle rectangle, Row row, Column column) {
    }
}

