/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.widgets.tree.TreeContainerRow;
import com.trollworks.ttk.widgets.tree.TreePanel;
import com.trollworks.ttk.widgets.tree.TreeRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TreeRowViewIterator
implements Iterator<TreeRow>,
Iterable<TreeRow> {
    private TreePanel mPanel;
    private List<TreeRow> mRows;
    private TreeRowViewIterator mIterator;
    private int mIndex;

    public TreeRowViewIterator(TreePanel treePanel, TreeRow treeRow) {
        this.mPanel = treePanel;
        this.mRows = new ArrayList<TreeRow>();
        this.mRows.add(treeRow);
    }

    public TreeRowViewIterator(TreePanel treePanel, TreeRow ... treeRowArray) {
        this.mPanel = treePanel;
        this.mRows = Arrays.asList(treeRowArray);
    }

    public TreeRowViewIterator(TreePanel treePanel, List<TreeRow> list) {
        this.mPanel = treePanel;
        this.mRows = list;
    }

    @Override
    public Iterator<TreeRow> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        boolean bl;
        boolean bl2 = bl = this.mIterator != null && this.mIterator.hasNext();
        if (!bl) {
            this.mIterator = null;
            bl = this.mIndex < this.mRows.size();
        }
        return bl;
    }

    @Override
    public TreeRow next() {
        if (this.hasNext()) {
            if (this.mIterator == null) {
                TreeContainerRow treeContainerRow;
                TreeRow treeRow;
                if ((treeRow = this.mRows.get(this.mIndex++)) instanceof TreeContainerRow && (treeContainerRow = (TreeContainerRow)treeRow).getChildCount() > 0 && this.mPanel.isOpen(treeContainerRow)) {
                    this.mIterator = new TreeRowViewIterator(this.mPanel, treeContainerRow.getChildren());
                }
                return treeRow;
            }
            return this.mIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

