/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps;

import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import java.util.Iterator;

public class MapObjects
implements Iterable<MapObject> {
    private Array<MapObject> objects = new Array();

    public MapObject get(int index) {
        return this.objects.get(index);
    }

    public MapObject get(String name2) {
        int n = this.objects.size;
        for (int i = 0; i < n; ++i) {
            MapObject object = this.objects.get(i);
            if (!name2.equals(object.getName())) continue;
            return object;
        }
        return null;
    }

    public int getIndex(String name2) {
        return this.getIndex(this.get(name2));
    }

    public int getIndex(MapObject object) {
        return this.objects.indexOf(object, true);
    }

    public int getCount() {
        return this.objects.size;
    }

    public void add(MapObject object) {
        this.objects.add(object);
    }

    public void remove(int index) {
        this.objects.removeIndex(index);
    }

    public void remove(MapObject object) {
        this.objects.removeValue(object, true);
    }

    public <T extends MapObject> Array<T> getByType(Class<T> type2) {
        return this.getByType(type2, new Array());
    }

    public <T extends MapObject> Array<T> getByType(Class<T> type2, Array<T> fill2) {
        fill2.clear();
        int n = this.objects.size;
        for (int i = 0; i < n; ++i) {
            MapObject object = this.objects.get(i);
            if (!ClassReflection.isInstance(type2, object)) continue;
            fill2.add(object);
        }
        return fill2;
    }

    @Override
    public Iterator<MapObject> iterator() {
        return this.objects.iterator();
    }
}

