/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.AddAction;
import com.badlogic.gdx.scenes.scene2d.actions.AddListenerAction;
import com.badlogic.gdx.scenes.scene2d.actions.AfterAction;
import com.badlogic.gdx.scenes.scene2d.actions.AlphaAction;
import com.badlogic.gdx.scenes.scene2d.actions.ColorAction;
import com.badlogic.gdx.scenes.scene2d.actions.DelayAction;
import com.badlogic.gdx.scenes.scene2d.actions.LayoutAction;
import com.badlogic.gdx.scenes.scene2d.actions.MoveByAction;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.actions.ParallelAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveActorAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveListenerAction;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.actions.RotateByAction;
import com.badlogic.gdx.scenes.scene2d.actions.RotateToAction;
import com.badlogic.gdx.scenes.scene2d.actions.RunnableAction;
import com.badlogic.gdx.scenes.scene2d.actions.ScaleByAction;
import com.badlogic.gdx.scenes.scene2d.actions.ScaleToAction;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.actions.SizeByAction;
import com.badlogic.gdx.scenes.scene2d.actions.SizeToAction;
import com.badlogic.gdx.scenes.scene2d.actions.TimeScaleAction;
import com.badlogic.gdx.scenes.scene2d.actions.TouchableAction;
import com.badlogic.gdx.scenes.scene2d.actions.VisibleAction;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class Actions {
    public static <T extends Action> T action(Class<T> type2) {
        Pool<T> pool = Pools.get(type2);
        Action action2 = (Action)pool.obtain();
        action2.setPool(pool);
        return (T)action2;
    }

    public static AddAction addAction(Action action2) {
        AddAction addAction = Actions.action(AddAction.class);
        addAction.setAction(action2);
        return addAction;
    }

    public static AddAction addAction(Action action2, Actor targetActor) {
        AddAction addAction = Actions.action(AddAction.class);
        addAction.setTarget(targetActor);
        addAction.setAction(action2);
        return addAction;
    }

    public static RemoveAction removeAction(Action action2) {
        RemoveAction removeAction = Actions.action(RemoveAction.class);
        removeAction.setAction(action2);
        return removeAction;
    }

    public static RemoveAction removeAction(Action action2, Actor targetActor) {
        RemoveAction removeAction = Actions.action(RemoveAction.class);
        removeAction.setTarget(targetActor);
        removeAction.setAction(action2);
        return removeAction;
    }

    public static MoveToAction moveTo(float x, float y) {
        return Actions.moveTo(x, y, 0.0f, null);
    }

    public static MoveToAction moveTo(float x, float y, float duration) {
        return Actions.moveTo(x, y, duration, null);
    }

    public static MoveToAction moveTo(float x, float y, float duration, @Null Interpolation interpolation) {
        MoveToAction action2 = Actions.action(MoveToAction.class);
        action2.setPosition(x, y);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static MoveToAction moveToAligned(float x, float y, int alignment) {
        return Actions.moveToAligned(x, y, alignment, 0.0f, null);
    }

    public static MoveToAction moveToAligned(float x, float y, int alignment, float duration) {
        return Actions.moveToAligned(x, y, alignment, duration, null);
    }

    public static MoveToAction moveToAligned(float x, float y, int alignment, float duration, @Null Interpolation interpolation) {
        MoveToAction action2 = Actions.action(MoveToAction.class);
        action2.setPosition(x, y, alignment);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static MoveByAction moveBy(float amountX, float amountY) {
        return Actions.moveBy(amountX, amountY, 0.0f, null);
    }

    public static MoveByAction moveBy(float amountX, float amountY, float duration) {
        return Actions.moveBy(amountX, amountY, duration, null);
    }

    public static MoveByAction moveBy(float amountX, float amountY, float duration, @Null Interpolation interpolation) {
        MoveByAction action2 = Actions.action(MoveByAction.class);
        action2.setAmount(amountX, amountY);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static SizeToAction sizeTo(float x, float y) {
        return Actions.sizeTo(x, y, 0.0f, null);
    }

    public static SizeToAction sizeTo(float x, float y, float duration) {
        return Actions.sizeTo(x, y, duration, null);
    }

    public static SizeToAction sizeTo(float x, float y, float duration, @Null Interpolation interpolation) {
        SizeToAction action2 = Actions.action(SizeToAction.class);
        action2.setSize(x, y);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static SizeByAction sizeBy(float amountX, float amountY) {
        return Actions.sizeBy(amountX, amountY, 0.0f, null);
    }

    public static SizeByAction sizeBy(float amountX, float amountY, float duration) {
        return Actions.sizeBy(amountX, amountY, duration, null);
    }

    public static SizeByAction sizeBy(float amountX, float amountY, float duration, @Null Interpolation interpolation) {
        SizeByAction action2 = Actions.action(SizeByAction.class);
        action2.setAmount(amountX, amountY);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static ScaleToAction scaleTo(float x, float y) {
        return Actions.scaleTo(x, y, 0.0f, null);
    }

    public static ScaleToAction scaleTo(float x, float y, float duration) {
        return Actions.scaleTo(x, y, duration, null);
    }

    public static ScaleToAction scaleTo(float x, float y, float duration, @Null Interpolation interpolation) {
        ScaleToAction action2 = Actions.action(ScaleToAction.class);
        action2.setScale(x, y);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static ScaleByAction scaleBy(float amountX, float amountY) {
        return Actions.scaleBy(amountX, amountY, 0.0f, null);
    }

    public static ScaleByAction scaleBy(float amountX, float amountY, float duration) {
        return Actions.scaleBy(amountX, amountY, duration, null);
    }

    public static ScaleByAction scaleBy(float amountX, float amountY, float duration, @Null Interpolation interpolation) {
        ScaleByAction action2 = Actions.action(ScaleByAction.class);
        action2.setAmount(amountX, amountY);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static RotateToAction rotateTo(float rotation) {
        return Actions.rotateTo(rotation, 0.0f, null);
    }

    public static RotateToAction rotateTo(float rotation, float duration) {
        return Actions.rotateTo(rotation, duration, null);
    }

    public static RotateToAction rotateTo(float rotation, float duration, @Null Interpolation interpolation) {
        RotateToAction action2 = Actions.action(RotateToAction.class);
        action2.setRotation(rotation);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static RotateByAction rotateBy(float rotationAmount) {
        return Actions.rotateBy(rotationAmount, 0.0f, null);
    }

    public static RotateByAction rotateBy(float rotationAmount, float duration) {
        return Actions.rotateBy(rotationAmount, duration, null);
    }

    public static RotateByAction rotateBy(float rotationAmount, float duration, @Null Interpolation interpolation) {
        RotateByAction action2 = Actions.action(RotateByAction.class);
        action2.setAmount(rotationAmount);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static ColorAction color(Color color) {
        return Actions.color(color, 0.0f, null);
    }

    public static ColorAction color(Color color, float duration) {
        return Actions.color(color, duration, null);
    }

    public static ColorAction color(Color color, float duration, @Null Interpolation interpolation) {
        ColorAction action2 = Actions.action(ColorAction.class);
        action2.setEndColor(color);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static AlphaAction alpha(float a) {
        return Actions.alpha(a, 0.0f, null);
    }

    public static AlphaAction alpha(float a, float duration) {
        return Actions.alpha(a, duration, null);
    }

    public static AlphaAction alpha(float a, float duration, @Null Interpolation interpolation) {
        AlphaAction action2 = Actions.action(AlphaAction.class);
        action2.setAlpha(a);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static AlphaAction fadeOut(float duration) {
        return Actions.alpha(0.0f, duration, null);
    }

    public static AlphaAction fadeOut(float duration, @Null Interpolation interpolation) {
        AlphaAction action2 = Actions.action(AlphaAction.class);
        action2.setAlpha(0.0f);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static AlphaAction fadeIn(float duration) {
        return Actions.alpha(1.0f, duration, null);
    }

    public static AlphaAction fadeIn(float duration, @Null Interpolation interpolation) {
        AlphaAction action2 = Actions.action(AlphaAction.class);
        action2.setAlpha(1.0f);
        action2.setDuration(duration);
        action2.setInterpolation(interpolation);
        return action2;
    }

    public static VisibleAction show() {
        return Actions.visible(true);
    }

    public static VisibleAction hide() {
        return Actions.visible(false);
    }

    public static VisibleAction visible(boolean visible) {
        VisibleAction action2 = Actions.action(VisibleAction.class);
        action2.setVisible(visible);
        return action2;
    }

    public static TouchableAction touchable(Touchable touchable) {
        TouchableAction action2 = Actions.action(TouchableAction.class);
        action2.setTouchable(touchable);
        return action2;
    }

    public static RemoveActorAction removeActor() {
        return Actions.action(RemoveActorAction.class);
    }

    public static RemoveActorAction removeActor(Actor removeActor) {
        RemoveActorAction action2 = Actions.action(RemoveActorAction.class);
        action2.setTarget(removeActor);
        return action2;
    }

    public static DelayAction delay(float duration) {
        DelayAction action2 = Actions.action(DelayAction.class);
        action2.setDuration(duration);
        return action2;
    }

    public static DelayAction delay(float duration, Action delayedAction) {
        DelayAction action2 = Actions.action(DelayAction.class);
        action2.setDuration(duration);
        action2.setAction(delayedAction);
        return action2;
    }

    public static TimeScaleAction timeScale(float scale, Action scaledAction) {
        TimeScaleAction action2 = Actions.action(TimeScaleAction.class);
        action2.setScale(scale);
        action2.setAction(scaledAction);
        return action2;
    }

    public static SequenceAction sequence(Action action1) {
        SequenceAction action2 = Actions.action(SequenceAction.class);
        action2.addAction(action1);
        return action2;
    }

    public static SequenceAction sequence(Action action1, Action action2) {
        SequenceAction action3 = Actions.action(SequenceAction.class);
        action3.addAction(action1);
        action3.addAction(action2);
        return action3;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3) {
        SequenceAction action4 = Actions.action(SequenceAction.class);
        action4.addAction(action1);
        action4.addAction(action2);
        action4.addAction(action3);
        return action4;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3, Action action4) {
        SequenceAction action5 = Actions.action(SequenceAction.class);
        action5.addAction(action1);
        action5.addAction(action2);
        action5.addAction(action3);
        action5.addAction(action4);
        return action5;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3, Action action4, Action action5) {
        SequenceAction action6 = Actions.action(SequenceAction.class);
        action6.addAction(action1);
        action6.addAction(action2);
        action6.addAction(action3);
        action6.addAction(action4);
        action6.addAction(action5);
        return action6;
    }

    public static SequenceAction sequence(Action ... actions) {
        SequenceAction action2 = Actions.action(SequenceAction.class);
        int n = actions.length;
        for (int i = 0; i < n; ++i) {
            action2.addAction(actions[i]);
        }
        return action2;
    }

    public static SequenceAction sequence() {
        return Actions.action(SequenceAction.class);
    }

    public static ParallelAction parallel(Action action1) {
        ParallelAction action2 = Actions.action(ParallelAction.class);
        action2.addAction(action1);
        return action2;
    }

    public static ParallelAction parallel(Action action1, Action action2) {
        ParallelAction action3 = Actions.action(ParallelAction.class);
        action3.addAction(action1);
        action3.addAction(action2);
        return action3;
    }

    public static ParallelAction parallel(Action action1, Action action2, Action action3) {
        ParallelAction action4 = Actions.action(ParallelAction.class);
        action4.addAction(action1);
        action4.addAction(action2);
        action4.addAction(action3);
        return action4;
    }

    public static ParallelAction parallel(Action action1, Action action2, Action action3, Action action4) {
        ParallelAction action5 = Actions.action(ParallelAction.class);
        action5.addAction(action1);
        action5.addAction(action2);
        action5.addAction(action3);
        action5.addAction(action4);
        return action5;
    }

    public static ParallelAction parallel(Action action1, Action action2, Action action3, Action action4, Action action5) {
        ParallelAction action6 = Actions.action(ParallelAction.class);
        action6.addAction(action1);
        action6.addAction(action2);
        action6.addAction(action3);
        action6.addAction(action4);
        action6.addAction(action5);
        return action6;
    }

    public static ParallelAction parallel(Action ... actions) {
        ParallelAction action2 = Actions.action(ParallelAction.class);
        int n = actions.length;
        for (int i = 0; i < n; ++i) {
            action2.addAction(actions[i]);
        }
        return action2;
    }

    public static ParallelAction parallel() {
        return Actions.action(ParallelAction.class);
    }

    public static RepeatAction repeat(int count2, Action repeatedAction) {
        RepeatAction action2 = Actions.action(RepeatAction.class);
        action2.setCount(count2);
        action2.setAction(repeatedAction);
        return action2;
    }

    public static RepeatAction forever(Action repeatedAction) {
        RepeatAction action2 = Actions.action(RepeatAction.class);
        action2.setCount(-1);
        action2.setAction(repeatedAction);
        return action2;
    }

    public static RunnableAction run(Runnable runnable) {
        RunnableAction action2 = Actions.action(RunnableAction.class);
        action2.setRunnable(runnable);
        return action2;
    }

    public static LayoutAction layout(boolean enabled) {
        LayoutAction action2 = Actions.action(LayoutAction.class);
        action2.setLayoutEnabled(enabled);
        return action2;
    }

    public static AfterAction after(Action action2) {
        AfterAction afterAction = Actions.action(AfterAction.class);
        afterAction.setAction(action2);
        return afterAction;
    }

    public static AddListenerAction addListener(EventListener listener, boolean capture) {
        AddListenerAction addAction = Actions.action(AddListenerAction.class);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static AddListenerAction addListener(EventListener listener, boolean capture, Actor targetActor) {
        AddListenerAction addAction = Actions.action(AddListenerAction.class);
        addAction.setTarget(targetActor);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static RemoveListenerAction removeListener(EventListener listener, boolean capture) {
        RemoveListenerAction addAction = Actions.action(RemoveListenerAction.class);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static RemoveListenerAction removeListener(EventListener listener, boolean capture, Actor targetActor) {
        RemoveListenerAction addAction = Actions.action(RemoveListenerAction.class);
        addAction.setTarget(targetActor);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static Action targeting(Actor target, Action action2) {
        action2.setTarget(target);
        return action2;
    }
}

