/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Touchpad;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;

public class Skin
implements Disposable {
    ObjectMap<Class, ObjectMap<String, Object>> resources = new ObjectMap();
    TextureAtlas atlas;
    float scale = 1.0f;
    private final ObjectMap<String, Class> jsonClassTags = new ObjectMap(defaultTagClasses.length);
    private static final Class[] defaultTagClasses = new Class[]{BitmapFont.class, Color.class, TintedDrawable.class, NinePatchDrawable.class, SpriteDrawable.class, TextureRegionDrawable.class, TiledDrawable.class, Button.ButtonStyle.class, CheckBox.CheckBoxStyle.class, ImageButton.ImageButtonStyle.class, ImageTextButton.ImageTextButtonStyle.class, Label.LabelStyle.class, List.ListStyle.class, ProgressBar.ProgressBarStyle.class, ScrollPane.ScrollPaneStyle.class, SelectBox.SelectBoxStyle.class, Slider.SliderStyle.class, SplitPane.SplitPaneStyle.class, TextButton.TextButtonStyle.class, TextField.TextFieldStyle.class, TextTooltip.TextTooltipStyle.class, Touchpad.TouchpadStyle.class, Tree.TreeStyle.class, Window.WindowStyle.class};

    public Skin() {
        for (Class c : defaultTagClasses) {
            this.jsonClassTags.put(c.getSimpleName(), c);
        }
    }

    public Skin(FileHandle skinFile) {
        for (Class c : defaultTagClasses) {
            this.jsonClassTags.put(c.getSimpleName(), c);
        }
        FileHandle atlasFile = skinFile.sibling(skinFile.nameWithoutExtension() + ".atlas");
        if (atlasFile.exists()) {
            this.atlas = new TextureAtlas(atlasFile);
            this.addRegions(this.atlas);
        }
        this.load(skinFile);
    }

    public Skin(FileHandle skinFile, TextureAtlas atlas) {
        for (Class c : defaultTagClasses) {
            this.jsonClassTags.put(c.getSimpleName(), c);
        }
        this.atlas = atlas;
        this.addRegions(atlas);
        this.load(skinFile);
    }

    public Skin(TextureAtlas atlas) {
        for (Class c : defaultTagClasses) {
            this.jsonClassTags.put(c.getSimpleName(), c);
        }
        this.atlas = atlas;
        this.addRegions(atlas);
    }

    public void load(FileHandle skinFile) {
        try {
            this.getJsonLoader(skinFile).fromJson(Skin.class, skinFile);
        }
        catch (SerializationException ex) {
            throw new SerializationException("Error reading file: " + skinFile, ex);
        }
    }

    public void addRegions(TextureAtlas atlas) {
        Array<TextureAtlas.AtlasRegion> regions = atlas.getRegions();
        int n = regions.size;
        for (int i = 0; i < n; ++i) {
            TextureAtlas.AtlasRegion region = regions.get(i);
            String name2 = region.name;
            if (region.index != -1) {
                name2 = name2 + "_" + region.index;
            }
            this.add(name2, region, TextureRegion.class);
        }
    }

    public void add(String name2, Object resource2) {
        this.add(name2, resource2, resource2.getClass());
    }

    public void add(String name2, Object resource2, Class type2) {
        if (name2 == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (resource2 == null) {
            throw new IllegalArgumentException("resource cannot be null.");
        }
        ObjectMap<String, Object> typeResources = this.resources.get(type2);
        if (typeResources == null) {
            typeResources = new ObjectMap(type2 == TextureRegion.class || type2 == Drawable.class || type2 == Sprite.class ? 256 : 64);
            this.resources.put(type2, typeResources);
        }
        typeResources.put(name2, resource2);
    }

    public void remove(String name2, Class type2) {
        if (name2 == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        ObjectMap<String, Object> typeResources = this.resources.get(type2);
        typeResources.remove(name2);
    }

    public <T> T get(Class<T> type2) {
        return this.get("default", type2);
    }

    public <T> T get(String name2, Class<T> type2) {
        if (name2 == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (type2 == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (type2 == Drawable.class) {
            return (T)this.getDrawable(name2);
        }
        if (type2 == TextureRegion.class) {
            return (T)this.getRegion(name2);
        }
        if (type2 == NinePatch.class) {
            return (T)this.getPatch(name2);
        }
        if (type2 == Sprite.class) {
            return (T)this.getSprite(name2);
        }
        ObjectMap<String, Object> typeResources = this.resources.get(type2);
        if (typeResources == null) {
            throw new GdxRuntimeException("No " + type2.getName() + " registered with name: " + name2);
        }
        Object resource2 = typeResources.get(name2);
        if (resource2 == null) {
            throw new GdxRuntimeException("No " + type2.getName() + " registered with name: " + name2);
        }
        return (T)resource2;
    }

    @Null
    public <T> T optional(String name2, Class<T> type2) {
        if (name2 == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (type2 == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        ObjectMap<String, Object> typeResources = this.resources.get(type2);
        if (typeResources == null) {
            return null;
        }
        return (T)typeResources.get(name2);
    }

    public boolean has(String name2, Class type2) {
        ObjectMap<String, Object> typeResources = this.resources.get(type2);
        if (typeResources == null) {
            return false;
        }
        return typeResources.containsKey(name2);
    }

    @Null
    public <T> ObjectMap<String, T> getAll(Class<T> type2) {
        return this.resources.get(type2);
    }

    public Color getColor(String name2) {
        return this.get(name2, Color.class);
    }

    public BitmapFont getFont(String name2) {
        return this.get(name2, BitmapFont.class);
    }

    public TextureRegion getRegion(String name2) {
        TextureRegion region = this.optional(name2, TextureRegion.class);
        if (region != null) {
            return region;
        }
        Texture texture = this.optional(name2, Texture.class);
        if (texture == null) {
            throw new GdxRuntimeException("No TextureRegion or Texture registered with name: " + name2);
        }
        region = new TextureRegion(texture);
        this.add(name2, region, TextureRegion.class);
        return region;
    }

    @Null
    public Array<TextureRegion> getRegions(String regionName) {
        Array<TextureRegion> regions = null;
        int i = 0;
        TextureRegion region = this.optional(regionName + "_" + i++, TextureRegion.class);
        if (region != null) {
            regions = new Array<TextureRegion>();
            while (region != null) {
                regions.add(region);
                region = this.optional(regionName + "_" + i++, TextureRegion.class);
            }
        }
        return regions;
    }

    public TiledDrawable getTiledDrawable(String name2) {
        TiledDrawable tiled = this.optional(name2, TiledDrawable.class);
        if (tiled != null) {
            return tiled;
        }
        tiled = new TiledDrawable(this.getRegion(name2));
        tiled.setName(name2);
        if (this.scale != 1.0f) {
            this.scale(tiled);
            tiled.setScale(this.scale);
        }
        this.add(name2, tiled, TiledDrawable.class);
        return tiled;
    }

    public NinePatch getPatch(String name2) {
        NinePatch patch2 = this.optional(name2, NinePatch.class);
        if (patch2 != null) {
            return patch2;
        }
        try {
            int[] splits;
            TextureRegion region = this.getRegion(name2);
            if (region instanceof TextureAtlas.AtlasRegion && (splits = ((TextureAtlas.AtlasRegion)region).findValue("split")) != null) {
                patch2 = new NinePatch(region, splits[0], splits[1], splits[2], splits[3]);
                int[] pads = ((TextureAtlas.AtlasRegion)region).findValue("pad");
                if (pads != null) {
                    patch2.setPadding(pads[0], pads[1], pads[2], pads[3]);
                }
            }
            if (patch2 == null) {
                patch2 = new NinePatch(region);
            }
            if (this.scale != 1.0f) {
                patch2.scale(this.scale, this.scale);
            }
            this.add(name2, patch2, NinePatch.class);
            return patch2;
        }
        catch (GdxRuntimeException ex) {
            throw new GdxRuntimeException("No NinePatch, TextureRegion, or Texture registered with name: " + name2);
        }
    }

    public Sprite getSprite(String name2) {
        Sprite sprite = this.optional(name2, Sprite.class);
        if (sprite != null) {
            return sprite;
        }
        try {
            TextureRegion textureRegion = this.getRegion(name2);
            if (textureRegion instanceof TextureAtlas.AtlasRegion) {
                TextureAtlas.AtlasRegion region = (TextureAtlas.AtlasRegion)textureRegion;
                if (region.rotate || region.packedWidth != region.originalWidth || region.packedHeight != region.originalHeight) {
                    sprite = new TextureAtlas.AtlasSprite(region);
                }
            }
            if (sprite == null) {
                sprite = new Sprite(textureRegion);
            }
            if (this.scale != 1.0f) {
                sprite.setSize(sprite.getWidth() * this.scale, sprite.getHeight() * this.scale);
            }
            this.add(name2, sprite, Sprite.class);
            return sprite;
        }
        catch (GdxRuntimeException ex) {
            throw new GdxRuntimeException("No NinePatch, TextureRegion, or Texture registered with name: " + name2);
        }
    }

    public Drawable getDrawable(String name2) {
        Drawable drawable = this.optional(name2, Drawable.class);
        if (drawable != null) {
            return drawable;
        }
        try {
            TextureRegion textureRegion = this.getRegion(name2);
            if (textureRegion instanceof TextureAtlas.AtlasRegion) {
                TextureAtlas.AtlasRegion region = (TextureAtlas.AtlasRegion)textureRegion;
                if (region.findValue("split") != null) {
                    drawable = new NinePatchDrawable(this.getPatch(name2));
                } else if (region.rotate || region.packedWidth != region.originalWidth || region.packedHeight != region.originalHeight) {
                    drawable = new SpriteDrawable(this.getSprite(name2));
                }
            }
            if (drawable == null) {
                drawable = new TextureRegionDrawable(textureRegion);
                if (this.scale != 1.0f) {
                    this.scale(drawable);
                }
            }
        }
        catch (GdxRuntimeException textureRegion) {
            // empty catch block
        }
        if (drawable == null) {
            NinePatch patch2 = this.optional(name2, NinePatch.class);
            if (patch2 != null) {
                drawable = new NinePatchDrawable(patch2);
            } else {
                Sprite sprite = this.optional(name2, Sprite.class);
                if (sprite != null) {
                    drawable = new SpriteDrawable(sprite);
                } else {
                    throw new GdxRuntimeException("No Drawable, NinePatch, TextureRegion, Texture, or Sprite registered with name: " + name2);
                }
            }
        }
        if (drawable instanceof BaseDrawable) {
            ((BaseDrawable)drawable).setName(name2);
        }
        this.add(name2, drawable, Drawable.class);
        return drawable;
    }

    @Null
    public String find(Object resource2) {
        if (resource2 == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        ObjectMap<String, Object> typeResources = this.resources.get(resource2.getClass());
        if (typeResources == null) {
            return null;
        }
        return typeResources.findKey(resource2, true);
    }

    public Drawable newDrawable(String name2) {
        return this.newDrawable(this.getDrawable(name2));
    }

    public Drawable newDrawable(String name2, float r, float g, float b, float a) {
        return this.newDrawable(this.getDrawable(name2), new Color(r, g, b, a));
    }

    public Drawable newDrawable(String name2, Color tint) {
        return this.newDrawable(this.getDrawable(name2), tint);
    }

    public Drawable newDrawable(Drawable drawable) {
        if (drawable instanceof TiledDrawable) {
            return new TiledDrawable((TiledDrawable)drawable);
        }
        if (drawable instanceof TextureRegionDrawable) {
            return new TextureRegionDrawable((TextureRegionDrawable)drawable);
        }
        if (drawable instanceof NinePatchDrawable) {
            return new NinePatchDrawable((NinePatchDrawable)drawable);
        }
        if (drawable instanceof SpriteDrawable) {
            return new SpriteDrawable((SpriteDrawable)drawable);
        }
        throw new GdxRuntimeException("Unable to copy, unknown drawable type: " + drawable.getClass());
    }

    public Drawable newDrawable(Drawable drawable, float r, float g, float b, float a) {
        return this.newDrawable(drawable, new Color(r, g, b, a));
    }

    public Drawable newDrawable(Drawable drawable, Color tint) {
        Drawable newDrawable;
        if (drawable instanceof TextureRegionDrawable) {
            newDrawable = ((TextureRegionDrawable)drawable).tint(tint);
        } else if (drawable instanceof NinePatchDrawable) {
            newDrawable = ((NinePatchDrawable)drawable).tint(tint);
        } else if (drawable instanceof SpriteDrawable) {
            newDrawable = ((SpriteDrawable)drawable).tint(tint);
        } else {
            throw new GdxRuntimeException("Unable to copy, unknown drawable type: " + drawable.getClass());
        }
        if (newDrawable instanceof BaseDrawable) {
            BaseDrawable named = (BaseDrawable)newDrawable;
            if (drawable instanceof BaseDrawable) {
                named.setName(((BaseDrawable)drawable).getName() + " (" + tint + ")");
            } else {
                named.setName(" (" + tint + ")");
            }
        }
        return newDrawable;
    }

    public void scale(Drawable drawble) {
        drawble.setLeftWidth(drawble.getLeftWidth() * this.scale);
        drawble.setRightWidth(drawble.getRightWidth() * this.scale);
        drawble.setBottomHeight(drawble.getBottomHeight() * this.scale);
        drawble.setTopHeight(drawble.getTopHeight() * this.scale);
        drawble.setMinWidth(drawble.getMinWidth() * this.scale);
        drawble.setMinHeight(drawble.getMinHeight() * this.scale);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setEnabled(Actor actor, boolean enabled) {
        Object style;
        Method method = Skin.findMethod(actor.getClass(), "getStyle");
        if (method == null) {
            return;
        }
        try {
            style = method.invoke(actor, new Object[0]);
        }
        catch (Exception ignored) {
            return;
        }
        String name2 = this.find(style);
        if (name2 == null) {
            return;
        }
        name2 = name2.replace("-disabled", "") + (enabled ? "" : "-disabled");
        style = this.get(name2, style.getClass());
        method = Skin.findMethod(actor.getClass(), "setStyle");
        if (method == null) {
            return;
        }
        try {
            method.invoke(actor, style);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    @Null
    public TextureAtlas getAtlas() {
        return this.atlas;
    }

    @Override
    public void dispose() {
        if (this.atlas != null) {
            this.atlas.dispose();
        }
        for (ObjectMap objectMap : this.resources.values()) {
            for (Object resource2 : objectMap.values()) {
                if (!(resource2 instanceof Disposable)) continue;
                ((Disposable)resource2).dispose();
            }
        }
    }

    protected Json getJsonLoader(final FileHandle skinFile) {
        final Skin skin = this;
        Json json = new Json(){
            private static final String parentFieldName = "parent";

            @Override
            public <T> T readValue(Class<T> type2, Class elementType, JsonValue jsonData) {
                if (jsonData != null && jsonData.isString() && !ClassReflection.isAssignableFrom(CharSequence.class, type2)) {
                    return Skin.this.get(jsonData.asString(), type2);
                }
                return super.readValue(type2, elementType, jsonData);
            }

            @Override
            protected boolean ignoreUnknownField(Class type2, String fieldName) {
                return fieldName.equals(parentFieldName);
            }

            @Override
            public void readFields(Object object, JsonValue jsonMap) {
                if (jsonMap.has(parentFieldName)) {
                    String parentName = this.readValue(parentFieldName, String.class, jsonMap);
                    Class<?> parentType = object.getClass();
                    while (true) {
                        try {
                            this.copyFields(Skin.this.get(parentName, parentType), object);
                        }
                        catch (GdxRuntimeException ex) {
                            if ((parentType = parentType.getSuperclass()) != Object.class) continue;
                            SerializationException se = new SerializationException("Unable to find parent resource with name: " + parentName);
                            se.addTrace(jsonMap.child.trace());
                            throw se;
                        }
                        break;
                    }
                }
                super.readFields(object, jsonMap);
            }
        };
        json.setTypeName(null);
        json.setUsePrototypes(false);
        json.setSerializer(Skin.class, new Json.ReadOnlySerializer<Skin>(){

            @Override
            public Skin read(Json json, JsonValue typeToValueMap, Class ignored) {
                JsonValue valueMap = typeToValueMap.child;
                while (valueMap != null) {
                    try {
                        Class type2 = json.getClass(valueMap.name());
                        if (type2 == null) {
                            type2 = ClassReflection.forName(valueMap.name());
                        }
                        this.readNamedObjects(json, type2, valueMap);
                    }
                    catch (ReflectionException ex) {
                        throw new SerializationException(ex);
                    }
                    valueMap = valueMap.next;
                }
                return skin;
            }

            private void readNamedObjects(Json json, Class type2, JsonValue valueMap) {
                Class addType = type2 == TintedDrawable.class ? Drawable.class : type2;
                JsonValue valueEntry = valueMap.child;
                while (valueEntry != null) {
                    Object object = json.readValue(type2, valueEntry);
                    if (object != null) {
                        try {
                            Skin.this.add(valueEntry.name, object, addType);
                            if (addType != Drawable.class && ClassReflection.isAssignableFrom(Drawable.class, addType)) {
                                Skin.this.add(valueEntry.name, object, Drawable.class);
                            }
                        }
                        catch (Exception ex) {
                            throw new SerializationException("Error reading " + ClassReflection.getSimpleName(type2) + ": " + valueEntry.name, ex);
                        }
                    }
                    valueEntry = valueEntry.next;
                }
            }
        });
        json.setSerializer(BitmapFont.class, new Json.ReadOnlySerializer<BitmapFont>(){

            @Override
            public BitmapFont read(Json json, JsonValue jsonData, Class type2) {
                String path = json.readValue("file", String.class, jsonData);
                float scaledSize = json.readValue("scaledSize", Float.TYPE, Float.valueOf(-1.0f), jsonData).floatValue();
                Boolean flip = json.readValue("flip", Boolean.class, Boolean.valueOf(false), jsonData);
                Boolean markupEnabled = json.readValue("markupEnabled", Boolean.class, Boolean.valueOf(false), jsonData);
                Boolean useIntegerPositions = json.readValue("useIntegerPositions", Boolean.class, Boolean.valueOf(true), jsonData);
                FileHandle fontFile = skinFile.parent().child(path);
                if (!fontFile.exists()) {
                    fontFile = Gdx.files.internal(path);
                }
                if (!fontFile.exists()) {
                    throw new SerializationException("Font file not found: " + fontFile);
                }
                String regionName = fontFile.nameWithoutExtension();
                try {
                    FileHandle imageFile;
                    TextureRegion region;
                    Array<TextureRegion> regions = skin.getRegions(regionName);
                    BitmapFont font = regions != null ? new BitmapFont(new BitmapFont.BitmapFontData(fontFile, flip), regions, true) : ((region = skin.optional(regionName, TextureRegion.class)) != null ? new BitmapFont(fontFile, region, (boolean)flip) : ((imageFile = fontFile.parent().child(regionName + ".png")).exists() ? new BitmapFont(fontFile, imageFile, (boolean)flip) : new BitmapFont(fontFile, flip)));
                    font.getData().markupEnabled = markupEnabled;
                    font.setUseIntegerPositions(useIntegerPositions);
                    if (scaledSize != -1.0f) {
                        font.getData().setScale(scaledSize / font.getCapHeight());
                    }
                    return font;
                }
                catch (RuntimeException ex) {
                    throw new SerializationException("Error loading bitmap font: " + fontFile, ex);
                }
            }
        });
        json.setSerializer(Color.class, new Json.ReadOnlySerializer<Color>(){

            @Override
            public Color read(Json json, JsonValue jsonData, Class type2) {
                if (jsonData.isString()) {
                    return Skin.this.get(jsonData.asString(), Color.class);
                }
                String hex = json.readValue("hex", String.class, (String)null, jsonData);
                if (hex != null) {
                    return Color.valueOf(hex);
                }
                float r = json.readValue("r", Float.TYPE, Float.valueOf(0.0f), jsonData).floatValue();
                float g = json.readValue("g", Float.TYPE, Float.valueOf(0.0f), jsonData).floatValue();
                float b = json.readValue("b", Float.TYPE, Float.valueOf(0.0f), jsonData).floatValue();
                float a = json.readValue("a", Float.TYPE, Float.valueOf(1.0f), jsonData).floatValue();
                return new Color(r, g, b, a);
            }
        });
        json.setSerializer(TintedDrawable.class, new Json.ReadOnlySerializer(){

            @Override
            public Object read(Json json, JsonValue jsonData, Class type2) {
                String name2 = json.readValue("name", String.class, jsonData);
                Color color = json.readValue("color", Color.class, jsonData);
                if (color == null) {
                    throw new SerializationException("TintedDrawable missing color: " + jsonData);
                }
                Drawable drawable = Skin.this.newDrawable(name2, color);
                if (drawable instanceof BaseDrawable) {
                    BaseDrawable named = (BaseDrawable)drawable;
                    named.setName(jsonData.name + " (" + name2 + ", " + color + ")");
                }
                return drawable;
            }
        });
        for (ObjectMap.Entry entry : this.jsonClassTags) {
            json.addClassTag((String)entry.key, (Class)entry.value);
        }
        return json;
    }

    public ObjectMap<String, Class> getJsonClassTags() {
        return this.jsonClassTags;
    }

    @Null
    private static Method findMethod(Class type2, String name2) {
        for (Method method : ClassReflection.getMethods(type2)) {
            if (!method.getName().equals(name2)) continue;
            return method;
        }
        return null;
    }

    public static class TintedDrawable {
        public String name;
        public Color color;
    }
}

