/*
 * Decompiled with CFR 0.152.
 */
package com.unciv;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.UndoHandler;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000eJ\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0004J\u0010\u0010\u001a\u001a\u00020\n2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\nJ\u0006\u0010!\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\""}, d2={"Lcom/unciv/GUI;", "", "()V", "keyboardAvailable", "", "getKeyboardAvailable", "()Z", "keyboardAvailableCache", "Ljava/lang/Boolean;", "clearUndoCheckpoints", "", "getMap", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "getSelectedPlayer", "Lcom/unciv/logic/civilization/Civilization;", "getSettings", "Lcom/unciv/models/metadata/GameSettings;", "getUnitTable", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "getViewingPlayer", "getWorldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "getWorldScreenIfActive", "isAllowedChangeState", "isMyTurn", "isWorldLoaded", "openCivilopedia", "link", "", "pushScreen", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "resetToWorldScreen", "setUpdateWorldOnNextRender", "core"})
public final class GUI {
    @NotNull
    public static final GUI INSTANCE = new GUI();
    @Nullable
    private static Boolean keyboardAvailableCache;

    private GUI() {
    }

    public final void setUpdateWorldOnNextRender() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        if (worldScreen != null) {
            worldScreen.setShouldUpdate(true);
        }
    }

    public final void pushScreen(@NotNull BaseScreen screen) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        UncivGame.Companion.getCurrent().pushScreen(screen);
    }

    public final void resetToWorldScreen() {
        UncivGame.Companion.getCurrent().resetToWorldScreen();
    }

    @NotNull
    public final GameSettings getSettings() {
        return UncivGame.Companion.getCurrent().getSettings();
    }

    public final boolean isWorldLoaded() {
        return UncivGame.Companion.getCurrent().getWorldScreen() != null;
    }

    public final boolean isMyTurn() {
        if (!UncivGame.Companion.isCurrentInitialized() || !this.isWorldLoaded()) {
            return false;
        }
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.isPlayersTurn();
    }

    public final boolean isAllowedChangeState() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getCanChangeState();
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen;
    }

    @Nullable
    public final WorldScreen getWorldScreenIfActive() {
        return UncivGame.Companion.getCurrent().getWorldScreenIfActive();
    }

    @NotNull
    public final WorldMapHolder getMap() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getMapHolder();
    }

    @NotNull
    public final UnitTable getUnitTable() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getBottomUnitTable$core();
    }

    @NotNull
    public final Civilization getViewingPlayer() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getViewingCiv();
    }

    @NotNull
    public final Civilization getSelectedPlayer() {
        WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
        Intrinsics.checkNotNull(worldScreen);
        return worldScreen.getSelectedCiv();
    }

    public final void clearUndoCheckpoints() {
        block0: {
            WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
            if (worldScreen == null) break block0;
            UndoHandler.Companion.clearUndoCheckpoints(worldScreen);
        }
    }

    public final void openCivilopedia(@NotNull String link) {
        block0: {
            Intrinsics.checkNotNullParameter(link, "link");
            BaseScreen baseScreen = UncivGame.Companion.getCurrent().getScreen();
            if (baseScreen == null) break block0;
            baseScreen.openCivilopedia(link);
        }
    }

    public static /* synthetic */ void openCivilopedia$default(GUI gUI, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        gUI.openCivilopedia(string);
    }

    public final boolean getKeyboardAvailable() {
        if (keyboardAvailableCache == null && Gdx.input != null) {
            keyboardAvailableCache = Gdx.input.isPeripheralAvailable(Input.Peripheral.HardwareKeyboard);
        }
        Boolean bl = keyboardAvailableCache;
        return bl != null ? bl : false;
    }
}

