/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.unciv.app.desktop.DesktopFont;
import com.unciv.ui.components.fonts.FontFamilyData;
import com.unciv.ui.components.fonts.FontImplementation;
import com.unciv.ui.components.fonts.FontMetricsCommon;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unciv/app/desktop/DesktopFont;", "Lcom/unciv/ui/components/fonts/FontImplementation;", "()V", "font", "Ljava/awt/Font;", "metric", "Ljava/awt/FontMetrics;", "createFontFromFile", "path", "", "size", "", "getCharPixmap", "Lcom/badlogic/gdx/graphics/Pixmap;", "char", "", "symbolString", "getCharPixmapCommon", "measuredWidth", "getFontSize", "getMetrics", "Lcom/unciv/ui/components/fonts/FontMetricsCommon;", "getSystemFonts", "Lkotlin/sequences/Sequence;", "Lcom/unciv/ui/components/fonts/FontFamilyData;", "setFontFamily", "", "fontFamilyData", "desktop"})
public final class DesktopFont
implements FontImplementation {
    private Font font;
    private FontMetrics metric;

    @Override
    public void setFontFamily(@NotNull FontFamilyData fontFamilyData, int size2) {
        Intrinsics.checkNotNullParameter(fontFamilyData, "fontFamilyData");
        if (fontFamilyData.getFilePath() != null) {
            String string = fontFamilyData.getFilePath();
            Intrinsics.checkNotNull(string);
            this.font = this.createFontFromFile(string, size2);
        } else {
            this.font = new Font(fontFamilyData.getInvariantName(), 0, size2);
        }
        BufferedImage bufferedImage = new BufferedImage(1, 1, 6);
        Graphics2D graphics = bufferedImage.createGraphics();
        Font font = this.font;
        if (font == null) {
            Intrinsics.throwUninitializedPropertyAccessException("font");
            font = null;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Intrinsics.checkNotNullExpressionValue(fontMetrics, "getFontMetrics(...)");
        this.metric = fontMetrics;
        graphics.dispose();
    }

    private final Font createFontFromFile(String path, int size2) {
        Font font = null;
        try {
            File fontFile = Gdx.files.local(path).file();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font font2 = Font.createFont(0, fontFile).deriveFont((float)size2);
            Intrinsics.checkNotNullExpressionValue(font2, "deriveFont(...)");
            font = font2;
            ge.registerFont(font);
        }
        catch (Exception _) {
            font = new Font("", 0, size2);
        }
        return font;
    }

    @Override
    public int getFontSize() {
        Font font = this.font;
        if (font == null) {
            Intrinsics.throwUninitializedPropertyAccessException("font");
            font = null;
        }
        return font.getSize();
    }

    @Override
    @NotNull
    public Pixmap getCharPixmap(char c) {
        String string = String.valueOf(c);
        FontMetrics fontMetrics = this.metric;
        if (fontMetrics == null) {
            Intrinsics.throwUninitializedPropertyAccessException("metric");
            fontMetrics = null;
        }
        return this.getCharPixmapCommon(string, fontMetrics.charWidth(c));
    }

    @Override
    @NotNull
    public Pixmap getCharPixmap(@NotNull String symbolString) {
        Intrinsics.checkNotNullParameter(symbolString, "symbolString");
        FontMetrics fontMetrics = this.metric;
        if (fontMetrics == null) {
            Intrinsics.throwUninitializedPropertyAccessException("metric");
            fontMetrics = null;
        }
        return this.getCharPixmapCommon(symbolString, fontMetrics.stringWidth(symbolString));
    }

    private final Pixmap getCharPixmapCommon(String symbolString, int measuredWidth) {
        int width = measuredWidth;
        FontMetrics fontMetrics = this.metric;
        if (fontMetrics == null) {
            Intrinsics.throwUninitializedPropertyAccessException("metric");
            fontMetrics = null;
        }
        int height = fontMetrics.getHeight();
        if (width == 0) {
            Font font = this.font;
            if (font == null) {
                Intrinsics.throwUninitializedPropertyAccessException("font");
                font = null;
            }
            width = height = font.getSize();
        }
        BufferedImage bi = new BufferedImage(width, height, 6);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = this.font;
        if (font == null) {
            Intrinsics.throwUninitializedPropertyAccessException("font");
            font = null;
        }
        g.setFont(font);
        g.setColor(Color.WHITE);
        FontMetrics fontMetrics2 = this.metric;
        if (fontMetrics2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("metric");
            fontMetrics2 = null;
        }
        int n = fontMetrics2.getLeading();
        FontMetrics fontMetrics3 = this.metric;
        if (fontMetrics3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("metric");
            fontMetrics3 = null;
        }
        g.drawString(symbolString, 0, n + fontMetrics3.getAscent());
        Pixmap pixmap = new Pixmap(bi.getWidth(), bi.getHeight(), Pixmap.Format.RGBA8888);
        int[] data2 = bi.getRGB(0, 0, bi.getWidth(), bi.getHeight(), null, 0, bi.getWidth());
        int n2 = bi.getWidth();
        for (int i = 0; i < n2; ++i) {
            int n3 = bi.getHeight();
            for (int j = 0; j < n3; ++j) {
                pixmap.setColor(Integer.reverseBytes(data2[i + j * bi.getWidth()]));
                pixmap.drawPixel(i, j);
            }
        }
        g.dispose();
        return pixmap;
    }

    @Override
    @NotNull
    public Sequence<FontFamilyData> getSystemFonts() {
        StringBuilder stringBuilder = new StringBuilder().append(" CJK ");
        String string = System.getProperty("user.language");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        String cjkLanguage = stringBuilder.append(string2).toString();
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Intrinsics.checkNotNullExpressionValue(fontArray, "getAllFonts(...)");
        return SequencesKt.distinctBy(SequencesKt.map(SequencesKt.filter(ArraysKt.asSequence((Object[])fontArray), (Function1)new Function1<Font, Boolean>(cjkLanguage){
            final /* synthetic */ String $cjkLanguage;
            {
                this.$cjkLanguage = $cjkLanguage;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(Font it) {
                boolean bl;
                String string = it.getFontName();
                Intrinsics.checkNotNullExpressionValue(string, "getFontName(...)");
                if (StringsKt.contains$default((CharSequence)string, " CJK ", false, 2, null)) {
                    String string2 = it.getFontName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getFontName(...)");
                    if (!StringsKt.contains$default((CharSequence)string2, this.$cjkLanguage, false, 2, null)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }), getSystemFonts.2.INSTANCE), getSystemFonts.3.INSTANCE);
    }

    @Override
    @NotNull
    public FontMetricsCommon getMetrics() {
        FontMetrics fontMetrics = this.metric;
        if (fontMetrics == null) {
            Intrinsics.throwUninitializedPropertyAccessException("metric");
            fontMetrics = null;
        }
        float f = fontMetrics.getAscent();
        FontMetrics fontMetrics2 = this.metric;
        if (fontMetrics2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("metric");
            fontMetrics2 = null;
        }
        float f2 = fontMetrics2.getDescent();
        FontMetrics fontMetrics3 = this.metric;
        if (fontMetrics3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("metric");
            fontMetrics3 = null;
        }
        float f3 = fontMetrics3.getHeight();
        FontMetrics fontMetrics4 = this.metric;
        if (fontMetrics4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("metric");
            fontMetrics4 = null;
        }
        return new FontMetricsCommon(f, f2, f3, fontMetrics4.getLeading());
    }

    @Override
    @NotNull
    public BitmapFont getBitmapFont() {
        return FontImplementation.DefaultImpls.getBitmapFont(this);
    }
}

