/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.unciv.UncivGame;
import com.unciv.app.desktop.DiscordGameInfo;
import com.unciv.app.desktop.DiscordUpdater;
import com.unciv.app.desktop.HardenGdxAudio;
import com.unciv.app.desktop.UncivWindowListener;
import com.unciv.logic.GameInfo;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unciv/app/desktop/DesktopGame;", "Lcom/unciv/UncivGame;", "config", "Lcom/badlogic/gdx/backends/lwjgl3/Lwjgl3ApplicationConfiguration;", "(Lcom/badlogic/gdx/backends/lwjgl3/Lwjgl3ApplicationConfiguration;)V", "discordUpdater", "Lcom/unciv/app/desktop/DiscordUpdater;", "windowListener", "Lcom/unciv/app/desktop/UncivWindowListener;", "dispose", "", "installAudioHooks", "notifyTurnStarted", "desktop"})
public final class DesktopGame
extends UncivGame {
    @NotNull
    private DiscordUpdater discordUpdater;
    @NotNull
    private final UncivWindowListener windowListener;

    public DesktopGame(@NotNull Lwjgl3ApplicationConfiguration config2) {
        Intrinsics.checkNotNullParameter(config2, "config");
        super(false, 1, null);
        this.discordUpdater = new DiscordUpdater();
        this.windowListener = new UncivWindowListener();
        config2.setWindowListener(this.windowListener);
        this.discordUpdater.setOnUpdate(new Function0<DiscordGameInfo>(){

            @Override
            @Nullable
            public final DiscordGameInfo invoke() {
                if (!this.isInitialized()) {
                    return null;
                }
                DiscordGameInfo info2 = new DiscordGameInfo(null, null, 0, 7, null);
                GameInfo game = this.getGameInfo();
                if (game != null) {
                    info2.setGameTurn(game.getTurns());
                    info2.setGameLeader(game.getCurrentPlayerCivilization().getNation().getLeaderName());
                    info2.setGameNation(game.getCurrentPlayerCivilization().getNation().getName());
                }
                return info2;
            }
        });
        this.discordUpdater.startUpdates();
    }

    @Override
    public void installAudioHooks() {
        Application application = Gdx.app;
        Intrinsics.checkNotNull(application, "null cannot be cast to non-null type com.unciv.app.desktop.HardenGdxAudio");
        ((HardenGdxAudio)application).installHooks(this.getMusicController().getAudioLoopCallback(), this.getMusicController().getAudioExceptionHandler());
    }

    @Override
    public void notifyTurnStarted() {
        this.windowListener.turnStarted();
    }

    @Override
    public void dispose() {
        this.discordUpdater.stopUpdates();
        super.dispose();
    }
}

