/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowAdapter;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.unciv.utils.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFWNativeWin32;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/unciv/app/desktop/UncivWindowListener;", "Lcom/badlogic/gdx/backends/lwjgl3/Lwjgl3WindowAdapter;", "()V", "hasFocus", "", "window", "Lcom/badlogic/gdx/backends/lwjgl3/Lwjgl3Window;", "created", "", "flashWindow", "focusGained", "focusLost", "turnStarted", "Companion", "desktop"})
public final class UncivWindowListener
extends Lwjgl3WindowAdapter {
    @NotNull
    private static final Companion Companion;
    @Nullable
    private Lwjgl3Window window;
    private boolean hasFocus = true;
    @Nullable
    private static final User32 user32;

    @Override
    public void created(@Nullable Lwjgl3Window window) {
        this.window = window;
    }

    @Override
    public void focusLost() {
        this.hasFocus = false;
    }

    @Override
    public void focusGained() {
        this.hasFocus = true;
    }

    public final void turnStarted() {
        this.flashWindow();
    }

    private final void flashWindow() {
        try {
            if (this.window == null || this.hasFocus) {
                return;
            }
            if (user32 == null) {
                Lwjgl3Window lwjgl3Window = this.window;
                Intrinsics.checkNotNull(lwjgl3Window);
                lwjgl3Window.flash();
                return;
            }
            WinUser.FLASHWINFO flashwinfo = new WinUser.FLASHWINFO();
            Lwjgl3Window lwjgl3Window = this.window;
            Intrinsics.checkNotNull(lwjgl3Window);
            long hwnd = GLFWNativeWin32.glfwGetWin32Window(lwjgl3Window.getWindowHandle());
            flashwinfo.hWnd = new WinNT.HANDLE(Pointer.createConstant(hwnd));
            flashwinfo.dwFlags = 3;
            flashwinfo.uCount = 3;
            user32.FlashWindowEx(flashwinfo);
        }
        catch (Throwable e) {
            Log.INSTANCE.error("Error while notifying the user of their turn", e);
        }
    }

    static {
        User32 user32;
        Companion = new Companion(null);
        try {
            String string = System.getProperty("os.name");
            user32 = (string != null ? StringsKt.contains$default((CharSequence)string, "Windows", false, 2, null) : false) ? Native.load(User32.class) : null;
        }
        catch (UnsatisfiedLinkError e) {
            Log.INSTANCE.error("Error while initializing turn notifier", e);
            user32 = null;
        }
        UncivWindowListener.user32 = user32;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/app/desktop/UncivWindowListener$Companion;", "", "()V", "user32", "Lcom/sun/jna/platform/win32/User32;", "getUser32", "()Lcom/sun/jna/platform/win32/User32;", "desktop"})
    private static final class Companion {
        private Companion() {
        }

        @Nullable
        public final User32 getUser32() {
            return user32;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

