/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.unciv.app.desktop.UniqueDocsWriter;
import com.unciv.logic.map.mapunit.MapUnitCache;
import com.unciv.models.ruleset.unique.UniqueFlag;
import com.unciv.models.ruleset.unique.UniqueParameterType;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/unciv/app/desktop/UniqueDocsWriter;", "", "()V", "toLink", "", "string", "write", "", "Companion", "desktop"})
@SourceDebugExtension(value={"SMAP\nUniqueDocsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueDocsWriter.kt\ncom/unciv/app/desktop/UniqueDocsWriter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,110:1\n759#2,2:111\n775#2,4:113\n603#2:123\n1549#3:117\n1620#3,3:118\n37#4,2:121\n*S KotlinDebug\n*F\n+ 1 UniqueDocsWriter.kt\ncom/unciv/app/desktop/UniqueDocsWriter\n*L\n51#1:111,2\n51#1:113,4\n101#1:123\n85#1:117\n85#1:118,3\n85#1:121,2\n*E\n"})
public final class UniqueDocsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final boolean showUniqueOnOneTarget = false;
    private static final boolean showInheritedTargets = false;

    @NotNull
    public final String toLink(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        char[] cArray = new char[]{' '};
        return '#' + CollectionsKt.joinToString$default(StringsKt.split$default((CharSequence)string, cArray, false, 0, 6, null), "-", null, null, 0, null, toLink.1.INSTANCE, 30, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void write() {
        Object object;
        Sequence $this$associateWith$iv = CollectionsKt.asSequence((Iterable)EntriesMappings.entries$1);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence sequence = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void target;
            Object element$iv$iv = iterator2.next();
            UniqueTarget uniqueTarget = (UniqueTarget)((Object)element$iv$iv);
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            List list2 = SequencesKt.toList(SequencesKt.distinct(SequencesKt.flatMap(UniqueDocsWriter.Companion.allTargets((UniqueTarget)target), write.targetTypesToUniques.2.1.INSTANCE)));
            object.put(t, list2);
        }
        Map targetTypesToUniques2 = result$iv;
        int capacity = 25 + targetTypesToUniques2.size() + EntriesMappings.entries$0.size() * 16;
        ArrayList lines2 = new ArrayList(capacity);
        ((Collection)lines2).add("# Uniques");
        ((Collection)lines2).add("An overview of uniques can be found [here](../Developers/Uniques.md)");
        ((Collection)lines2).add("\nSimple unique parameters are explained by mouseover. Complex parameters are explained in [Unique parameter types](../Unique-parameters)");
        ((Collection)lines2).add("");
        for (Map.Entry entry : targetTypesToUniques2.entrySet()) {
            UniqueTarget targetType = (UniqueTarget)((Object)entry.getKey());
            List uniqueTypes2 = (List)entry.getValue();
            if (uniqueTypes2.isEmpty()) continue;
            ((Collection)lines2).add("## " + targetType.name() + " uniques");
            if (((CharSequence)targetType.getDocumentationString()).length() > 0) {
                ((Collection)lines2).add("!!! note \"\"\n\n    " + targetType.getDocumentationString() + '\n');
            }
            for (UniqueType uniqueType : uniqueTypes2) {
                if (uniqueType.getDeprecationAnnotation() != null) continue;
                String uniqueText = targetType.getModifierType() != UniqueTarget.ModifierType.None ? "&lt;" + uniqueType.getText() + "&gt;" : uniqueType.getText();
                ((Collection)lines2).add("??? example  \"" + uniqueText + '\"');
                if (uniqueType.getDocDescription() != null) {
                    ((Collection)lines2).add('\t' + uniqueType.getDocDescription());
                }
                if (!((Collection)uniqueType.getParameterTypeMap()).isEmpty()) {
                    void $this$toTypedArray$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = uniqueType.getParameterTypeMap();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        List list3 = (List)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.add(((UniqueParameterType)((Object)CollectionsKt.first(it))).getDocExample());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] paramExamples = thisCollection$iv.toArray(new String[0]);
                    ((Collection)lines2).add("\tExample: \"" + TranslationsKt.fillPlaceholders(uniqueText, Arrays.copyOf(paramExamples, paramExamples.length)) + "\"\n");
                }
                if (uniqueType.getFlags().contains((Object)UniqueFlag.AcceptsSpeedModifier)) {
                    ((Collection)lines2).add("\tThis unique's effect can be modified with &lt;" + UniqueType.ModifiedByGameSpeed.getText() + "&gt;");
                }
                if (MapUnitCache.Companion.getUnitMovementUniques().contains((Object)uniqueType)) {
                    ((Collection)lines2).add("\tDue to performance considerations, this unique is cached, thus conditionals that may change within a turn may not work.");
                }
                ((Collection)lines2).add("\tApplicable to: " + SequencesKt.joinToString$default(SequencesKt.sorted(UniqueDocsWriter.Companion.allTargets(uniqueType)), null, null, null, 0, null, null, 63, null));
                ((Collection)lines2).add("");
            }
        }
        ((Collection)lines2).add("");
        Sequence sequence2 = CollectionsKt.asSequence((Iterable)EntriesMappings.entries$2);
        boolean $i$f$sortedBy = false;
        Iterator iterator3 = SequencesKt.sortedWith(sequence2, new Comparator(){

            public final int compare(T a, T b) {
                UniqueParameterType it = (UniqueParameterType)((Object)a);
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getParameterName());
                it = (UniqueParameterType)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getParameterName()));
            }
        }).iterator();
        while (iterator3.hasNext()) {
            UniqueParameterType uniqueParameterType = (UniqueParameterType)((Object)iterator3.next());
            if (uniqueParameterType.getDocDescription() == null) continue;
            String string = uniqueParameterType.getDocDescription();
            Intrinsics.checkNotNull(string);
            String punctuation = CharsKt.getCategory(StringsKt.last(string)) == CharsKt.getCategory('.') ? "" : ".";
            ((Collection)lines2).add("*[" + uniqueParameterType.getParameterName() + "]: " + uniqueParameterType.getDocDescription() + punctuation);
        }
        FilesKt.writeText$default(new File("../../docs/Modders/uniques.md"), CollectionsKt.joinToString$default(lines2, "\n", null, null, 0, null, null, 62, null), null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\bH\u0002J\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\tH\u0002J\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0007*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/app/desktop/UniqueDocsWriter$Companion;", "", "()V", "showInheritedTargets", "", "showUniqueOnOneTarget", "allTargets", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "Lcom/unciv/models/ruleset/unique/UniqueType;", "allUniqueTypes", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        private final Sequence<UniqueTarget> allTargets(UniqueTarget $this$allTargets) {
            return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UniqueTarget>, Continuation<? super Unit>, Object>($this$allTargets, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ UniqueTarget $this_allTargets;
                {
                    this.$this_allTargets = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            SequenceScope $this$sequence = (SequenceScope)this.L$0;
                            this.label = 1;
                            Object object3 = $this$sequence.yield(this.$this_allTargets, this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super UniqueTarget>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super UniqueTarget> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        private final Sequence<UniqueTarget> allTargets(UniqueType $this$allTargets) {
            return SequencesKt.distinct(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)$this$allTargets.getTargetTypes()), allTargets.2.INSTANCE));
        }

        private final Sequence<UniqueType> allUniqueTypes(UniqueTarget $this$allUniqueTypes) {
            return SequencesKt.filter(CollectionsKt.asSequence((Iterable)EntriesMappings.entries$0), (Function1)new Function1<UniqueType, Boolean>($this$allUniqueTypes){
                final /* synthetic */ UniqueTarget $this_allUniqueTypes;
                {
                    this.$this_allUniqueTypes = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull UniqueType it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                    return it.getTargetTypes().contains((Object)((Object)this.$this_allUniqueTypes));
                }
            });
        }

        public static final /* synthetic */ Sequence access$allUniqueTypes(Companion $this, UniqueTarget $receiver) {
            return $this.allUniqueTypes($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<UniqueType> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])UniqueType.values());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<UniqueType> entries$0;
        public static final /* synthetic */ EnumEntries<UniqueTarget> entries$1;
        public static final /* synthetic */ EnumEntries<UniqueParameterType> entries$2;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])UniqueType.values());
            entries$1 = EnumEntriesKt.enumEntries((Enum[])UniqueTarget.values());
            entries$2 = EnumEntriesKt.enumEntries((Enum[])UniqueParameterType.values());
        }
    }
}

