/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import com.unciv.logic.BackwardCompatibility;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.managers.GreatPersonManager;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitPromotions;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.Ruleset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\n\u0010\f\u001a\u00020\u0004*\u00020\rJ\n\u0010\u000e\u001a\u00020\u0004*\u00020\rJ\n\u0010\u000f\u001a\u00020\u0004*\u00020\rJ\f\u0010\u0010\u001a\u00020\u0004*\u00020\rH\u0002J\n\u0010\u0011\u001a\u00020\u0004*\u00020\rJ\n\u0010\u0012\u001a\u00020\u0004*\u00020\rJ\n\u0010\u0013\u001a\u00020\u0004*\u00020\rJ\f\u0010\u0014\u001a\u00020\u0004*\u00020\rH\u0002J\f\u0010\u0015\u001a\u00020\u0004*\u00020\rH\u0002J\f\u0010\u0016\u001a\u00020\u0004*\u00020\rH\u0002J\u001a\u0010\u0017\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u001c\u0010\u001b\u001a\u00020\u0004*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\n\u0010\u001f\u001a\u00020\u0004*\u00020 \u00a8\u0006!"}, d2={"Lcom/unciv/logic/BackwardCompatibility;", "", "()V", "changeBuildingNameIfNotInRuleset", "", "ruleSet", "Lcom/unciv/models/ruleset/Ruleset;", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "oldBuildingName", "", "newBuildingName", "convertFortify", "Lcom/unciv/logic/GameInfo;", "ensureUnitIds", "guaranteeUnitPromotions", "handleMissingReferencesForEachCity", "migrateGreatGeneralPools", "migrateToTileHistory", "removeMissingModReferences", "removeOldPillagedImprovements", "removeTechAndPolicies", "removeUnitsAndPromotions", "replaceDiplomacyFlag", "old", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyFlags;", "new", "replaceUpdatedTechName", "Lcom/unciv/logic/civilization/managers/TechManager;", "oldTechName", "newTechName", "updateDeprecations", "Lcom/unciv/models/ruleset/ModOptions;", "core"})
@SourceDebugExtension(value={"SMAP\nBackwardCompatibility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackwardCompatibility.kt\ncom/unciv/logic/BackwardCompatibility\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1549#2:212\n1620#2,3:213\n1360#2:216\n1446#2,5:217\n1855#2,2:222\n1373#2:225\n1461#2,5:226\n1#3:224\n*S KotlinDebug\n*F\n+ 1 BackwardCompatibility.kt\ncom/unciv/logic/BackwardCompatibility\n*L\n130#1:212\n130#1:213,3\n167#1:216\n167#1:217,5\n167#1:222,2\n206#1:225\n206#1:226,5\n*E\n"})
public final class BackwardCompatibility {
    @NotNull
    public static final BackwardCompatibility INSTANCE = new BackwardCompatibility();

    private BackwardCompatibility() {
    }

    public final void removeMissingModReferences(@NotNull GameInfo $this$removeMissingModReferences) {
        Intrinsics.checkNotNullParameter($this$removeMissingModReferences, "<this>");
        $this$removeMissingModReferences.getTileMap().removeMissingTerrainModReferences($this$removeMissingModReferences.getRuleset());
        this.removeUnitsAndPromotions($this$removeMissingModReferences);
        this.removeOldPillagedImprovements($this$removeMissingModReferences);
        this.handleMissingReferencesForEachCity($this$removeMissingModReferences);
        this.removeTechAndPolicies($this$removeMissingModReferences);
    }

    public final void migrateGreatGeneralPools(@NotNull GameInfo $this$migrateGreatGeneralPools) {
        Intrinsics.checkNotNullParameter($this$migrateGreatGeneralPools, "<this>");
        for (Civilization civ : $this$migrateGreatGeneralPools.getCivilizations()) {
            GreatPersonManager $this$migrateGreatGeneralPools_u24lambda_u240 = civ.getGreatPeople();
            boolean bl = false;
            if ($this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneral() >= ((Number)$this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneralCounter().get((Object)"Great General")).intValue()) {
                ((Map)$this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneralCounter()).put("Great General", $this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneral());
                continue;
            }
            $this$migrateGreatGeneralPools_u24lambda_u240.setPointsForNextGreatGeneral(((Number)$this$migrateGreatGeneralPools_u24lambda_u240.getPointsForNextGreatGeneralCounter().get((Object)"Great General")).intValue());
        }
    }

    private final void removeUnitsAndPromotions(GameInfo $this$removeUnitsAndPromotions) {
        for (Tile tile : $this$removeUnitsAndPromotions.getTileMap().getValues()) {
            for (MapUnit unit : SequencesKt.toList(tile.getUnits())) {
                if (!$this$removeUnitsAndPromotions.getRuleset().getUnits().containsKey(unit.getName())) {
                    tile.removeUnit(unit);
                }
                for (String promotion2 : CollectionsKt.toList((Iterable)unit.getPromotions().getPromotions())) {
                    if ($this$removeUnitsAndPromotions.getRuleset().getUnitPromotions().containsKey(promotion2)) continue;
                    unit.getPromotions().getPromotions().remove(promotion2);
                }
            }
        }
    }

    private final void removeOldPillagedImprovements(GameInfo $this$removeOldPillagedImprovements) {
        if (!$this$removeOldPillagedImprovements.getRuleset().getTileImprovements().containsKey("Repair")) {
            for (Tile tile : $this$removeOldPillagedImprovements.getTileMap().getValues()) {
                if (tile.getRoadIsPillaged()) {
                    tile.setRoadStatus(RoadStatus.None);
                    tile.setRoadIsPillaged(false);
                }
                if (!tile.getImprovementIsPillaged()) continue;
                tile.setImprovement(null);
                tile.setImprovementIsPillaged(false);
            }
        }
    }

    private final void handleMissingReferencesForEachCity(GameInfo $this$handleMissingReferencesForEachCity) {
        Iterator iterator2 = SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)$this$handleMissingReferencesForEachCity.getCivilizations()), handleMissingReferencesForEachCity.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            City city2 = (City)iterator2.next();
            for (String building : CollectionsKt.toList((Iterable)city2.getCityConstructions().getBuiltBuildings())) {
                if ($this$handleMissingReferencesForEachCity.getRuleset().getBuildings().containsKey(building)) continue;
                city2.getCityConstructions().getBuiltBuildings().remove(building);
            }
            for (String construction2 : CollectionsKt.toList((Iterable)city2.getCityConstructions().getConstructionQueue())) {
                if (!BackwardCompatibility.handleMissingReferencesForEachCity$isInvalidConstruction($this$handleMissingReferencesForEachCity, construction2)) continue;
                city2.getCityConstructions().getConstructionQueue().remove(construction2);
            }
            Set<String> set2 = city2.getCityConstructions().getInProgressConstructions().keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            for (String construction2 : CollectionsKt.toList((Iterable)set2)) {
                Intrinsics.checkNotNull(construction2);
                if (!BackwardCompatibility.handleMissingReferencesForEachCity$isInvalidConstruction($this$handleMissingReferencesForEachCity, construction2)) continue;
                city2.getCityConstructions().getInProgressConstructions().remove(construction2);
            }
        }
    }

    private final void removeTechAndPolicies(GameInfo $this$removeTechAndPolicies) {
        for (Civilization civInfo : $this$removeTechAndPolicies.getCivilizations()) {
            for (String tech : CollectionsKt.toList((Iterable)civInfo.getTech().getTechsResearched())) {
                if ($this$removeTechAndPolicies.getRuleset().getTechnologies().containsKey(tech)) continue;
                civInfo.getTech().getTechsResearched().remove(tech);
            }
            for (String policy2 : CollectionsKt.toList((Iterable)civInfo.getPolicies().getAdoptedPolicies$core())) {
                if ($this$removeTechAndPolicies.getRuleset().getPolicies().containsKey(policy2)) continue;
                civInfo.getPolicies().getAdoptedPolicies$core().remove(policy2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void changeBuildingNameIfNotInRuleset(Ruleset ruleSet, CityConstructions cityConstructions, String oldBuildingName, String newBuildingName) {
        if (ruleSet.getBuildings().containsKey(oldBuildingName)) {
            return;
        }
        if (cityConstructions.isBuilt(oldBuildingName)) {
            cityConstructions.removeBuilding(oldBuildingName);
            cityConstructions.addBuilding(newBuildingName);
        }
        if (!cityConstructions.isBuilt(newBuildingName) && !cityConstructions.getConstructionQueue().contains(newBuildingName)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = cityConstructions.getConstructionQueue();
            CityConstructions cityConstructions2 = cityConstructions;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Intrinsics.areEqual(it, oldBuildingName) ? newBuildingName : it);
            }
            cityConstructions2.setConstructionQueue(CollectionsKt.toMutableList((List)destination$iv$iv));
        } else {
            cityConstructions.getConstructionQueue().remove(oldBuildingName);
        }
        if (cityConstructions.getInProgressConstructions().containsKey(oldBuildingName)) {
            if (!cityConstructions.isBuilt(newBuildingName) && !cityConstructions.getInProgressConstructions().containsKey(newBuildingName)) {
                Map map2 = cityConstructions.getInProgressConstructions();
                Integer n = cityConstructions.getInProgressConstructions().get(oldBuildingName);
                Intrinsics.checkNotNull(n);
                map2.put(newBuildingName, n);
            }
            cityConstructions.getInProgressConstructions().remove(oldBuildingName);
        }
    }

    private final void replaceUpdatedTechName(TechManager $this$replaceUpdatedTechName, String oldTechName, String newTechName) {
        int index;
        if ($this$replaceUpdatedTechName.getTechsResearched().contains(oldTechName)) {
            $this$replaceUpdatedTechName.getTechsResearched().remove(oldTechName);
            $this$replaceUpdatedTechName.getTechsResearched().add(newTechName);
        }
        if ((index = $this$replaceUpdatedTechName.getTechsToResearch().indexOf(oldTechName)) >= 0) {
            $this$replaceUpdatedTechName.getTechsToResearch().set(index, newTechName);
        }
        if (((Map)$this$replaceUpdatedTechName.getTechsInProgress()).containsKey(oldTechName)) {
            ((Map)$this$replaceUpdatedTechName.getTechsInProgress()).put(newTechName, $this$replaceUpdatedTechName.researchOfTech(oldTechName));
            $this$replaceUpdatedTechName.getTechsInProgress().remove(oldTechName);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void replaceDiplomacyFlag(@NotNull GameInfo $this$replaceDiplomacyFlag, @NotNull DiplomacyFlags old, @NotNull DiplomacyFlags diplomacyFlags) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$replaceDiplomacyFlag, "<this>");
        Intrinsics.checkNotNullParameter((Object)old, "old");
        Intrinsics.checkNotNullParameter((Object)diplomacyFlags, "new");
        Iterable $this$flatMap$iv = $this$replaceDiplomacyFlag.getCivilizations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Civilization civ = (Civilization)element$iv$iv;
            boolean bl = false;
            Collection<DiplomacyManager> collection = civ.getDiplomacy().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DiplomacyManager it = (DiplomacyManager)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            BackwardCompatibility.replaceDiplomacyFlag$replaceFlag(it, old, diplomacyFlags);
        }
    }

    public final void guaranteeUnitPromotions(@NotNull GameInfo $this$guaranteeUnitPromotions) {
        Intrinsics.checkNotNullParameter($this$guaranteeUnitPromotions, "<this>");
        for (Tile tileInfo : $this$guaranteeUnitPromotions.getTileMap().getValues()) {
            Iterator<MapUnit> iterator2 = tileInfo.getUnits().iterator();
            while (iterator2.hasNext()) {
                MapUnit unit = iterator2.next();
                for (String startingPromo : unit.getBaseUnit().getPromotions()) {
                    UnitPromotions unitPromotions = unit.getPromotions();
                    Intrinsics.checkNotNull(startingPromo);
                    unitPromotions.addPromotion(startingPromo, true);
                }
            }
        }
    }

    public final void updateDeprecations(@NotNull ModOptions $this$updateDeprecations) {
        Intrinsics.checkNotNullParameter($this$updateDeprecations, "<this>");
    }

    public final void convertFortify(@NotNull GameInfo $this$convertFortify) {
        Intrinsics.checkNotNullParameter($this$convertFortify, "<this>");
        Regex reg = new Regex("^Fortify\\s+(\\d+)([\\w\\s]*)");
        for (Civilization civInfo : $this$convertFortify.getCivilizations()) {
            Iterator<MapUnit> iterator2 = civInfo.getUnits().getCivUnits().iterator();
            while (iterator2.hasNext()) {
                MapUnit unit = iterator2.next();
                if (unit.getAction() == null) continue;
                String string = unit.getAction();
                Intrinsics.checkNotNull(string);
                if (!reg.matches(string)) continue;
                String string2 = unit.getAction();
                Intrinsics.checkNotNull(string2);
                MatchResult matchResult = Regex.find$default(reg, string2, 0, 2, null);
                Intrinsics.checkNotNull(matchResult);
                MatchResult.Destructured destructured = matchResult.getDestructured();
                String turns = destructured.getMatch().getGroupValues().get(1);
                String heal = destructured.getMatch().getGroupValues().get(2);
                unit.setTurnsFortified(Integer.parseInt(turns));
                unit.setAction("Fortify" + heal);
            }
        }
    }

    public final void migrateToTileHistory(@NotNull GameInfo $this$migrateToTileHistory) {
        Intrinsics.checkNotNullParameter($this$migrateToTileHistory, "<this>");
        if ($this$migrateToTileHistory.getHistoryStartTurn() >= 0) {
            return;
        }
        Iterator iterator2 = SequencesKt.flatMap($this$migrateToTileHistory.getCities(), migrateToTileHistory.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            Tile tile = (Tile)iterator2.next();
            tile.getHistory().recordTakeOwnership(tile);
        }
        $this$migrateToTileHistory.setHistoryStartTurn($this$migrateToTileHistory.getTurns());
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureUnitIds(@NotNull GameInfo $this$ensureUnitIds) {
        void $this$flatMapTo$iv$iv;
        Object it;
        Intrinsics.checkNotNullParameter($this$ensureUnitIds, "<this>");
        if ($this$ensureUnitIds.getLastUnitId() == 0) {
            Object object;
            Sequence sequence = SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)$this$ensureUnitIds.getTileMap().getValues()), ensureUnitIds.1.INSTANCE);
            GameInfo gameInfo2 = $this$ensureUnitIds;
            Iterator iterator2 = sequence.iterator();
            if (!iterator2.hasNext()) {
                object = null;
            } else {
                it = (MapUnit)iterator2.next();
                boolean bl = false;
                it = ((MapUnit)it).getId();
                while (iterator2.hasNext()) {
                    Object it2 = (MapUnit)iterator2.next();
                    $i$a$-maxOfOrNull-BackwardCompatibility$ensureUnitIds$2 = false;
                    if (it.compareTo(it2 = (Comparable)Integer.valueOf(((MapUnit)it2).getId())) >= 0) continue;
                    it = it2;
                }
                object = it;
            }
            Integer n = (Integer)object;
            gameInfo2.setLastUnitId(n != null ? RangesKt.coerceAtLeast(n, 0) : 0);
        }
        Iterable $this$flatMap$iv = $this$ensureUnitIds.getTileMap().getValues();
        boolean $i$f$flatMapSequence = false;
        it = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Tile it3 = (Tile)element$iv$iv;
            boolean bl = false;
            Sequence<MapUnit> list$iv$iv = it3.getUnits();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (MapUnit unit : (List)destination$iv$iv) {
            if (unit.getId() != -1) continue;
            $this$ensureUnitIds.setLastUnitId($this$ensureUnitIds.getLastUnitId() + 1);
            unit.setId($this$ensureUnitIds.getLastUnitId());
        }
    }

    private static final boolean handleMissingReferencesForEachCity$isInvalidConstruction(GameInfo $this_handleMissingReferencesForEachCity, String construction2) {
        return !$this_handleMissingReferencesForEachCity.getRuleset().getBuildings().containsKey(construction2) && !$this_handleMissingReferencesForEachCity.getRuleset().getUnits().containsKey(construction2) && !PerpetualConstruction.Companion.getPerpetualConstructionsMap().containsKey(construction2);
    }

    private static final void replaceDiplomacyFlag$replaceFlag(DiplomacyManager $this$replaceDiplomacyFlag_u24replaceFlag, DiplomacyFlags $old, DiplomacyFlags $new) {
        if ($this$replaceDiplomacyFlag_u24replaceFlag.hasFlag($old)) {
            int value = $this$replaceDiplomacyFlag_u24replaceFlag.getFlag($old);
            $this$replaceDiplomacyFlag_u24replaceFlag.removeFlag($old);
            $this$replaceDiplomacyFlag_u24replaceFlag.setFlag($new, value);
        }
    }
}

