/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import java.time.LocalDate;
import java.time.Month;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/HolidayDates;", "", "()V", "getHolidayByDate", "Lcom/unciv/logic/HolidayDates$Holidays;", "date", "Ljava/time/LocalDate;", "getHolidayByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "holiday", "year", "", "getMonth", "Ljava/time/Month;", "DateRange", "Holidays", "core"})
@SourceDebugExtension(value={"SMAP\nHolidayDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,75:1\n1282#2,2:76\n*S KotlinDebug\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates\n*L\n66#1:76,2\n*E\n"})
public final class HolidayDates {
    @NotNull
    public static final HolidayDates INSTANCE = new HolidayDates();

    private HolidayDates() {
    }

    @NotNull
    public final DateRange getHolidayByYear(@NotNull Holidays holiday, int year2) {
        Intrinsics.checkNotNullParameter((Object)holiday, "holiday");
        return holiday.getByYear(year2);
    }

    @Nullable
    public final Holidays getHolidayByDate(@NotNull LocalDate date) {
        Object object;
        block3: {
            block4: {
                Intrinsics.checkNotNullParameter(date, "date");
                object = System.getProperty("easterEgg");
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                Holidays holidays = Holidays.Companion.safeValueOf(it);
                object = holidays;
                if (holidays != null) break block3;
            }
            Holidays[] $this$firstOrNull$iv = Holidays.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Holidays element$iv;
                Holidays it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!it.getByYear(date.getYear()).contains((Comparable)date)) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        return object;
    }

    public static /* synthetic */ Holidays getHolidayByDate$default(HolidayDates holidayDates, LocalDate localDate, int n, Object object) {
        if ((n & 1) != 0) {
            LocalDate localDate2 = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue(localDate2, "now(...)");
            localDate = localDate2;
        }
        return holidayDates.getHolidayByDate(localDate);
    }

    @NotNull
    public final Month getMonth() {
        Month month;
        Month month2;
        Month month3;
        Object object = System.getProperty("month");
        if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            month3 = Month.of(it);
        } else {
            month3 = month2 = null;
        }
        if (month2 == null) {
            Month month4 = LocalDate.now().getMonth();
            month = month4;
            Intrinsics.checkNotNullExpressionValue(month4, "getMonth(...)");
        } else {
            month = month2;
        }
        return month;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/unciv/logic/HolidayDates$DateRange;", "Lkotlin/ranges/ClosedRange;", "Ljava/time/LocalDate;", "start", "endInclusive", "(Ljava/time/LocalDate;Ljava/time/LocalDate;)V", "getEndInclusive", "()Ljava/time/LocalDate;", "getStart", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "core"})
    public static final class DateRange
    implements ClosedRange<LocalDate> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final LocalDate start;
        @NotNull
        private final LocalDate endInclusive;

        public DateRange(@NotNull LocalDate start2, @NotNull LocalDate endInclusive) {
            Intrinsics.checkNotNullParameter(start2, "start");
            Intrinsics.checkNotNullParameter(endInclusive, "endInclusive");
            this.start = start2;
            this.endInclusive = endInclusive;
        }

        @Override
        @NotNull
        public LocalDate getStart() {
            return this.start;
        }

        @Override
        @NotNull
        public LocalDate getEndInclusive() {
            return this.endInclusive;
        }

        @NotNull
        public String toString() {
            return this.getStart() + ".." + this.getEndInclusive();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DateRange)) {
                return false;
            }
            return Intrinsics.areEqual(this.getStart(), ((DateRange)other).getStart()) && Intrinsics.areEqual(this.getEndInclusive(), ((DateRange)other).getEndInclusive());
        }

        public int hashCode() {
            return 31 * this.getStart().hashCode() + this.getEndInclusive().hashCode();
        }

        @Override
        public boolean contains(@NotNull LocalDate value) {
            return ClosedRange.DefaultImpls.contains(this, (Comparable)value);
        }

        @Override
        public boolean isEmpty() {
            return ClosedRange.DefaultImpls.isEmpty(this);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/HolidayDates$DateRange$Companion;", "", "()V", "of", "Lcom/unciv/logic/HolidayDates$DateRange;", "date", "Ljava/time/LocalDate;", "duration", "", "year", "month", "day", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DateRange of(@NotNull LocalDate date) {
                Intrinsics.checkNotNullParameter(date, "date");
                return new DateRange(date, date);
            }

            @NotNull
            public final DateRange of(int year2, int month, int day2) {
                LocalDate localDate = LocalDate.of(year2, month, day2);
                Intrinsics.checkNotNullExpressionValue(localDate, "of(...)");
                return this.of(localDate);
            }

            @NotNull
            public final DateRange of(@NotNull LocalDate date, int duration) {
                Intrinsics.checkNotNullParameter(date, "date");
                LocalDate localDate = date.plusDays((long)duration - 1L);
                Intrinsics.checkNotNullExpressionValue(localDate, "plusDays(...)");
                return new DateRange(date, localDate);
            }

            @NotNull
            public final DateRange of(int year2, int month, int day2, int duration) {
                LocalDate localDate = LocalDate.of(year2, month, day2);
                Intrinsics.checkNotNullExpressionValue(localDate, "of(...)");
                return this.of(localDate, duration);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays;", "", "(Ljava/lang/String;I)V", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "Easter", "Samhain", "Xmas", "Companion", "core"})
    public static final abstract class Holidays
    extends Enum<Holidays> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ Holidays Easter;
        public static final /* enum */ Holidays Samhain;
        public static final /* enum */ Holidays Xmas;
        private static final /* synthetic */ Holidays[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Holidays() {
        }

        @NotNull
        public abstract DateRange getByYear(int var1);

        public static Holidays[] values() {
            return (Holidays[])$VALUES.clone();
        }

        public static Holidays valueOf(String value) {
            return Enum.valueOf(Holidays.class, value);
        }

        @NotNull
        public static EnumEntries<Holidays> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Holidays(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            Easter = new Easter("Easter", 0);
            Samhain = new Samhain("Samhain", 1);
            Xmas = new Xmas("Xmas", 2);
            $VALUES = holidaysArray = new Holidays[]{Holidays.Easter, Holidays.Samhain, Holidays.Xmas};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Companion;", "", "()V", "safeValueOf", "Lcom/unciv/logic/HolidayDates$Holidays;", "name", "", "core"})
        @SourceDebugExtension(value={"SMAP\nHolidayDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,75:1\n1282#2,2:76\n*S KotlinDebug\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Companion\n*L\n40#1:76,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Holidays safeValueOf(@NotNull String name2) {
                Holidays holidays;
                block1: {
                    Intrinsics.checkNotNullParameter(name2, "name");
                    Holidays[] $this$firstOrNull$iv = Holidays.values();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Holidays element$iv;
                        Holidays it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.name(), name2)) continue;
                        holidays = element$iv;
                        break block1;
                    }
                    holidays = null;
                }
                return holidays;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Easter;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Easter
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Easter() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                int a = year2 % 19;
                int b = year2 / 100;
                int c = year2 % 100;
                int d = b / 4;
                int e = b % 4;
                int g = (8 * b + 13) / 25;
                int h = (19 * a + b - d - g + 15) % 30;
                int i = c / 4;
                int k = c % 4;
                int l = (32 + 2 * e + 2 * i - h - k) % 7;
                int m = (a + 11 * h + 19 * l) / 433;
                int n = (h + l - 7 * m + 90) / 25;
                int p = (h + l - 7 * m + 33 * n + 19) % 32;
                LocalDate sunday = LocalDate.of(year2, n, p);
                LocalDate localDate = sunday.minusDays(2L);
                Intrinsics.checkNotNullExpressionValue(localDate, "minusDays(...)");
                return DateRange.Companion.of(localDate, 4);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Samhain;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Samhain
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Samhain() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 10, 31);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Xmas;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Xmas
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Xmas() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 12, 24, 4);
            }
        }
    }
}

