/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lcom/unciv/logic/IdChecker;", "", "()V", "checkAndReturnGameUuid", "", "gameId", "checkAndReturnPlayerUuid", "playerId", "checkAndReturnUuiId", "id", "prefix", "getCheckDigit", "", "uuid", "core"})
@SourceDebugExtension(value={"SMAP\nIdChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdChecker.kt\ncom/unciv/logic/IdChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class IdChecker {
    @NotNull
    public static final IdChecker INSTANCE = new IdChecker();

    private IdChecker() {
    }

    @NotNull
    public final String checkAndReturnPlayerUuid(@NotNull String playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        return this.checkAndReturnUuiId(playerId, "P");
    }

    @NotNull
    public final String checkAndReturnGameUuid(@NotNull String gameId) {
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        return this.checkAndReturnUuiId(gameId, "G");
    }

    private final String checkAndReturnUuiId(String id, String prefix2) {
        String trimmedPlayerId = ((Object)StringsKt.trim((CharSequence)id)).toString();
        if (trimmedPlayerId.length() == 40) {
            if (!StringsKt.startsWith(trimmedPlayerId, prefix2, true)) {
                boolean $i$a$-require-IdChecker$checkAndReturnUuiId$32 = false;
                String $i$a$-require-IdChecker$checkAndReturnUuiId$32 = "Not a valid ID. Does not start with prefix " + prefix2;
                throw new IllegalArgumentException($i$a$-require-IdChecker$checkAndReturnUuiId$32.toString());
            }
            String string = trimmedPlayerId.substring(StringsKt.getLastIndex(trimmedPlayerId), StringsKt.getLastIndex(trimmedPlayerId) + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String checkDigit = string;
            String string2 = trimmedPlayerId.substring(2, 38);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String shortenedPlayerId = string2;
            String calculatedCheckDigit = String.valueOf(this.getCheckDigit(shortenedPlayerId));
            if (!Intrinsics.areEqual(calculatedCheckDigit, checkDigit)) {
                boolean bl = false;
                String string3 = "Not a valid ID. Checkdigit invalid.";
                throw new IllegalArgumentException(string3.toString());
            }
            return shortenedPlayerId;
        }
        if (trimmedPlayerId.length() == 36) {
            return trimmedPlayerId;
        }
        throw new IllegalArgumentException("Not a valid ID. Wrong length.");
    }

    public final int getCheckDigit(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        String validChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVYWXZ-";
        String idWithoutCheckdigit = uuid;
        String string = ((Object)StringsKt.trim((CharSequence)idWithoutCheckdigit)).toString();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        idWithoutCheckdigit = string2;
        int sum = 0;
        int n = idWithoutCheckdigit.length();
        for (int i = 0; i < n; ++i) {
            char ch = idWithoutCheckdigit.charAt(idWithoutCheckdigit.length() - i - 1);
            if (!(StringsKt.indexOf$default((CharSequence)validChars, ch, 0, false, 6, null) != -1)) {
                boolean $i$a$-require-IdChecker$getCheckDigit$22 = false;
                String $i$a$-require-IdChecker$getCheckDigit$22 = ch + " is an invalid character";
                throw new IllegalArgumentException($i$a$-require-IdChecker$getCheckDigit$22.toString());
            }
            int digit = ch - 48;
            int weight = 0;
            weight = i % 2 == 0 ? 2 * digit - digit / 5 * 9 : digit;
            sum += weight;
        }
        sum = Math.abs(sum) + 10;
        return (10 - sum % 10) % 10;
    }
}

