/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.ai;

import com.badlogic.gdx.graphics.Color;
import com.unciv.GUI;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.ai.TacticalAnalysisMap;
import com.unciv.logic.automation.ai.TacticalDominanceZone;
import com.unciv.logic.automation.ai.TacticalTerritoryType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.utils.Log;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/unciv/logic/automation/ai/TacticalAI;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "debug", "", "player", "Lcom/unciv/logic/civilization/Civilization;", "tacticalAnalysisMap", "Lcom/unciv/logic/automation/ai/TacticalAnalysisMap;", "init", "", "showZonesDebug", "tile", "Lcom/unciv/logic/map/tile/Tile;", "core"})
public final class TacticalAI
implements IsPartOfGameInfoSerialization {
    private final boolean debug;
    @NotNull
    private final transient TacticalAnalysisMap tacticalAnalysisMap = new TacticalAnalysisMap();
    @Nullable
    private transient Civilization player;

    public final void init(@NotNull Civilization player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.player = player;
        this.tacticalAnalysisMap.reset(player);
    }

    public final void showZonesDebug(@NotNull Tile tile) {
        TacticalDominanceZone zone;
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!this.debug) {
            return;
        }
        TacticalDominanceZone tacticalDominanceZone = zone = this.tacticalAnalysisMap.getZoneByTile(tile);
        String zoneId = tacticalDominanceZone != null ? tacticalDominanceZone.getId() : null;
        TacticalDominanceZone tacticalDominanceZone2 = zone;
        TacticalDominanceZone tacticalDominanceZone3 = zone;
        TacticalDominanceZone tacticalDominanceZone4 = zone;
        Log.INSTANCE.debug("MYTAG Zone " + zoneId + " City: " + (tacticalDominanceZone2 != null ? tacticalDominanceZone2.getCity() : null) + " Area: " + (tacticalDominanceZone3 != null ? Integer.valueOf(tacticalDominanceZone3.getArea()) : null) + " Area size: " + tile.getTileMap().getContinentSizes().get(tile.getContinent()) + " Zone size: " + (tacticalDominanceZone4 != null ? Integer.valueOf(tacticalDominanceZone4.getTileCount()) : null), new Object[0]);
        WorldMapHolder mapHolder2 = GUI.INSTANCE.getMap();
        Iterator iterator2 = CollectionsKt.asSequence((Iterable)mapHolder2.getTileMap$core().getValues()).iterator();
        while (iterator2.hasNext()) {
            Object object;
            WorldTileGroup it;
            Tile otherTile = (Tile)iterator2.next();
            String otherZoneId = this.tacticalAnalysisMap.getPlotPositionToZoneId().get(otherTile.getPosition());
            if (Intrinsics.areEqual(otherZoneId, zoneId)) {
                if (mapHolder2.getTileGroups().get(otherTile) != null) {
                    Color color;
                    boolean bl = false;
                    TileGroup tileGroup = it;
                    TacticalDominanceZone tacticalDominanceZone5 = zone;
                    TacticalTerritoryType tacticalTerritoryType = tacticalDominanceZone5 != null ? tacticalDominanceZone5.getTerritoryType() : null;
                    switch (tacticalTerritoryType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tacticalTerritoryType.ordinal()]) {
                        case 1: {
                            color = Color.GREEN;
                            break;
                        }
                        case 2: {
                            color = Color.RED;
                            break;
                        }
                        default: {
                            color = Color.WHITE;
                        }
                    }
                    Color color2 = color;
                    Intrinsics.checkNotNull(color2);
                    mapHolder2.addOverlayOnTileGroup(tileGroup, Scene2dExtensionsKt.toGroup(ImageGetter.getCircle$default(ImageGetter.INSTANCE, color2, null, 2, null), 20.0f));
                }
            }
            boolean bl = (object = zone) != null && (object = ((TacticalDominanceZone)object).getNeighboringZones()) != null ? CollectionsKt.contains((Iterable)object, otherZoneId) : false;
            if (!bl) continue;
            if (mapHolder2.getTileGroups().get(otherTile) == null) continue;
            boolean bl2 = false;
            TileGroup tileGroup = it;
            Color color = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "GRAY");
            mapHolder2.addOverlayOnTileGroup(tileGroup, Scene2dExtensionsKt.toGroup(ImageGetter.getCircle$default(ImageGetter.INSTANCE, color, null, 2, null), 20.0f));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TacticalTerritoryType.values().length];
            try {
                nArray[TacticalTerritoryType.FRIENDLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TacticalTerritoryType.ENEMY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

