/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.ai;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.GameInfo;
import com.unciv.logic.automation.ai.TacticalDominanceZone;
import com.unciv.logic.automation.ai.TacticalTerritoryType;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.CityDistance;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 72\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%J\b\u0010'\u001a\u00020%H\u0002J\u0010\u0010(\u001a\u0004\u0018\u00010 2\u0006\u0010)\u001a\u00020\u0018J\u0010\u0010*\u001a\u0004\u0018\u00010 2\u0006\u0010+\u001a\u00020\nJ\u0010\u0010,\u001a\u0004\u0018\u00010 2\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020%H\u0002J \u00100\u001a\u00020%2\u0016\u00101\u001a\u0012\u0012\u0004\u0012\u00020.0\u001fj\b\u0012\u0004\u0012\u00020.`!H\u0002J\u0006\u00102\u001a\u00020%J\u0006\u00103\u001a\u000204J\b\u00105\u001a\u00020%H\u0002J\u000e\u00106\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R-\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR-\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0\u0016j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR!\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020 0\u001fj\b\u0012\u0004\u0012\u00020 `!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00068"}, d2={"Lcom/unciv/logic/automation/ai/TacticalAnalysisMap;", "", "()V", "game", "Lcom/unciv/logic/GameInfo;", "getGame", "()Lcom/unciv/logic/GameInfo;", "setGame", "(Lcom/unciv/logic/GameInfo;)V", "lastUpdate", "", "getLastUpdate", "()I", "setLastUpdate", "(I)V", "player", "Lcom/unciv/logic/civilization/Civilization;", "getPlayer", "()Lcom/unciv/logic/civilization/Civilization;", "setPlayer", "(Lcom/unciv/logic/civilization/Civilization;)V", "plotPositionToZoneId", "Ljava/util/HashMap;", "Lcom/badlogic/gdx/math/Vector2;", "", "Lkotlin/collections/HashMap;", "getPlotPositionToZoneId", "()Ljava/util/HashMap;", "zoneIdToZoneIndex", "getZoneIdToZoneIndex", "zones", "Ljava/util/ArrayList;", "Lcom/unciv/logic/automation/ai/TacticalDominanceZone;", "Lkotlin/collections/ArrayList;", "getZones", "()Ljava/util/ArrayList;", "createDominanceZones", "", "debugOutput", "establishZoneNeighborhood", "getZoneById", "id", "getZoneByIndex", "index", "getZoneByTile", "tile", "Lcom/unciv/logic/map/tile/Tile;", "glueSmallZonesToBig", "groupRemainingNonCityTiles", "nonCityTiles", "invalidate", "isUpToDate", "", "refreshIfOutdated", "reset", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTacticalAnalysisMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TacticalAnalysisMap.kt\ncom/unciv/logic/automation/ai/TacticalAnalysisMap\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n1313#2,2:329\n1603#3,9:331\n1855#3:340\n1856#3:342\n1612#3:343\n1#4:341\n*S KotlinDebug\n*F\n+ 1 TacticalAnalysisMap.kt\ncom/unciv/logic/automation/ai/TacticalAnalysisMap\n*L\n284#1:329,2\n309#1:331,9\n309#1:340\n309#1:342\n309#1:343\n309#1:341\n*E\n"})
public final class TacticalAnalysisMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public GameInfo game;
    public Civilization player;
    private int lastUpdate = -1;
    @NotNull
    private final ArrayList<TacticalDominanceZone> zones = new ArrayList();
    @NotNull
    private final HashMap<String, Integer> zoneIdToZoneIndex = new HashMap();
    @NotNull
    private final HashMap<Vector2, String> plotPositionToZoneId = new HashMap();
    public static final int maxRange = 4;
    public static final int maxZoneSize = 30;

    @NotNull
    public final GameInfo getGame() {
        GameInfo gameInfo2 = this.game;
        if (gameInfo2 != null) {
            return gameInfo2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("game");
        return null;
    }

    public final void setGame(@NotNull GameInfo gameInfo2) {
        Intrinsics.checkNotNullParameter(gameInfo2, "<set-?>");
        this.game = gameInfo2;
    }

    @NotNull
    public final Civilization getPlayer() {
        Civilization civilization = this.player;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("player");
        return null;
    }

    public final void setPlayer(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.player = civilization;
    }

    public final int getLastUpdate() {
        return this.lastUpdate;
    }

    public final void setLastUpdate(int n) {
        this.lastUpdate = n;
    }

    @NotNull
    public final ArrayList<TacticalDominanceZone> getZones() {
        return this.zones;
    }

    @NotNull
    public final HashMap<String, Integer> getZoneIdToZoneIndex() {
        return this.zoneIdToZoneIndex;
    }

    @NotNull
    public final HashMap<Vector2, String> getPlotPositionToZoneId() {
        return this.plotPositionToZoneId;
    }

    public final void reset(@NotNull Civilization player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.setPlayer(player);
        this.setGame(player.getGameInfo());
        this.lastUpdate = -1;
        this.zones.clear();
        this.zoneIdToZoneIndex.clear();
        this.plotPositionToZoneId.clear();
    }

    public final boolean isUpToDate() {
        if (this.lastUpdate == -1) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getPlayer(), this.getGame().getCurrentPlayerCiv())) {
            return true;
        }
        return this.lastUpdate == this.getGame().getTurns();
    }

    public final void invalidate() {
        this.lastUpdate = -1;
    }

    private final void refreshIfOutdated() {
        if (this.isUpToDate()) {
            return;
        }
        Log.INSTANCE.debug("Refreshing Tactical Analysis Map...", new Object[0]);
        this.createDominanceZones();
        this.establishZoneNeighborhood();
        this.glueSmallZonesToBig();
    }

    @Nullable
    public final TacticalDominanceZone getZoneByTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.refreshIfOutdated();
        String string = this.plotPositionToZoneId.get(tile.getPosition());
        if (string == null) {
            return null;
        }
        String zoneId = string;
        return this.getZoneById(zoneId);
    }

    @Nullable
    public final TacticalDominanceZone getZoneById(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        this.refreshIfOutdated();
        Integer index = this.zoneIdToZoneIndex.get(id);
        if (index != null) {
            return this.getZoneByIndex(index);
        }
        return null;
    }

    @Nullable
    public final TacticalDominanceZone getZoneByIndex(int index) {
        this.refreshIfOutdated();
        if (index < 0 || index >= this.zones.size()) {
            return null;
        }
        return this.zones.get(index);
    }

    public final void createDominanceZones() {
        this.lastUpdate = this.getGame().getTurns();
        this.zones.clear();
        this.zoneIdToZoneIndex.clear();
        this.plotPositionToZoneId.clear();
        TacticalDominanceZone unknownZone = new TacticalDominanceZone();
        this.zones.add(unknownZone);
        ((Map)this.zoneIdToZoneIndex).put(unknownZone.getId(), 0);
        ArrayList<Tile> nonCityTiles = new ArrayList<Tile>();
        TacticalDominanceZone zone = null;
        Iterator iterator2 = CollectionsKt.asSequence((Iterable)this.getGame().getTileMap().getValues()).iterator();
        while (iterator2.hasNext()) {
            String zoneId;
            City city2;
            Tile tile = (Tile)iterator2.next();
            if (!this.getPlayer().hasExplored(tile)) {
                ((Map)this.plotPositionToZoneId).put(tile.getPosition(), unknownZone.getId());
                continue;
            }
            CityDistance cityDistance = this.getGame().getCityDistances().getClosestCityDistance(tile, null, false);
            if (cityDistance == null) {
                nonCityTiles.add(tile);
                continue;
            }
            City city3 = city2 = cityDistance.getDistance() < 3 ? cityDistance.getCity() : tile.getCity();
            if (city2 == null) {
                nonCityTiles.add(tile);
                continue;
            }
            String string = zoneId = tile.isWater() ? '-' + city2.getId() : city2.getId();
            if (!(zone != null && Intrinsics.areEqual(zone.getId(), zoneId) || (zone = this.getZoneById(zoneId)) != null)) {
                TacticalDominanceZone newZone = new TacticalDominanceZone();
                newZone.setId(zoneId);
                newZone.setCity(city2);
                newZone.setOwner(city2.getCiv());
                newZone.setArea(tile.getContinent());
                if (Intrinsics.areEqual(newZone.getOwner(), this.getPlayer())) {
                    newZone.setTerritoryType(TacticalTerritoryType.FRIENDLY);
                } else {
                    Civilization civilization = newZone.getOwner();
                    boolean bl = civilization != null ? civilization.isAtWarWith(this.getPlayer()) : false;
                    if (bl) {
                        newZone.setTerritoryType(TacticalTerritoryType.ENEMY);
                    } else {
                        newZone.setTerritoryType(TacticalTerritoryType.NEUTRAL);
                    }
                }
                ((Map)this.zoneIdToZoneIndex).put(zoneId, this.zones.size());
                this.zones.add(newZone);
                zone = (TacticalDominanceZone)CollectionsKt.last((List)this.zones);
            }
            ((Map)this.plotPositionToZoneId).put(tile.getPosition(), zoneId);
            zone.extend();
        }
        this.getGame().getTileMap().assignContinents(TileMap.AssignContinentsMode.Ensure);
        this.groupRemainingNonCityTiles(nonCityTiles);
    }

    private final void groupRemainingNonCityTiles(ArrayList<Tile> nonCityTiles) {
        while (!((Collection)nonCityTiles).isEmpty()) {
            String randomId;
            int count2 = 30;
            ArrayList<Object> stack = new ArrayList<Object>();
            stack.add(CollectionsKt.removeFirst((List)nonCityTiles));
            Intrinsics.checkNotNullExpressionValue(UUID.randomUUID().toString(), "toString(...)");
            String newId = ((Tile)CollectionsKt.last((List)stack)).isWater() ? '-' + randomId : randomId;
            TacticalDominanceZone newZone = new TacticalDominanceZone();
            newZone.setId(newId);
            newZone.setCity(null);
            newZone.setArea(((Tile)CollectionsKt.last((List)stack)).getContinent());
            newZone.setTerritoryType(TacticalTerritoryType.NEUTRAL);
            while ((!((Collection)stack).isEmpty() || count2 > 0) && (Tile)CollectionsKt.removeLastOrNull((List)stack) != null) {
                Tile tile;
                Integer n = tile.getTileMap().getContinentSizes().get(tile.getContinent());
                if (n == null) {
                    n = Integer.MAX_VALUE;
                }
                int tileContinentSize = ((Number)n).intValue();
                ((Map)this.plotPositionToZoneId).put(tile.getPosition(), newId);
                newZone.extend();
                Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
                while (iterator2.hasNext()) {
                    Tile neighbor = iterator2.next();
                    boolean isLake = Tile.matchesTerrainFilter$default(neighbor, "Lakes", null, 2, null);
                    boolean isMountain = Tile.matchesTerrainFilter$default(neighbor, "Mountain", null, 2, null);
                    Integer n2 = neighbor.getTileMap().getContinentSizes().get(neighbor.getContinent());
                    if (n2 == null) {
                        n2 = Integer.MAX_VALUE;
                    }
                    int neighborContinentSize = ((Number)n2).intValue();
                    boolean isSameZone = neighbor.getContinent() == tile.getContinent() || isLake || isMountain && neighbor.isLand() || neighborContinentSize < 4 || tileContinentSize < 4;
                    if (!isSameZone || !nonCityTiles.contains(neighbor) || count2 <= 0) continue;
                    nonCityTiles.remove(neighbor);
                    stack.add(neighbor);
                    --count2;
                }
            }
            ((Map)this.zoneIdToZoneIndex).put(newZone.getId(), this.zones.size());
            this.zones.add(newZone);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void glueSmallZonesToBig() {
        HashSet<TacticalDominanceZone> toRemove = new HashSet<TacticalDominanceZone>();
        for (TacticalDominanceZone zone : this.zones) {
            void $this$forEach$iv;
            TacticalDominanceZone biggerZone2;
            if (zone.getTileCount() >= 5 || zone.getCity() != null || (biggerZone2 = (TacticalDominanceZone)SequencesKt.firstOrNull(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.zones), (Function1)new Function1<TacticalDominanceZone, Boolean>(zone){
                final /* synthetic */ TacticalDominanceZone $zone;
                {
                    this.$zone = $zone;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull TacticalDominanceZone it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.isWater() == this.$zone.isWater() && it.getNeighboringZones().contains(this.$zone.getId());
                }
            }))) == null) continue;
            Sequence sequence = SequencesKt.filter(MapsKt.asSequence((Map)this.plotPositionToZoneId), (Function1)new Function1<Map.Entry<? extends Vector2, ? extends String>, Boolean>(zone){
                final /* synthetic */ TacticalDominanceZone $zone;
                {
                    this.$zone = $zone;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Map.Entry<? extends Vector2, String> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it.getValue(), this.$zone.getId());
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                ((Map)this.plotPositionToZoneId).put(it.getKey(), biggerZone2.getId());
            }
            toRemove.add(zone);
        }
        this.zones.removeAll((Collection)toRemove);
        this.zoneIdToZoneIndex.clear();
        int n = this.zones.size();
        for (int i = 0; i < n; ++i) {
            String zoneId = this.zones.get(i).getId();
            Integer n2 = i;
            ((Map)this.zoneIdToZoneIndex).put(zoneId, n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void establishZoneNeighborhood() {
        for (TacticalDominanceZone zone : this.zones) {
            zone.getNeighboringZones().clear();
        }
        TileMap tileMap = this.getGame().getTileMap();
        Integer[] integerArray = new Integer[]{12, 4, 8};
        Set<Integer> directionsToCheck = SetsKt.setOf(integerArray);
        for (Tile tile : tileMap.getValues()) {
            void $this$mapNotNullTo$iv$iv;
            TacticalDominanceZone zoneA;
            TacticalDominanceZone tacticalDominanceZone = zoneA = this.getZoneByTile(tile);
            Intrinsics.checkNotNull(tacticalDominanceZone);
            String zoneAId = tacticalDominanceZone.getId();
            Iterable $this$mapNotNull$iv = directionsToCheck;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Tile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if (tileMap.getClockPositionNeighborTile(tile, it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (Tile neighbor : (List)destination$iv$iv) {
                TacticalDominanceZone zoneB;
                Intrinsics.checkNotNull(this.getZoneByTile(neighbor));
                String zoneBId = zoneB.getId();
                if (Intrinsics.areEqual(zoneAId, zoneBId)) continue;
                zoneA.getNeighboringZones().add(zoneB.getId());
                zoneB.getNeighboringZones().add(zoneA.getId());
            }
        }
    }

    public final void debugOutput() {
        Log.INSTANCE.debug("MYTAG: Total tactical zones: " + this.zones.size(), new Object[0]);
        for (TacticalDominanceZone zone : this.zones) {
            Log.INSTANCE.debug("MYTAG: Zone: " + zone.getId() + " City: " + zone.getCity() + " Territory: " + (Object)((Object)zone.getTerritoryType()) + " Neighbors: " + zone.getNeighboringZones(), new Object[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/automation/ai/TacticalAnalysisMap$Companion;", "", "()V", "maxRange", "", "maxZoneSize", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

