/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.automation.civilization.BarbarianAutomation;
import com.unciv.logic.automation.civilization.Encampment;
import com.unciv.logic.automation.unit.BattleHelper;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/unciv/logic/automation/civilization/BarbarianAutomation;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "automate", "", "automateCapturedCivilian", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "automateCombatUnit", "automateUnit", "automateUnitOnEncampment", "core"})
@SourceDebugExtension(value={"SMAP\nBarbarianAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarbarianAutomation.kt\ncom/unciv/logic/automation/civilization/BarbarianAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1313#2,2:73\n1313#2,2:75\n1313#2,2:77\n1549#3:79\n1620#3,3:80\n1045#3:83\n288#3,2:84\n*S KotlinDebug\n*F\n+ 1 BarbarianAutomation.kt\ncom/unciv/logic/automation/civilization/BarbarianAutomation\n*L\n13#1:73,2\n14#1:75,2\n15#1:77,2\n30#1:79\n30#1:80,3\n31#1:83\n32#1:84,2\n*E\n"})
public final class BarbarianAutomation {
    @NotNull
    private final Civilization civInfo;

    public BarbarianAutomation(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    public final void automate() {
        MapUnit it;
        MapUnit element$iv;
        Sequence<MapUnit> $this$forEach$iv = SequencesKt.filter(this.civInfo.getUnits().getCivUnits(), automate.1.INSTANCE);
        boolean $i$f$forEach = false;
        Iterator<MapUnit> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            this.automateUnit(it);
        }
        $this$forEach$iv = SequencesKt.filter(this.civInfo.getUnits().getCivUnits(), automate.3.INSTANCE);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            this.automateUnit(it);
        }
        $this$forEach$iv = SequencesKt.filter(this.civInfo.getUnits().getCivUnits(), automate.5.INSTANCE);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            this.automateUnit(it);
        }
        this.civInfo.getPopupAlerts().clear();
    }

    private final void automateUnit(MapUnit unit) {
        if (unit.isCivilian()) {
            this.automateCapturedCivilian(unit);
        } else if (Intrinsics.areEqual(unit.getCurrentTile().getImprovement(), "Barbarian encampment")) {
            this.automateUnitOnEncampment(unit);
        } else {
            this.automateCombatUnit(unit);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void automateCapturedCivilian(MapUnit unit) {
        Object v0;
        block5: {
            void $this$mapTo$iv$iv;
            if (Intrinsics.areEqual(unit.getCurrentTile().getImprovement(), "Barbarian encampment")) {
                return;
            }
            Iterable $this$map$iv = unit.getCiv().getGameInfo().getBarbarians().getEncampments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Encampment encampment = (Encampment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(unit.getCiv().getGameInfo().getTileMap().get(it.getPosition()));
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List campTiles = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$unit$inlined.getCurrentTile().aerialDistanceTo(it));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, this.$unit$inlined.getCurrentTile().aerialDistanceTo(it));
                }
            });
            Iterable $this$firstOrNull$iv = campTiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!(it.getCivilianUnit() == null && unit.getMovement().canReach(it))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        Tile bestCamp = v0;
        if (bestCamp != null) {
            unit.getMovement().headTowards(bestCamp);
        } else {
            UnitAutomation.wander$default(UnitAutomation.INSTANCE, unit, false, null, 6, null);
        }
    }

    private final void automateUnitOnEncampment(MapUnit unit) {
        if (UnitAutomation.INSTANCE.tryUpgradeUnit$core(unit)) {
            return;
        }
        if (BattleHelper.INSTANCE.tryAttackNearbyEnemy(unit, true)) {
            return;
        }
        unit.fortifyIfCan();
    }

    private final void automateCombatUnit(MapUnit unit) {
        if (unit.getHealth() < 50 && UnitAutomation.INSTANCE.tryPillageImprovement(unit, true) && unit.getCurrentMovement() == 0.0f) {
            return;
        }
        if (UnitAutomation.INSTANCE.tryUpgradeUnit$core(unit)) {
            return;
        }
        if (BattleHelper.INSTANCE.tryDisembarkUnitToAttackPosition(unit)) {
            return;
        }
        if (!unit.isCivilian() && BattleHelper.tryAttackNearbyEnemy$default(BattleHelper.INSTANCE, unit, false, 2, null)) {
            return;
        }
        while (UnitAutomation.tryPillageImprovement$default(UnitAutomation.INSTANCE, unit, false, 2, null)) {
            if (!(unit.getCurrentMovement() == 0.0f)) continue;
            return;
        }
        UnitAutomation.wander$default(UnitAutomation.INSTANCE, unit, false, null, 6, null);
    }
}

