/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.components.extensions.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0006\u0010 \u001a\u00020\u0000J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\rH\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0006\u0010%\u001a\u00020\"J\u0006\u0010&\u001a\u00020\"J\u0006\u0010'\u001a\u00020\"R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u000b\u00a8\u0006("}, d2={"Lcom/unciv/logic/automation/civilization/Encampment;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "position", "Lcom/badlogic/gdx/math/Vector2;", "(Lcom/badlogic/gdx/math/Vector2;)V", "()V", "countdown", "", "getCountdown", "()I", "setCountdown", "(I)V", "destroyed", "", "getDestroyed", "()Z", "setDestroyed", "(Z)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "setGameInfo", "(Lcom/unciv/logic/GameInfo;)V", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "spawnedUnits", "getSpawnedUnits", "setSpawnedUnits", "chooseBarbarianUnit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "naval", "clone", "resetCountdown", "", "spawnBarbarian", "spawnUnit", "update", "wasAttacked", "wasDestroyed", "core"})
@SourceDebugExtension(value={"SMAP\nBarbarianManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarbarianManager.kt\ncom/unciv/logic/automation/civilization/Encampment\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n1268#2,3:290\n819#3:293\n847#3,2:294\n766#3:296\n857#3,2:297\n766#3:299\n857#3,2:300\n1549#3:302\n1620#3,3:303\n*S KotlinDebug\n*F\n+ 1 BarbarianManager.kt\ncom/unciv/logic/automation/civilization/Encampment\n*L\n226#1:290,3\n230#1:293\n230#1:294,2\n253#1:296\n253#1:297,2\n259#1:299\n259#1:300,2\n269#1:302\n269#1:303,3\n*E\n"})
public final class Encampment
implements IsPartOfGameInfoSerialization {
    @NotNull
    private final Vector2 position;
    private int countdown;
    private int spawnedUnits;
    private boolean destroyed;
    public transient GameInfo gameInfo;

    public Encampment() {
        this.position = new Vector2();
        this.spawnedUnits = -1;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    public final int getCountdown() {
        return this.countdown;
    }

    public final void setCountdown(int n) {
        this.countdown = n;
    }

    public final int getSpawnedUnits() {
        return this.spawnedUnits;
    }

    public final void setSpawnedUnits(int n) {
        this.spawnedUnits = n;
    }

    public final boolean getDestroyed() {
        return this.destroyed;
    }

    public final void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    @NotNull
    public final GameInfo getGameInfo() {
        GameInfo gameInfo2 = this.gameInfo;
        if (gameInfo2 != null) {
            return gameInfo2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
        return null;
    }

    public final void setGameInfo(@NotNull GameInfo gameInfo2) {
        Intrinsics.checkNotNullParameter(gameInfo2, "<set-?>");
        this.gameInfo = gameInfo2;
    }

    public Encampment(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        this();
        this.position.x = position.x;
        this.position.y = position.y;
    }

    @NotNull
    public final Encampment clone() {
        Encampment toReturn = new Encampment(this.position);
        toReturn.countdown = this.countdown;
        toReturn.spawnedUnits = this.spawnedUnits;
        toReturn.destroyed = this.destroyed;
        return toReturn;
    }

    public final void update() {
        if (this.countdown > 0) {
            int n = this.countdown;
            this.countdown = n + -1;
        } else if (!this.destroyed && this.spawnBarbarian()) {
            int n = this.spawnedUnits;
            this.spawnedUnits = n + 1;
            this.resetCountdown();
        }
    }

    public final void wasAttacked() {
        if (!this.destroyed) {
            this.countdown /= 2;
        }
    }

    public final void wasDestroyed() {
        if (!this.destroyed) {
            this.countdown = 15;
            this.destroyed = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean spawnBarbarian() {
        void $this$filterNotTo$iv$iv;
        Object element$iv;
        Tile tile = this.getGameInfo().getTileMap().get(this.position);
        if (tile.getMilitaryUnit() == null) {
            return this.spawnUnit(false);
        }
        if (this.getGameInfo().getTurns() < 10) {
            return false;
        }
        Civilization barbarianCiv = this.getGameInfo().getBarbarianCivilization();
        Sequence<Tile> $this$count$iv = tile.getTilesInDistance(4);
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Tile> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            Tile it = element$iv;
            boolean bl = false;
            MapUnit mapUnit = it.getMilitaryUnit();
            if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, barbarianCiv) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        if (count$iv > 2) {
            return false;
        }
        boolean canSpawnBoats = this.getGameInfo().getTurns() > 30;
        Iterable $this$filterNot$iv = SequencesKt.toList(tile.getNeighbors());
        boolean $i$f$filterNot = false;
        element$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            if (it.isImpassible() || it.isCityCenter() || it.getFirstUnit() != null || it.isWater() && !canSpawnBoats || Tile.terrainHasUnique$default(it, UniqueType.FreshWater, null, 2, null) && it.isWater()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validTiles = (List)destination$iv$iv;
        if (validTiles.isEmpty()) {
            return false;
        }
        return this.spawnUnit(((Tile)CollectionsKt.random(validTiles, Random.Default)).isWater());
    }

    private final boolean spawnUnit(boolean naval) {
        BaseUnit baseUnit = this.chooseBarbarianUnit(naval);
        if (baseUnit == null) {
            return false;
        }
        BaseUnit unitToSpawn2 = baseUnit;
        MapUnit spawnedUnit = TileMap.placeUnitNearTile$default(this.getGameInfo().getTileMap(), this.position, unitToSpawn2, this.getGameInfo().getBarbarianCivilization(), null, 8, null);
        return spawnedUnit != null;
    }

    /*
     * Unable to fully structure code
     */
    private final BaseUnit chooseBarbarianUnit(boolean naval) {
        v0 = this.getGameInfo().getRuleset().getTechnologies().keySet();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-keys>(...)");
        allResearchedTechs = CollectionsKt.toMutableList((Collection)v0);
        $this$filter$iv = this.getGameInfo().getCivilizations();
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            $i$a$-filter-Encampment$chooseBarbarianUnit$1 = false;
            if (!(it.isBarbarian() == false && it.isDefeated() == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv) {
            allResearchedTechs.retainAll((Collection)civ.getTech().getTechsResearched());
        }
        barbarianCiv = this.getGameInfo().getBarbarianCivilization();
        barbarianCiv.getTech().setTechsResearched(CollectionsKt.toHashSet((Iterable)allResearchedTechs));
        v1 = this.getGameInfo().getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(v1, "<get-values>(...)");
        $i$f$filter = v1;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            it = (BaseUnit)element$iv$iv;
            $i$a$-filter-Encampment$chooseBarbarianUnit$unitList$1 = false;
            if (!it.isMilitary()) ** GOTO lbl-1000
            Intrinsics.checkNotNull(it);
            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.CannotAttack, null, 2, null) && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.CannotBeBarbarian, null, 2, null) && (naval != false ? it.isWaterUnit() : it.isLandUnit()) && it.isBuildable(barbarianCiv)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        unitList = (List)destination$iv$iv;
        if (unitList.isEmpty()) {
            return null;
        }
        $this$map$iv = unitList;
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-Encampment$chooseBarbarianUnit$unitList$1 = (BaseUnit)item$iv$iv;
            var15_26 = destination$iv$iv;
            $i$a$-map-Encampment$chooseBarbarianUnit$weightings$1 = false;
            var15_26.add(Float.valueOf(it.getForceEvaluation()));
        }
        weightings = (List)destination$iv$iv;
        return (BaseUnit)CollectionExtensionsKt.randomWeighted$default(unitList, weightings, null, 2, null);
    }

    private final void resetCountdown() {
        this.countdown = 8 + Random.Default.nextInt(5);
        if (this.getGameInfo().getGameParameters().getRagingBarbarians()) {
            this.countdown /= 2;
        }
        Difficulty difficulty = this.getGameInfo().getRuleset().getDifficulties().get(this.getGameInfo().getGameParameters().getDifficulty());
        Intrinsics.checkNotNull(difficulty);
        this.countdown += difficulty.getBarbarianSpawnDelay();
        this.countdown -= Math.min(3, this.spawnedUnits);
        this.countdown = (int)((float)this.countdown * this.getGameInfo().getSpeed().getBarbarianModifier());
    }
}

