/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/automation/unit/BattleHelper;", "", "()V", "chooseAttackTarget", "Lcom/unciv/logic/battle/AttackableTile;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "attackableEnemies", "", "getCityAttackValue", "", "attacker", "city", "Lcom/unciv/logic/city/City;", "getUnitAttackValue", "attackTile", "tryAttackNearbyEnemy", "", "stayOnTile", "tryDisembarkUnitToAttackPosition", "core"})
@SourceDebugExtension(value={"SMAP\nBattleHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleHelper.kt\ncom/unciv/logic/automation/unit/BattleHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,178:1\n766#2:179\n857#2,2:180\n766#2:182\n857#2,2:183\n766#2:185\n857#2,2:186\n1268#3,3:188\n1313#3,2:191\n*S KotlinDebug\n*F\n+ 1 BattleHelper.kt\ncom/unciv/logic/automation/unit/BattleHelper\n*L\n21#1:179\n21#1:180,2\n49#1:182\n49#1:183,2\n55#1:185\n55#1:186,2\n106#1:188,3\n126#1:191,2\n*E\n"})
public final class BattleHelper {
    @NotNull
    public static final BattleHelper INSTANCE = new BattleHelper();

    private BattleHelper() {
    }

    /*
     * Unable to fully structure code
     */
    public final boolean tryAttackNearbyEnemy(@NotNull MapUnit unit, boolean stayOnTile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (MapUnit.hasUnique$default(unit, UniqueType.CannotAttack, null, false, 6, null)) {
            return false;
        }
        distanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
        var5_4 = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), null, stayOnTile, 4, null);
        $i$f$filter = false;
        var7_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (AttackableTile)element$iv$iv;
            $i$a$-filter-BattleHelper$tryAttackNearbyEnemy$attackableEnemies$1 = false;
            if (MapUnit.hasUnique$default(unit, UniqueType.SelfDestructs, null, false, 6, null)) ** GOTO lbl-1000
            v0 = new MapUnitCombatant(unit);
            v1 = Battle.INSTANCE.getMapCombatantOfTile(it.getTileToAttack());
            Intrinsics.checkNotNull(v1);
            if (BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, v0, v1, null, 0.0f, 12, null) + unit.getDamageFromTerrain(it.getTileToAttackFrom()) < unit.getHealth()) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        attackableEnemies = (List)destination$iv$iv;
        enemyTileToAttack = this.chooseAttackTarget(unit, attackableEnemies);
        if (enemyTileToAttack != null) {
            if (enemyTileToAttack.getTileToAttack().getMilitaryUnit() == null && unit.getBaseUnit().isRanged() && UnitMovement.canMoveTo$default(unit.getMovement(), enemyTileToAttack.getTileToAttack(), false, false, false, 14, null) && distanceToTiles.containsKey((Object)enemyTileToAttack.getTileToAttack())) {
                UnitMovement.moveToTile$default(unit.getMovement(), enemyTileToAttack.getTileToAttack(), false, 2, null);
            } else {
                Battle.INSTANCE.moveAndAttack(new MapUnitCombatant(unit), enemyTileToAttack);
            }
        }
        return unit.getCurrentMovement() == 0.0f;
    }

    public static /* synthetic */ boolean tryAttackNearbyEnemy$default(BattleHelper battleHelper, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return battleHelper.tryAttackNearbyEnemy(mapUnit, bl);
    }

    public final boolean tryDisembarkUnitToAttackPosition(@NotNull MapUnit unit) {
        AttackableTile it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (!(unit.getBaseUnit().isMelee() && unit.getBaseUnit().isLandUnit() && unit.isEmbarked())) {
            return false;
        }
        PathsToTilesWithinTurn unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
        Iterable iterable = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, unitDistanceToTiles, null, false, 12, null);
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AttackableTile)element$iv$iv;
            boolean bl = false;
            ICombatant iCombatant = new MapUnitCombatant(unit);
            ICombatant iCombatant2 = Battle.INSTANCE.getMapCombatantOfTile(it.getTileToAttack());
            Intrinsics.checkNotNull(iCombatant2);
            boolean bl2 = BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, iCombatant, iCombatant2, null, 0.0f, 12, null) < unit.getHealth();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AttackableTile)element$iv$iv;
            boolean bl = false;
            if (!it.getTileToAttackFrom().isLand()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List attackableEnemiesNextTurn = (List)destination$iv$iv;
        AttackableTile enemyTileToAttackNextTurn = this.chooseAttackTarget(unit, attackableEnemiesNextTurn);
        if (enemyTileToAttackNextTurn != null) {
            UnitMovement.moveToTile$default(unit.getMovement(), enemyTileToAttackNextTurn.getTileToAttackFrom(), false, 2, null);
            return true;
        }
        return false;
    }

    private final AttackableTile chooseAttackTarget(MapUnit unit, List<AttackableTile> attackableEnemies) {
        int highestAttackValue = 0;
        AttackableTile attackTile = null;
        for (AttackableTile attackableEnemy : attackableEnemies) {
            int tempAttackValue;
            int n;
            if (attackableEnemy.getTileToAttack().isCityCenter()) {
                City city2 = attackableEnemy.getTileToAttack().getCity();
                Intrinsics.checkNotNull(city2);
                n = this.getCityAttackValue(unit, city2);
            } else {
                n = this.getUnitAttackValue(unit, attackableEnemy);
            }
            if ((tempAttackValue = n) <= highestAttackValue) continue;
            highestAttackValue = tempAttackValue;
            attackTile = attackableEnemy;
        }
        return highestAttackValue > 30 ? attackTile : null;
    }

    private final int getCityAttackValue(MapUnit attacker, City city2) {
        boolean isCityCapturable;
        MapUnitCombatant attackerUnit = new MapUnitCombatant(attacker);
        CityCombatant cityUnit = new CityCombatant(city2);
        boolean bl = isCityCapturable = city2.getHealth() == 1 || attacker.getBaseUnit().isMelee() && city2.getHealth() <= RangesKt.coerceAtLeast(BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, attackerUnit, cityUnit, null, 0.0f, 12, null), 1);
        if (isCityCapturable) {
            return attacker.getBaseUnit().isMelee() ? 10000 : 0;
        }
        if (attacker.getBaseUnit().isMelee()) {
            int battleDamage = BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, attackerUnit, cityUnit, null, 0.0f, 12, null);
            if (attacker.getHealth() - battleDamage * 2 <= 0 && !MapUnit.hasUnique$default(attacker, UniqueType.SelfDestructs, null, false, 6, null)) {
                Sequence<Tile> $this$count$iv = city2.getCenterTile().getTilesInDistance(3);
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<Tile> iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    MapUnit mapUnit = it.getMilitaryUnit();
                    if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, attacker.getCiv()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int friendlyUnitsAroundCity = count$iv;
                if (friendlyUnitsAroundCity < 5) {
                    double attackerHealthModifier = 1.0 + 1.0 / (double)friendlyUnitsAroundCity;
                    if ((double)attacker.getHealth() - (double)battleDamage * attackerHealthModifier <= 0.0) {
                        return 0;
                    }
                }
            }
        }
        int attackValue = 0;
        attackValue = 100;
        if (attacker.getBaseUnit().isProbablySiegeUnit()) {
            attackValue += 100;
        } else if (attacker.getBaseUnit().isRanged()) {
            attackValue += 10;
        }
        attackValue -= (city2.getHealth() - 60) / 2;
        Civilization defendingCityCiv = city2.getCiv();
        Sequence<Tile> $this$forEach$iv = city2.getCenterTile().getTilesInDistance(2);
        boolean $i$f$forEach = false;
        Iterator<Tile> iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            Tile element$iv;
            Tile it = element$iv = iterator3.next();
            boolean bl3 = false;
            if (it.getMilitaryUnit() == null) continue;
            MapUnit mapUnit = it.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (mapUnit.getCiv().isAtWarWith(attacker.getCiv())) {
                attackValue -= 5;
            }
            MapUnit mapUnit2 = it.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit2);
            if (!mapUnit2.getCiv().isAtWarWith(defendingCityCiv)) continue;
            attackValue += 15;
        }
        return attackValue;
    }

    private final int getUnitAttackValue(MapUnit attacker, AttackableTile attackTile) {
        int attackValue = Integer.MIN_VALUE;
        MapUnit militaryUnit = attackTile.getTileToAttack().getMilitaryUnit();
        MapUnit civilianUnit = attackTile.getTileToAttack().getCivilianUnit();
        if (militaryUnit != null) {
            attackValue = 100;
            float attacksToKill = RangesKt.coerceAtMost(RangesKt.coerceAtLeast((float)militaryUnit.getHealth() / (float)BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, new MapUnitCombatant(attacker), new MapUnitCombatant(militaryUnit), null, 0.0f, 12, null), 1.0f), 10.0f);
            attackValue = attacksToKill <= 1.0f ? (attackValue += 30) : (attackValue -= (int)(attacksToKill * (float)5));
        } else if (civilianUnit != null) {
            attackValue = 50;
            if (attacker.getBaseUnit().isMelee() || attacker.getMovement().canReachInCurrentTurn(attackTile.getTileToAttack())) {
                if (civilianUnit.isGreatPerson()) {
                    attackValue += 150;
                }
                if (MapUnit.hasUnique$default(civilianUnit, UniqueType.FoundCity, null, false, 6, null)) {
                    attackValue += 60;
                }
            } else if (attacker.getBaseUnit().isRanged() && !MapUnit.hasUnique$default(civilianUnit, UniqueType.Uncapturable, null, false, 6, null)) {
                return 10;
            }
        }
        return attackValue += (int)(attackTile.getMovementLeftAfterMovingToAttackTile() * (float)5);
    }
}

