/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.automation.Automation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ModConstants;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J'\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002Jd\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00042\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001c2\"\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u001ej\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0013`\u001f2\u0006\u0010 \u001a\u00020!H\u0002JR\u0010\"\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\"\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u001ej\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0013`\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006$"}, d2={"Lcom/unciv/logic/automation/unit/CityLocationTileRanker;", "", "()V", "canSettleTile", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "civ", "Lcom/unciv/logic/civilization/Civilization;", "nearbyCities", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/city/City;", "getBestTilesToFoundCity", "Lcom/unciv/logic/automation/unit/CityLocationTileRanker$BestTilesToFoundCity;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "distanceToSearch", "", "minimumValue", "", "(Lcom/unciv/logic/map/mapunit/MapUnit;Ljava/lang/Integer;F)Lcom/unciv/logic/automation/unit/CityLocationTileRanker$BestTilesToFoundCity;", "getDistanceToCityModifier", "newCityTile", "rankTile", "onCoast", "newUniqueLuxuryResources", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "baseTileMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "uniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "rankTileToSettle", "BestTilesToFoundCity", "core"})
@SourceDebugExtension(value={"SMAP\nCityLocationTileRanker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityLocationTileRanker.kt\ncom/unciv/logic/automation/unit/CityLocationTileRanker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,181:1\n1#2:182\n614#3:183\n179#3,2:184\n*S KotlinDebug\n*F\n+ 1 CityLocationTileRanker.kt\ncom/unciv/logic/automation/unit/CityLocationTileRanker\n*L\n48#1:183\n50#1:184,2\n*E\n"})
public final class CityLocationTileRanker {
    @NotNull
    public static final CityLocationTileRanker INSTANCE = new CityLocationTileRanker();

    private CityLocationTileRanker() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BestTilesToFoundCity getBestTilesToFoundCity(@NotNull MapUnit unit, @Nullable Integer distanceToSearch, float minimumValue) {
        Object v3;
        BestTilesToFoundCity bestTilesToFoundCity;
        block8: {
            void $this$sortedByDescending$iv;
            Sequence possibleTileLocationsWithRank2;
            int n;
            Intrinsics.checkNotNullParameter(unit, "unit");
            Integer n2 = distanceToSearch;
            if (n2 != null) {
                n = n2;
            } else {
                int n3;
                if (unit.getCiv().getCities().isEmpty()) {
                    n3 = 0;
                } else {
                    Iterator iterator2 = ((Iterable)unit.getCiv().getCities()).iterator();
                    if (!iterator2.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    City it22 = (City)iterator2.next();
                    boolean bl = false;
                    int it22 = it22.getCenterTile().aerialDistanceTo(unit.getTile());
                    while (iterator2.hasNext()) {
                        City it32 = (City)iterator2.next();
                        $i$a$-minOf-CityLocationTileRanker$getBestTilesToFoundCity$range$distanceFromHome$1 = false;
                        int it32 = it32.getCenterTile().aerialDistanceTo(unit.getTile());
                        if (it22 <= it32) continue;
                        it22 = it32;
                    }
                    n3 = it22;
                }
                int distanceFromHome = n3;
                n = RangesKt.coerceIn(8 - distanceFromHome, 1, 5);
            }
            int range = n;
            Sequence<City> nearbyCities2 = SequencesKt.filter(unit.getCiv().getGameInfo().getCities(), (Function1)new Function1<City, Boolean>(unit, range){
                final /* synthetic */ MapUnit $unit;
                final /* synthetic */ int $range;
                {
                    this.$unit = $unit;
                    this.$range = $range;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull City it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getCenterTile().aerialDistanceTo(this.$unit.getTile()) <= 7 + this.$range;
                }
            });
            Sequence<Tile> possibleCityLocations2 = SequencesKt.filter(unit.getTile().getTilesInDistance(range), (Function1)new Function1<Tile, Boolean>(unit, nearbyCities2){
                final /* synthetic */ MapUnit $unit;
                final /* synthetic */ Sequence<City> $nearbyCities;
                {
                    this.$unit = $unit;
                    this.$nearbyCities = $nearbyCities;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return CityLocationTileRanker.access$canSettleTile(CityLocationTileRanker.INSTANCE, it, this.$unit.getCiv(), this.$nearbyCities) && (Intrinsics.areEqual(this.$unit.getTile(), it) || UnitMovement.canMoveTo$default(this.$unit.getMovement(), it, false, false, false, 14, null));
                }
            });
            LocalUniqueCache uniqueCache = new LocalUniqueCache(false, 1, null);
            bestTilesToFoundCity = new BestTilesToFoundCity();
            HashMap<Tile, Float> baseTileMap = new HashMap<Tile, Float>();
            Sequence sequence = SequencesKt.filter(SequencesKt.map(possibleCityLocations2, (Function1)new Function1<Tile, Pair<? extends Tile, ? extends Float>>(unit, nearbyCities2, baseTileMap, uniqueCache, minimumValue, bestTilesToFoundCity){
                final /* synthetic */ MapUnit $unit;
                final /* synthetic */ Sequence<City> $nearbyCities;
                final /* synthetic */ HashMap<Tile, Float> $baseTileMap;
                final /* synthetic */ LocalUniqueCache $uniqueCache;
                final /* synthetic */ float $minimumValue;
                final /* synthetic */ BestTilesToFoundCity $bestTilesToFoundCity;
                {
                    this.$unit = $unit;
                    this.$nearbyCities = $nearbyCities;
                    this.$baseTileMap = $baseTileMap;
                    this.$uniqueCache = $uniqueCache;
                    this.$minimumValue = $minimumValue;
                    this.$bestTilesToFoundCity = $bestTilesToFoundCity;
                    super(1);
                }

                @NotNull
                public final Pair<Tile, Float> invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    float tileValue = CityLocationTileRanker.access$rankTileToSettle(CityLocationTileRanker.INSTANCE, it, this.$unit.getCiv(), this.$nearbyCities, this.$baseTileMap, this.$uniqueCache);
                    if (tileValue >= this.$minimumValue) {
                        Float f = Float.valueOf(tileValue);
                        ((Map)this.$bestTilesToFoundCity.getTileRankMap()).put(it, f);
                    }
                    return new Pair<Tile, Float>(it, Float.valueOf(tileValue));
                }
            }), (Function1)new Function1<Pair<? extends Tile, ? extends Float>, Boolean>(minimumValue){
                final /* synthetic */ float $minimumValue;
                {
                    this.$minimumValue = $minimumValue;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Pair<Tile, Float> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return ((Number)it.getSecond()).floatValue() >= this.$minimumValue;
                }
            });
            boolean $i$f$sortedByDescending = false;
            Sequence $this$firstOrNull$iv = possibleTileLocationsWithRank2 = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = (Float)it.getSecond();
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getSecond()));
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator iterator3 = $this$firstOrNull$iv.iterator();
            while (iterator3.hasNext()) {
                Object element$iv = iterator3.next();
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach((Tile)it.getFirst())) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        Pair bestReachableTile = v3;
        if (bestReachableTile != null) {
            bestTilesToFoundCity.setBestTile((Tile)bestReachableTile.getFirst());
            bestTilesToFoundCity.setBestTileRank(((Number)bestReachableTile.getSecond()).floatValue());
        }
        return bestTilesToFoundCity;
    }

    public static /* synthetic */ BestTilesToFoundCity getBestTilesToFoundCity$default(CityLocationTileRanker cityLocationTileRanker, MapUnit mapUnit, Integer n, float f, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return cityLocationTileRanker.getBestTilesToFoundCity(mapUnit, n, f);
    }

    private final boolean canSettleTile(Tile tile, Civilization civ, Sequence<City> nearbyCities2) {
        ModConstants modConstants = civ.getGameInfo().getRuleset().getModOptions().getConstants();
        if (!tile.isLand() || tile.isImpassible()) {
            return false;
        }
        if (tile.getOwner() != null && !Intrinsics.areEqual(tile.getOwner(), civ)) {
            return false;
        }
        Iterator<City> iterator2 = nearbyCities2.iterator();
        while (iterator2.hasNext()) {
            City city2 = iterator2.next();
            int distance = city2.getCenterTile().aerialDistanceTo(tile);
            if (distance <= 6 && civ.knows(city2.getCiv()) && !civ.isAtWarWith(city2.getCiv())) {
                DiplomacyManager diplomacyManager = city2.getCiv().getDiplomacyManager(civ);
                Intrinsics.checkNotNull(diplomacyManager);
                if (diplomacyManager.hasFlag(DiplomacyFlags.AgreedToNotSettleNearUs)) {
                    return false;
                }
            }
            if (!(tile.getContinent() == city2.getCenterTile().getContinent() ? distance <= modConstants.getMinimalCityDistance() : distance <= modConstants.getMinimalCityDistanceOnDifferentContinents())) continue;
            return false;
        }
        return true;
    }

    private final float rankTileToSettle(Tile newCityTile, Civilization civ, Sequence<City> nearbyCities2, HashMap<Tile, Float> baseTileMap, LocalUniqueCache uniqueCache) {
        float tileValue = 0.0f;
        tileValue += this.getDistanceToCityModifier(newCityTile, nearbyCities2, civ);
        boolean onCoast = newCityTile.isCoastalTile();
        boolean onHill = newCityTile.isHill();
        boolean isNextToMountain = Tile.isAdjacentTo$default(newCityTile, "Mountain", null, 2, null);
        HashSet<String> newUniqueLuxuryResources = new HashSet<String>();
        if (onCoast) {
            tileValue += (float)3;
        }
        if (onHill) {
            tileValue += (float)7;
        }
        if (isNextToMountain) {
            tileValue += (float)5;
        }
        if (newCityTile.isAdjacentToRiver()) {
            tileValue += (float)14;
        }
        if (Tile.terrainHasUnique$default(newCityTile, UniqueType.FreshWater, null, 2, null)) {
            tileValue += (float)5;
        }
        if (Tile.terrainHasUnique$default(newCityTile, UniqueType.Unbuildable, null, 2, null)) {
            tileValue += (float)3;
        }
        if (newCityTile.getResource() != null) {
            tileValue -= (float)4;
        }
        int tiles2 = 0;
        for (int i = 0; i < 4; ++i) {
            Iterator<Tile> iterator2 = newCityTile.getTilesAtDistance(i).iterator();
            while (iterator2.hasNext()) {
                Tile nearbyTile = iterator2.next();
                ++tiles2;
                tileValue += this.rankTile(nearbyTile, civ, onCoast, newUniqueLuxuryResources, baseTileMap, uniqueCache);
            }
        }
        return tileValue -= (float)((HexMath.INSTANCE.getNumberOfTilesInHexagon(3) - tiles2) * 3);
    }

    private final float getDistanceToCityModifier(Tile newCityTile, Sequence<City> nearbyCities2, Civilization civ) {
        float modifier = 0.0f;
        Iterator<City> iterator2 = nearbyCities2.iterator();
        while (iterator2.hasNext()) {
            float distanceToCityModifier;
            City city2 = iterator2.next();
            int distanceToCity = newCityTile.aerialDistanceTo(city2.getCenterTile());
            float f = distanceToCity == 7 ? 2.0f : (distanceToCity == 6 ? 4.0f : (distanceToCity == 5 ? 8.0f : (distanceToCity == 4 ? 6.0f : (distanceToCity == 3 ? -25.0f : (distanceToCityModifier = distanceToCity < 3 ? -30.0f : 0.0f)))));
            if (Intrinsics.areEqual(city2.getCiv(), civ)) {
                distanceToCityModifier *= (float)(city2.isCapital() ? 2 : 1);
            }
            modifier += distanceToCityModifier;
        }
        return modifier;
    }

    private final float rankTile(Tile rankTile, Civilization civ, boolean onCoast, HashSet<String> newUniqueLuxuryResources, HashMap<Tile, Float> baseTileMap, LocalUniqueCache uniqueCache) {
        if (rankTile.getCity() != null) {
            return -1.0f;
        }
        float locationSpecificTileValue = 0.0f;
        if (rankTile.isCoastalTile() && !onCoast) {
            locationSpecificTileValue -= (float)2;
        }
        if (onCoast && rankTile.isOcean()) {
            locationSpecificTileValue += 1.0f;
        }
        if (rankTile.getResource() != null && rankTile.getTileResource().getResourceType() == ResourceType.Luxury) {
            String string = rankTile.getResource();
            Intrinsics.checkNotNull(string);
            if (!civ.hasResource(string) && !CollectionsKt.contains((Iterable)newUniqueLuxuryResources, rankTile.getResource())) {
                locationSpecificTileValue += (float)10;
                String string2 = rankTile.getResource();
                Intrinsics.checkNotNull(string2);
                newUniqueLuxuryResources.add(string2);
            }
        }
        if (baseTileMap.containsKey(rankTile)) {
            Float f = baseTileMap.get(rankTile);
            Intrinsics.checkNotNull(f);
            return locationSpecificTileValue + ((Number)f).floatValue();
        }
        if (rankTile.getOwner() != null && !Intrinsics.areEqual(rankTile.getOwner(), civ)) {
            return 0.0f;
        }
        float rankTileValue = Automation.INSTANCE.rankStatsValue(rankTile.getStats().getTileStats(null, civ, uniqueCache), civ);
        if (!rankTile.isLand()) {
            rankTileValue -= 1.0f;
        }
        if (rankTile.getResource() != null) {
            float f;
            switch (WhenMappings.$EnumSwitchMapping$0[rankTile.getTileResource().getResourceType().ordinal()]) {
                case 1: {
                    f = 2.0f;
                    break;
                }
                case 2: {
                    f = 1.2f * (float)rankTile.getResourceAmount();
                    break;
                }
                case 3: {
                    f = 5.0f * (float)rankTile.getResourceAmount();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            rankTileValue += f;
        }
        if (rankTile.isNaturalWonder()) {
            rankTileValue += (float)10;
        }
        Float f = Float.valueOf(rankTileValue);
        ((Map)baseTileMap).put(rankTile, f);
        return rankTileValue + locationSpecificTileValue;
    }

    public static final /* synthetic */ boolean access$canSettleTile(CityLocationTileRanker $this, Tile tile, Civilization civ, Sequence nearbyCities2) {
        return $this.canSettleTile(tile, civ, nearbyCities2);
    }

    public static final /* synthetic */ float access$rankTileToSettle(CityLocationTileRanker $this, Tile newCityTile, Civilization civ, Sequence nearbyCities2, HashMap baseTileMap, LocalUniqueCache uniqueCache) {
        return $this.rankTileToSettle(newCityTile, civ, nearbyCities2, baseTileMap, uniqueCache);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR6\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u0010j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n`\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/unciv/logic/automation/unit/CityLocationTileRanker$BestTilesToFoundCity;", "", "()V", "bestTile", "Lcom/unciv/logic/map/tile/Tile;", "getBestTile", "()Lcom/unciv/logic/map/tile/Tile;", "setBestTile", "(Lcom/unciv/logic/map/tile/Tile;)V", "bestTileRank", "", "getBestTileRank", "()F", "setBestTileRank", "(F)V", "tileRankMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getTileRankMap", "()Ljava/util/HashMap;", "setTileRankMap", "(Ljava/util/HashMap;)V", "core"})
    public static final class BestTilesToFoundCity {
        @NotNull
        private HashMap<Tile, Float> tileRankMap = new HashMap();
        @Nullable
        private Tile bestTile;
        private float bestTileRank;

        @NotNull
        public final HashMap<Tile, Float> getTileRankMap() {
            return this.tileRankMap;
        }

        public final void setTileRankMap(@NotNull HashMap<Tile, Float> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
            this.tileRankMap = hashMap;
        }

        @Nullable
        public final Tile getBestTile() {
            return this.bestTile;
        }

        public final void setBestTile(@Nullable Tile tile) {
            this.bestTile = tile;
        }

        public final float getBestTileRank() {
            return this.bestTileRank;
        }

        public final void setBestTileRank(float f) {
            this.bestTileRank = f;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            try {
                nArray[ResourceType.Bonus.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Strategic.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Luxury.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

