/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.badlogic.gdx.math.Vector2;
import com.unciv.UncivGame;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.battle.AirInterception;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.BattleUnitCapture;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.Nuke;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.PromoteUnitAction;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.RejectionReason;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.UnitMovementMemoryType;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsPillage;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001@B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0018H\u0002J\"\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00142\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ \u0010\u001d\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J \u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\bH\u0002J(\u0010#\u001a\u0012\u0012\u0004\u0012\u00020%0$j\b\u0012\u0004\u0012\u00020%`&2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0018H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010\u00062\u0006\u0010*\u001a\u00020\u001fJ\u0016\u0010+\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J \u0010,\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010-\u001a\u00020!J \u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\bH\u0002J\u0018\u00102\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J \u00103\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J=\u00104\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b6J\u0018\u00107\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u001d\u00108\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b9J%\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b=J\u0018\u0010>\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0018H\u0002J\u0010\u0010?\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a8\u0006A"}, d2={"Lcom/unciv/logic/battle/Battle;", "", "()V", "addXp", "", "thisCombatant", "Lcom/unciv/logic/battle/ICombatant;", "amount", "", "otherCombatant", "addXp$core", "attack", "Lcom/unciv/logic/battle/Battle$DamageDealt;", "attacker", "defender", "attackOrNuke", "attackableTile", "Lcom/unciv/logic/battle/AttackableTile;", "automateCityConquer", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "city", "Lcom/unciv/logic/city/City;", "conquerCity", "Lcom/unciv/logic/battle/MapUnitCombatant;", "destroyIfDefeated", "attackedCiv", "notificationLocation", "Lcom/badlogic/gdx/math/Vector2;", "doDestroyImprovementsAbility", "attackedTile", "Lcom/unciv/logic/map/tile/Tile;", "doWithdrawFromMeleeAbility", "", "withdrawChance", "getKillUnitPlunderUniques", "Ljava/util/ArrayList;", "Lcom/unciv/models/ruleset/unique/Unique;", "Lkotlin/collections/ArrayList;", "civUnit", "defeatedUnit", "getMapCombatantOfTile", "tile", "moveAndAttack", "movePreparingAttack", "tryHealPillage", "plunderFromDamage", "plunderingUnit", "plunderedUnit", "damageDealt", "postBattleAddXp", "postBattleMoveToAttackedTile", "postBattleNotifications", "attackerTile", "postBattleNotifications$core", "reduceAttackerMovementPointsAndAttacks", "takeDamage", "takeDamage$core", "triggerDefeatUniques", "ourUnit", "enemy", "triggerDefeatUniques$core", "tryEarnFromKilling", "tryHealAfterKilling", "DamageDealt", "core"})
@SourceDebugExtension(value={"SMAP\nBattle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Battle.kt\ncom/unciv/logic/battle/Battle\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,691:1\n1284#2,3:692\n179#2,2:697\n2159#2,2:708\n288#3,2:695\n1747#3,3:699\n1747#3,3:702\n766#3:706\n857#3:707\n858#3:710\n1747#3,3:711\n1#4:705\n*S KotlinDebug\n*F\n+ 1 Battle.kt\ncom/unciv/logic/battle/Battle\n*L\n138#1:692,3\n282#1:697,2\n514#1:708,2\n222#1:695,2\n337#1:699,3\n342#1:702,3\n512#1:706\n512#1:707\n512#1:710\n182#1:711,3\n*E\n"})
public final class Battle {
    @NotNull
    public static final Battle INSTANCE = new Battle();

    private Battle() {
    }

    public final void moveAndAttack(@NotNull ICombatant attacker, @NotNull AttackableTile attackableTile) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(attackableTile, "attackableTile");
        if (!this.movePreparingAttack(attacker, attackableTile, true)) {
            return;
        }
        this.attackOrNuke(attacker, attackableTile);
    }

    public final boolean movePreparingAttack(@NotNull ICombatant attacker, @NotNull AttackableTile attackableTile, boolean tryHealPillage) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(attackableTile, "attackableTile");
        if (!(attacker instanceof MapUnitCombatant)) {
            return true;
        }
        List<Tile> tilesMovedThrough = UnitMovement.getDistanceToTiles$default(((MapUnitCombatant)attacker).getUnit().getMovement(), false, null, null, false, 15, null).getPathToTile(attackableTile.getTileToAttackFrom());
        UnitMovement.moveToTile$default(((MapUnitCombatant)attacker).getUnit().getMovement(), attackableTile.getTileToAttackFrom(), false, 2, null);
        if (!Intrinsics.areEqual(attacker.getTile(), attackableTile.getTileToAttackFrom())) {
            return false;
        }
        ICombatant combatant = this.getMapCombatantOfTile(attackableTile.getTileToAttack());
        if (combatant == null || Intrinsics.areEqual(combatant.getCivInfo(), attacker.getCivInfo())) {
            return false;
        }
        if (MapUnitCombatant.hasUnique$default((MapUnitCombatant)attacker, UniqueType.MustSetUp, null, 2, null) && !((MapUnitCombatant)attacker).getUnit().isSetUpForSiege() && ((MapUnitCombatant)attacker).getUnit().getCurrentMovement() > 0.0f) {
            ((MapUnitCombatant)attacker).getUnit().setAction(UnitActionType.SetUp.getValue());
            ((MapUnitCombatant)attacker).getUnit().useMovementPoints(1.0f);
        }
        if (tryHealPillage) {
            for (Tile tileToPillage : tilesMovedThrough) {
                if (((MapUnitCombatant)attacker).getUnit().getCurrentMovement() <= 1.0f || ((MapUnitCombatant)attacker).getUnit().getHealth() > 90) break;
                if (!UnitActionsPillage.INSTANCE.canPillage(((MapUnitCombatant)attacker).getUnit(), tileToPillage) || !tileToPillage.canPillageTileImprovement()) continue;
                Object object = UnitActionsPillage.INSTANCE.getPillageAction$core(((MapUnitCombatant)attacker).getUnit(), tileToPillage);
                if (object != null && (object = ((UnitAction)object).getAction()) != null) {
                    object.invoke();
                }
            }
        }
        return ((MapUnitCombatant)attacker).getUnit().getCurrentMovement() > 0.0f;
    }

    public static /* synthetic */ boolean movePreparingAttack$default(Battle battle, ICombatant iCombatant, AttackableTile attackableTile, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return battle.movePreparingAttack(iCombatant, attackableTile, bl);
    }

    @NotNull
    public final DamageDealt attackOrNuke(@NotNull ICombatant attacker, @NotNull AttackableTile attackableTile) {
        DamageDealt damageDealt;
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(attackableTile, "attackableTile");
        if (attacker instanceof MapUnitCombatant && ((MapUnitCombatant)attacker).getUnit().isNuclearWeapon()) {
            Nuke.INSTANCE.NUKE((MapUnitCombatant)attacker, attackableTile.getTileToAttack());
            damageDealt = DamageDealt.Companion.getNone();
        } else {
            ICombatant iCombatant = this.getMapCombatantOfTile(attackableTile.getTileToAttack());
            Intrinsics.checkNotNull(iCombatant);
            damageDealt = this.attack(attacker, iCombatant);
        }
        return damageDealt;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DamageDealt attack(@NotNull ICombatant attacker, @NotNull ICombatant defender) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Object[] objectArray = new Object[]{attacker.getCivInfo().getCivName(), attacker.getName(), defender.getCivInfo().getCivName(), defender.getName()};
        LogKt.debug("%s %s attacked %s %s", objectArray);
        Tile attackedTile = defender.getTile();
        if (attacker instanceof MapUnitCombatant) {
            ((MapUnitCombatant)attacker).getUnit().getAttacksSinceTurnStart().add(new Vector2(attackedTile.getPosition()));
        } else {
            attacker.getCivInfo().getAttacksSinceTurnStart().add(new Civilization.HistoricalAttackMemory(null, new Vector2(attacker.getTile().getPosition()), new Vector2(attackedTile.getPosition())));
        }
        DamageDealt interceptDamage = null;
        if (attacker instanceof MapUnitCombatant && ((MapUnitCombatant)attacker).getUnit().getBaseUnit().isAirUnit()) {
            interceptDamage = AirInterception.INSTANCE.tryInterceptAirAttack$core((MapUnitCombatant)attacker, attackedTile, defender.getCivInfo(), defender);
            if (attacker.isDefeated()) {
                return interceptDamage;
            }
        } else {
            interceptDamage = DamageDealt.Companion.getNone();
        }
        if (attacker instanceof MapUnitCombatant && attacker.isMelee() && defender instanceof MapUnitCombatant) {
            int withdrawChance;
            int n;
            Object object = defender.getCivInfo();
            if (MapUnit.hasUnique$default(((MapUnitCombatant)defender).getUnit(), UniqueType.WithdrawsBeforeMeleeCombat, new StateForConditionals((Civilization)object, null, null, attackedTile, defender, attacker, null, null, null, false, 966, null), false, 4, null)) {
                n = 100;
            } else {
                void $this$fold$iv;
                void initial$iv;
                object = MapUnit.getMatchingUniques$default(((MapUnitCombatant)defender).getUnit(), UniqueType.MayWithdraw, null, false, 6, null);
                int n2 = 100;
                int n3 = 100;
                boolean $i$f$fold = false;
                void accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void unique;
                    Unique unique2 = (Unique)element$iv;
                    void probabilityToWithdraw = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = probabilityToWithdraw * (100 - Integer.parseInt(unique.getParams().get(0))) / 100;
                }
                void var16_20 = accumulator$iv;
                n = withdrawChance = n3 - var16_20;
            }
            if (withdrawChance != 0 && this.doWithdrawFromMeleeAbility((MapUnitCombatant)attacker, (MapUnitCombatant)defender, withdrawChance)) {
                return DamageDealt.Companion.getNone();
            }
        }
        boolean isAlreadyDefeatedCity = defender instanceof CityCombatant && defender.isDefeated();
        DamageDealt damageDealt = this.takeDamage$core(attacker, defender);
        boolean captureMilitaryUnitSuccess = BattleUnitCapture.INSTANCE.tryCaptureMilitaryUnit(attacker, defender, attackedTile);
        if (!captureMilitaryUnitSuccess) {
            this.postBattleNotifications$core(attacker, defender, attackedTile, attacker.getTile(), damageDealt);
        }
        if (defender.getCivInfo().isBarbarian() && Intrinsics.areEqual(attackedTile.getImprovement(), "Barbarian encampment")) {
            defender.getCivInfo().getGameInfo().getBarbarians().campAttacked(attackedTile.getPosition());
        }
        if (defender.isDefeated() && defender instanceof CityCombatant && attacker instanceof MapUnitCombatant && attacker.isMelee() && !MapUnit.hasUnique$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.CannotCaptureCities, null, false, 6, null)) {
            if (((MapUnitCombatant)attacker).getUnit().getCiv().isBarbarian()) {
                defender.takeDamage(-1);
                int ransom = Math.min(200, ((CityCombatant)defender).getCity().getCiv().getGold());
                ((CityCombatant)defender).getCity().getCiv().addGold(-ransom);
                String[] accumulator$iv = new String[]{"OtherIcons/Pillage"};
                ((CityCombatant)defender).getCity().getCiv().addNotification("Barbarians raided [" + ((CityCombatant)defender).getCity().getName() + "] and stole [" + ransom + "] Gold from your treasury!", ((CityCombatant)defender).getCity().getLocation(), Notification.NotificationCategory.War, accumulator$iv);
                MapUnit.destroy$default(((MapUnitCombatant)attacker).getUnit(), false, 1, null);
            } else {
                this.conquerCity(((CityCombatant)defender).getCity(), (MapUnitCombatant)attacker);
            }
        }
        if (!defender.isDefeated() && defender instanceof MapUnitCombatant && ((MapUnitCombatant)defender).getUnit().isExploring()) {
            ((MapUnitCombatant)defender).getUnit().setAction(null);
        }
        if (defender.isDefeated() && defender instanceof MapUnitCombatant && !((MapUnitCombatant)defender).getUnit().isCivilian()) {
            this.tryEarnFromKilling(attacker, (MapUnitCombatant)defender);
            this.tryHealAfterKilling(attacker);
            if (attacker instanceof MapUnitCombatant) {
                Battle.attack$triggerVictoryUniques(attackedTile, (MapUnitCombatant)attacker, (MapUnitCombatant)defender);
            }
            this.triggerDefeatUniques$core((MapUnitCombatant)defender, attacker, attackedTile);
        } else if (attacker.isDefeated() && attacker instanceof MapUnitCombatant && !((MapUnitCombatant)attacker).getUnit().isCivilian()) {
            this.tryEarnFromKilling(defender, (MapUnitCombatant)attacker);
            this.tryHealAfterKilling(defender);
            if (defender instanceof MapUnitCombatant) {
                Battle.attack$triggerVictoryUniques(attackedTile, (MapUnitCombatant)defender, (MapUnitCombatant)attacker);
            }
            this.triggerDefeatUniques$core((MapUnitCombatant)attacker, defender, attackedTile);
        }
        if (attacker instanceof MapUnitCombatant) {
            if (MapUnit.hasUnique$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.SelfDestructs, null, false, 6, null)) {
                MapUnit.destroy$default(((MapUnitCombatant)attacker).getUnit(), false, 1, null);
            } else if (((MapUnitCombatant)attacker).getUnit().isMoving()) {
                ((MapUnitCombatant)attacker).getUnit().setAction(null);
            }
            this.doDestroyImprovementsAbility((MapUnitCombatant)attacker, attackedTile, defender);
        }
        if (!captureMilitaryUnitSuccess) {
            this.postBattleMoveToAttackedTile(attacker, defender, attackedTile);
        }
        this.reduceAttackerMovementPointsAndAttacks(attacker, defender);
        if (!isAlreadyDefeatedCity) {
            this.postBattleAddXp(attacker, defender);
        }
        if (attacker instanceof CityCombatant) {
            Object v1;
            block29: {
                void $this$firstOrNull$iv;
                Iterable accumulator$iv = attacker.getCivInfo().getNotifications();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Notification it = (Notification)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getText(), "Your city [" + attacker.getName() + "] can bombard the enemy!")) continue;
                    v1 = element$iv;
                    break block29;
                }
                v1 = null;
            }
            Notification cityCanBombardNotification = v1;
            TypeIntrinsics.asMutableCollection(attacker.getCivInfo().getNotifications()).remove(cityCanBombardNotification);
        }
        return damageDealt.plus(interceptDamage);
    }

    public final void triggerDefeatUniques$core(@NotNull MapUnitCombatant ourUnit, @NotNull ICombatant enemy, @NotNull Tile attackedTile) {
        Intrinsics.checkNotNullParameter(ourUnit, "ourUnit");
        Intrinsics.checkNotNullParameter(enemy, "enemy");
        Intrinsics.checkNotNullParameter(attackedTile, "attackedTile");
        Object object = ourUnit.getCivInfo();
        StateForConditionals stateForConditionals = new StateForConditionals((Civilization)object, null, null, attackedTile, ourUnit, enemy, null, null, null, false, 966, null);
        object = ourUnit.getUnit().getTriggeredUniques(UniqueType.TriggerUponDefeat, stateForConditionals).iterator();
        while (object.hasNext()) {
            Unique unique = (Unique)object.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, ourUnit.getUnit(), null, "due to our [" + ourUnit.getName() + "] being defeated by a [" + enemy.getName() + ']', 4, null);
        }
    }

    private final void tryEarnFromKilling(ICombatant civUnit, MapUnitCombatant defeatedUnit) {
        int unitStr = Math.max(defeatedUnit.getUnit().getBaseUnit().getStrength(), defeatedUnit.getUnit().getBaseUnit().getRangedStrength());
        int unitCost = defeatedUnit.getUnit().getBaseUnit().getCost();
        ArrayList<Unique> bonusUniques = this.getKillUnitPlunderUniques(civUnit, defeatedUnit);
        for (Unique unique : bonusUniques) {
            if (!defeatedUnit.matchesFilter(unique.getParams().get(1))) continue;
            float yieldPercent = Float.parseFloat(unique.getParams().get(0)) / (float)100;
            String defeatedUnitYieldSourceType = unique.getParams().get(2);
            int yieldTypeSourceAmount = Intrinsics.areEqual(defeatedUnitYieldSourceType, "Cost") ? unitCost : unitStr;
            int yieldAmount = (int)((float)yieldTypeSourceAmount * yieldPercent);
            Stat stat = Stat.valueOf(unique.getParams().get(3));
            civUnit.getCivInfo().addStat(stat, yieldAmount);
        }
        if (defeatedUnit.getCivInfo().isBarbarian() && !defeatedUnit.isCivilian() && civUnit.getCivInfo().isMajorCiv()) {
            for (Civilization cityState : defeatedUnit.getCivInfo().getGameInfo().getAliveCityStates()) {
                if (!civUnit.getCivInfo().knows(cityState) || !defeatedUnit.getUnit().threatensCiv(cityState)) continue;
                cityState.getCityStateFunctions().threateningBarbarianKilledBy(civUnit.getCivInfo());
            }
        }
        for (Civilization cityState : defeatedUnit.getCivInfo().getGameInfo().getAliveCityStates()) {
            cityState.getQuestManager().militaryUnitKilledBy(civUnit.getCivInfo(), defeatedUnit.getCivInfo());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final ArrayList<Unique> getKillUnitPlunderUniques(ICombatant civUnit, MapUnitCombatant defeatedUnit) {
        block6: {
            bonusUniques = new ArrayList<Unique>();
            stateForConditionals = new StateForConditionals(civUnit.getCivInfo(), null, null, null, civUnit, defeatedUnit, null, null, null, false, 974, null);
            if (civUnit instanceof MapUnitCombatant) {
                CollectionsKt.addAll((Collection)bonusUniques, ((MapUnitCombatant)civUnit).getMatchingUniques(UniqueType.KillUnitPlunder, stateForConditionals, true));
            } else {
                CollectionsKt.addAll((Collection)bonusUniques, civUnit.getCivInfo().getMatchingUniques(UniqueType.KillUnitPlunder, stateForConditionals));
            }
            $this$firstOrNull$iv = civUnit.getTile().getTilesInDistance(4);
            $i$f$firstOrNull = false;
            var9_7 = $this$firstOrNull$iv.iterator();
            while (var9_7.hasNext()) {
                it = element$iv = var9_7.next();
                $i$a$-firstOrNull-Battle$getKillUnitPlunderUniques$cityWithReligion$1 = false;
                if (!it.isCityCenter()) ** GOTO lbl-1000
                v0 = it.getCity();
                Intrinsics.checkNotNull(v0);
                if (SequencesKt.any(City.getMatchingUniques$default(v0, UniqueType.KillUnitPlunderNearCity, stateForConditionals, false, 4, null))) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block6;
            }
            v2 = null;
        }
        var6_11 = v2;
        v3 = cityWithReligion = var6_11 != null ? var6_11.getCity() : null;
        if (cityWithReligion != null) {
            CollectionsKt.addAll((Collection)bonusUniques, City.getMatchingUniques$default(cityWithReligion, UniqueType.KillUnitPlunderNearCity, stateForConditionals, false, 4, null));
        }
        return bonusUniques;
    }

    @NotNull
    public final DamageDealt takeDamage$core(@NotNull ICombatant attacker, @NotNull ICombatant defender) {
        Unique it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Unique unique;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        int potentialDamageToDefender = BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, attacker, defender, null, 0.0f, 12, null);
        int potentialDamageToAttacker = BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, attacker, defender, null, 0.0f, 12, null);
        int attackerHealthBefore = attacker.getHealth();
        int defenderHealthBefore = defender.getHealth();
        if (defender instanceof MapUnitCombatant && ((MapUnitCombatant)defender).getUnit().isCivilian() && attacker.isMelee()) {
            BattleUnitCapture.captureCivilianUnit$default(BattleUnitCapture.INSTANCE, attacker, (MapUnitCombatant)defender, false, 4, null);
        } else if (attacker.isRanged() && !attacker.isAirUnit()) {
            defender.takeDamage(potentialDamageToDefender);
        } else {
            while (potentialDamageToDefender + potentialDamageToAttacker > 0) {
                if (Random.Default.nextInt(potentialDamageToDefender + potentialDamageToAttacker) < potentialDamageToDefender) {
                    --potentialDamageToDefender;
                    defender.takeDamage(1);
                    if (!defender.isDefeated()) continue;
                    break;
                }
                --potentialDamageToAttacker;
                attacker.takeDamage(1);
                if (!attacker.isDefeated()) continue;
            }
        }
        int defenderDamageDealt = attackerHealthBefore - attacker.getHealth();
        int attackerDamageDealt = defenderHealthBefore - defender.getHealth();
        if (attacker instanceof MapUnitCombatant) {
            iterator2 = MapUnit.getTriggeredUniques$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.TriggerUponLosingHealth, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                block16: {
                    unique = (Unique)iterator2.next();
                    $this$any$iv = unique.getConditionals();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Unique)element$iv;
                            boolean bl2 = false;
                            if (!(Integer.parseInt(it.getParams().get(0)) <= defenderDamageDealt)) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, ((MapUnitCombatant)attacker).getUnit(), null, "due to losing [" + defenderDamageDealt + "] HP", 4, null);
            }
        }
        if (defender instanceof MapUnitCombatant) {
            iterator2 = MapUnit.getTriggeredUniques$default(((MapUnitCombatant)defender).getUnit(), UniqueType.TriggerUponLosingHealth, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                block17: {
                    unique = (Unique)iterator2.next();
                    $this$any$iv = unique.getConditionals();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Unique)element$iv;
                            boolean bl3 = false;
                            if (!(Integer.parseInt(it.getParams().get(0)) <= attackerDamageDealt)) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, ((MapUnitCombatant)defender).getUnit(), null, "due to losing [" + attackerDamageDealt + "] HP", 4, null);
            }
        }
        this.plunderFromDamage(attacker, defender, attackerDamageDealt);
        return new DamageDealt(attackerDamageDealt, defenderDamageDealt);
    }

    private final void plunderFromDamage(ICombatant plunderingUnit, ICombatant plunderedUnit, int damageDealt) {
        if (!(plunderingUnit instanceof MapUnitCombatant)) {
            return;
        }
        Stats plunderedGoods = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        Iterator iterator2 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)plunderingUnit).getUnit(), UniqueType.DamageUnitsPlunder, null, true, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!plunderedUnit.matchesFilter(unique.getParams().get(1))) continue;
            float percentage = Float.parseFloat(unique.getParams().get(0));
            plunderedGoods.add(Stat.valueOf(unique.getParams().get(2)), percentage / 100.0f * (float)damageDealt);
        }
        Civilization civ = plunderingUnit.getCivInfo();
        for (Stats.StatValuePair statValuePair : plunderedGoods) {
            Stat key = statValuePair.component1();
            float value = statValuePair.component2();
            int plunderedAmount = (int)value;
            if (plunderedAmount == 0) continue;
            civ.addStat(key, plunderedAmount);
            String[] stringArray = new String[]{plunderingUnit.getName(), "OtherIcons/Pillage", "StatIcons/" + key.name(), plunderedUnit instanceof CityCombatant ? "ImprovementIcons/City center" : plunderedUnit.getName()};
            civ.addNotification("Your [" + plunderingUnit.getName() + "] plundered [" + plunderedAmount + "] [" + key.name() + "] from [" + plunderedUnit.getName() + ']', plunderedUnit.getTile().getPosition(), Notification.NotificationCategory.War, stringArray);
        }
    }

    public final void postBattleNotifications$core(@NotNull ICombatant attacker, @NotNull ICombatant defender, @NotNull Tile attackedTile, @Nullable Tile attackerTile, @Nullable DamageDealt damageDealt) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Intrinsics.checkNotNullParameter(attackedTile, "attackedTile");
        if (!Intrinsics.areEqual(attacker.getCivInfo(), defender.getCivInfo())) {
            String attackerString;
            Pair<String, String> pair = !(attacker instanceof CityCombatant) && attacker.isDefeated() ? TuplesKt.to("OtherIcons/Pillage", " was destroyed while attacking") : (!defender.isDefeated() ? TuplesKt.to("OtherIcons/Pillage", " has attacked") : (defender.isCity() && attacker.isMelee() && attacker.getCivInfo().isBarbarian() ? TuplesKt.to("OtherIcons/Pillage", " has raided") : (defender.isCity() && attacker.isMelee() ? TuplesKt.to("OtherIcons/Pillage", " has captured") : TuplesKt.to("OtherIcons/DisbandUnit", " has destroyed"))));
            String whatHappenedIcon = pair.component1();
            String whatHappenedString = pair.component2();
            String string = attackerString = attacker.isCity() ? "Enemy city [" + attacker.getName() + ']' : "An enemy [" + attacker.getName() + ']';
            String defenderString = defender.isCity() ? (defender.isDefeated() && attacker.isRanged() ? " the defence of [" + defender.getName() + ']' : " [" + defender.getName() + ']') : " our [" + defender.getName() + ']';
            String attackerHurtString = damageDealt != null ? " ([-" + damageDealt.getDefenderDealt() + "] HP)" : "";
            String defenderHurtString = damageDealt != null ? " ([-" + damageDealt.getAttackerDealt() + "] HP)" : "";
            String notificationString = attackerString + attackerHurtString + whatHappenedString + defenderString + defenderHurtString;
            String attackerIcon = attacker instanceof CityCombatant ? "ImprovementIcons/City center" : attacker.getName();
            String defenderIcon = defender instanceof CityCombatant ? "ImprovementIcons/City center" : defender.getName();
            Object[] objectArray = new Vector2[2];
            objectArray[0] = attackedTile.getPosition();
            Tile tile = attackerTile;
            objectArray[1] = tile != null ? tile.getPosition() : null;
            Sequence<LocationAction> locations = LocationAction.Companion.invoke((Vector2[])objectArray);
            objectArray = new String[]{attackerIcon, whatHappenedIcon, defenderIcon};
            defender.getCivInfo().addNotification(notificationString, locations, Notification.NotificationCategory.War, (String[])objectArray);
        }
    }

    public static /* synthetic */ void postBattleNotifications$core$default(Battle battle, ICombatant iCombatant, ICombatant iCombatant2, Tile tile, Tile tile2, DamageDealt damageDealt, int n, Object object) {
        if ((n & 8) != 0) {
            tile2 = null;
        }
        if ((n & 0x10) != 0) {
            damageDealt = null;
        }
        battle.postBattleNotifications$core(iCombatant, iCombatant2, tile, tile2, damageDealt);
    }

    private final void tryHealAfterKilling(ICombatant attacker) {
        if (attacker instanceof MapUnitCombatant) {
            Iterator iterator2 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.HealsAfterKilling, null, true, 2, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                int amountToHeal = Integer.parseInt(unique.getParams().get(0));
                ((MapUnitCombatant)attacker).getUnit().healBy(amountToHeal);
            }
        }
    }

    private final void postBattleMoveToAttackedTile(ICombatant attacker, ICombatant defender, Tile attackedTile) {
        if (!attacker.isMelee()) {
            return;
        }
        if (!defender.isDefeated() && !Intrinsics.areEqual(defender.getCivInfo(), attacker.getCivInfo())) {
            return;
        }
        if (attacker instanceof MapUnitCombatant && ((MapUnitCombatant)attacker).getUnit().getCache().getCannotMove()) {
            return;
        }
        Intrinsics.checkNotNull(attacker, "null cannot be cast to non-null type com.unciv.logic.battle.MapUnitCombatant");
        if (UnitMovement.canMoveTo$default(((MapUnitCombatant)attacker).getUnit().getMovement(), attackedTile, false, false, false, 14, null)) {
            ((MapUnitCombatant)attacker).getUnit().getMovement().moveToTile(attackedTile, false);
            ((MapUnitCombatant)attacker).getUnit().setMostRecentMoveType(UnitMovementMemoryType.UnitAttacked);
        }
    }

    private final void postBattleAddXp(ICombatant attacker, ICombatant defender) {
        if (attacker.isAirUnit()) {
            this.addXp$core(attacker, 4, defender);
            this.addXp$core(defender, 2, attacker);
        } else if (attacker.isRanged()) {
            if (defender.isCity()) {
                this.addXp$core(attacker, 3, defender);
            } else {
                this.addXp$core(attacker, 2, defender);
            }
            this.addXp$core(defender, 2, attacker);
        } else if (!defender.isCivilian()) {
            this.addXp$core(attacker, 5, defender);
            this.addXp$core(defender, 4, attacker);
        }
    }

    private final void reduceAttackerMovementPointsAndAttacks(ICombatant attacker, ICombatant defender) {
        if (attacker instanceof MapUnitCombatant) {
            MapUnit unit = ((MapUnitCombatant)attacker).getUnit();
            if (defender.isCivilian() && Intrinsics.areEqual(attacker.getTile(), defender.getTile())) {
                return;
            }
            unit.setAttacksThisTurn(unit.getAttacksThisTurn() + 1);
            if (MapUnit.hasUnique$default(unit, UniqueType.CanMoveAfterAttacking, null, false, 6, null) || unit.maxAttacksPerTurn() > unit.getAttacksThisTurn()) {
                if (!(((MapUnitCombatant)attacker).getUnit().getBaseUnit().getMovesLikeAirUnits() || attacker.isMelee() && defender.isDefeated())) {
                    unit.useMovementPoints(1.0f);
                }
            } else {
                unit.setCurrentMovement(0.0f);
            }
            if (unit.isFortified() || unit.isSleeping()) {
                ((MapUnitCombatant)attacker).getUnit().setAction(null);
            }
        } else if (attacker instanceof CityCombatant) {
            ((CityCombatant)attacker).getCity().setAttackedThisTurn(true);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void addXp$core(@NotNull ICombatant thisCombatant, int amount, @NotNull ICombatant otherCombatant) {
        block13: {
            Intrinsics.checkNotNullParameter(thisCombatant, "thisCombatant");
            Intrinsics.checkNotNullParameter(otherCombatant, "otherCombatant");
            if (!(thisCombatant instanceof MapUnitCombatant)) {
                return;
            }
            civ = thisCombatant.getCivInfo();
            otherIsBarbarian = otherCombatant.getCivInfo().isBarbarian();
            promotions = ((MapUnitCombatant)thisCombatant).getUnit().getPromotions();
            modConstants = civ.getGameInfo().getRuleset().getModOptions().getConstants();
            if (otherIsBarbarian && promotions.totalXpProduced() >= modConstants.getMaxXPfromBarbarians()) {
                return;
            }
            unitCouldAlreadyPromote = promotions.canBePromoted();
            stateForConditionals = new StateForConditionals(civ, null, null, null, thisCombatant, otherCombatant, null, null, null, false, 974, null);
            var11_10 = ((MapUnitCombatant)thisCombatant).getMatchingUniques(UniqueType.FlatXPGain, stateForConditionals, true);
            var32_12 = amount;
            var12_15 = 0;
            var13_16 = var11_10.iterator();
            while (var13_16.hasNext()) {
                var15_24 = var14_22 = var13_16.next();
                var33_18 = var12_15;
                $i$a$-sumOfInt-Battle$addXp$baseXP$1 = false;
                var34_19 = Integer.parseInt(it.getParams().get(0));
                var12_15 = var33_18 + var34_19;
            }
            var33_18 = var12_15;
            baseXP = var32_12 + var33_18;
            var13_16 = ((MapUnitCombatant)thisCombatant).getMatchingUniques(UniqueType.PercentageXPGain, stateForConditionals, true);
            var14_23 = 0.0;
            $i$a$-sumOfInt-Battle$addXp$baseXP$1 = var13_16.iterator();
            while ($i$a$-sumOfInt-Battle$addXp$baseXP$1.hasNext()) {
                var17_29 = $i$a$-sumOfInt-Battle$addXp$baseXP$1.next();
                var18_30 = (Unique)var17_29;
                var32_13 = var14_23;
                $i$a$-sumOfDouble-Battle$addXp$xpBonus$1 = false;
                var34_20 = Double.parseDouble(it.getParams().get(0));
                var14_23 = var32_13 + var34_20;
            }
            xpBonus = var14_23;
            xpModifier = 1.0 + xpBonus / (double)100;
            xpGained = (int)((double)baseXP * xpModifier);
            promotions.setXP(promotions.getXP() + xpGained);
            if (otherIsBarbarian || !civ.isMajorCiv()) break block13;
            var17_29 = civ.getGameInfo().getRuleset().getGreatGeneralUnits();
            $i$f$filter = false;
            $i$a$-sumOfDouble-Battle$addXp$xpBonus$1 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block12: {
                    it = (BaseUnit)element$iv$iv;
                    $i$a$-filter-Battle$addXp$greatGeneralUnits$1 = false;
                    if (!it.hasUnique(UniqueType.GreatPersonFromCombat, stateForConditionals)) ** GOTO lbl-1000
                    Intrinsics.checkNotNull(it);
                    $this$none$iv = BaseUnit.getRejectionReasons$default(it, civ, null, null, 6, null);
                    $i$f$none = false;
                    var28_49 = $this$none$iv.iterator();
                    while (var28_49.hasNext()) {
                        element$iv = var28_49.next();
                        reason = (RejectionReason)element$iv;
                        $i$a$-none-Battle$addXp$greatGeneralUnits$1$1 = false;
                        v0 = !reason.isConstructionRejection() && !reason.techPolicyEraWonderRequirements();
                        if (!v0) continue;
                        v1 = false;
                        break block12;
                    }
                    v1 = true;
                }
                if (v1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            greatGeneralUnits /* !! */  = CollectionsKt.asSequence((List)destination$iv$iv);
            if (civ.getGameInfo().getRuleset().getGreatGeneralUnits().isEmpty() && civ.getGameInfo().getRuleset().getUnits().get("Great General") != null) {
                v3 = civ.getGameInfo().getRuleset().getUnits().get("Great General");
                Intrinsics.checkNotNull(v3);
                greatGeneralUnits /* !! */  = SequencesKt.plus(greatGeneralUnits /* !! */ , v3);
            }
            var17_29 = greatGeneralUnits /* !! */ .iterator();
            while (var17_29.hasNext()) {
                unit = (BaseUnit)var17_29.next();
                $i$f$filterTo = SequencesKt.filter(((MapUnitCombatant)thisCombatant).getMatchingUniques(UniqueType.GreatPersonEarnedFaster, stateForConditionals, true), (Function1)new Function1<Unique, Boolean>(unit){
                    final /* synthetic */ BaseUnit $unit;
                    {
                        this.$unit = $unit;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Unique it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$unit.matchesFilter(it.getParams().get(0));
                    }
                });
                var22_41 = 0.0;
                var24_44 = $i$f$filterTo.iterator();
                while (var24_44.hasNext()) {
                    $this$none$iv = var25_46 = var24_44.next();
                    var32_14 = var22_41;
                    $i$a$-sumOfDouble-Battle$addXp$greatGeneralPointsBonus$2 = false;
                    var34_21 = Double.parseDouble(it.getParams().get(1));
                    var22_41 = var32_14 + var34_21;
                }
                greatGeneralPointsBonus = var22_41;
                greatGeneralPointsModifier = 1.0 + greatGeneralPointsBonus / (double)100;
                greatGeneralPointsGained = (int)((double)xpGained * greatGeneralPointsModifier);
                var24_44 = civ.getGreatPeople().getGreatGeneralPointsCounter();
                var25_46 = unit.getName();
                ((Map)var24_44).put(var25_46, ((Number)var24_44.get(var25_46)).intValue() + greatGeneralPointsGained);
            }
        }
        if (!thisCombatant.isDefeated() && !unitCouldAlreadyPromote && promotions.canBePromoted()) {
            pos = thisCombatant.getTile().getPosition();
            var17_29 = new NotificationAction[]{new MapUnitAction(pos, 0, 2, null), new PromoteUnitAction(thisCombatant.getName(), pos)};
            v4 = CollectionsKt.listOf(var17_29);
            var17_29 = new String[]{((MapUnitCombatant)thisCombatant).getUnit().getName()};
            civ.addNotification('[' + ((MapUnitCombatant)thisCombatant).getUnit().displayName() + "] can be promoted!", v4, Notification.NotificationCategory.Units, (String[])var17_29);
        }
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private final void conquerCity(City city, MapUnitCombatant attacker) {
        block10: {
            block9: {
                attackerCiv = attacker.getCivInfo();
                var4_4 = new String[]{"OtherIcons/Pillage"};
                attackerCiv.addNotification("We have conquered the city of [" + city.getName() + "]!", city.getLocation(), Notification.NotificationCategory.War, (String[])var4_4);
                city.setHasJustBeenConquered(true);
                $this$conquerCity_u24lambda_u2411 = var4_4 = city.getCenterTile();
                $i$a$-apply-Battle$conquerCity$1 = false;
                if ($this$conquerCity_u24lambda_u2411.getMilitaryUnit() != null) {
                    v0 = $this$conquerCity_u24lambda_u2411.getMilitaryUnit();
                    Intrinsics.checkNotNull(v0);
                    MapUnit.destroy$default(v0, false, 1, null);
                }
                if ($this$conquerCity_u24lambda_u2411.getCivilianUnit() != null) {
                    v1 = attacker;
                    v2 = $this$conquerCity_u24lambda_u2411.getCivilianUnit();
                    Intrinsics.checkNotNull(v2);
                    BattleUnitCapture.INSTANCE.captureCivilianUnit(v1, new MapUnitCombatant(v2), false);
                }
                for (MapUnit airUnit : CollectionsKt.toList((Iterable)$this$conquerCity_u24lambda_u2411.getAirUnits())) {
                    MapUnit.destroy$default(airUnit, false, 1, null);
                }
                stateForConditionals = new StateForConditionals(attackerCiv, city, attacker.getUnit(), null, attacker, null, city.getCenterTile(), null, null, false, 936, null);
                var5_5 = attacker.getMatchingUniques(UniqueType.CaptureCityPlunder, stateForConditionals, true).iterator();
                while (var5_5.hasNext()) {
                    unique = var5_5.next();
                    attackerCiv.addStat(Stat.valueOf(unique.getParams().get(2)), Integer.parseInt(unique.getParams().get(0)) * (int)city.getCityStats().getCurrentCityStats().get(Stat.valueOf(unique.getParams().get(1))));
                }
                if (attackerCiv.isBarbarian() || attackerCiv.isOneCityChallenger()) {
                    city.destroyCity(true);
                    return;
                }
                if (!city.isOriginalCapital() || !Intrinsics.areEqual(city.getFoundingCiv(), attackerCiv.getCivName())) break block9;
                city.puppetCity(attackerCiv);
                city.annexCity();
                break block10;
            }
            if (!attackerCiv.isHuman()) ** GOTO lbl-1000
            v3 = UncivGame.Companion.getCurrent().getWorldScreen();
            v4 = v3 != null && (v3 = v3.getAutoPlay()) != null ? !v3.isAutoPlayingAndFullAutoPlayAI() : false;
            if (v4) {
                attackerCiv.getPopupAlerts().add(new PopupAlert(AlertType.CityConquered, city.getId()));
            } else lbl-1000:
            // 2 sources

            {
                this.automateCityConquer(attackerCiv, city);
            }
        }
        if (attackerCiv.isCurrentPlayer()) {
            UncivGame.Companion.getCurrent().getSettings().addCompletedTutorialTask("Conquer a city");
        }
        for (Unique unique : CollectionsKt.plus(attackerCiv.getTriggeredUniques(UniqueType.TriggerUponConqueringCity, stateForConditionals), attacker.getUnit().getTriggeredUniques(UniqueType.TriggerUponConqueringCity, stateForConditionals))) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, attacker.getUnit(), null, null, 12, null);
        }
    }

    private final void automateCityConquer(Civilization civInfo, City city2) {
        if (!city2.hasDiplomaticMarriage()) {
            Civilization foundingCiv = civInfo.getGameInfo().getCivilization(city2.getFoundingCiv());
            int valueAlliance = NextTurnAutomation.valueCityStateAlliance$core$default(NextTurnAutomation.INSTANCE, civInfo, foundingCiv, false, 4, null);
            if (civInfo.getHappiness() < 0) {
                valueAlliance -= civInfo.getHappiness();
            }
            if (foundingCiv.isCityState() && !Intrinsics.areEqual(city2.getCiv(), civInfo) && !Intrinsics.areEqual(foundingCiv, civInfo) && !civInfo.isAtWarWith(foundingCiv) && valueAlliance > 0) {
                city2.liberateCity(civInfo);
                return;
            }
        }
        city2.puppetCity(civInfo);
        if ((city2.getPopulation().getPopulation() < 4 || civInfo.isCityState()) && !Intrinsics.areEqual(city2.getFoundingCiv(), civInfo.getCivName()) && city2.canBeDestroyed(true)) {
            if (!Civilization.hasUnique$default(civInfo, UniqueType.MayNotAnnexCities, null, 2, null)) {
                city2.annexCity();
            }
            city2.setBeingRazed(true);
        }
    }

    @Nullable
    public final ICombatant getMapCombatantOfTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (tile.isCityCenter()) {
            City city2 = tile.getCity();
            Intrinsics.checkNotNull(city2);
            return new CityCombatant(city2);
        }
        if (tile.getMilitaryUnit() != null) {
            MapUnit mapUnit = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            return new MapUnitCombatant(mapUnit);
        }
        if (tile.getCivilianUnit() != null) {
            MapUnit mapUnit = tile.getCivilianUnit();
            Intrinsics.checkNotNull(mapUnit);
            return new MapUnitCombatant(mapUnit);
        }
        return null;
    }

    public final void destroyIfDefeated(@NotNull Civilization attackedCiv, @NotNull Civilization attacker, @Nullable Vector2 notificationLocation) {
        Intrinsics.checkNotNullParameter(attackedCiv, "attackedCiv");
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        if (attackedCiv.isDefeated()) {
            if (attackedCiv.isCityState()) {
                attackedCiv.getCityStateFunctions().cityStateDestroyed(attacker);
            }
            attackedCiv.destroy(notificationLocation);
            attacker.getPopupAlerts().add(new PopupAlert(AlertType.Defeated, attackedCiv.getCivName()));
        }
    }

    public static /* synthetic */ void destroyIfDefeated$default(Battle battle, Civilization civilization, Civilization civilization2, Vector2 vector2, int n, Object object) {
        if ((n & 4) != 0) {
            vector2 = null;
        }
        battle.destroyIfDefeated(civilization, civilization2, vector2);
    }

    private final boolean doWithdrawFromMeleeAbility(MapUnitCombatant attacker, MapUnitCombatant defender, int withdrawChance) {
        Tile tile;
        if (withdrawChance == 0) {
            return false;
        }
        if (defender.getUnit().isEmbarked()) {
            return false;
        }
        if (defender.getUnit().getCache().getCannotMove()) {
            return false;
        }
        if (RandomKt.Random((long)attacker.getCivInfo().getGameInfo().getTurns() * (long)defender.getTile().getPosition().hashCode()).nextInt(100) > withdrawChance) {
            return false;
        }
        Tile fromTile = defender.getTile();
        Tile attackerTile = attacker.getTile();
        Sequence<Tile> firstCandidateTiles2 = SequencesKt.filterNot(SequencesKt.filterNot(fromTile.getNeighbors(), (Function1)new Function1<Tile, Boolean>(attackerTile){
            final /* synthetic */ Tile $attackerTile;
            {
                this.$attackerTile = $attackerTile;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it, this.$attackerTile) || SequencesKt.contains(this.$attackerTile.getNeighbors(), it);
            }
        }), (Function1)new Function1<Tile, Boolean>(defender){
            final /* synthetic */ MapUnitCombatant $defender;
            {
                this.$defender = $defender;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Battle.access$doWithdrawFromMeleeAbility$canNotWithdrawTo(this.$defender, it);
            }
        });
        Sequence<Tile> secondCandidateTiles2 = SequencesKt.filterNot(SequencesKt.filter(fromTile.getNeighbors(), (Function1)new Function1<Tile, Boolean>(attackerTile){
            final /* synthetic */ Tile $attackerTile;
            {
                this.$attackerTile = $attackerTile;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return SequencesKt.contains(this.$attackerTile.getNeighbors(), it);
            }
        }), (Function1)new Function1<Tile, Boolean>(defender){
            final /* synthetic */ MapUnitCombatant $defender;
            {
                this.$defender = $defender;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Battle.access$doWithdrawFromMeleeAbility$canNotWithdrawTo(this.$defender, it);
            }
        });
        if (SequencesKt.any(firstCandidateTiles2)) {
            tile = (Tile)CollectionsKt.random((Collection)SequencesKt.toList(firstCandidateTiles2), Random.Default);
        } else if (SequencesKt.any(secondCandidateTiles2)) {
            tile = (Tile)CollectionsKt.random((Collection)SequencesKt.toList(secondCandidateTiles2), Random.Default);
        } else {
            return false;
        }
        Tile toTile = tile;
        defender.getUnit().removeFromTile();
        defender.getUnit().putInTile(toTile);
        defender.getUnit().setMostRecentMoveType(UnitMovementMemoryType.UnitWithdrew);
        this.reduceAttackerMovementPointsAndAttacks(attacker, defender);
        String attackerName = attacker.getName();
        String defenderName = defender.getName();
        String notificationString = '[' + defenderName + "] withdrew from a [" + attackerName + ']';
        Object[] objectArray = new Vector2[]{toTile.getPosition(), attacker.getTile().getPosition()};
        Sequence<LocationAction> locations = LocationAction.Companion.invoke((Vector2[])objectArray);
        objectArray = new String[]{defenderName, "OtherIcons/Pillage", attackerName};
        defender.getCivInfo().addNotification(notificationString, locations, Notification.NotificationCategory.War, (String[])objectArray);
        objectArray = new String[]{defenderName, "OtherIcons/Pillage", attackerName};
        attacker.getCivInfo().addNotification(notificationString, locations, Notification.NotificationCategory.War, (String[])objectArray);
        return true;
    }

    private final void doDestroyImprovementsAbility(MapUnitCombatant attacker, Tile attackedTile, ICombatant defender) {
        if (attackedTile.getImprovement() == null) {
            return;
        }
        Civilization civilization = attacker.getCivInfo();
        Object[] objectArray = CombatAction.Attack;
        StateForConditionals conditionalState = new StateForConditionals(civilization, null, null, null, attacker, defender, attackedTile, (CombatAction)objectArray, null, false, 782, null);
        TileImprovement tileImprovement = attackedTile.getTileImprovement();
        Intrinsics.checkNotNull(tileImprovement);
        if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)tileImprovement, UniqueType.Unpillagable, null, 2, null) && attacker.hasUnique(UniqueType.DestroysImprovementUponAttack, conditionalState)) {
            String currentTileImprovement = attackedTile.getImprovement();
            attackedTile.removeImprovement();
            objectArray = new Vector2[]{attackedTile.getPosition(), attacker.getTile().getPosition()};
            Sequence<LocationAction> sequence = LocationAction.Companion.invoke((Vector2[])objectArray);
            objectArray = new String[]{attacker.getUnit().getBaseUnit().getName(), "OtherIcons/Pillage"};
            defender.getCivInfo().addNotification("An enemy [" + attacker.getUnit().getBaseUnit().getName() + "] has destroyed our tile improvement [" + currentTileImprovement + ']', sequence, Notification.NotificationCategory.War, (String[])objectArray);
        }
    }

    private static final void attack$triggerVictoryUniques(Tile attackedTile, MapUnitCombatant ourUnit, MapUnitCombatant enemy) {
        Object object = ourUnit.getCivInfo();
        StateForConditionals stateForConditionals = new StateForConditionals((Civilization)object, null, null, attackedTile, ourUnit, enemy, null, null, null, false, 966, null);
        object = ourUnit.getUnit().getTriggeredUniques(UniqueType.TriggerUponDefeatingUnit, stateForConditionals).iterator();
        while (object.hasNext()) {
            boolean bl;
            Unique unique;
            block4: {
                unique = (Unique)object.next();
                Iterable $this$any$iv = unique.getConditionals();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Unique it = (Unique)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = it.getType() == UniqueType.TriggerUponDefeatingUnit && enemy.getUnit().matchesFilter(it.getParams().get(0));
                        if (!bl3) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, ourUnit.getUnit(), null, "due to our [" + ourUnit.getName() + "] defeating a [" + enemy.getName() + ']', 4, null);
        }
    }

    private static final boolean doWithdrawFromMeleeAbility$canNotWithdrawTo(MapUnitCombatant $defender, Tile tile) {
        return !UnitMovement.canMoveTo$default($defender.getUnit().getMovement(), tile, false, false, false, 14, null) || $defender.isLandUnit() && !tile.isLand() || tile.isCityCenter() && !Intrinsics.areEqual(tile.getOwner(), $defender.getCivInfo());
    }

    public static final /* synthetic */ boolean access$doWithdrawFromMeleeAbility$canNotWithdrawTo(MapUnitCombatant $defender, Tile tile) {
        return Battle.doWithdrawFromMeleeAbility$canNotWithdrawTo($defender, tile);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/battle/Battle$DamageDealt;", "", "attackerDealt", "", "defenderDealt", "(II)V", "getAttackerDealt", "()I", "getDefenderDealt", "component1", "component2", "copy", "equals", "", "other", "hashCode", "plus", "toString", "", "Companion", "core"})
    public static final class DamageDealt {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int attackerDealt;
        private final int defenderDealt;
        @NotNull
        private static final DamageDealt None = new DamageDealt(0, 0);

        public DamageDealt(int attackerDealt, int defenderDealt) {
            this.attackerDealt = attackerDealt;
            this.defenderDealt = defenderDealt;
        }

        public final int getAttackerDealt() {
            return this.attackerDealt;
        }

        public final int getDefenderDealt() {
            return this.defenderDealt;
        }

        @NotNull
        public final DamageDealt plus(@NotNull DamageDealt other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return new DamageDealt(this.attackerDealt + other.attackerDealt, this.defenderDealt + other.defenderDealt);
        }

        public final int component1() {
            return this.attackerDealt;
        }

        public final int component2() {
            return this.defenderDealt;
        }

        @NotNull
        public final DamageDealt copy(int attackerDealt, int defenderDealt) {
            return new DamageDealt(attackerDealt, defenderDealt);
        }

        public static /* synthetic */ DamageDealt copy$default(DamageDealt damageDealt, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = damageDealt.attackerDealt;
            }
            if ((n3 & 2) != 0) {
                n2 = damageDealt.defenderDealt;
            }
            return damageDealt.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "DamageDealt(attackerDealt=" + this.attackerDealt + ", defenderDealt=" + this.defenderDealt + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.attackerDealt);
            result2 = result2 * 31 + Integer.hashCode(this.defenderDealt);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DamageDealt)) {
                return false;
            }
            DamageDealt damageDealt = (DamageDealt)other;
            if (this.attackerDealt != damageDealt.attackerDealt) {
                return false;
            }
            return this.defenderDealt == damageDealt.defenderDealt;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/battle/Battle$DamageDealt$Companion;", "", "()V", "None", "Lcom/unciv/logic/battle/Battle$DamageDealt;", "getNone", "()Lcom/unciv/logic/battle/Battle$DamageDealt;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DamageDealt getNone() {
                return None;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

