/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.Constants;
import com.unciv.logic.MultiFilter;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ModConstants;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Lcom/unciv/logic/battle/CityCombatant;", "Lcom/unciv/logic/battle/ICombatant;", "city", "Lcom/unciv/logic/city/City;", "(Lcom/unciv/logic/city/City;)V", "getCity", "()Lcom/unciv/logic/city/City;", "canAttack", "", "getAttackSound", "Lcom/unciv/models/UncivSound;", "getAttackingStrength", "", "getCityStrength", "combatAction", "Lcom/unciv/logic/battle/CombatAction;", "getCivInfo", "Lcom/unciv/logic/civilization/Civilization;", "getDefendingStrength", "attackedByRanged", "getHealth", "getMaxHealth", "getName", "", "getTile", "Lcom/unciv/logic/map/tile/Tile;", "getUnitType", "Lcom/unciv/models/ruleset/unit/UnitType;", "isDefeated", "isInvisible", "to", "matchesFilter", "filter", "takeDamage", "", "damage", "toString", "core"})
public final class CityCombatant
implements ICombatant {
    @NotNull
    private final City city;

    public CityCombatant(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        this.city = city2;
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    @Override
    public int getMaxHealth() {
        return this.city.getMaxHealth$core();
    }

    @Override
    public int getHealth() {
        return this.city.getHealth();
    }

    @Override
    @NotNull
    public Civilization getCivInfo() {
        return this.city.getCiv();
    }

    @Override
    @NotNull
    public Tile getTile() {
        return this.city.getCenterTile();
    }

    @Override
    @NotNull
    public String getName() {
        return this.city.getName();
    }

    @Override
    public boolean isDefeated() {
        return this.city.getHealth() == 1;
    }

    @Override
    public boolean isInvisible(@NotNull Civilization to) {
        Intrinsics.checkNotNullParameter(to, "to");
        return false;
    }

    @Override
    public boolean canAttack() {
        return this.city.canBombard();
    }

    @Override
    public boolean matchesFilter(@NotNull String filter2) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, new Function1<String, Boolean>(this){
            final /* synthetic */ CityCombatant this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it, "City") || Constants.INSTANCE.getAll().contains(it) || City.matchesFilter$default(this.this$0.getCity(), it, null, 2, null);
            }
        }, false, 4, null);
    }

    @Override
    @NotNull
    public UncivSound getAttackSound() {
        return UncivSound.Companion.getBombard();
    }

    @Override
    public void takeDamage(int damage) {
        City city2 = this.city;
        city2.setHealth(city2.getHealth() - damage);
        if (this.city.getHealth() < 1) {
            this.city.setHealth(1);
        }
    }

    @Override
    @NotNull
    public UnitType getUnitType() {
        return UnitType.Companion.getCity();
    }

    @Override
    public int getAttackingStrength() {
        return MathKt.roundToInt((double)this.getCityStrength(CombatAction.Attack) * 0.75);
    }

    @Override
    public int getDefendingStrength(boolean attackedByRanged) {
        if (this.isDefeated()) {
            return 1;
        }
        return CityCombatant.getCityStrength$default(this, null, 1, null);
    }

    public final int getCityStrength(@NotNull CombatAction combatAction) {
        Intrinsics.checkNotNullParameter((Object)combatAction, "combatAction");
        ModConstants modConstants = this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants();
        double strength = modConstants.getCityStrengthBase();
        strength += (double)this.city.getPopulation().getPopulation() * modConstants.getCityStrengthPerPop();
        Tile cityTile = this.city.getCenterTile();
        Iterator iterator2 = SequencesKt.flatMap(cityTile.getAllTerrains(), getCityStrength.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            strength += (double)Integer.parseInt(unique.getParams().get(0));
        }
        int techCount = this.getCivInfo().getGameInfo().getRuleset().getTechnologies().size();
        float techsPercentKnown = techCount > 0 ? (float)this.city.getCiv().getTech().getTechsResearched().size() / (float)techCount : 0.5f;
        strength += Math.pow((double)techsPercentKnown * modConstants.getCityStrengthFromTechsMultiplier(), modConstants.getCityStrengthFromTechsExponent()) * modConstants.getCityStrengthFromTechsFullMultiplier();
        if (cityTile.getMilitaryUnit() != null) {
            MapUnit mapUnit = cityTile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            float f = mapUnit.getBaseUnit().getStrength();
            MapUnit mapUnit2 = cityTile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit2);
            strength += (double)(f * ((float)mapUnit2.getHealth() / 100.0f)) * modConstants.getCityStrengthFromGarrison();
        }
        float buildingsStrength = this.city.getStrength();
        StateForConditionals stateForConditionals = new StateForConditionals(this.getCivInfo(), this.city, null, null, this, null, null, combatAction, null, false, 876, null);
        Iterator<Unique> iterator3 = this.getCivInfo().getMatchingUniques(UniqueType.BetterDefensiveBuildings, stateForConditionals).iterator();
        while (iterator3.hasNext()) {
            Unique unique = iterator3.next();
            buildingsStrength *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return MathKt.roundToInt(strength += (double)buildingsStrength);
    }

    public static /* synthetic */ int getCityStrength$default(CityCombatant cityCombatant, CombatAction combatAction, int n, Object object) {
        if ((n & 1) != 0) {
            combatAction = CombatAction.Defend;
        }
        return cityCombatant.getCityStrength(combatAction);
    }

    @NotNull
    public String toString() {
        return this.city.getName();
    }

    @Override
    public boolean isMelee() {
        return ICombatant.DefaultImpls.isMelee(this);
    }

    @Override
    public boolean isRanged() {
        return ICombatant.DefaultImpls.isRanged(this);
    }

    @Override
    public boolean isAirUnit() {
        return ICombatant.DefaultImpls.isAirUnit(this);
    }

    @Override
    public boolean isWaterUnit() {
        return ICombatant.DefaultImpls.isWaterUnit(this);
    }

    @Override
    public boolean isLandUnit() {
        return ICombatant.DefaultImpls.isLandUnit(this);
    }

    @Override
    public boolean isCity() {
        return ICombatant.DefaultImpls.isCity(this);
    }

    @Override
    public boolean isCivilian() {
        return ICombatant.DefaultImpls.isCivilian(this);
    }
}

